// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/osconfig/v1/osconfig_zonal_service.proto

package osconfigpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	OsConfigZonalService_CreateOSPolicyAssignment_FullMethodName        = "/google.cloud.osconfig.v1.OsConfigZonalService/CreateOSPolicyAssignment"
	OsConfigZonalService_UpdateOSPolicyAssignment_FullMethodName        = "/google.cloud.osconfig.v1.OsConfigZonalService/UpdateOSPolicyAssignment"
	OsConfigZonalService_GetOSPolicyAssignment_FullMethodName           = "/google.cloud.osconfig.v1.OsConfigZonalService/GetOSPolicyAssignment"
	OsConfigZonalService_ListOSPolicyAssignments_FullMethodName         = "/google.cloud.osconfig.v1.OsConfigZonalService/ListOSPolicyAssignments"
	OsConfigZonalService_ListOSPolicyAssignmentRevisions_FullMethodName = "/google.cloud.osconfig.v1.OsConfigZonalService/ListOSPolicyAssignmentRevisions"
	OsConfigZonalService_DeleteOSPolicyAssignment_FullMethodName        = "/google.cloud.osconfig.v1.OsConfigZonalService/DeleteOSPolicyAssignment"
	OsConfigZonalService_GetOSPolicyAssignmentReport_FullMethodName     = "/google.cloud.osconfig.v1.OsConfigZonalService/GetOSPolicyAssignmentReport"
	OsConfigZonalService_ListOSPolicyAssignmentReports_FullMethodName   = "/google.cloud.osconfig.v1.OsConfigZonalService/ListOSPolicyAssignmentReports"
	OsConfigZonalService_GetInventory_FullMethodName                    = "/google.cloud.osconfig.v1.OsConfigZonalService/GetInventory"
	OsConfigZonalService_ListInventories_FullMethodName                 = "/google.cloud.osconfig.v1.OsConfigZonalService/ListInventories"
	OsConfigZonalService_GetVulnerabilityReport_FullMethodName          = "/google.cloud.osconfig.v1.OsConfigZonalService/GetVulnerabilityReport"
	OsConfigZonalService_ListVulnerabilityReports_FullMethodName        = "/google.cloud.osconfig.v1.OsConfigZonalService/ListVulnerabilityReports"
)

// OsConfigZonalServiceClient is the client API for OsConfigZonalService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OsConfigZonalServiceClient interface {
	// Create an OS policy assignment.
	//
	// This method also creates the first revision of the OS policy assignment.
	//
	// This method returns a long running operation (LRO) that contains the
	// rollout details. The rollout can be cancelled by cancelling the LRO.
	//
	// For more information, see [Method:
	// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
	CreateOSPolicyAssignment(ctx context.Context, in *CreateOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update an existing OS policy assignment.
	//
	// This method creates a new revision of the OS policy assignment.
	//
	// This method returns a long running operation (LRO) that contains the
	// rollout details. The rollout can be cancelled by cancelling the LRO.
	//
	// For more information, see [Method:
	// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
	UpdateOSPolicyAssignment(ctx context.Context, in *UpdateOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Retrieve an existing OS policy assignment.
	//
	// This method always returns the latest revision. In order to retrieve a
	// previous revision of the assignment, also provide the revision ID in the
	// `name` parameter.
	GetOSPolicyAssignment(ctx context.Context, in *GetOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*OSPolicyAssignment, error)
	// List the OS policy assignments under the parent resource.
	//
	// For each OS policy assignment, the latest revision is returned.
	ListOSPolicyAssignments(ctx context.Context, in *ListOSPolicyAssignmentsRequest, opts ...grpc.CallOption) (*ListOSPolicyAssignmentsResponse, error)
	// List the OS policy assignment revisions for a given OS policy assignment.
	ListOSPolicyAssignmentRevisions(ctx context.Context, in *ListOSPolicyAssignmentRevisionsRequest, opts ...grpc.CallOption) (*ListOSPolicyAssignmentRevisionsResponse, error)
	// Delete the OS policy assignment.
	//
	// This method creates a new revision of the OS policy assignment.
	//
	// This method returns a long running operation (LRO) that contains the
	// rollout details. The rollout can be cancelled by cancelling the LRO.
	//
	// If the LRO completes and is not cancelled, all revisions associated with
	// the OS policy assignment are deleted.
	//
	// For more information, see [Method:
	// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
	DeleteOSPolicyAssignment(ctx context.Context, in *DeleteOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get the OS policy asssignment report for the specified Compute Engine VM
	// instance.
	GetOSPolicyAssignmentReport(ctx context.Context, in *GetOSPolicyAssignmentReportRequest, opts ...grpc.CallOption) (*OSPolicyAssignmentReport, error)
	// List OS policy asssignment reports for all Compute Engine VM instances in
	// the specified zone.
	ListOSPolicyAssignmentReports(ctx context.Context, in *ListOSPolicyAssignmentReportsRequest, opts ...grpc.CallOption) (*ListOSPolicyAssignmentReportsResponse, error)
	// Get inventory data for the specified VM instance. If the VM has no
	// associated inventory, the message `NOT_FOUND` is returned.
	GetInventory(ctx context.Context, in *GetInventoryRequest, opts ...grpc.CallOption) (*Inventory, error)
	// List inventory data for all VM instances in the specified zone.
	ListInventories(ctx context.Context, in *ListInventoriesRequest, opts ...grpc.CallOption) (*ListInventoriesResponse, error)
	// Gets the vulnerability report for the specified VM instance. Only VMs with
	// inventory data have vulnerability reports associated with them.
	GetVulnerabilityReport(ctx context.Context, in *GetVulnerabilityReportRequest, opts ...grpc.CallOption) (*VulnerabilityReport, error)
	// List vulnerability reports for all VM instances in the specified zone.
	ListVulnerabilityReports(ctx context.Context, in *ListVulnerabilityReportsRequest, opts ...grpc.CallOption) (*ListVulnerabilityReportsResponse, error)
}

type osConfigZonalServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOsConfigZonalServiceClient(cc grpc.ClientConnInterface) OsConfigZonalServiceClient {
	return &osConfigZonalServiceClient{cc}
}

func (c *osConfigZonalServiceClient) CreateOSPolicyAssignment(ctx context.Context, in *CreateOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, OsConfigZonalService_CreateOSPolicyAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) UpdateOSPolicyAssignment(ctx context.Context, in *UpdateOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, OsConfigZonalService_UpdateOSPolicyAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) GetOSPolicyAssignment(ctx context.Context, in *GetOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*OSPolicyAssignment, error) {
	out := new(OSPolicyAssignment)
	err := c.cc.Invoke(ctx, OsConfigZonalService_GetOSPolicyAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) ListOSPolicyAssignments(ctx context.Context, in *ListOSPolicyAssignmentsRequest, opts ...grpc.CallOption) (*ListOSPolicyAssignmentsResponse, error) {
	out := new(ListOSPolicyAssignmentsResponse)
	err := c.cc.Invoke(ctx, OsConfigZonalService_ListOSPolicyAssignments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) ListOSPolicyAssignmentRevisions(ctx context.Context, in *ListOSPolicyAssignmentRevisionsRequest, opts ...grpc.CallOption) (*ListOSPolicyAssignmentRevisionsResponse, error) {
	out := new(ListOSPolicyAssignmentRevisionsResponse)
	err := c.cc.Invoke(ctx, OsConfigZonalService_ListOSPolicyAssignmentRevisions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) DeleteOSPolicyAssignment(ctx context.Context, in *DeleteOSPolicyAssignmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, OsConfigZonalService_DeleteOSPolicyAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) GetOSPolicyAssignmentReport(ctx context.Context, in *GetOSPolicyAssignmentReportRequest, opts ...grpc.CallOption) (*OSPolicyAssignmentReport, error) {
	out := new(OSPolicyAssignmentReport)
	err := c.cc.Invoke(ctx, OsConfigZonalService_GetOSPolicyAssignmentReport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) ListOSPolicyAssignmentReports(ctx context.Context, in *ListOSPolicyAssignmentReportsRequest, opts ...grpc.CallOption) (*ListOSPolicyAssignmentReportsResponse, error) {
	out := new(ListOSPolicyAssignmentReportsResponse)
	err := c.cc.Invoke(ctx, OsConfigZonalService_ListOSPolicyAssignmentReports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) GetInventory(ctx context.Context, in *GetInventoryRequest, opts ...grpc.CallOption) (*Inventory, error) {
	out := new(Inventory)
	err := c.cc.Invoke(ctx, OsConfigZonalService_GetInventory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) ListInventories(ctx context.Context, in *ListInventoriesRequest, opts ...grpc.CallOption) (*ListInventoriesResponse, error) {
	out := new(ListInventoriesResponse)
	err := c.cc.Invoke(ctx, OsConfigZonalService_ListInventories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) GetVulnerabilityReport(ctx context.Context, in *GetVulnerabilityReportRequest, opts ...grpc.CallOption) (*VulnerabilityReport, error) {
	out := new(VulnerabilityReport)
	err := c.cc.Invoke(ctx, OsConfigZonalService_GetVulnerabilityReport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *osConfigZonalServiceClient) ListVulnerabilityReports(ctx context.Context, in *ListVulnerabilityReportsRequest, opts ...grpc.CallOption) (*ListVulnerabilityReportsResponse, error) {
	out := new(ListVulnerabilityReportsResponse)
	err := c.cc.Invoke(ctx, OsConfigZonalService_ListVulnerabilityReports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OsConfigZonalServiceServer is the server API for OsConfigZonalService service.
// All implementations should embed UnimplementedOsConfigZonalServiceServer
// for forward compatibility
type OsConfigZonalServiceServer interface {
	// Create an OS policy assignment.
	//
	// This method also creates the first revision of the OS policy assignment.
	//
	// This method returns a long running operation (LRO) that contains the
	// rollout details. The rollout can be cancelled by cancelling the LRO.
	//
	// For more information, see [Method:
	// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
	CreateOSPolicyAssignment(context.Context, *CreateOSPolicyAssignmentRequest) (*longrunningpb.Operation, error)
	// Update an existing OS policy assignment.
	//
	// This method creates a new revision of the OS policy assignment.
	//
	// This method returns a long running operation (LRO) that contains the
	// rollout details. The rollout can be cancelled by cancelling the LRO.
	//
	// For more information, see [Method:
	// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
	UpdateOSPolicyAssignment(context.Context, *UpdateOSPolicyAssignmentRequest) (*longrunningpb.Operation, error)
	// Retrieve an existing OS policy assignment.
	//
	// This method always returns the latest revision. In order to retrieve a
	// previous revision of the assignment, also provide the revision ID in the
	// `name` parameter.
	GetOSPolicyAssignment(context.Context, *GetOSPolicyAssignmentRequest) (*OSPolicyAssignment, error)
	// List the OS policy assignments under the parent resource.
	//
	// For each OS policy assignment, the latest revision is returned.
	ListOSPolicyAssignments(context.Context, *ListOSPolicyAssignmentsRequest) (*ListOSPolicyAssignmentsResponse, error)
	// List the OS policy assignment revisions for a given OS policy assignment.
	ListOSPolicyAssignmentRevisions(context.Context, *ListOSPolicyAssignmentRevisionsRequest) (*ListOSPolicyAssignmentRevisionsResponse, error)
	// Delete the OS policy assignment.
	//
	// This method creates a new revision of the OS policy assignment.
	//
	// This method returns a long running operation (LRO) that contains the
	// rollout details. The rollout can be cancelled by cancelling the LRO.
	//
	// If the LRO completes and is not cancelled, all revisions associated with
	// the OS policy assignment are deleted.
	//
	// For more information, see [Method:
	// projects.locations.osPolicyAssignments.operations.cancel](https://cloud.google.com/compute/docs/osconfig/rest/v1/projects.locations.osPolicyAssignments.operations/cancel).
	DeleteOSPolicyAssignment(context.Context, *DeleteOSPolicyAssignmentRequest) (*longrunningpb.Operation, error)
	// Get the OS policy asssignment report for the specified Compute Engine VM
	// instance.
	GetOSPolicyAssignmentReport(context.Context, *GetOSPolicyAssignmentReportRequest) (*OSPolicyAssignmentReport, error)
	// List OS policy asssignment reports for all Compute Engine VM instances in
	// the specified zone.
	ListOSPolicyAssignmentReports(context.Context, *ListOSPolicyAssignmentReportsRequest) (*ListOSPolicyAssignmentReportsResponse, error)
	// Get inventory data for the specified VM instance. If the VM has no
	// associated inventory, the message `NOT_FOUND` is returned.
	GetInventory(context.Context, *GetInventoryRequest) (*Inventory, error)
	// List inventory data for all VM instances in the specified zone.
	ListInventories(context.Context, *ListInventoriesRequest) (*ListInventoriesResponse, error)
	// Gets the vulnerability report for the specified VM instance. Only VMs with
	// inventory data have vulnerability reports associated with them.
	GetVulnerabilityReport(context.Context, *GetVulnerabilityReportRequest) (*VulnerabilityReport, error)
	// List vulnerability reports for all VM instances in the specified zone.
	ListVulnerabilityReports(context.Context, *ListVulnerabilityReportsRequest) (*ListVulnerabilityReportsResponse, error)
}

// UnimplementedOsConfigZonalServiceServer should be embedded to have forward compatible implementations.
type UnimplementedOsConfigZonalServiceServer struct {
}

func (UnimplementedOsConfigZonalServiceServer) CreateOSPolicyAssignment(context.Context, *CreateOSPolicyAssignmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateOSPolicyAssignment not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) UpdateOSPolicyAssignment(context.Context, *UpdateOSPolicyAssignmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateOSPolicyAssignment not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) GetOSPolicyAssignment(context.Context, *GetOSPolicyAssignmentRequest) (*OSPolicyAssignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOSPolicyAssignment not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) ListOSPolicyAssignments(context.Context, *ListOSPolicyAssignmentsRequest) (*ListOSPolicyAssignmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOSPolicyAssignments not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) ListOSPolicyAssignmentRevisions(context.Context, *ListOSPolicyAssignmentRevisionsRequest) (*ListOSPolicyAssignmentRevisionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOSPolicyAssignmentRevisions not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) DeleteOSPolicyAssignment(context.Context, *DeleteOSPolicyAssignmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteOSPolicyAssignment not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) GetOSPolicyAssignmentReport(context.Context, *GetOSPolicyAssignmentReportRequest) (*OSPolicyAssignmentReport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOSPolicyAssignmentReport not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) ListOSPolicyAssignmentReports(context.Context, *ListOSPolicyAssignmentReportsRequest) (*ListOSPolicyAssignmentReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOSPolicyAssignmentReports not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) GetInventory(context.Context, *GetInventoryRequest) (*Inventory, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInventory not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) ListInventories(context.Context, *ListInventoriesRequest) (*ListInventoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInventories not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) GetVulnerabilityReport(context.Context, *GetVulnerabilityReportRequest) (*VulnerabilityReport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVulnerabilityReport not implemented")
}
func (UnimplementedOsConfigZonalServiceServer) ListVulnerabilityReports(context.Context, *ListVulnerabilityReportsRequest) (*ListVulnerabilityReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVulnerabilityReports not implemented")
}

// UnsafeOsConfigZonalServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OsConfigZonalServiceServer will
// result in compilation errors.
type UnsafeOsConfigZonalServiceServer interface {
	mustEmbedUnimplementedOsConfigZonalServiceServer()
}

func RegisterOsConfigZonalServiceServer(s grpc.ServiceRegistrar, srv OsConfigZonalServiceServer) {
	s.RegisterService(&OsConfigZonalService_ServiceDesc, srv)
}

func _OsConfigZonalService_CreateOSPolicyAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateOSPolicyAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).CreateOSPolicyAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_CreateOSPolicyAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).CreateOSPolicyAssignment(ctx, req.(*CreateOSPolicyAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_UpdateOSPolicyAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOSPolicyAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).UpdateOSPolicyAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_UpdateOSPolicyAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).UpdateOSPolicyAssignment(ctx, req.(*UpdateOSPolicyAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_GetOSPolicyAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOSPolicyAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).GetOSPolicyAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_GetOSPolicyAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).GetOSPolicyAssignment(ctx, req.(*GetOSPolicyAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_ListOSPolicyAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOSPolicyAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).ListOSPolicyAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_ListOSPolicyAssignments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).ListOSPolicyAssignments(ctx, req.(*ListOSPolicyAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_ListOSPolicyAssignmentRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOSPolicyAssignmentRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).ListOSPolicyAssignmentRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_ListOSPolicyAssignmentRevisions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).ListOSPolicyAssignmentRevisions(ctx, req.(*ListOSPolicyAssignmentRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_DeleteOSPolicyAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOSPolicyAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).DeleteOSPolicyAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_DeleteOSPolicyAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).DeleteOSPolicyAssignment(ctx, req.(*DeleteOSPolicyAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_GetOSPolicyAssignmentReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOSPolicyAssignmentReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).GetOSPolicyAssignmentReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_GetOSPolicyAssignmentReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).GetOSPolicyAssignmentReport(ctx, req.(*GetOSPolicyAssignmentReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_ListOSPolicyAssignmentReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOSPolicyAssignmentReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).ListOSPolicyAssignmentReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_ListOSPolicyAssignmentReports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).ListOSPolicyAssignmentReports(ctx, req.(*ListOSPolicyAssignmentReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_GetInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).GetInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_GetInventory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).GetInventory(ctx, req.(*GetInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_ListInventories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInventoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).ListInventories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_ListInventories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).ListInventories(ctx, req.(*ListInventoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_GetVulnerabilityReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVulnerabilityReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).GetVulnerabilityReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_GetVulnerabilityReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).GetVulnerabilityReport(ctx, req.(*GetVulnerabilityReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OsConfigZonalService_ListVulnerabilityReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVulnerabilityReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OsConfigZonalServiceServer).ListVulnerabilityReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OsConfigZonalService_ListVulnerabilityReports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OsConfigZonalServiceServer).ListVulnerabilityReports(ctx, req.(*ListVulnerabilityReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OsConfigZonalService_ServiceDesc is the grpc.ServiceDesc for OsConfigZonalService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OsConfigZonalService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.v1.OsConfigZonalService",
	HandlerType: (*OsConfigZonalServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateOSPolicyAssignment",
			Handler:    _OsConfigZonalService_CreateOSPolicyAssignment_Handler,
		},
		{
			MethodName: "UpdateOSPolicyAssignment",
			Handler:    _OsConfigZonalService_UpdateOSPolicyAssignment_Handler,
		},
		{
			MethodName: "GetOSPolicyAssignment",
			Handler:    _OsConfigZonalService_GetOSPolicyAssignment_Handler,
		},
		{
			MethodName: "ListOSPolicyAssignments",
			Handler:    _OsConfigZonalService_ListOSPolicyAssignments_Handler,
		},
		{
			MethodName: "ListOSPolicyAssignmentRevisions",
			Handler:    _OsConfigZonalService_ListOSPolicyAssignmentRevisions_Handler,
		},
		{
			MethodName: "DeleteOSPolicyAssignment",
			Handler:    _OsConfigZonalService_DeleteOSPolicyAssignment_Handler,
		},
		{
			MethodName: "GetOSPolicyAssignmentReport",
			Handler:    _OsConfigZonalService_GetOSPolicyAssignmentReport_Handler,
		},
		{
			MethodName: "ListOSPolicyAssignmentReports",
			Handler:    _OsConfigZonalService_ListOSPolicyAssignmentReports_Handler,
		},
		{
			MethodName: "GetInventory",
			Handler:    _OsConfigZonalService_GetInventory_Handler,
		},
		{
			MethodName: "ListInventories",
			Handler:    _OsConfigZonalService_ListInventories_Handler,
		},
		{
			MethodName: "GetVulnerabilityReport",
			Handler:    _OsConfigZonalService_GetVulnerabilityReport_Handler,
		},
		{
			MethodName: "ListVulnerabilityReports",
			Handler:    _OsConfigZonalService_ListVulnerabilityReports_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/osconfig/v1/osconfig_zonal_service.proto",
}
