// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/reasoning_engine.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// ReasoningEngine configurations
type ReasoningEngineSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The service account that the Reasoning Engine artifact runs as.
	// It should have "roles/storage.objectViewer" for reading the user project's
	// Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
	// not specified, the Vertex AI Reasoning Engine Service Agent in the project
	// will be used.
	ServiceAccount *string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3,oneof" json:"service_account,omitempty"`
	// Optional. User provided package spec of the ReasoningEngine.
	// Ignored when users directly specify a deployment image through
	// `deployment_spec.first_party_image_override`, but keeping the
	// field_behavior to avoid introducing breaking changes.
	PackageSpec *ReasoningEngineSpec_PackageSpec `protobuf:"bytes,2,opt,name=package_spec,json=packageSpec,proto3" json:"package_spec,omitempty"`
	// Optional. The specification of a Reasoning Engine deployment.
	DeploymentSpec *ReasoningEngineSpec_DeploymentSpec `protobuf:"bytes,4,opt,name=deployment_spec,json=deploymentSpec,proto3" json:"deployment_spec,omitempty"`
	// Optional. Declarations for object class methods in OpenAPI specification
	// format.
	ClassMethods []*structpb.Struct `protobuf:"bytes,3,rep,name=class_methods,json=classMethods,proto3" json:"class_methods,omitempty"`
	// Optional. The OSS agent framework used to develop the agent.
	// Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
	// "llama-index", "custom".
	AgentFramework string `protobuf:"bytes,5,opt,name=agent_framework,json=agentFramework,proto3" json:"agent_framework,omitempty"`
}

func (x *ReasoningEngineSpec) Reset() {
	*x = ReasoningEngineSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineSpec) ProtoMessage() {}

func (x *ReasoningEngineSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{0}
}

func (x *ReasoningEngineSpec) GetServiceAccount() string {
	if x != nil && x.ServiceAccount != nil {
		return *x.ServiceAccount
	}
	return ""
}

func (x *ReasoningEngineSpec) GetPackageSpec() *ReasoningEngineSpec_PackageSpec {
	if x != nil {
		return x.PackageSpec
	}
	return nil
}

func (x *ReasoningEngineSpec) GetDeploymentSpec() *ReasoningEngineSpec_DeploymentSpec {
	if x != nil {
		return x.DeploymentSpec
	}
	return nil
}

func (x *ReasoningEngineSpec) GetClassMethods() []*structpb.Struct {
	if x != nil {
		return x.ClassMethods
	}
	return nil
}

func (x *ReasoningEngineSpec) GetAgentFramework() string {
	if x != nil {
		return x.AgentFramework
	}
	return ""
}

// ReasoningEngine provides a customizable runtime for models to determine
// which actions to take and in which order.
type ReasoningEngine struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the ReasoningEngine.
	// Format:
	// `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the ReasoningEngine.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The description of the ReasoningEngine.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Configurations of the ReasoningEngine
	Spec *ReasoningEngineSpec `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
	// Output only. Timestamp when this ReasoningEngine was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this ReasoningEngine was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Used to perform consistent read-modify-write updates. If not set,
	// a blind "overwrite" update happens.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Configuration for how Agent Engine sub-resources should manage
	// context.
	ContextSpec *ReasoningEngineContextSpec `protobuf:"bytes,9,opt,name=context_spec,json=contextSpec,proto3" json:"context_spec,omitempty"`
}

func (x *ReasoningEngine) Reset() {
	*x = ReasoningEngine{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngine) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngine) ProtoMessage() {}

func (x *ReasoningEngine) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngine.ProtoReflect.Descriptor instead.
func (*ReasoningEngine) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{1}
}

func (x *ReasoningEngine) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReasoningEngine) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ReasoningEngine) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ReasoningEngine) GetSpec() *ReasoningEngineSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *ReasoningEngine) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ReasoningEngine) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ReasoningEngine) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *ReasoningEngine) GetContextSpec() *ReasoningEngineContextSpec {
	if x != nil {
		return x.ContextSpec
	}
	return nil
}

// Configuration for how Agent Engine sub-resources should manage context.
type ReasoningEngineContextSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specification for a Memory Bank, which manages memories for the
	// Agent Engine.
	MemoryBankConfig *ReasoningEngineContextSpec_MemoryBankConfig `protobuf:"bytes,1,opt,name=memory_bank_config,json=memoryBankConfig,proto3" json:"memory_bank_config,omitempty"`
}

func (x *ReasoningEngineContextSpec) Reset() {
	*x = ReasoningEngineContextSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineContextSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineContextSpec) ProtoMessage() {}

func (x *ReasoningEngineContextSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineContextSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineContextSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{2}
}

func (x *ReasoningEngineContextSpec) GetMemoryBankConfig() *ReasoningEngineContextSpec_MemoryBankConfig {
	if x != nil {
		return x.MemoryBankConfig
	}
	return nil
}

// User provided package spec like pickled object and package requirements.
type ReasoningEngineSpec_PackageSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Cloud Storage URI of the pickled python object.
	PickleObjectGcsUri string `protobuf:"bytes,1,opt,name=pickle_object_gcs_uri,json=pickleObjectGcsUri,proto3" json:"pickle_object_gcs_uri,omitempty"`
	// Optional. The Cloud Storage URI of the dependency files in tar.gz format.
	DependencyFilesGcsUri string `protobuf:"bytes,2,opt,name=dependency_files_gcs_uri,json=dependencyFilesGcsUri,proto3" json:"dependency_files_gcs_uri,omitempty"`
	// Optional. The Cloud Storage URI of the `requirements.txt` file
	RequirementsGcsUri string `protobuf:"bytes,3,opt,name=requirements_gcs_uri,json=requirementsGcsUri,proto3" json:"requirements_gcs_uri,omitempty"`
	// Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
	// If not specified, default value is 3.10.
	PythonVersion string `protobuf:"bytes,4,opt,name=python_version,json=pythonVersion,proto3" json:"python_version,omitempty"`
}

func (x *ReasoningEngineSpec_PackageSpec) Reset() {
	*x = ReasoningEngineSpec_PackageSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineSpec_PackageSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineSpec_PackageSpec) ProtoMessage() {}

func (x *ReasoningEngineSpec_PackageSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineSpec_PackageSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineSpec_PackageSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{0, 0}
}

func (x *ReasoningEngineSpec_PackageSpec) GetPickleObjectGcsUri() string {
	if x != nil {
		return x.PickleObjectGcsUri
	}
	return ""
}

func (x *ReasoningEngineSpec_PackageSpec) GetDependencyFilesGcsUri() string {
	if x != nil {
		return x.DependencyFilesGcsUri
	}
	return ""
}

func (x *ReasoningEngineSpec_PackageSpec) GetRequirementsGcsUri() string {
	if x != nil {
		return x.RequirementsGcsUri
	}
	return ""
}

func (x *ReasoningEngineSpec_PackageSpec) GetPythonVersion() string {
	if x != nil {
		return x.PythonVersion
	}
	return ""
}

// The specification of a Reasoning Engine deployment.
type ReasoningEngineSpec_DeploymentSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Environment variables to be set with the Reasoning Engine
	// deployment. The environment variables can be updated through the
	// UpdateReasoningEngine API.
	Env []*EnvVar `protobuf:"bytes,1,rep,name=env,proto3" json:"env,omitempty"`
	// Optional. Environment variables where the value is a secret in Cloud
	// Secret Manager.
	// To use this feature, add 'Secret Manager Secret Accessor' role
	// (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
	// Service Agent.
	SecretEnv []*SecretEnvVar `protobuf:"bytes,2,rep,name=secret_env,json=secretEnv,proto3" json:"secret_env,omitempty"`
}

func (x *ReasoningEngineSpec_DeploymentSpec) Reset() {
	*x = ReasoningEngineSpec_DeploymentSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineSpec_DeploymentSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineSpec_DeploymentSpec) ProtoMessage() {}

func (x *ReasoningEngineSpec_DeploymentSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineSpec_DeploymentSpec.ProtoReflect.Descriptor instead.
func (*ReasoningEngineSpec_DeploymentSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetEnv() []*EnvVar {
	if x != nil {
		return x.Env
	}
	return nil
}

func (x *ReasoningEngineSpec_DeploymentSpec) GetSecretEnv() []*SecretEnvVar {
	if x != nil {
		return x.SecretEnv
	}
	return nil
}

// Specification for a Memory Bank.
type ReasoningEngineContextSpec_MemoryBankConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Configuration for how to generate memories for the Memory Bank.
	GenerationConfig *ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig `protobuf:"bytes,1,opt,name=generation_config,json=generationConfig,proto3" json:"generation_config,omitempty"`
	// Optional. Configuration for how to perform similarity search on memories.
	// If not set, the Memory Bank will use the default embedding model
	// `text-embedding-005`.
	SimilaritySearchConfig *ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig `protobuf:"bytes,2,opt,name=similarity_search_config,json=similaritySearchConfig,proto3" json:"similarity_search_config,omitempty"`
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig) Reset() {
	*x = ReasoningEngineContextSpec_MemoryBankConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineContextSpec_MemoryBankConfig) ProtoMessage() {}

func (x *ReasoningEngineContextSpec_MemoryBankConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineContextSpec_MemoryBankConfig.ProtoReflect.Descriptor instead.
func (*ReasoningEngineContextSpec_MemoryBankConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{2, 0}
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig) GetGenerationConfig() *ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig) GetSimilaritySearchConfig() *ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig {
	if x != nil {
		return x.SimilaritySearchConfig
	}
	return nil
}

// Configuration for how to generate memories.
type ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model used to generate memories.
	// Format:
	// `projects/{project}/locations/{location}/publishers/google/models/{model}`
	// or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig) Reset() {
	*x = ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig) ProtoMessage() {}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig.ProtoReflect.Descriptor instead.
func (*ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Configuration for how to perform similarity search on memories.
type ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model used to generate embeddings to lookup similar
	// memories. Format:
	// `projects/{project}/locations/{location}/publishers/google/models/{model}`
	// or `projects/{project}/locations/{location}/endpoints/{endpoint}`.
	EmbeddingModel string `protobuf:"bytes,1,opt,name=embedding_model,json=embeddingModel,proto3" json:"embedding_model,omitempty"`
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig) Reset() {
	*x = ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig) ProtoMessage() {}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig.ProtoReflect.Descriptor instead.
func (*ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP(), []int{2, 0, 1}
}

func (x *ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig) GetEmbeddingModel() string {
	if x != nil {
		return x.EmbeddingModel
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_reasoning_engine_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x65, 0x6e, 0x76, 0x5f, 0x76, 0x61, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xb9, 0x06, 0x0a, 0x13, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x31, 0x0a, 0x0f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x68,
	0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x71, 0x0a, 0x0f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x41, 0x0a, 0x0d, 0x63,
	0x6c, 0x61, 0x73, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x12, 0x2c,
	0x0a, 0x0f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72,
	0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x1a, 0xe6, 0x01, 0x0a,
	0x0b, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x36, 0x0a, 0x15,
	0x70, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x67, 0x63,
	0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x12, 0x70, 0x69, 0x63, 0x6b, 0x6c, 0x65, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x47, 0x63,
	0x73, 0x55, 0x72, 0x69, 0x12, 0x3c, 0x0a, 0x18, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e,
	0x63, 0x79, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x47, 0x63, 0x73, 0x55,
	0x72, 0x69, 0x12, 0x35, 0x0a, 0x14, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x47, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x2a, 0x0a, 0x0e, 0x70, 0x79, 0x74,
	0x68, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x70, 0x79, 0x74, 0x68, 0x6f, 0x6e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0xa3, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3e, 0x0a, 0x03, 0x65, 0x6e, 0x76, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x03, 0x65, 0x6e, 0x76, 0x12, 0x51, 0x0a, 0x0a, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x5f, 0x65, 0x6e, 0x76, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x56, 0x61, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x45, 0x6e, 0x76, 0x42, 0x12, 0x0a, 0x10, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22,
	0xec, 0x04, 0x0a, 0x0f, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x04, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x63, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x70, 0x65, 0x63, 0x3a, 0x9f, 0x01, 0xea,
	0x41, 0x9b, 0x01, 0x0a, 0x29, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x4b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x7d, 0x2a, 0x10, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x32, 0x0f, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0xae,
	0x05, 0x0a, 0x1a, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x7f, 0x0a,
	0x12, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x62, 0x61, 0x6e, 0x6b, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e,
	0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x65,
	0x6d, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x8e,
	0x04, 0x0a, 0x10, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e, 0x6b, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x8f, 0x01, 0x0a, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xa2, 0x01, 0x0a, 0x18, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61,
	0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x61, 0x6e, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x16, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x54, 0x0a, 0x10, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40,
	0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x1a, 0x6d, 0x0a, 0x16, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0f, 0x65, 0x6d,
	0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52,
	0x0e, 0x65, 0x6d, 0x62, 0x65, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42,
	0xeb, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x14, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56,
	0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_goTypes = []any{
	(*ReasoningEngineSpec)(nil),                                                // 0: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec
	(*ReasoningEngine)(nil),                                                    // 1: google.cloud.aiplatform.v1beta1.ReasoningEngine
	(*ReasoningEngineContextSpec)(nil),                                         // 2: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
	(*ReasoningEngineSpec_PackageSpec)(nil),                                    // 3: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
	(*ReasoningEngineSpec_DeploymentSpec)(nil),                                 // 4: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
	(*ReasoningEngineContextSpec_MemoryBankConfig)(nil),                        // 5: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
	(*ReasoningEngineContextSpec_MemoryBankConfig_GenerationConfig)(nil),       // 6: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig
	(*ReasoningEngineContextSpec_MemoryBankConfig_SimilaritySearchConfig)(nil), // 7: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig
	(*structpb.Struct)(nil),                                                    // 8: google.protobuf.Struct
	(*timestamppb.Timestamp)(nil),                                              // 9: google.protobuf.Timestamp
	(*EnvVar)(nil),                                                             // 10: google.cloud.aiplatform.v1beta1.EnvVar
	(*SecretEnvVar)(nil),                                                       // 11: google.cloud.aiplatform.v1beta1.SecretEnvVar
}
var file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_depIdxs = []int32{
	3,  // 0: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.package_spec:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.PackageSpec
	4,  // 1: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.deployment_spec:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec
	8,  // 2: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.class_methods:type_name -> google.protobuf.Struct
	0,  // 3: google.cloud.aiplatform.v1beta1.ReasoningEngine.spec:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineSpec
	9,  // 4: google.cloud.aiplatform.v1beta1.ReasoningEngine.create_time:type_name -> google.protobuf.Timestamp
	9,  // 5: google.cloud.aiplatform.v1beta1.ReasoningEngine.update_time:type_name -> google.protobuf.Timestamp
	2,  // 6: google.cloud.aiplatform.v1beta1.ReasoningEngine.context_spec:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec
	5,  // 7: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.memory_bank_config:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig
	10, // 8: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.env:type_name -> google.cloud.aiplatform.v1beta1.EnvVar
	11, // 9: google.cloud.aiplatform.v1beta1.ReasoningEngineSpec.DeploymentSpec.secret_env:type_name -> google.cloud.aiplatform.v1beta1.SecretEnvVar
	6,  // 10: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.generation_config:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.GenerationConfig
	7,  // 11: google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.similarity_search_config:type_name -> google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_init() }
func file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_reasoning_engine_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_env_var_proto_init()
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes[0].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_reasoning_engine_proto = out.File
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_reasoning_engine_proto_depIdxs = nil
}
