// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1beta1/model_monitoring_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ModelMonitoringService_CreateModelMonitor_FullMethodName          = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/CreateModelMonitor"
	ModelMonitoringService_UpdateModelMonitor_FullMethodName          = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/UpdateModelMonitor"
	ModelMonitoringService_GetModelMonitor_FullMethodName             = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/GetModelMonitor"
	ModelMonitoringService_ListModelMonitors_FullMethodName           = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/ListModelMonitors"
	ModelMonitoringService_DeleteModelMonitor_FullMethodName          = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/DeleteModelMonitor"
	ModelMonitoringService_CreateModelMonitoringJob_FullMethodName    = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/CreateModelMonitoringJob"
	ModelMonitoringService_GetModelMonitoringJob_FullMethodName       = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/GetModelMonitoringJob"
	ModelMonitoringService_ListModelMonitoringJobs_FullMethodName     = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/ListModelMonitoringJobs"
	ModelMonitoringService_DeleteModelMonitoringJob_FullMethodName    = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/DeleteModelMonitoringJob"
	ModelMonitoringService_SearchModelMonitoringStats_FullMethodName  = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/SearchModelMonitoringStats"
	ModelMonitoringService_SearchModelMonitoringAlerts_FullMethodName = "/google.cloud.aiplatform.v1beta1.ModelMonitoringService/SearchModelMonitoringAlerts"
)

// ModelMonitoringServiceClient is the client API for ModelMonitoringService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ModelMonitoringServiceClient interface {
	// Creates a ModelMonitor.
	CreateModelMonitor(ctx context.Context, in *CreateModelMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a ModelMonitor.
	UpdateModelMonitor(ctx context.Context, in *UpdateModelMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a ModelMonitor.
	GetModelMonitor(ctx context.Context, in *GetModelMonitorRequest, opts ...grpc.CallOption) (*ModelMonitor, error)
	// Lists ModelMonitors in a Location.
	ListModelMonitors(ctx context.Context, in *ListModelMonitorsRequest, opts ...grpc.CallOption) (*ListModelMonitorsResponse, error)
	// Deletes a ModelMonitor.
	DeleteModelMonitor(ctx context.Context, in *DeleteModelMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a ModelMonitoringJob.
	CreateModelMonitoringJob(ctx context.Context, in *CreateModelMonitoringJobRequest, opts ...grpc.CallOption) (*ModelMonitoringJob, error)
	// Gets a ModelMonitoringJob.
	GetModelMonitoringJob(ctx context.Context, in *GetModelMonitoringJobRequest, opts ...grpc.CallOption) (*ModelMonitoringJob, error)
	// Lists ModelMonitoringJobs.
	// Callers may choose to read across multiple Monitors as per
	// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
	// character) as a wildcard character instead of modelMonitor id in the
	// parent. Format
	// `projects/{project_id}/locations/{location}/moodelMonitors/-/modelMonitoringJobs`
	ListModelMonitoringJobs(ctx context.Context, in *ListModelMonitoringJobsRequest, opts ...grpc.CallOption) (*ListModelMonitoringJobsResponse, error)
	// Deletes a ModelMonitoringJob.
	DeleteModelMonitoringJob(ctx context.Context, in *DeleteModelMonitoringJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Searches Model Monitoring Stats generated within a given time window.
	SearchModelMonitoringStats(ctx context.Context, in *SearchModelMonitoringStatsRequest, opts ...grpc.CallOption) (*SearchModelMonitoringStatsResponse, error)
	// Returns the Model Monitoring alerts.
	SearchModelMonitoringAlerts(ctx context.Context, in *SearchModelMonitoringAlertsRequest, opts ...grpc.CallOption) (*SearchModelMonitoringAlertsResponse, error)
}

type modelMonitoringServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewModelMonitoringServiceClient(cc grpc.ClientConnInterface) ModelMonitoringServiceClient {
	return &modelMonitoringServiceClient{cc}
}

func (c *modelMonitoringServiceClient) CreateModelMonitor(ctx context.Context, in *CreateModelMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelMonitoringService_CreateModelMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) UpdateModelMonitor(ctx context.Context, in *UpdateModelMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelMonitoringService_UpdateModelMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) GetModelMonitor(ctx context.Context, in *GetModelMonitorRequest, opts ...grpc.CallOption) (*ModelMonitor, error) {
	out := new(ModelMonitor)
	err := c.cc.Invoke(ctx, ModelMonitoringService_GetModelMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) ListModelMonitors(ctx context.Context, in *ListModelMonitorsRequest, opts ...grpc.CallOption) (*ListModelMonitorsResponse, error) {
	out := new(ListModelMonitorsResponse)
	err := c.cc.Invoke(ctx, ModelMonitoringService_ListModelMonitors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) DeleteModelMonitor(ctx context.Context, in *DeleteModelMonitorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelMonitoringService_DeleteModelMonitor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) CreateModelMonitoringJob(ctx context.Context, in *CreateModelMonitoringJobRequest, opts ...grpc.CallOption) (*ModelMonitoringJob, error) {
	out := new(ModelMonitoringJob)
	err := c.cc.Invoke(ctx, ModelMonitoringService_CreateModelMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) GetModelMonitoringJob(ctx context.Context, in *GetModelMonitoringJobRequest, opts ...grpc.CallOption) (*ModelMonitoringJob, error) {
	out := new(ModelMonitoringJob)
	err := c.cc.Invoke(ctx, ModelMonitoringService_GetModelMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) ListModelMonitoringJobs(ctx context.Context, in *ListModelMonitoringJobsRequest, opts ...grpc.CallOption) (*ListModelMonitoringJobsResponse, error) {
	out := new(ListModelMonitoringJobsResponse)
	err := c.cc.Invoke(ctx, ModelMonitoringService_ListModelMonitoringJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) DeleteModelMonitoringJob(ctx context.Context, in *DeleteModelMonitoringJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ModelMonitoringService_DeleteModelMonitoringJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) SearchModelMonitoringStats(ctx context.Context, in *SearchModelMonitoringStatsRequest, opts ...grpc.CallOption) (*SearchModelMonitoringStatsResponse, error) {
	out := new(SearchModelMonitoringStatsResponse)
	err := c.cc.Invoke(ctx, ModelMonitoringService_SearchModelMonitoringStats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *modelMonitoringServiceClient) SearchModelMonitoringAlerts(ctx context.Context, in *SearchModelMonitoringAlertsRequest, opts ...grpc.CallOption) (*SearchModelMonitoringAlertsResponse, error) {
	out := new(SearchModelMonitoringAlertsResponse)
	err := c.cc.Invoke(ctx, ModelMonitoringService_SearchModelMonitoringAlerts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ModelMonitoringServiceServer is the server API for ModelMonitoringService service.
// All implementations should embed UnimplementedModelMonitoringServiceServer
// for forward compatibility
type ModelMonitoringServiceServer interface {
	// Creates a ModelMonitor.
	CreateModelMonitor(context.Context, *CreateModelMonitorRequest) (*longrunningpb.Operation, error)
	// Updates a ModelMonitor.
	UpdateModelMonitor(context.Context, *UpdateModelMonitorRequest) (*longrunningpb.Operation, error)
	// Gets a ModelMonitor.
	GetModelMonitor(context.Context, *GetModelMonitorRequest) (*ModelMonitor, error)
	// Lists ModelMonitors in a Location.
	ListModelMonitors(context.Context, *ListModelMonitorsRequest) (*ListModelMonitorsResponse, error)
	// Deletes a ModelMonitor.
	DeleteModelMonitor(context.Context, *DeleteModelMonitorRequest) (*longrunningpb.Operation, error)
	// Creates a ModelMonitoringJob.
	CreateModelMonitoringJob(context.Context, *CreateModelMonitoringJobRequest) (*ModelMonitoringJob, error)
	// Gets a ModelMonitoringJob.
	GetModelMonitoringJob(context.Context, *GetModelMonitoringJobRequest) (*ModelMonitoringJob, error)
	// Lists ModelMonitoringJobs.
	// Callers may choose to read across multiple Monitors as per
	// [AIP-159](https://google.aip.dev/159) by using '-' (the hyphen or dash
	// character) as a wildcard character instead of modelMonitor id in the
	// parent. Format
	// `projects/{project_id}/locations/{location}/moodelMonitors/-/modelMonitoringJobs`
	ListModelMonitoringJobs(context.Context, *ListModelMonitoringJobsRequest) (*ListModelMonitoringJobsResponse, error)
	// Deletes a ModelMonitoringJob.
	DeleteModelMonitoringJob(context.Context, *DeleteModelMonitoringJobRequest) (*longrunningpb.Operation, error)
	// Searches Model Monitoring Stats generated within a given time window.
	SearchModelMonitoringStats(context.Context, *SearchModelMonitoringStatsRequest) (*SearchModelMonitoringStatsResponse, error)
	// Returns the Model Monitoring alerts.
	SearchModelMonitoringAlerts(context.Context, *SearchModelMonitoringAlertsRequest) (*SearchModelMonitoringAlertsResponse, error)
}

// UnimplementedModelMonitoringServiceServer should be embedded to have forward compatible implementations.
type UnimplementedModelMonitoringServiceServer struct {
}

func (UnimplementedModelMonitoringServiceServer) CreateModelMonitor(context.Context, *CreateModelMonitorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModelMonitor not implemented")
}
func (UnimplementedModelMonitoringServiceServer) UpdateModelMonitor(context.Context, *UpdateModelMonitorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateModelMonitor not implemented")
}
func (UnimplementedModelMonitoringServiceServer) GetModelMonitor(context.Context, *GetModelMonitorRequest) (*ModelMonitor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelMonitor not implemented")
}
func (UnimplementedModelMonitoringServiceServer) ListModelMonitors(context.Context, *ListModelMonitorsRequest) (*ListModelMonitorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelMonitors not implemented")
}
func (UnimplementedModelMonitoringServiceServer) DeleteModelMonitor(context.Context, *DeleteModelMonitorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModelMonitor not implemented")
}
func (UnimplementedModelMonitoringServiceServer) CreateModelMonitoringJob(context.Context, *CreateModelMonitoringJobRequest) (*ModelMonitoringJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateModelMonitoringJob not implemented")
}
func (UnimplementedModelMonitoringServiceServer) GetModelMonitoringJob(context.Context, *GetModelMonitoringJobRequest) (*ModelMonitoringJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetModelMonitoringJob not implemented")
}
func (UnimplementedModelMonitoringServiceServer) ListModelMonitoringJobs(context.Context, *ListModelMonitoringJobsRequest) (*ListModelMonitoringJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListModelMonitoringJobs not implemented")
}
func (UnimplementedModelMonitoringServiceServer) DeleteModelMonitoringJob(context.Context, *DeleteModelMonitoringJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteModelMonitoringJob not implemented")
}
func (UnimplementedModelMonitoringServiceServer) SearchModelMonitoringStats(context.Context, *SearchModelMonitoringStatsRequest) (*SearchModelMonitoringStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchModelMonitoringStats not implemented")
}
func (UnimplementedModelMonitoringServiceServer) SearchModelMonitoringAlerts(context.Context, *SearchModelMonitoringAlertsRequest) (*SearchModelMonitoringAlertsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchModelMonitoringAlerts not implemented")
}

// UnsafeModelMonitoringServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ModelMonitoringServiceServer will
// result in compilation errors.
type UnsafeModelMonitoringServiceServer interface {
	mustEmbedUnimplementedModelMonitoringServiceServer()
}

func RegisterModelMonitoringServiceServer(s grpc.ServiceRegistrar, srv ModelMonitoringServiceServer) {
	s.RegisterService(&ModelMonitoringService_ServiceDesc, srv)
}

func _ModelMonitoringService_CreateModelMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).CreateModelMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_CreateModelMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).CreateModelMonitor(ctx, req.(*CreateModelMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_UpdateModelMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateModelMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).UpdateModelMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_UpdateModelMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).UpdateModelMonitor(ctx, req.(*UpdateModelMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_GetModelMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).GetModelMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_GetModelMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).GetModelMonitor(ctx, req.(*GetModelMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_ListModelMonitors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelMonitorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).ListModelMonitors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_ListModelMonitors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).ListModelMonitors(ctx, req.(*ListModelMonitorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_DeleteModelMonitor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelMonitorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).DeleteModelMonitor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_DeleteModelMonitor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).DeleteModelMonitor(ctx, req.(*DeleteModelMonitorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_CreateModelMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateModelMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).CreateModelMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_CreateModelMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).CreateModelMonitoringJob(ctx, req.(*CreateModelMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_GetModelMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetModelMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).GetModelMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_GetModelMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).GetModelMonitoringJob(ctx, req.(*GetModelMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_ListModelMonitoringJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListModelMonitoringJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).ListModelMonitoringJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_ListModelMonitoringJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).ListModelMonitoringJobs(ctx, req.(*ListModelMonitoringJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_DeleteModelMonitoringJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteModelMonitoringJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).DeleteModelMonitoringJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_DeleteModelMonitoringJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).DeleteModelMonitoringJob(ctx, req.(*DeleteModelMonitoringJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_SearchModelMonitoringStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchModelMonitoringStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).SearchModelMonitoringStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_SearchModelMonitoringStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).SearchModelMonitoringStats(ctx, req.(*SearchModelMonitoringStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ModelMonitoringService_SearchModelMonitoringAlerts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchModelMonitoringAlertsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ModelMonitoringServiceServer).SearchModelMonitoringAlerts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ModelMonitoringService_SearchModelMonitoringAlerts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ModelMonitoringServiceServer).SearchModelMonitoringAlerts(ctx, req.(*SearchModelMonitoringAlertsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ModelMonitoringService_ServiceDesc is the grpc.ServiceDesc for ModelMonitoringService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ModelMonitoringService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.ModelMonitoringService",
	HandlerType: (*ModelMonitoringServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateModelMonitor",
			Handler:    _ModelMonitoringService_CreateModelMonitor_Handler,
		},
		{
			MethodName: "UpdateModelMonitor",
			Handler:    _ModelMonitoringService_UpdateModelMonitor_Handler,
		},
		{
			MethodName: "GetModelMonitor",
			Handler:    _ModelMonitoringService_GetModelMonitor_Handler,
		},
		{
			MethodName: "ListModelMonitors",
			Handler:    _ModelMonitoringService_ListModelMonitors_Handler,
		},
		{
			MethodName: "DeleteModelMonitor",
			Handler:    _ModelMonitoringService_DeleteModelMonitor_Handler,
		},
		{
			MethodName: "CreateModelMonitoringJob",
			Handler:    _ModelMonitoringService_CreateModelMonitoringJob_Handler,
		},
		{
			MethodName: "GetModelMonitoringJob",
			Handler:    _ModelMonitoringService_GetModelMonitoringJob_Handler,
		},
		{
			MethodName: "ListModelMonitoringJobs",
			Handler:    _ModelMonitoringService_ListModelMonitoringJobs_Handler,
		},
		{
			MethodName: "DeleteModelMonitoringJob",
			Handler:    _ModelMonitoringService_DeleteModelMonitoringJob_Handler,
		},
		{
			MethodName: "SearchModelMonitoringStats",
			Handler:    _ModelMonitoringService_SearchModelMonitoringStats_Handler,
		},
		{
			MethodName: "SearchModelMonitoringAlerts",
			Handler:    _ModelMonitoringService_SearchModelMonitoringAlerts_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/model_monitoring_service.proto",
}
