// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/notebook_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NotebookService_CreateNotebookRuntimeTemplate_FullMethodName = "/google.cloud.aiplatform.v1.NotebookService/CreateNotebookRuntimeTemplate"
	NotebookService_GetNotebookRuntimeTemplate_FullMethodName    = "/google.cloud.aiplatform.v1.NotebookService/GetNotebookRuntimeTemplate"
	NotebookService_ListNotebookRuntimeTemplates_FullMethodName  = "/google.cloud.aiplatform.v1.NotebookService/ListNotebookRuntimeTemplates"
	NotebookService_DeleteNotebookRuntimeTemplate_FullMethodName = "/google.cloud.aiplatform.v1.NotebookService/DeleteNotebookRuntimeTemplate"
	NotebookService_UpdateNotebookRuntimeTemplate_FullMethodName = "/google.cloud.aiplatform.v1.NotebookService/UpdateNotebookRuntimeTemplate"
	NotebookService_AssignNotebookRuntime_FullMethodName         = "/google.cloud.aiplatform.v1.NotebookService/AssignNotebookRuntime"
	NotebookService_GetNotebookRuntime_FullMethodName            = "/google.cloud.aiplatform.v1.NotebookService/GetNotebookRuntime"
	NotebookService_ListNotebookRuntimes_FullMethodName          = "/google.cloud.aiplatform.v1.NotebookService/ListNotebookRuntimes"
	NotebookService_DeleteNotebookRuntime_FullMethodName         = "/google.cloud.aiplatform.v1.NotebookService/DeleteNotebookRuntime"
	NotebookService_UpgradeNotebookRuntime_FullMethodName        = "/google.cloud.aiplatform.v1.NotebookService/UpgradeNotebookRuntime"
	NotebookService_StartNotebookRuntime_FullMethodName          = "/google.cloud.aiplatform.v1.NotebookService/StartNotebookRuntime"
	NotebookService_StopNotebookRuntime_FullMethodName           = "/google.cloud.aiplatform.v1.NotebookService/StopNotebookRuntime"
	NotebookService_CreateNotebookExecutionJob_FullMethodName    = "/google.cloud.aiplatform.v1.NotebookService/CreateNotebookExecutionJob"
	NotebookService_GetNotebookExecutionJob_FullMethodName       = "/google.cloud.aiplatform.v1.NotebookService/GetNotebookExecutionJob"
	NotebookService_ListNotebookExecutionJobs_FullMethodName     = "/google.cloud.aiplatform.v1.NotebookService/ListNotebookExecutionJobs"
	NotebookService_DeleteNotebookExecutionJob_FullMethodName    = "/google.cloud.aiplatform.v1.NotebookService/DeleteNotebookExecutionJob"
)

// NotebookServiceClient is the client API for NotebookService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NotebookServiceClient interface {
	// Creates a NotebookRuntimeTemplate.
	CreateNotebookRuntimeTemplate(ctx context.Context, in *CreateNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a NotebookRuntimeTemplate.
	GetNotebookRuntimeTemplate(ctx context.Context, in *GetNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*NotebookRuntimeTemplate, error)
	// Lists NotebookRuntimeTemplates in a Location.
	ListNotebookRuntimeTemplates(ctx context.Context, in *ListNotebookRuntimeTemplatesRequest, opts ...grpc.CallOption) (*ListNotebookRuntimeTemplatesResponse, error)
	// Deletes a NotebookRuntimeTemplate.
	DeleteNotebookRuntimeTemplate(ctx context.Context, in *DeleteNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a NotebookRuntimeTemplate.
	UpdateNotebookRuntimeTemplate(ctx context.Context, in *UpdateNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*NotebookRuntimeTemplate, error)
	// Assigns a NotebookRuntime to a user for a particular Notebook file. This
	// method will either returns an existing assignment or generates a new one.
	AssignNotebookRuntime(ctx context.Context, in *AssignNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a NotebookRuntime.
	GetNotebookRuntime(ctx context.Context, in *GetNotebookRuntimeRequest, opts ...grpc.CallOption) (*NotebookRuntime, error)
	// Lists NotebookRuntimes in a Location.
	ListNotebookRuntimes(ctx context.Context, in *ListNotebookRuntimesRequest, opts ...grpc.CallOption) (*ListNotebookRuntimesResponse, error)
	// Deletes a NotebookRuntime.
	DeleteNotebookRuntime(ctx context.Context, in *DeleteNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upgrades a NotebookRuntime.
	UpgradeNotebookRuntime(ctx context.Context, in *UpgradeNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a NotebookRuntime.
	StartNotebookRuntime(ctx context.Context, in *StartNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a NotebookRuntime.
	StopNotebookRuntime(ctx context.Context, in *StopNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a NotebookExecutionJob.
	CreateNotebookExecutionJob(ctx context.Context, in *CreateNotebookExecutionJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a NotebookExecutionJob.
	GetNotebookExecutionJob(ctx context.Context, in *GetNotebookExecutionJobRequest, opts ...grpc.CallOption) (*NotebookExecutionJob, error)
	// Lists NotebookExecutionJobs in a Location.
	ListNotebookExecutionJobs(ctx context.Context, in *ListNotebookExecutionJobsRequest, opts ...grpc.CallOption) (*ListNotebookExecutionJobsResponse, error)
	// Deletes a NotebookExecutionJob.
	DeleteNotebookExecutionJob(ctx context.Context, in *DeleteNotebookExecutionJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type notebookServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNotebookServiceClient(cc grpc.ClientConnInterface) NotebookServiceClient {
	return &notebookServiceClient{cc}
}

func (c *notebookServiceClient) CreateNotebookRuntimeTemplate(ctx context.Context, in *CreateNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_CreateNotebookRuntimeTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) GetNotebookRuntimeTemplate(ctx context.Context, in *GetNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*NotebookRuntimeTemplate, error) {
	out := new(NotebookRuntimeTemplate)
	err := c.cc.Invoke(ctx, NotebookService_GetNotebookRuntimeTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) ListNotebookRuntimeTemplates(ctx context.Context, in *ListNotebookRuntimeTemplatesRequest, opts ...grpc.CallOption) (*ListNotebookRuntimeTemplatesResponse, error) {
	out := new(ListNotebookRuntimeTemplatesResponse)
	err := c.cc.Invoke(ctx, NotebookService_ListNotebookRuntimeTemplates_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) DeleteNotebookRuntimeTemplate(ctx context.Context, in *DeleteNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_DeleteNotebookRuntimeTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) UpdateNotebookRuntimeTemplate(ctx context.Context, in *UpdateNotebookRuntimeTemplateRequest, opts ...grpc.CallOption) (*NotebookRuntimeTemplate, error) {
	out := new(NotebookRuntimeTemplate)
	err := c.cc.Invoke(ctx, NotebookService_UpdateNotebookRuntimeTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) AssignNotebookRuntime(ctx context.Context, in *AssignNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_AssignNotebookRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) GetNotebookRuntime(ctx context.Context, in *GetNotebookRuntimeRequest, opts ...grpc.CallOption) (*NotebookRuntime, error) {
	out := new(NotebookRuntime)
	err := c.cc.Invoke(ctx, NotebookService_GetNotebookRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) ListNotebookRuntimes(ctx context.Context, in *ListNotebookRuntimesRequest, opts ...grpc.CallOption) (*ListNotebookRuntimesResponse, error) {
	out := new(ListNotebookRuntimesResponse)
	err := c.cc.Invoke(ctx, NotebookService_ListNotebookRuntimes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) DeleteNotebookRuntime(ctx context.Context, in *DeleteNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_DeleteNotebookRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) UpgradeNotebookRuntime(ctx context.Context, in *UpgradeNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_UpgradeNotebookRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) StartNotebookRuntime(ctx context.Context, in *StartNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_StartNotebookRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) StopNotebookRuntime(ctx context.Context, in *StopNotebookRuntimeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_StopNotebookRuntime_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) CreateNotebookExecutionJob(ctx context.Context, in *CreateNotebookExecutionJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_CreateNotebookExecutionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) GetNotebookExecutionJob(ctx context.Context, in *GetNotebookExecutionJobRequest, opts ...grpc.CallOption) (*NotebookExecutionJob, error) {
	out := new(NotebookExecutionJob)
	err := c.cc.Invoke(ctx, NotebookService_GetNotebookExecutionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) ListNotebookExecutionJobs(ctx context.Context, in *ListNotebookExecutionJobsRequest, opts ...grpc.CallOption) (*ListNotebookExecutionJobsResponse, error) {
	out := new(ListNotebookExecutionJobsResponse)
	err := c.cc.Invoke(ctx, NotebookService_ListNotebookExecutionJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notebookServiceClient) DeleteNotebookExecutionJob(ctx context.Context, in *DeleteNotebookExecutionJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, NotebookService_DeleteNotebookExecutionJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NotebookServiceServer is the server API for NotebookService service.
// All implementations should embed UnimplementedNotebookServiceServer
// for forward compatibility
type NotebookServiceServer interface {
	// Creates a NotebookRuntimeTemplate.
	CreateNotebookRuntimeTemplate(context.Context, *CreateNotebookRuntimeTemplateRequest) (*longrunningpb.Operation, error)
	// Gets a NotebookRuntimeTemplate.
	GetNotebookRuntimeTemplate(context.Context, *GetNotebookRuntimeTemplateRequest) (*NotebookRuntimeTemplate, error)
	// Lists NotebookRuntimeTemplates in a Location.
	ListNotebookRuntimeTemplates(context.Context, *ListNotebookRuntimeTemplatesRequest) (*ListNotebookRuntimeTemplatesResponse, error)
	// Deletes a NotebookRuntimeTemplate.
	DeleteNotebookRuntimeTemplate(context.Context, *DeleteNotebookRuntimeTemplateRequest) (*longrunningpb.Operation, error)
	// Updates a NotebookRuntimeTemplate.
	UpdateNotebookRuntimeTemplate(context.Context, *UpdateNotebookRuntimeTemplateRequest) (*NotebookRuntimeTemplate, error)
	// Assigns a NotebookRuntime to a user for a particular Notebook file. This
	// method will either returns an existing assignment or generates a new one.
	AssignNotebookRuntime(context.Context, *AssignNotebookRuntimeRequest) (*longrunningpb.Operation, error)
	// Gets a NotebookRuntime.
	GetNotebookRuntime(context.Context, *GetNotebookRuntimeRequest) (*NotebookRuntime, error)
	// Lists NotebookRuntimes in a Location.
	ListNotebookRuntimes(context.Context, *ListNotebookRuntimesRequest) (*ListNotebookRuntimesResponse, error)
	// Deletes a NotebookRuntime.
	DeleteNotebookRuntime(context.Context, *DeleteNotebookRuntimeRequest) (*longrunningpb.Operation, error)
	// Upgrades a NotebookRuntime.
	UpgradeNotebookRuntime(context.Context, *UpgradeNotebookRuntimeRequest) (*longrunningpb.Operation, error)
	// Starts a NotebookRuntime.
	StartNotebookRuntime(context.Context, *StartNotebookRuntimeRequest) (*longrunningpb.Operation, error)
	// Stops a NotebookRuntime.
	StopNotebookRuntime(context.Context, *StopNotebookRuntimeRequest) (*longrunningpb.Operation, error)
	// Creates a NotebookExecutionJob.
	CreateNotebookExecutionJob(context.Context, *CreateNotebookExecutionJobRequest) (*longrunningpb.Operation, error)
	// Gets a NotebookExecutionJob.
	GetNotebookExecutionJob(context.Context, *GetNotebookExecutionJobRequest) (*NotebookExecutionJob, error)
	// Lists NotebookExecutionJobs in a Location.
	ListNotebookExecutionJobs(context.Context, *ListNotebookExecutionJobsRequest) (*ListNotebookExecutionJobsResponse, error)
	// Deletes a NotebookExecutionJob.
	DeleteNotebookExecutionJob(context.Context, *DeleteNotebookExecutionJobRequest) (*longrunningpb.Operation, error)
}

// UnimplementedNotebookServiceServer should be embedded to have forward compatible implementations.
type UnimplementedNotebookServiceServer struct {
}

func (UnimplementedNotebookServiceServer) CreateNotebookRuntimeTemplate(context.Context, *CreateNotebookRuntimeTemplateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotebookRuntimeTemplate not implemented")
}
func (UnimplementedNotebookServiceServer) GetNotebookRuntimeTemplate(context.Context, *GetNotebookRuntimeTemplateRequest) (*NotebookRuntimeTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotebookRuntimeTemplate not implemented")
}
func (UnimplementedNotebookServiceServer) ListNotebookRuntimeTemplates(context.Context, *ListNotebookRuntimeTemplatesRequest) (*ListNotebookRuntimeTemplatesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotebookRuntimeTemplates not implemented")
}
func (UnimplementedNotebookServiceServer) DeleteNotebookRuntimeTemplate(context.Context, *DeleteNotebookRuntimeTemplateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotebookRuntimeTemplate not implemented")
}
func (UnimplementedNotebookServiceServer) UpdateNotebookRuntimeTemplate(context.Context, *UpdateNotebookRuntimeTemplateRequest) (*NotebookRuntimeTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotebookRuntimeTemplate not implemented")
}
func (UnimplementedNotebookServiceServer) AssignNotebookRuntime(context.Context, *AssignNotebookRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AssignNotebookRuntime not implemented")
}
func (UnimplementedNotebookServiceServer) GetNotebookRuntime(context.Context, *GetNotebookRuntimeRequest) (*NotebookRuntime, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotebookRuntime not implemented")
}
func (UnimplementedNotebookServiceServer) ListNotebookRuntimes(context.Context, *ListNotebookRuntimesRequest) (*ListNotebookRuntimesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotebookRuntimes not implemented")
}
func (UnimplementedNotebookServiceServer) DeleteNotebookRuntime(context.Context, *DeleteNotebookRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotebookRuntime not implemented")
}
func (UnimplementedNotebookServiceServer) UpgradeNotebookRuntime(context.Context, *UpgradeNotebookRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeNotebookRuntime not implemented")
}
func (UnimplementedNotebookServiceServer) StartNotebookRuntime(context.Context, *StartNotebookRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNotebookRuntime not implemented")
}
func (UnimplementedNotebookServiceServer) StopNotebookRuntime(context.Context, *StopNotebookRuntimeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopNotebookRuntime not implemented")
}
func (UnimplementedNotebookServiceServer) CreateNotebookExecutionJob(context.Context, *CreateNotebookExecutionJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotebookExecutionJob not implemented")
}
func (UnimplementedNotebookServiceServer) GetNotebookExecutionJob(context.Context, *GetNotebookExecutionJobRequest) (*NotebookExecutionJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotebookExecutionJob not implemented")
}
func (UnimplementedNotebookServiceServer) ListNotebookExecutionJobs(context.Context, *ListNotebookExecutionJobsRequest) (*ListNotebookExecutionJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotebookExecutionJobs not implemented")
}
func (UnimplementedNotebookServiceServer) DeleteNotebookExecutionJob(context.Context, *DeleteNotebookExecutionJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotebookExecutionJob not implemented")
}

// UnsafeNotebookServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NotebookServiceServer will
// result in compilation errors.
type UnsafeNotebookServiceServer interface {
	mustEmbedUnimplementedNotebookServiceServer()
}

func RegisterNotebookServiceServer(s grpc.ServiceRegistrar, srv NotebookServiceServer) {
	s.RegisterService(&NotebookService_ServiceDesc, srv)
}

func _NotebookService_CreateNotebookRuntimeTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotebookRuntimeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).CreateNotebookRuntimeTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_CreateNotebookRuntimeTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).CreateNotebookRuntimeTemplate(ctx, req.(*CreateNotebookRuntimeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_GetNotebookRuntimeTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotebookRuntimeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).GetNotebookRuntimeTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_GetNotebookRuntimeTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).GetNotebookRuntimeTemplate(ctx, req.(*GetNotebookRuntimeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_ListNotebookRuntimeTemplates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotebookRuntimeTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ListNotebookRuntimeTemplates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ListNotebookRuntimeTemplates_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ListNotebookRuntimeTemplates(ctx, req.(*ListNotebookRuntimeTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_DeleteNotebookRuntimeTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotebookRuntimeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).DeleteNotebookRuntimeTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_DeleteNotebookRuntimeTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).DeleteNotebookRuntimeTemplate(ctx, req.(*DeleteNotebookRuntimeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_UpdateNotebookRuntimeTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotebookRuntimeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).UpdateNotebookRuntimeTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_UpdateNotebookRuntimeTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).UpdateNotebookRuntimeTemplate(ctx, req.(*UpdateNotebookRuntimeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_AssignNotebookRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AssignNotebookRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).AssignNotebookRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_AssignNotebookRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).AssignNotebookRuntime(ctx, req.(*AssignNotebookRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_GetNotebookRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotebookRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).GetNotebookRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_GetNotebookRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).GetNotebookRuntime(ctx, req.(*GetNotebookRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_ListNotebookRuntimes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotebookRuntimesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ListNotebookRuntimes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ListNotebookRuntimes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ListNotebookRuntimes(ctx, req.(*ListNotebookRuntimesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_DeleteNotebookRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotebookRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).DeleteNotebookRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_DeleteNotebookRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).DeleteNotebookRuntime(ctx, req.(*DeleteNotebookRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_UpgradeNotebookRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeNotebookRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).UpgradeNotebookRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_UpgradeNotebookRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).UpgradeNotebookRuntime(ctx, req.(*UpgradeNotebookRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_StartNotebookRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNotebookRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).StartNotebookRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_StartNotebookRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).StartNotebookRuntime(ctx, req.(*StartNotebookRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_StopNotebookRuntime_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopNotebookRuntimeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).StopNotebookRuntime(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_StopNotebookRuntime_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).StopNotebookRuntime(ctx, req.(*StopNotebookRuntimeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_CreateNotebookExecutionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotebookExecutionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).CreateNotebookExecutionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_CreateNotebookExecutionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).CreateNotebookExecutionJob(ctx, req.(*CreateNotebookExecutionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_GetNotebookExecutionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotebookExecutionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).GetNotebookExecutionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_GetNotebookExecutionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).GetNotebookExecutionJob(ctx, req.(*GetNotebookExecutionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_ListNotebookExecutionJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotebookExecutionJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).ListNotebookExecutionJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_ListNotebookExecutionJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).ListNotebookExecutionJobs(ctx, req.(*ListNotebookExecutionJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotebookService_DeleteNotebookExecutionJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotebookExecutionJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotebookServiceServer).DeleteNotebookExecutionJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotebookService_DeleteNotebookExecutionJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotebookServiceServer).DeleteNotebookExecutionJob(ctx, req.(*DeleteNotebookExecutionJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NotebookService_ServiceDesc is the grpc.ServiceDesc for NotebookService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NotebookService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.NotebookService",
	HandlerType: (*NotebookServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateNotebookRuntimeTemplate",
			Handler:    _NotebookService_CreateNotebookRuntimeTemplate_Handler,
		},
		{
			MethodName: "GetNotebookRuntimeTemplate",
			Handler:    _NotebookService_GetNotebookRuntimeTemplate_Handler,
		},
		{
			MethodName: "ListNotebookRuntimeTemplates",
			Handler:    _NotebookService_ListNotebookRuntimeTemplates_Handler,
		},
		{
			MethodName: "DeleteNotebookRuntimeTemplate",
			Handler:    _NotebookService_DeleteNotebookRuntimeTemplate_Handler,
		},
		{
			MethodName: "UpdateNotebookRuntimeTemplate",
			Handler:    _NotebookService_UpdateNotebookRuntimeTemplate_Handler,
		},
		{
			MethodName: "AssignNotebookRuntime",
			Handler:    _NotebookService_AssignNotebookRuntime_Handler,
		},
		{
			MethodName: "GetNotebookRuntime",
			Handler:    _NotebookService_GetNotebookRuntime_Handler,
		},
		{
			MethodName: "ListNotebookRuntimes",
			Handler:    _NotebookService_ListNotebookRuntimes_Handler,
		},
		{
			MethodName: "DeleteNotebookRuntime",
			Handler:    _NotebookService_DeleteNotebookRuntime_Handler,
		},
		{
			MethodName: "UpgradeNotebookRuntime",
			Handler:    _NotebookService_UpgradeNotebookRuntime_Handler,
		},
		{
			MethodName: "StartNotebookRuntime",
			Handler:    _NotebookService_StartNotebookRuntime_Handler,
		},
		{
			MethodName: "StopNotebookRuntime",
			Handler:    _NotebookService_StopNotebookRuntime_Handler,
		},
		{
			MethodName: "CreateNotebookExecutionJob",
			Handler:    _NotebookService_CreateNotebookExecutionJob_Handler,
		},
		{
			MethodName: "GetNotebookExecutionJob",
			Handler:    _NotebookService_GetNotebookExecutionJob_Handler,
		},
		{
			MethodName: "ListNotebookExecutionJobs",
			Handler:    _NotebookService_ListNotebookExecutionJobs_Handler,
		},
		{
			MethodName: "DeleteNotebookExecutionJob",
			Handler:    _NotebookService_DeleteNotebookExecutionJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/notebook_service.proto",
}
