// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/connectors/v1/authconfig.proto

package connectors

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AuthType defines different authentication types.
type AuthType int32

const (
	// Authentication type not specified.
	AuthType_AUTH_TYPE_UNSPECIFIED AuthType = 0
	// Username and Password Authentication.
	AuthType_USER_PASSWORD AuthType = 1
	// JSON Web Token (JWT) Profile for Oauth 2.0
	// Authorization Grant based authentication
	AuthType_OAUTH2_JWT_BEARER AuthType = 2
	// Oauth 2.0 Client Credentials Grant Authentication
	AuthType_OAUTH2_CLIENT_CREDENTIALS AuthType = 3
	// SSH Public Key Authentication
	AuthType_SSH_PUBLIC_KEY AuthType = 4
)

// Enum value maps for AuthType.
var (
	AuthType_name = map[int32]string{
		0: "AUTH_TYPE_UNSPECIFIED",
		1: "USER_PASSWORD",
		2: "OAUTH2_JWT_BEARER",
		3: "OAUTH2_CLIENT_CREDENTIALS",
		4: "SSH_PUBLIC_KEY",
	}
	AuthType_value = map[string]int32{
		"AUTH_TYPE_UNSPECIFIED":     0,
		"USER_PASSWORD":             1,
		"OAUTH2_JWT_BEARER":         2,
		"OAUTH2_CLIENT_CREDENTIALS": 3,
		"SSH_PUBLIC_KEY":            4,
	}
)

func (x AuthType) Enum() *AuthType {
	p := new(AuthType)
	*p = x
	return p
}

func (x AuthType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_connectors_v1_authconfig_proto_enumTypes[0].Descriptor()
}

func (AuthType) Type() protoreflect.EnumType {
	return &file_google_cloud_connectors_v1_authconfig_proto_enumTypes[0]
}

func (x AuthType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthType.Descriptor instead.
func (AuthType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0}
}

// AuthConfig defines details of a authentication type.
type AuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of authentication configured.
	AuthType AuthType `protobuf:"varint,1,opt,name=auth_type,json=authType,proto3,enum=google.cloud.connectors.v1.AuthType" json:"auth_type,omitempty"`
	// Supported auth types.
	//
	// Types that are assignable to Type:
	//
	//	*AuthConfig_UserPassword_
	//	*AuthConfig_Oauth2JwtBearer_
	//	*AuthConfig_Oauth2ClientCredentials_
	//	*AuthConfig_SshPublicKey_
	Type isAuthConfig_Type `protobuf_oneof:"type"`
	// List containing additional auth configs.
	AdditionalVariables []*ConfigVariable `protobuf:"bytes,5,rep,name=additional_variables,json=additionalVariables,proto3" json:"additional_variables,omitempty"`
}

func (x *AuthConfig) Reset() {
	*x = AuthConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig) ProtoMessage() {}

func (x *AuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig.ProtoReflect.Descriptor instead.
func (*AuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0}
}

func (x *AuthConfig) GetAuthType() AuthType {
	if x != nil {
		return x.AuthType
	}
	return AuthType_AUTH_TYPE_UNSPECIFIED
}

func (m *AuthConfig) GetType() isAuthConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *AuthConfig) GetUserPassword() *AuthConfig_UserPassword {
	if x, ok := x.GetType().(*AuthConfig_UserPassword_); ok {
		return x.UserPassword
	}
	return nil
}

func (x *AuthConfig) GetOauth2JwtBearer() *AuthConfig_Oauth2JwtBearer {
	if x, ok := x.GetType().(*AuthConfig_Oauth2JwtBearer_); ok {
		return x.Oauth2JwtBearer
	}
	return nil
}

func (x *AuthConfig) GetOauth2ClientCredentials() *AuthConfig_Oauth2ClientCredentials {
	if x, ok := x.GetType().(*AuthConfig_Oauth2ClientCredentials_); ok {
		return x.Oauth2ClientCredentials
	}
	return nil
}

func (x *AuthConfig) GetSshPublicKey() *AuthConfig_SshPublicKey {
	if x, ok := x.GetType().(*AuthConfig_SshPublicKey_); ok {
		return x.SshPublicKey
	}
	return nil
}

func (x *AuthConfig) GetAdditionalVariables() []*ConfigVariable {
	if x != nil {
		return x.AdditionalVariables
	}
	return nil
}

type isAuthConfig_Type interface {
	isAuthConfig_Type()
}

type AuthConfig_UserPassword_ struct {
	// UserPassword.
	UserPassword *AuthConfig_UserPassword `protobuf:"bytes,2,opt,name=user_password,json=userPassword,proto3,oneof"`
}

type AuthConfig_Oauth2JwtBearer_ struct {
	// Oauth2JwtBearer.
	Oauth2JwtBearer *AuthConfig_Oauth2JwtBearer `protobuf:"bytes,3,opt,name=oauth2_jwt_bearer,json=oauth2JwtBearer,proto3,oneof"`
}

type AuthConfig_Oauth2ClientCredentials_ struct {
	// Oauth2ClientCredentials.
	Oauth2ClientCredentials *AuthConfig_Oauth2ClientCredentials `protobuf:"bytes,4,opt,name=oauth2_client_credentials,json=oauth2ClientCredentials,proto3,oneof"`
}

type AuthConfig_SshPublicKey_ struct {
	// SSH Public Key.
	SshPublicKey *AuthConfig_SshPublicKey `protobuf:"bytes,6,opt,name=ssh_public_key,json=sshPublicKey,proto3,oneof"`
}

func (*AuthConfig_UserPassword_) isAuthConfig_Type() {}

func (*AuthConfig_Oauth2JwtBearer_) isAuthConfig_Type() {}

func (*AuthConfig_Oauth2ClientCredentials_) isAuthConfig_Type() {}

func (*AuthConfig_SshPublicKey_) isAuthConfig_Type() {}

// AuthConfigTemplate defines required field over an authentication type.
type AuthConfigTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of authentication configured.
	AuthType AuthType `protobuf:"varint,1,opt,name=auth_type,json=authType,proto3,enum=google.cloud.connectors.v1.AuthType" json:"auth_type,omitempty"`
	// Config variables to describe an `AuthConfig` for a `Connection`.
	ConfigVariableTemplates []*ConfigVariableTemplate `protobuf:"bytes,2,rep,name=config_variable_templates,json=configVariableTemplates,proto3" json:"config_variable_templates,omitempty"`
}

func (x *AuthConfigTemplate) Reset() {
	*x = AuthConfigTemplate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfigTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfigTemplate) ProtoMessage() {}

func (x *AuthConfigTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfigTemplate.ProtoReflect.Descriptor instead.
func (*AuthConfigTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{1}
}

func (x *AuthConfigTemplate) GetAuthType() AuthType {
	if x != nil {
		return x.AuthType
	}
	return AuthType_AUTH_TYPE_UNSPECIFIED
}

func (x *AuthConfigTemplate) GetConfigVariableTemplates() []*ConfigVariableTemplate {
	if x != nil {
		return x.ConfigVariableTemplates
	}
	return nil
}

// Parameters to support Username and Password Authentication.
type AuthConfig_UserPassword struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Secret version reference containing the password.
	Password *Secret `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
}

func (x *AuthConfig_UserPassword) Reset() {
	*x = AuthConfig_UserPassword{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig_UserPassword) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_UserPassword) ProtoMessage() {}

func (x *AuthConfig_UserPassword) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_UserPassword.ProtoReflect.Descriptor instead.
func (*AuthConfig_UserPassword) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0, 0}
}

func (x *AuthConfig_UserPassword) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *AuthConfig_UserPassword) GetPassword() *Secret {
	if x != nil {
		return x.Password
	}
	return nil
}

// Parameters to support JSON Web Token (JWT) Profile for Oauth 2.0
// Authorization Grant based authentication.
// See https://tools.ietf.org/html/rfc7523 for more details.
type AuthConfig_Oauth2JwtBearer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Secret version reference containing a PKCS#8 PEM-encoded private
	// key associated with the Client Certificate. This private key will be
	// used to sign JWTs used for the jwt-bearer authorization grant.
	// Specified in the form as: `projects/*/secrets/*/versions/*`.
	ClientKey *Secret `protobuf:"bytes,1,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// JwtClaims providers fields to generate the token.
	JwtClaims *AuthConfig_Oauth2JwtBearer_JwtClaims `protobuf:"bytes,2,opt,name=jwt_claims,json=jwtClaims,proto3" json:"jwt_claims,omitempty"`
}

func (x *AuthConfig_Oauth2JwtBearer) Reset() {
	*x = AuthConfig_Oauth2JwtBearer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig_Oauth2JwtBearer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_Oauth2JwtBearer) ProtoMessage() {}

func (x *AuthConfig_Oauth2JwtBearer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_Oauth2JwtBearer.ProtoReflect.Descriptor instead.
func (*AuthConfig_Oauth2JwtBearer) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0, 1}
}

func (x *AuthConfig_Oauth2JwtBearer) GetClientKey() *Secret {
	if x != nil {
		return x.ClientKey
	}
	return nil
}

func (x *AuthConfig_Oauth2JwtBearer) GetJwtClaims() *AuthConfig_Oauth2JwtBearer_JwtClaims {
	if x != nil {
		return x.JwtClaims
	}
	return nil
}

// Parameters to support Oauth 2.0 Client Credentials Grant Authentication.
// See https://tools.ietf.org/html/rfc6749#section-1.3.4 for more details.
type AuthConfig_Oauth2ClientCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The client identifier.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Secret version reference containing the client secret.
	ClientSecret *Secret `protobuf:"bytes,2,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
}

func (x *AuthConfig_Oauth2ClientCredentials) Reset() {
	*x = AuthConfig_Oauth2ClientCredentials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig_Oauth2ClientCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_Oauth2ClientCredentials) ProtoMessage() {}

func (x *AuthConfig_Oauth2ClientCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_Oauth2ClientCredentials.ProtoReflect.Descriptor instead.
func (*AuthConfig_Oauth2ClientCredentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0, 2}
}

func (x *AuthConfig_Oauth2ClientCredentials) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *AuthConfig_Oauth2ClientCredentials) GetClientSecret() *Secret {
	if x != nil {
		return x.ClientSecret
	}
	return nil
}

// Parameters to support Ssh public key Authentication.
type AuthConfig_SshPublicKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user account used to authenticate.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// This is an optional field used in case client has enabled multi-factor
	// authentication
	Password *Secret `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// SSH Client Cert. It should contain both public and private key.
	SshClientCert *Secret `protobuf:"bytes,3,opt,name=ssh_client_cert,json=sshClientCert,proto3" json:"ssh_client_cert,omitempty"`
	// Format of SSH Client cert.
	CertType string `protobuf:"bytes,4,opt,name=cert_type,json=certType,proto3" json:"cert_type,omitempty"`
	// Password (passphrase) for ssh client certificate if it has one.
	SshClientCertPass *Secret `protobuf:"bytes,5,opt,name=ssh_client_cert_pass,json=sshClientCertPass,proto3" json:"ssh_client_cert_pass,omitempty"`
}

func (x *AuthConfig_SshPublicKey) Reset() {
	*x = AuthConfig_SshPublicKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig_SshPublicKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_SshPublicKey) ProtoMessage() {}

func (x *AuthConfig_SshPublicKey) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_SshPublicKey.ProtoReflect.Descriptor instead.
func (*AuthConfig_SshPublicKey) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0, 3}
}

func (x *AuthConfig_SshPublicKey) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *AuthConfig_SshPublicKey) GetPassword() *Secret {
	if x != nil {
		return x.Password
	}
	return nil
}

func (x *AuthConfig_SshPublicKey) GetSshClientCert() *Secret {
	if x != nil {
		return x.SshClientCert
	}
	return nil
}

func (x *AuthConfig_SshPublicKey) GetCertType() string {
	if x != nil {
		return x.CertType
	}
	return ""
}

func (x *AuthConfig_SshPublicKey) GetSshClientCertPass() *Secret {
	if x != nil {
		return x.SshClientCertPass
	}
	return nil
}

// JWT claims used for the jwt-bearer authorization grant.
type AuthConfig_Oauth2JwtBearer_JwtClaims struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Value for the "iss" claim.
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// Value for the "sub" claim.
	Subject string `protobuf:"bytes,2,opt,name=subject,proto3" json:"subject,omitempty"`
	// Value for the "aud" claim.
	Audience string `protobuf:"bytes,3,opt,name=audience,proto3" json:"audience,omitempty"`
}

func (x *AuthConfig_Oauth2JwtBearer_JwtClaims) Reset() {
	*x = AuthConfig_Oauth2JwtBearer_JwtClaims{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthConfig_Oauth2JwtBearer_JwtClaims) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthConfig_Oauth2JwtBearer_JwtClaims) ProtoMessage() {}

func (x *AuthConfig_Oauth2JwtBearer_JwtClaims) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_connectors_v1_authconfig_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthConfig_Oauth2JwtBearer_JwtClaims.ProtoReflect.Descriptor instead.
func (*AuthConfig_Oauth2JwtBearer_JwtClaims) Descriptor() ([]byte, []int) {
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *AuthConfig_Oauth2JwtBearer_JwtClaims) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *AuthConfig_Oauth2JwtBearer_JwtClaims) GetSubject() string {
	if x != nil {
		return x.Subject
	}
	return ""
}

func (x *AuthConfig_Oauth2JwtBearer_JwtClaims) GetAudience() string {
	if x != nil {
		return x.Audience
	}
	return ""
}

var File_google_cloud_connectors_v1_authconfig_proto protoreflect.FileDescriptor

var file_google_cloud_connectors_v1_authconfig_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xfe, 0x0a, 0x0a, 0x0a, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x41, 0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x48, 0x00, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0x64, 0x0a, 0x11, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x5f, 0x6a, 0x77, 0x74, 0x5f, 0x62,
	0x65, 0x61, 0x72, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x4a, 0x77, 0x74, 0x42, 0x65, 0x61,
	0x72, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0f, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x4a, 0x77, 0x74,
	0x42, 0x65, 0x61, 0x72, 0x65, 0x72, 0x12, 0x7c, 0x0a, 0x19, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x32,
	0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x72,
	0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x17, 0x6f, 0x61, 0x75,
	0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0x5b, 0x0a, 0x0e, 0x73, 0x73, 0x68, 0x5f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x12, 0x5d, 0x0a, 0x14, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x13, 0x61, 0x64, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x1a, 0x6a, 0x0a, 0x0c, 0x55, 0x73, 0x65, 0x72, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
	0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x08,
	0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x1a, 0x90, 0x02, 0x0a,
	0x0f, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x4a, 0x77, 0x74, 0x42, 0x65, 0x61, 0x72, 0x65, 0x72,
	0x12, 0x41, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x12, 0x5f, 0x0a, 0x0a, 0x6a, 0x77, 0x74, 0x5f, 0x63, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x4a, 0x77, 0x74, 0x42, 0x65, 0x61, 0x72, 0x65, 0x72, 0x2e,
	0x4a, 0x77, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x52, 0x09, 0x6a, 0x77, 0x74, 0x43, 0x6c,
	0x61, 0x69, 0x6d, 0x73, 0x1a, 0x59, 0x0a, 0x09, 0x4a, 0x77, 0x74, 0x43, 0x6c, 0x61, 0x69, 0x6d,
	0x73, 0x12, 0x16, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x73, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x1a,
	0x7f, 0x0a, 0x17, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x32, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x1a, 0xa8, 0x02, 0x0a, 0x0c, 0x53, 0x73, 0x68, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x4b, 0x65,
	0x79, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3e, 0x0a,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x4a, 0x0a,
	0x0f, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x0d, 0x73, 0x73, 0x68, 0x43,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x65, 0x72,
	0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x65,
	0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x14, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x52, 0x11, 0x73, 0x73, 0x68, 0x43, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x50, 0x61, 0x73, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x22, 0xc7, 0x01, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x61, 0x75,
	0x74, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x08, 0x61, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x6e, 0x0a,
	0x19, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x52, 0x17, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x62, 0x6c, 0x65, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2a, 0x82, 0x01,
	0x0a, 0x08, 0x41, 0x75, 0x74, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x41, 0x55,
	0x54, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x50, 0x41,
	0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x41, 0x55, 0x54,
	0x48, 0x32, 0x5f, 0x4a, 0x57, 0x54, 0x5f, 0x42, 0x45, 0x41, 0x52, 0x45, 0x52, 0x10, 0x02, 0x12,
	0x1d, 0x0a, 0x19, 0x4f, 0x41, 0x55, 0x54, 0x48, 0x32, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54,
	0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x10, 0x03, 0x12, 0x12,
	0x0a, 0x0e, 0x53, 0x53, 0x48, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x4b, 0x45, 0x59,
	0x10, 0x04, 0x42, 0x79, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f,
	0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_connectors_v1_authconfig_proto_rawDescOnce sync.Once
	file_google_cloud_connectors_v1_authconfig_proto_rawDescData = file_google_cloud_connectors_v1_authconfig_proto_rawDesc
)

func file_google_cloud_connectors_v1_authconfig_proto_rawDescGZIP() []byte {
	file_google_cloud_connectors_v1_authconfig_proto_rawDescOnce.Do(func() {
		file_google_cloud_connectors_v1_authconfig_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_connectors_v1_authconfig_proto_rawDescData)
	})
	return file_google_cloud_connectors_v1_authconfig_proto_rawDescData
}

var file_google_cloud_connectors_v1_authconfig_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_connectors_v1_authconfig_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_connectors_v1_authconfig_proto_goTypes = []interface{}{
	(AuthType)(0),                                // 0: google.cloud.connectors.v1.AuthType
	(*AuthConfig)(nil),                           // 1: google.cloud.connectors.v1.AuthConfig
	(*AuthConfigTemplate)(nil),                   // 2: google.cloud.connectors.v1.AuthConfigTemplate
	(*AuthConfig_UserPassword)(nil),              // 3: google.cloud.connectors.v1.AuthConfig.UserPassword
	(*AuthConfig_Oauth2JwtBearer)(nil),           // 4: google.cloud.connectors.v1.AuthConfig.Oauth2JwtBearer
	(*AuthConfig_Oauth2ClientCredentials)(nil),   // 5: google.cloud.connectors.v1.AuthConfig.Oauth2ClientCredentials
	(*AuthConfig_SshPublicKey)(nil),              // 6: google.cloud.connectors.v1.AuthConfig.SshPublicKey
	(*AuthConfig_Oauth2JwtBearer_JwtClaims)(nil), // 7: google.cloud.connectors.v1.AuthConfig.Oauth2JwtBearer.JwtClaims
	(*ConfigVariable)(nil),                       // 8: google.cloud.connectors.v1.ConfigVariable
	(*ConfigVariableTemplate)(nil),               // 9: google.cloud.connectors.v1.ConfigVariableTemplate
	(*Secret)(nil),                               // 10: google.cloud.connectors.v1.Secret
}
var file_google_cloud_connectors_v1_authconfig_proto_depIdxs = []int32{
	0,  // 0: google.cloud.connectors.v1.AuthConfig.auth_type:type_name -> google.cloud.connectors.v1.AuthType
	3,  // 1: google.cloud.connectors.v1.AuthConfig.user_password:type_name -> google.cloud.connectors.v1.AuthConfig.UserPassword
	4,  // 2: google.cloud.connectors.v1.AuthConfig.oauth2_jwt_bearer:type_name -> google.cloud.connectors.v1.AuthConfig.Oauth2JwtBearer
	5,  // 3: google.cloud.connectors.v1.AuthConfig.oauth2_client_credentials:type_name -> google.cloud.connectors.v1.AuthConfig.Oauth2ClientCredentials
	6,  // 4: google.cloud.connectors.v1.AuthConfig.ssh_public_key:type_name -> google.cloud.connectors.v1.AuthConfig.SshPublicKey
	8,  // 5: google.cloud.connectors.v1.AuthConfig.additional_variables:type_name -> google.cloud.connectors.v1.ConfigVariable
	0,  // 6: google.cloud.connectors.v1.AuthConfigTemplate.auth_type:type_name -> google.cloud.connectors.v1.AuthType
	9,  // 7: google.cloud.connectors.v1.AuthConfigTemplate.config_variable_templates:type_name -> google.cloud.connectors.v1.ConfigVariableTemplate
	10, // 8: google.cloud.connectors.v1.AuthConfig.UserPassword.password:type_name -> google.cloud.connectors.v1.Secret
	10, // 9: google.cloud.connectors.v1.AuthConfig.Oauth2JwtBearer.client_key:type_name -> google.cloud.connectors.v1.Secret
	7,  // 10: google.cloud.connectors.v1.AuthConfig.Oauth2JwtBearer.jwt_claims:type_name -> google.cloud.connectors.v1.AuthConfig.Oauth2JwtBearer.JwtClaims
	10, // 11: google.cloud.connectors.v1.AuthConfig.Oauth2ClientCredentials.client_secret:type_name -> google.cloud.connectors.v1.Secret
	10, // 12: google.cloud.connectors.v1.AuthConfig.SshPublicKey.password:type_name -> google.cloud.connectors.v1.Secret
	10, // 13: google.cloud.connectors.v1.AuthConfig.SshPublicKey.ssh_client_cert:type_name -> google.cloud.connectors.v1.Secret
	10, // 14: google.cloud.connectors.v1.AuthConfig.SshPublicKey.ssh_client_cert_pass:type_name -> google.cloud.connectors.v1.Secret
	15, // [15:15] is the sub-list for method output_type
	15, // [15:15] is the sub-list for method input_type
	15, // [15:15] is the sub-list for extension type_name
	15, // [15:15] is the sub-list for extension extendee
	0,  // [0:15] is the sub-list for field type_name
}

func init() { file_google_cloud_connectors_v1_authconfig_proto_init() }
func file_google_cloud_connectors_v1_authconfig_proto_init() {
	if File_google_cloud_connectors_v1_authconfig_proto != nil {
		return
	}
	file_google_cloud_connectors_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfigTemplate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig_UserPassword); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig_Oauth2JwtBearer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig_Oauth2ClientCredentials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig_SshPublicKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_connectors_v1_authconfig_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthConfig_Oauth2JwtBearer_JwtClaims); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_connectors_v1_authconfig_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*AuthConfig_UserPassword_)(nil),
		(*AuthConfig_Oauth2JwtBearer_)(nil),
		(*AuthConfig_Oauth2ClientCredentials_)(nil),
		(*AuthConfig_SshPublicKey_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_connectors_v1_authconfig_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_connectors_v1_authconfig_proto_goTypes,
		DependencyIndexes: file_google_cloud_connectors_v1_authconfig_proto_depIdxs,
		EnumInfos:         file_google_cloud_connectors_v1_authconfig_proto_enumTypes,
		MessageInfos:      file_google_cloud_connectors_v1_authconfig_proto_msgTypes,
	}.Build()
	File_google_cloud_connectors_v1_authconfig_proto = out.File
	file_google_cloud_connectors_v1_authconfig_proto_rawDesc = nil
	file_google_cloud_connectors_v1_authconfig_proto_goTypes = nil
	file_google_cloud_connectors_v1_authconfig_proto_depIdxs = nil
}
