// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/maps/places/v1/place.proto

package placespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	viewport "google.golang.org/genproto/googleapis/geo/type/viewport"
	date "google.golang.org/genproto/googleapis/type/date"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	localized_text "google.golang.org/genproto/googleapis/type/localized_text"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Price level of the place.
type PriceLevel int32

const (
	// Place price level is unspecified or unknown.
	PriceLevel_PRICE_LEVEL_UNSPECIFIED PriceLevel = 0
	// Place provides free services.
	PriceLevel_PRICE_LEVEL_FREE PriceLevel = 1
	// Place provides inexpensive services.
	PriceLevel_PRICE_LEVEL_INEXPENSIVE PriceLevel = 2
	// Place provides moderately priced services.
	PriceLevel_PRICE_LEVEL_MODERATE PriceLevel = 3
	// Place provides expensive services.
	PriceLevel_PRICE_LEVEL_EXPENSIVE PriceLevel = 4
	// Place provides very expensive services.
	PriceLevel_PRICE_LEVEL_VERY_EXPENSIVE PriceLevel = 5
)

// Enum value maps for PriceLevel.
var (
	PriceLevel_name = map[int32]string{
		0: "PRICE_LEVEL_UNSPECIFIED",
		1: "PRICE_LEVEL_FREE",
		2: "PRICE_LEVEL_INEXPENSIVE",
		3: "PRICE_LEVEL_MODERATE",
		4: "PRICE_LEVEL_EXPENSIVE",
		5: "PRICE_LEVEL_VERY_EXPENSIVE",
	}
	PriceLevel_value = map[string]int32{
		"PRICE_LEVEL_UNSPECIFIED":    0,
		"PRICE_LEVEL_FREE":           1,
		"PRICE_LEVEL_INEXPENSIVE":    2,
		"PRICE_LEVEL_MODERATE":       3,
		"PRICE_LEVEL_EXPENSIVE":      4,
		"PRICE_LEVEL_VERY_EXPENSIVE": 5,
	}
)

func (x PriceLevel) Enum() *PriceLevel {
	p := new(PriceLevel)
	*p = x
	return p
}

func (x PriceLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PriceLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_place_proto_enumTypes[0].Descriptor()
}

func (PriceLevel) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_place_proto_enumTypes[0]
}

func (x PriceLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PriceLevel.Descriptor instead.
func (PriceLevel) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0}
}

// Business status for the place.
type Place_BusinessStatus int32

const (
	// Default value. This value is unused.
	Place_BUSINESS_STATUS_UNSPECIFIED Place_BusinessStatus = 0
	// The establishment is operational, not necessarily open now.
	Place_OPERATIONAL Place_BusinessStatus = 1
	// The establishment is temporarily closed.
	Place_CLOSED_TEMPORARILY Place_BusinessStatus = 2
	// The establishment is permanently closed.
	Place_CLOSED_PERMANENTLY Place_BusinessStatus = 3
)

// Enum value maps for Place_BusinessStatus.
var (
	Place_BusinessStatus_name = map[int32]string{
		0: "BUSINESS_STATUS_UNSPECIFIED",
		1: "OPERATIONAL",
		2: "CLOSED_TEMPORARILY",
		3: "CLOSED_PERMANENTLY",
	}
	Place_BusinessStatus_value = map[string]int32{
		"BUSINESS_STATUS_UNSPECIFIED": 0,
		"OPERATIONAL":                 1,
		"CLOSED_TEMPORARILY":          2,
		"CLOSED_PERMANENTLY":          3,
	}
)

func (x Place_BusinessStatus) Enum() *Place_BusinessStatus {
	p := new(Place_BusinessStatus)
	*p = x
	return p
}

func (x Place_BusinessStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Place_BusinessStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_place_proto_enumTypes[1].Descriptor()
}

func (Place_BusinessStatus) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_place_proto_enumTypes[1]
}

func (x Place_BusinessStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Place_BusinessStatus.Descriptor instead.
func (Place_BusinessStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 0}
}

// A type used to identify the type of secondary hours.
type Place_OpeningHours_SecondaryHoursType int32

const (
	// Default value when secondary hour type is not specified.
	Place_OpeningHours_SECONDARY_HOURS_TYPE_UNSPECIFIED Place_OpeningHours_SecondaryHoursType = 0
	// The drive-through hour for banks, restaurants, or pharmacies.
	Place_OpeningHours_DRIVE_THROUGH Place_OpeningHours_SecondaryHoursType = 1
	// The happy hour.
	Place_OpeningHours_HAPPY_HOUR Place_OpeningHours_SecondaryHoursType = 2
	// The delivery hour.
	Place_OpeningHours_DELIVERY Place_OpeningHours_SecondaryHoursType = 3
	// The takeout hour.
	Place_OpeningHours_TAKEOUT Place_OpeningHours_SecondaryHoursType = 4
	// The kitchen hour.
	Place_OpeningHours_KITCHEN Place_OpeningHours_SecondaryHoursType = 5
	// The breakfast hour.
	Place_OpeningHours_BREAKFAST Place_OpeningHours_SecondaryHoursType = 6
	// The lunch hour.
	Place_OpeningHours_LUNCH Place_OpeningHours_SecondaryHoursType = 7
	// The dinner hour.
	Place_OpeningHours_DINNER Place_OpeningHours_SecondaryHoursType = 8
	// The brunch hour.
	Place_OpeningHours_BRUNCH Place_OpeningHours_SecondaryHoursType = 9
	// The pickup hour.
	Place_OpeningHours_PICKUP Place_OpeningHours_SecondaryHoursType = 10
	// The access hours for storage places.
	Place_OpeningHours_ACCESS Place_OpeningHours_SecondaryHoursType = 11
	// The special hours for seniors.
	Place_OpeningHours_SENIOR_HOURS Place_OpeningHours_SecondaryHoursType = 12
	// The online service hours.
	Place_OpeningHours_ONLINE_SERVICE_HOURS Place_OpeningHours_SecondaryHoursType = 13
)

// Enum value maps for Place_OpeningHours_SecondaryHoursType.
var (
	Place_OpeningHours_SecondaryHoursType_name = map[int32]string{
		0:  "SECONDARY_HOURS_TYPE_UNSPECIFIED",
		1:  "DRIVE_THROUGH",
		2:  "HAPPY_HOUR",
		3:  "DELIVERY",
		4:  "TAKEOUT",
		5:  "KITCHEN",
		6:  "BREAKFAST",
		7:  "LUNCH",
		8:  "DINNER",
		9:  "BRUNCH",
		10: "PICKUP",
		11: "ACCESS",
		12: "SENIOR_HOURS",
		13: "ONLINE_SERVICE_HOURS",
	}
	Place_OpeningHours_SecondaryHoursType_value = map[string]int32{
		"SECONDARY_HOURS_TYPE_UNSPECIFIED": 0,
		"DRIVE_THROUGH":                    1,
		"HAPPY_HOUR":                       2,
		"DELIVERY":                         3,
		"TAKEOUT":                          4,
		"KITCHEN":                          5,
		"BREAKFAST":                        6,
		"LUNCH":                            7,
		"DINNER":                           8,
		"BRUNCH":                           9,
		"PICKUP":                           10,
		"ACCESS":                           11,
		"SENIOR_HOURS":                     12,
		"ONLINE_SERVICE_HOURS":             13,
	}
)

func (x Place_OpeningHours_SecondaryHoursType) Enum() *Place_OpeningHours_SecondaryHoursType {
	p := new(Place_OpeningHours_SecondaryHoursType)
	*p = x
	return p
}

func (x Place_OpeningHours_SecondaryHoursType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Place_OpeningHours_SecondaryHoursType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_places_v1_place_proto_enumTypes[2].Descriptor()
}

func (Place_OpeningHours_SecondaryHoursType) Type() protoreflect.EnumType {
	return &file_google_maps_places_v1_place_proto_enumTypes[2]
}

func (x Place_OpeningHours_SecondaryHoursType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Place_OpeningHours_SecondaryHoursType.Descriptor instead.
func (Place_OpeningHours_SecondaryHoursType) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 2, 0}
}

// All the information representing a Place.
type Place struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This Place's resource name, in `places/{place_id}` format.  Can be used to
	// look up the Place.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique identifier of a place.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The localized name of the place, suitable as a short human-readable
	// description. For example, "Google Sydney", "Starbucks", "Pyrmont", etc.
	DisplayName *localized_text.LocalizedText `protobuf:"bytes,31,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A set of type tags for this result. For example, "political" and
	// "locality". For the complete list of possible values, see Table A and Table
	// B at
	// https://developers.google.com/maps/documentation/places/web-service/place-types
	Types []string `protobuf:"bytes,5,rep,name=types,proto3" json:"types,omitempty"`
	// The primary type of the given result. This type must be one of the Places
	// API supported types. For example, "restaurant", "cafe", "airport", etc.  A
	// place can only have a single primary type.  For the complete list of
	// possible values, see Table A and Table B at
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// The primary type may be missing if the place's primary type is not a
	// supported type. When a primary type is present, it is always one of the
	// types in the `types` field.
	PrimaryType string `protobuf:"bytes,50,opt,name=primary_type,json=primaryType,proto3" json:"primary_type,omitempty"`
	// The display name of the primary type, localized to the request language if
	// applicable. For the complete list of possible values, see Table A and Table
	// B at
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// The primary type may be missing if the place's primary type is not a
	// supported type.
	PrimaryTypeDisplayName *localized_text.LocalizedText `protobuf:"bytes,32,opt,name=primary_type_display_name,json=primaryTypeDisplayName,proto3" json:"primary_type_display_name,omitempty"`
	// A human-readable phone number for the place, in national format.
	NationalPhoneNumber string `protobuf:"bytes,7,opt,name=national_phone_number,json=nationalPhoneNumber,proto3" json:"national_phone_number,omitempty"`
	// A human-readable phone number for the place, in international format.
	InternationalPhoneNumber string `protobuf:"bytes,8,opt,name=international_phone_number,json=internationalPhoneNumber,proto3" json:"international_phone_number,omitempty"`
	// A full, human-readable address for this place.
	FormattedAddress string `protobuf:"bytes,9,opt,name=formatted_address,json=formattedAddress,proto3" json:"formatted_address,omitempty"`
	// A short, human-readable address for this place.
	ShortFormattedAddress string `protobuf:"bytes,51,opt,name=short_formatted_address,json=shortFormattedAddress,proto3" json:"short_formatted_address,omitempty"`
	// The address in postal address format.
	PostalAddress *postaladdress.PostalAddress `protobuf:"bytes,90,opt,name=postal_address,json=postalAddress,proto3" json:"postal_address,omitempty"`
	// Repeated components for each locality level.
	// Note the following facts about the address_components[] array:
	// - The array of address components may contain more components than the
	// formatted_address.
	// - The array does not necessarily include all the political entities that
	// contain an address, apart from those included in the formatted_address. To
	// retrieve all the political entities that contain a specific address, you
	// should use reverse geocoding, passing the latitude/longitude of the address
	// as a parameter to the request.
	// - The format of the response is not guaranteed to remain the same between
	// requests. In particular, the number of address_components varies based on
	// the address requested and can change over time for the same address. A
	// component can change position in the array. The type of the component can
	// change. A particular component may be missing in a later response.
	AddressComponents []*Place_AddressComponent `protobuf:"bytes,10,rep,name=address_components,json=addressComponents,proto3" json:"address_components,omitempty"`
	// Plus code of the place location lat/long.
	PlusCode *Place_PlusCode `protobuf:"bytes,11,opt,name=plus_code,json=plusCode,proto3" json:"plus_code,omitempty"`
	// The position of this place.
	Location *latlng.LatLng `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
	// A viewport suitable for displaying the place on an average-sized map. This
	// viewport should not be used as the physical boundary or the service area of
	// the business.
	Viewport *viewport.Viewport `protobuf:"bytes,13,opt,name=viewport,proto3" json:"viewport,omitempty"`
	// A rating between 1.0 and 5.0, based on user reviews of this place.
	Rating float64 `protobuf:"fixed64,14,opt,name=rating,proto3" json:"rating,omitempty"`
	// A URL providing more information about this place.
	GoogleMapsUri string `protobuf:"bytes,15,opt,name=google_maps_uri,json=googleMapsUri,proto3" json:"google_maps_uri,omitempty"`
	// The authoritative website for this place, e.g. a business' homepage.
	// Note that for places that are part of a chain (e.g. an IKEA store), this
	// will usually be the website for the individual store, not the overall
	// chain.
	WebsiteUri string `protobuf:"bytes,16,opt,name=website_uri,json=websiteUri,proto3" json:"website_uri,omitempty"`
	// List of reviews about this place, sorted by relevance. A maximum of 5
	// reviews can be returned.
	Reviews []*Review `protobuf:"bytes,53,rep,name=reviews,proto3" json:"reviews,omitempty"`
	// The regular hours of operation. Note that if a place is always open (24
	// hours), the `close` field will not be set. Clients can rely on always open
	// (24 hours) being represented as an
	// [`open`](https://developers.google.com/maps/documentation/places/web-service/reference/rest/v1/places#Period)
	// period containing
	// [`day`](https://developers.google.com/maps/documentation/places/web-service/reference/rest/v1/places#Point)
	// with value `0`,
	// [`hour`](https://developers.google.com/maps/documentation/places/web-service/reference/rest/v1/places#Point)
	// with value `0`, and
	// [`minute`](https://developers.google.com/maps/documentation/places/web-service/reference/rest/v1/places#Point)
	// with value `0`.
	RegularOpeningHours *Place_OpeningHours `protobuf:"bytes,21,opt,name=regular_opening_hours,json=regularOpeningHours,proto3" json:"regular_opening_hours,omitempty"`
	// Number of minutes this place's timezone is currently offset from UTC.
	// This is expressed in minutes to support timezones that are offset by
	// fractions of an hour, e.g. X hours and 15 minutes.
	UtcOffsetMinutes *int32 `protobuf:"varint,22,opt,name=utc_offset_minutes,json=utcOffsetMinutes,proto3,oneof" json:"utc_offset_minutes,omitempty"`
	// IANA Time Zone Database time zone. For example "America/New_York".
	TimeZone *datetime.TimeZone `protobuf:"bytes,88,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Information (including references) about photos of this place. A maximum of
	// 10 photos can be returned.
	Photos []*Photo `protobuf:"bytes,54,rep,name=photos,proto3" json:"photos,omitempty"`
	// The place's address in adr microformat: http://microformats.org/wiki/adr.
	AdrFormatAddress string `protobuf:"bytes,24,opt,name=adr_format_address,json=adrFormatAddress,proto3" json:"adr_format_address,omitempty"`
	// The business status for the place.
	BusinessStatus Place_BusinessStatus `protobuf:"varint,25,opt,name=business_status,json=businessStatus,proto3,enum=google.maps.places.v1.Place_BusinessStatus" json:"business_status,omitempty"`
	// Price level of the place.
	PriceLevel PriceLevel `protobuf:"varint,26,opt,name=price_level,json=priceLevel,proto3,enum=google.maps.places.v1.PriceLevel" json:"price_level,omitempty"`
	// A set of data provider that must be shown with this result.
	Attributions []*Place_Attribution `protobuf:"bytes,27,rep,name=attributions,proto3" json:"attributions,omitempty"`
	// The total number of reviews (with or without text) for this place.
	UserRatingCount *int32 `protobuf:"varint,28,opt,name=user_rating_count,json=userRatingCount,proto3,oneof" json:"user_rating_count,omitempty"`
	// A truncated URL to an icon mask. User can access different icon type by
	// appending type suffix to the end (eg, ".svg" or ".png").
	IconMaskBaseUri string `protobuf:"bytes,29,opt,name=icon_mask_base_uri,json=iconMaskBaseUri,proto3" json:"icon_mask_base_uri,omitempty"`
	// Background color for icon_mask in hex format, e.g. #909CE1.
	IconBackgroundColor string `protobuf:"bytes,30,opt,name=icon_background_color,json=iconBackgroundColor,proto3" json:"icon_background_color,omitempty"`
	// Specifies if the business supports takeout.
	Takeout *bool `protobuf:"varint,33,opt,name=takeout,proto3,oneof" json:"takeout,omitempty"`
	// Specifies if the business supports delivery.
	Delivery *bool `protobuf:"varint,34,opt,name=delivery,proto3,oneof" json:"delivery,omitempty"`
	// Specifies if the business supports indoor or outdoor seating options.
	DineIn *bool `protobuf:"varint,35,opt,name=dine_in,json=dineIn,proto3,oneof" json:"dine_in,omitempty"`
	// Specifies if the business supports curbside pickup.
	CurbsidePickup *bool `protobuf:"varint,36,opt,name=curbside_pickup,json=curbsidePickup,proto3,oneof" json:"curbside_pickup,omitempty"`
	// Specifies if the place supports reservations.
	Reservable *bool `protobuf:"varint,38,opt,name=reservable,proto3,oneof" json:"reservable,omitempty"`
	// Specifies if the place serves breakfast.
	ServesBreakfast *bool `protobuf:"varint,39,opt,name=serves_breakfast,json=servesBreakfast,proto3,oneof" json:"serves_breakfast,omitempty"`
	// Specifies if the place serves lunch.
	ServesLunch *bool `protobuf:"varint,40,opt,name=serves_lunch,json=servesLunch,proto3,oneof" json:"serves_lunch,omitempty"`
	// Specifies if the place serves dinner.
	ServesDinner *bool `protobuf:"varint,41,opt,name=serves_dinner,json=servesDinner,proto3,oneof" json:"serves_dinner,omitempty"`
	// Specifies if the place serves beer.
	ServesBeer *bool `protobuf:"varint,42,opt,name=serves_beer,json=servesBeer,proto3,oneof" json:"serves_beer,omitempty"`
	// Specifies if the place serves wine.
	ServesWine *bool `protobuf:"varint,43,opt,name=serves_wine,json=servesWine,proto3,oneof" json:"serves_wine,omitempty"`
	// Specifies if the place serves brunch.
	ServesBrunch *bool `protobuf:"varint,44,opt,name=serves_brunch,json=servesBrunch,proto3,oneof" json:"serves_brunch,omitempty"`
	// Specifies if the place serves vegetarian food.
	ServesVegetarianFood *bool `protobuf:"varint,45,opt,name=serves_vegetarian_food,json=servesVegetarianFood,proto3,oneof" json:"serves_vegetarian_food,omitempty"`
	// The hours of operation for the next seven days (including today). The time
	// period starts at midnight on the date of the request and ends at 11:59 pm
	// six days later. This field includes the special_days subfield of all hours,
	// set for dates that have exceptional hours.
	CurrentOpeningHours *Place_OpeningHours `protobuf:"bytes,46,opt,name=current_opening_hours,json=currentOpeningHours,proto3" json:"current_opening_hours,omitempty"`
	// Contains an array of entries for the next seven days including information
	// about secondary hours of a business. Secondary hours are different from a
	// business's main hours. For example, a restaurant can specify drive through
	// hours or delivery hours as its secondary hours. This field populates the
	// type subfield, which draws from a predefined list of opening hours types
	// (such as DRIVE_THROUGH, PICKUP, or TAKEOUT) based on the types of the
	// place. This field includes the special_days subfield of all hours, set for
	// dates that have exceptional hours.
	CurrentSecondaryOpeningHours []*Place_OpeningHours `protobuf:"bytes,47,rep,name=current_secondary_opening_hours,json=currentSecondaryOpeningHours,proto3" json:"current_secondary_opening_hours,omitempty"`
	// Contains an array of entries for information about regular secondary hours
	// of a business. Secondary hours are different from a business's main hours.
	// For example, a restaurant can specify drive through hours or delivery hours
	// as its secondary hours. This field populates the type subfield, which draws
	// from a predefined list of opening hours types (such as DRIVE_THROUGH,
	// PICKUP, or TAKEOUT) based on the types of the place.
	RegularSecondaryOpeningHours []*Place_OpeningHours `protobuf:"bytes,49,rep,name=regular_secondary_opening_hours,json=regularSecondaryOpeningHours,proto3" json:"regular_secondary_opening_hours,omitempty"`
	// Contains a summary of the place. A summary is comprised of a textual
	// overview, and also includes the language code for these if applicable.
	// Summary text must be presented as-is and can not be modified or altered.
	EditorialSummary *localized_text.LocalizedText `protobuf:"bytes,52,opt,name=editorial_summary,json=editorialSummary,proto3" json:"editorial_summary,omitempty"`
	// Place provides outdoor seating.
	OutdoorSeating *bool `protobuf:"varint,55,opt,name=outdoor_seating,json=outdoorSeating,proto3,oneof" json:"outdoor_seating,omitempty"`
	// Place provides live music.
	LiveMusic *bool `protobuf:"varint,56,opt,name=live_music,json=liveMusic,proto3,oneof" json:"live_music,omitempty"`
	// Place has a children's menu.
	MenuForChildren *bool `protobuf:"varint,57,opt,name=menu_for_children,json=menuForChildren,proto3,oneof" json:"menu_for_children,omitempty"`
	// Place serves cocktails.
	ServesCocktails *bool `protobuf:"varint,58,opt,name=serves_cocktails,json=servesCocktails,proto3,oneof" json:"serves_cocktails,omitempty"`
	// Place serves dessert.
	ServesDessert *bool `protobuf:"varint,59,opt,name=serves_dessert,json=servesDessert,proto3,oneof" json:"serves_dessert,omitempty"`
	// Place serves coffee.
	ServesCoffee *bool `protobuf:"varint,60,opt,name=serves_coffee,json=servesCoffee,proto3,oneof" json:"serves_coffee,omitempty"`
	// Place is good for children.
	GoodForChildren *bool `protobuf:"varint,62,opt,name=good_for_children,json=goodForChildren,proto3,oneof" json:"good_for_children,omitempty"`
	// Place allows dogs.
	AllowsDogs *bool `protobuf:"varint,63,opt,name=allows_dogs,json=allowsDogs,proto3,oneof" json:"allows_dogs,omitempty"`
	// Place has restroom.
	Restroom *bool `protobuf:"varint,64,opt,name=restroom,proto3,oneof" json:"restroom,omitempty"`
	// Place accommodates groups.
	GoodForGroups *bool `protobuf:"varint,65,opt,name=good_for_groups,json=goodForGroups,proto3,oneof" json:"good_for_groups,omitempty"`
	// Place is suitable for watching sports.
	GoodForWatchingSports *bool `protobuf:"varint,66,opt,name=good_for_watching_sports,json=goodForWatchingSports,proto3,oneof" json:"good_for_watching_sports,omitempty"`
	// Payment options the place accepts. If a payment option data is not
	// available, the payment option field will be unset.
	PaymentOptions *Place_PaymentOptions `protobuf:"bytes,67,opt,name=payment_options,json=paymentOptions,proto3" json:"payment_options,omitempty"`
	// Options of parking provided by the place.
	ParkingOptions *Place_ParkingOptions `protobuf:"bytes,70,opt,name=parking_options,json=parkingOptions,proto3" json:"parking_options,omitempty"`
	// A list of sub-destinations related to the place.
	SubDestinations []*Place_SubDestination `protobuf:"bytes,71,rep,name=sub_destinations,json=subDestinations,proto3" json:"sub_destinations,omitempty"`
	// Information about the accessibility options a place offers.
	AccessibilityOptions *Place_AccessibilityOptions `protobuf:"bytes,72,opt,name=accessibility_options,json=accessibilityOptions,proto3,oneof" json:"accessibility_options,omitempty"`
	// The most recent information about fuel options in a gas station. This
	// information is updated regularly.
	FuelOptions *FuelOptions `protobuf:"bytes,78,opt,name=fuel_options,json=fuelOptions,proto3" json:"fuel_options,omitempty"`
	// Information of ev charging options.
	EvChargeOptions *EVChargeOptions `protobuf:"bytes,79,opt,name=ev_charge_options,json=evChargeOptions,proto3" json:"ev_charge_options,omitempty"`
	// AI-generated summary of the place.
	GenerativeSummary *Place_GenerativeSummary `protobuf:"bytes,80,opt,name=generative_summary,json=generativeSummary,proto3" json:"generative_summary,omitempty"`
	// List of places in which the current place is located.
	ContainingPlaces []*Place_ContainingPlace `protobuf:"bytes,82,rep,name=containing_places,json=containingPlaces,proto3" json:"containing_places,omitempty"`
	// Indicates whether the place is a pure service area business. Pure service
	// area business is a business that visits or delivers to customers directly
	// but does not serve customers at their business address. For example,
	// businesses like cleaning services or plumbers. Those businesses may not
	// have a physical address or location on Google Maps.
	PureServiceAreaBusiness *bool `protobuf:"varint,83,opt,name=pure_service_area_business,json=pureServiceAreaBusiness,proto3,oneof" json:"pure_service_area_business,omitempty"`
	// The address descriptor of the place. Address descriptors include additional
	// information that help describe a location using landmarks and areas. See
	// address descriptor regional coverage in
	// https://developers.google.com/maps/documentation/geocoding/address-descriptors/coverage.
	AddressDescriptor *AddressDescriptor `protobuf:"bytes,84,opt,name=address_descriptor,json=addressDescriptor,proto3" json:"address_descriptor,omitempty"`
	// The price range associated with a Place.
	PriceRange *PriceRange `protobuf:"bytes,86,opt,name=price_range,json=priceRange,proto3" json:"price_range,omitempty"`
	// AI-generated summary of the place using user reviews.
	ReviewSummary *Place_ReviewSummary `protobuf:"bytes,87,opt,name=review_summary,json=reviewSummary,proto3" json:"review_summary,omitempty"`
	// The summary of amenities near the EV charging station.
	EvChargeAmenitySummary *Place_EvChargeAmenitySummary `protobuf:"bytes,89,opt,name=ev_charge_amenity_summary,json=evChargeAmenitySummary,proto3" json:"ev_charge_amenity_summary,omitempty"`
	// A summary of points of interest near the place.
	NeighborhoodSummary *Place_NeighborhoodSummary `protobuf:"bytes,91,opt,name=neighborhood_summary,json=neighborhoodSummary,proto3" json:"neighborhood_summary,omitempty"`
	// The consumer alert message for the place when we detect suspicious review
	// activity on a business or a business violates our policies.
	ConsumerAlert *Place_ConsumerAlert `protobuf:"bytes,92,opt,name=consumer_alert,json=consumerAlert,proto3" json:"consumer_alert,omitempty"`
	// If this Place is permanently closed and has moved to a new Place, this
	// field contains the new Place's resource name, in `places/{place_id}`
	// format. If this Place moved multiple times, this field will represent the
	// first moved place. This field will not be populated if this Place has not
	// moved.
	MovedPlace string `protobuf:"bytes,93,opt,name=moved_place,json=movedPlace,proto3" json:"moved_place,omitempty"`
	// If this Place is permanently closed and has moved to a new Place, this
	// field contains the new Place's place ID. If this Place moved multiple
	// times, this field will represent the first moved Place. This field will not
	// be populated if this Place has not moved.
	MovedPlaceId string `protobuf:"bytes,94,opt,name=moved_place_id,json=movedPlaceId,proto3" json:"moved_place_id,omitempty"`
}

func (x *Place) Reset() {
	*x = Place{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place) ProtoMessage() {}

func (x *Place) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place.ProtoReflect.Descriptor instead.
func (*Place) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0}
}

func (x *Place) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Place) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Place) GetDisplayName() *localized_text.LocalizedText {
	if x != nil {
		return x.DisplayName
	}
	return nil
}

func (x *Place) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *Place) GetPrimaryType() string {
	if x != nil {
		return x.PrimaryType
	}
	return ""
}

func (x *Place) GetPrimaryTypeDisplayName() *localized_text.LocalizedText {
	if x != nil {
		return x.PrimaryTypeDisplayName
	}
	return nil
}

func (x *Place) GetNationalPhoneNumber() string {
	if x != nil {
		return x.NationalPhoneNumber
	}
	return ""
}

func (x *Place) GetInternationalPhoneNumber() string {
	if x != nil {
		return x.InternationalPhoneNumber
	}
	return ""
}

func (x *Place) GetFormattedAddress() string {
	if x != nil {
		return x.FormattedAddress
	}
	return ""
}

func (x *Place) GetShortFormattedAddress() string {
	if x != nil {
		return x.ShortFormattedAddress
	}
	return ""
}

func (x *Place) GetPostalAddress() *postaladdress.PostalAddress {
	if x != nil {
		return x.PostalAddress
	}
	return nil
}

func (x *Place) GetAddressComponents() []*Place_AddressComponent {
	if x != nil {
		return x.AddressComponents
	}
	return nil
}

func (x *Place) GetPlusCode() *Place_PlusCode {
	if x != nil {
		return x.PlusCode
	}
	return nil
}

func (x *Place) GetLocation() *latlng.LatLng {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *Place) GetViewport() *viewport.Viewport {
	if x != nil {
		return x.Viewport
	}
	return nil
}

func (x *Place) GetRating() float64 {
	if x != nil {
		return x.Rating
	}
	return 0
}

func (x *Place) GetGoogleMapsUri() string {
	if x != nil {
		return x.GoogleMapsUri
	}
	return ""
}

func (x *Place) GetWebsiteUri() string {
	if x != nil {
		return x.WebsiteUri
	}
	return ""
}

func (x *Place) GetReviews() []*Review {
	if x != nil {
		return x.Reviews
	}
	return nil
}

func (x *Place) GetRegularOpeningHours() *Place_OpeningHours {
	if x != nil {
		return x.RegularOpeningHours
	}
	return nil
}

func (x *Place) GetUtcOffsetMinutes() int32 {
	if x != nil && x.UtcOffsetMinutes != nil {
		return *x.UtcOffsetMinutes
	}
	return 0
}

func (x *Place) GetTimeZone() *datetime.TimeZone {
	if x != nil {
		return x.TimeZone
	}
	return nil
}

func (x *Place) GetPhotos() []*Photo {
	if x != nil {
		return x.Photos
	}
	return nil
}

func (x *Place) GetAdrFormatAddress() string {
	if x != nil {
		return x.AdrFormatAddress
	}
	return ""
}

func (x *Place) GetBusinessStatus() Place_BusinessStatus {
	if x != nil {
		return x.BusinessStatus
	}
	return Place_BUSINESS_STATUS_UNSPECIFIED
}

func (x *Place) GetPriceLevel() PriceLevel {
	if x != nil {
		return x.PriceLevel
	}
	return PriceLevel_PRICE_LEVEL_UNSPECIFIED
}

func (x *Place) GetAttributions() []*Place_Attribution {
	if x != nil {
		return x.Attributions
	}
	return nil
}

func (x *Place) GetUserRatingCount() int32 {
	if x != nil && x.UserRatingCount != nil {
		return *x.UserRatingCount
	}
	return 0
}

func (x *Place) GetIconMaskBaseUri() string {
	if x != nil {
		return x.IconMaskBaseUri
	}
	return ""
}

func (x *Place) GetIconBackgroundColor() string {
	if x != nil {
		return x.IconBackgroundColor
	}
	return ""
}

func (x *Place) GetTakeout() bool {
	if x != nil && x.Takeout != nil {
		return *x.Takeout
	}
	return false
}

func (x *Place) GetDelivery() bool {
	if x != nil && x.Delivery != nil {
		return *x.Delivery
	}
	return false
}

func (x *Place) GetDineIn() bool {
	if x != nil && x.DineIn != nil {
		return *x.DineIn
	}
	return false
}

func (x *Place) GetCurbsidePickup() bool {
	if x != nil && x.CurbsidePickup != nil {
		return *x.CurbsidePickup
	}
	return false
}

func (x *Place) GetReservable() bool {
	if x != nil && x.Reservable != nil {
		return *x.Reservable
	}
	return false
}

func (x *Place) GetServesBreakfast() bool {
	if x != nil && x.ServesBreakfast != nil {
		return *x.ServesBreakfast
	}
	return false
}

func (x *Place) GetServesLunch() bool {
	if x != nil && x.ServesLunch != nil {
		return *x.ServesLunch
	}
	return false
}

func (x *Place) GetServesDinner() bool {
	if x != nil && x.ServesDinner != nil {
		return *x.ServesDinner
	}
	return false
}

func (x *Place) GetServesBeer() bool {
	if x != nil && x.ServesBeer != nil {
		return *x.ServesBeer
	}
	return false
}

func (x *Place) GetServesWine() bool {
	if x != nil && x.ServesWine != nil {
		return *x.ServesWine
	}
	return false
}

func (x *Place) GetServesBrunch() bool {
	if x != nil && x.ServesBrunch != nil {
		return *x.ServesBrunch
	}
	return false
}

func (x *Place) GetServesVegetarianFood() bool {
	if x != nil && x.ServesVegetarianFood != nil {
		return *x.ServesVegetarianFood
	}
	return false
}

func (x *Place) GetCurrentOpeningHours() *Place_OpeningHours {
	if x != nil {
		return x.CurrentOpeningHours
	}
	return nil
}

func (x *Place) GetCurrentSecondaryOpeningHours() []*Place_OpeningHours {
	if x != nil {
		return x.CurrentSecondaryOpeningHours
	}
	return nil
}

func (x *Place) GetRegularSecondaryOpeningHours() []*Place_OpeningHours {
	if x != nil {
		return x.RegularSecondaryOpeningHours
	}
	return nil
}

func (x *Place) GetEditorialSummary() *localized_text.LocalizedText {
	if x != nil {
		return x.EditorialSummary
	}
	return nil
}

func (x *Place) GetOutdoorSeating() bool {
	if x != nil && x.OutdoorSeating != nil {
		return *x.OutdoorSeating
	}
	return false
}

func (x *Place) GetLiveMusic() bool {
	if x != nil && x.LiveMusic != nil {
		return *x.LiveMusic
	}
	return false
}

func (x *Place) GetMenuForChildren() bool {
	if x != nil && x.MenuForChildren != nil {
		return *x.MenuForChildren
	}
	return false
}

func (x *Place) GetServesCocktails() bool {
	if x != nil && x.ServesCocktails != nil {
		return *x.ServesCocktails
	}
	return false
}

func (x *Place) GetServesDessert() bool {
	if x != nil && x.ServesDessert != nil {
		return *x.ServesDessert
	}
	return false
}

func (x *Place) GetServesCoffee() bool {
	if x != nil && x.ServesCoffee != nil {
		return *x.ServesCoffee
	}
	return false
}

func (x *Place) GetGoodForChildren() bool {
	if x != nil && x.GoodForChildren != nil {
		return *x.GoodForChildren
	}
	return false
}

func (x *Place) GetAllowsDogs() bool {
	if x != nil && x.AllowsDogs != nil {
		return *x.AllowsDogs
	}
	return false
}

func (x *Place) GetRestroom() bool {
	if x != nil && x.Restroom != nil {
		return *x.Restroom
	}
	return false
}

func (x *Place) GetGoodForGroups() bool {
	if x != nil && x.GoodForGroups != nil {
		return *x.GoodForGroups
	}
	return false
}

func (x *Place) GetGoodForWatchingSports() bool {
	if x != nil && x.GoodForWatchingSports != nil {
		return *x.GoodForWatchingSports
	}
	return false
}

func (x *Place) GetPaymentOptions() *Place_PaymentOptions {
	if x != nil {
		return x.PaymentOptions
	}
	return nil
}

func (x *Place) GetParkingOptions() *Place_ParkingOptions {
	if x != nil {
		return x.ParkingOptions
	}
	return nil
}

func (x *Place) GetSubDestinations() []*Place_SubDestination {
	if x != nil {
		return x.SubDestinations
	}
	return nil
}

func (x *Place) GetAccessibilityOptions() *Place_AccessibilityOptions {
	if x != nil {
		return x.AccessibilityOptions
	}
	return nil
}

func (x *Place) GetFuelOptions() *FuelOptions {
	if x != nil {
		return x.FuelOptions
	}
	return nil
}

func (x *Place) GetEvChargeOptions() *EVChargeOptions {
	if x != nil {
		return x.EvChargeOptions
	}
	return nil
}

func (x *Place) GetGenerativeSummary() *Place_GenerativeSummary {
	if x != nil {
		return x.GenerativeSummary
	}
	return nil
}

func (x *Place) GetContainingPlaces() []*Place_ContainingPlace {
	if x != nil {
		return x.ContainingPlaces
	}
	return nil
}

func (x *Place) GetPureServiceAreaBusiness() bool {
	if x != nil && x.PureServiceAreaBusiness != nil {
		return *x.PureServiceAreaBusiness
	}
	return false
}

func (x *Place) GetAddressDescriptor() *AddressDescriptor {
	if x != nil {
		return x.AddressDescriptor
	}
	return nil
}

func (x *Place) GetPriceRange() *PriceRange {
	if x != nil {
		return x.PriceRange
	}
	return nil
}

func (x *Place) GetReviewSummary() *Place_ReviewSummary {
	if x != nil {
		return x.ReviewSummary
	}
	return nil
}

func (x *Place) GetEvChargeAmenitySummary() *Place_EvChargeAmenitySummary {
	if x != nil {
		return x.EvChargeAmenitySummary
	}
	return nil
}

func (x *Place) GetNeighborhoodSummary() *Place_NeighborhoodSummary {
	if x != nil {
		return x.NeighborhoodSummary
	}
	return nil
}

func (x *Place) GetConsumerAlert() *Place_ConsumerAlert {
	if x != nil {
		return x.ConsumerAlert
	}
	return nil
}

func (x *Place) GetMovedPlace() string {
	if x != nil {
		return x.MovedPlace
	}
	return ""
}

func (x *Place) GetMovedPlaceId() string {
	if x != nil {
		return x.MovedPlaceId
	}
	return ""
}

// The structured components that form the formatted address, if this
// information is available.
type Place_AddressComponent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full text description or name of the address component. For example,
	// an address component for the country Australia may have a long_name of
	// "Australia".
	LongText string `protobuf:"bytes,1,opt,name=long_text,json=longText,proto3" json:"long_text,omitempty"`
	// An abbreviated textual name for the address component, if available. For
	// example, an address component for the country of Australia may have a
	// short_name of "AU".
	ShortText string `protobuf:"bytes,2,opt,name=short_text,json=shortText,proto3" json:"short_text,omitempty"`
	// An array indicating the type(s) of the address component.
	Types []string `protobuf:"bytes,3,rep,name=types,proto3" json:"types,omitempty"`
	// The language used to format this components, in CLDR notation.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Place_AddressComponent) Reset() {
	*x = Place_AddressComponent{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_AddressComponent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_AddressComponent) ProtoMessage() {}

func (x *Place_AddressComponent) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_AddressComponent.ProtoReflect.Descriptor instead.
func (*Place_AddressComponent) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Place_AddressComponent) GetLongText() string {
	if x != nil {
		return x.LongText
	}
	return ""
}

func (x *Place_AddressComponent) GetShortText() string {
	if x != nil {
		return x.ShortText
	}
	return ""
}

func (x *Place_AddressComponent) GetTypes() []string {
	if x != nil {
		return x.Types
	}
	return nil
}

func (x *Place_AddressComponent) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// Plus code (http://plus.codes) is a location reference with two formats:
// global code defining a 14mx14m (1/8000th of a degree) or smaller rectangle,
// and compound code, replacing the prefix with a reference location.
type Place_PlusCode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place's global (full) code, such as "9FWM33GV+HQ", representing an
	// 1/8000 by 1/8000 degree area (~14 by 14 meters).
	GlobalCode string `protobuf:"bytes,1,opt,name=global_code,json=globalCode,proto3" json:"global_code,omitempty"`
	// Place's compound code, such as "33GV+HQ, Ramberg, Norway", containing
	// the suffix of the global code and replacing the prefix with a formatted
	// name of a reference entity.
	CompoundCode string `protobuf:"bytes,2,opt,name=compound_code,json=compoundCode,proto3" json:"compound_code,omitempty"`
}

func (x *Place_PlusCode) Reset() {
	*x = Place_PlusCode{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_PlusCode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_PlusCode) ProtoMessage() {}

func (x *Place_PlusCode) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_PlusCode.ProtoReflect.Descriptor instead.
func (*Place_PlusCode) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Place_PlusCode) GetGlobalCode() string {
	if x != nil {
		return x.GlobalCode
	}
	return ""
}

func (x *Place_PlusCode) GetCompoundCode() string {
	if x != nil {
		return x.CompoundCode
	}
	return ""
}

// Information about business hour of the place.
type Place_OpeningHours struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the opening hours period is currently active. For regular opening
	// hours and current opening hours, this field means whether the place is
	// open. For secondary opening hours and current secondary opening hours,
	// this field means whether the secondary hours of this place is active.
	OpenNow *bool `protobuf:"varint,1,opt,name=open_now,json=openNow,proto3,oneof" json:"open_now,omitempty"`
	// The periods that this place is open during the week. The periods are in
	// chronological order, in the place-local timezone. An empty (but not
	// absent) value indicates a place that is never open, e.g.
	// because it is closed temporarily for renovations.
	//
	// The starting day of `periods` is NOT fixed and should not be assumed to
	// be Sunday. The API determines the start day based on a variety of
	// factors. For example, for a 24/7 business, the first period may begin on
	// the day of the request. For other businesses, it might be the first day
	// of the week that they are open.
	//
	// NOTE: The ordering of the `periods` array is independent of the ordering
	// of the `weekday_descriptions` array. Do not assume they will begin on the
	// same day.
	Periods []*Place_OpeningHours_Period `protobuf:"bytes,2,rep,name=periods,proto3" json:"periods,omitempty"`
	// Localized strings describing the opening hours of this place, one string
	// for each day of the week.
	//
	// NOTE: The order of the days and the start of the week is determined by
	// the locale (language and region). The ordering of the `periods` array is
	// independent of the ordering of the `weekday_descriptions` array. Do not
	// assume they will begin on the same day.
	//
	// Will be empty if the hours are unknown or could not be converted to
	// localized text. Example: "Sun: 18:00–06:00"
	WeekdayDescriptions []string `protobuf:"bytes,3,rep,name=weekday_descriptions,json=weekdayDescriptions,proto3" json:"weekday_descriptions,omitempty"`
	// A type string used to identify the type of secondary hours.
	SecondaryHoursType Place_OpeningHours_SecondaryHoursType `protobuf:"varint,4,opt,name=secondary_hours_type,json=secondaryHoursType,proto3,enum=google.maps.places.v1.Place_OpeningHours_SecondaryHoursType" json:"secondary_hours_type,omitempty"`
	// Structured information for special days that fall within the period that
	// the returned opening hours cover. Special days are days that could impact
	// the business hours of a place, e.g. Christmas day. Set for
	// current_opening_hours and current_secondary_opening_hours if there are
	// exceptional hours.
	SpecialDays []*Place_OpeningHours_SpecialDay `protobuf:"bytes,5,rep,name=special_days,json=specialDays,proto3" json:"special_days,omitempty"`
	// The next time the current opening hours period starts up to 7 days in the
	// future. This field is only populated if the opening hours period is not
	// active at the time of serving the request.
	NextOpenTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=next_open_time,json=nextOpenTime,proto3" json:"next_open_time,omitempty"`
	// The next time the current opening hours period ends up to 7 days in the
	// future. This field is only populated if the opening hours period is
	// active at the time of serving the request.
	NextCloseTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=next_close_time,json=nextCloseTime,proto3" json:"next_close_time,omitempty"`
}

func (x *Place_OpeningHours) Reset() {
	*x = Place_OpeningHours{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_OpeningHours) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours) ProtoMessage() {}

func (x *Place_OpeningHours) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Place_OpeningHours) GetOpenNow() bool {
	if x != nil && x.OpenNow != nil {
		return *x.OpenNow
	}
	return false
}

func (x *Place_OpeningHours) GetPeriods() []*Place_OpeningHours_Period {
	if x != nil {
		return x.Periods
	}
	return nil
}

func (x *Place_OpeningHours) GetWeekdayDescriptions() []string {
	if x != nil {
		return x.WeekdayDescriptions
	}
	return nil
}

func (x *Place_OpeningHours) GetSecondaryHoursType() Place_OpeningHours_SecondaryHoursType {
	if x != nil {
		return x.SecondaryHoursType
	}
	return Place_OpeningHours_SECONDARY_HOURS_TYPE_UNSPECIFIED
}

func (x *Place_OpeningHours) GetSpecialDays() []*Place_OpeningHours_SpecialDay {
	if x != nil {
		return x.SpecialDays
	}
	return nil
}

func (x *Place_OpeningHours) GetNextOpenTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextOpenTime
	}
	return nil
}

func (x *Place_OpeningHours) GetNextCloseTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextCloseTime
	}
	return nil
}

// Information about data providers of this place.
type Place_Attribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the Place's data provider.
	Provider string `protobuf:"bytes,1,opt,name=provider,proto3" json:"provider,omitempty"`
	// URI to the Place's data provider.
	ProviderUri string `protobuf:"bytes,2,opt,name=provider_uri,json=providerUri,proto3" json:"provider_uri,omitempty"`
}

func (x *Place_Attribution) Reset() {
	*x = Place_Attribution{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_Attribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_Attribution) ProtoMessage() {}

func (x *Place_Attribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_Attribution.ProtoReflect.Descriptor instead.
func (*Place_Attribution) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Place_Attribution) GetProvider() string {
	if x != nil {
		return x.Provider
	}
	return ""
}

func (x *Place_Attribution) GetProviderUri() string {
	if x != nil {
		return x.ProviderUri
	}
	return ""
}

// Payment options the place accepts.
type Place_PaymentOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place accepts credit cards as payment.
	AcceptsCreditCards *bool `protobuf:"varint,1,opt,name=accepts_credit_cards,json=acceptsCreditCards,proto3,oneof" json:"accepts_credit_cards,omitempty"`
	// Place accepts debit cards as payment.
	AcceptsDebitCards *bool `protobuf:"varint,2,opt,name=accepts_debit_cards,json=acceptsDebitCards,proto3,oneof" json:"accepts_debit_cards,omitempty"`
	// Place accepts cash only as payment. Places with this attribute may still
	// accept other payment methods.
	AcceptsCashOnly *bool `protobuf:"varint,3,opt,name=accepts_cash_only,json=acceptsCashOnly,proto3,oneof" json:"accepts_cash_only,omitempty"`
	// Place accepts NFC payments.
	AcceptsNfc *bool `protobuf:"varint,4,opt,name=accepts_nfc,json=acceptsNfc,proto3,oneof" json:"accepts_nfc,omitempty"`
}

func (x *Place_PaymentOptions) Reset() {
	*x = Place_PaymentOptions{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_PaymentOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_PaymentOptions) ProtoMessage() {}

func (x *Place_PaymentOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_PaymentOptions.ProtoReflect.Descriptor instead.
func (*Place_PaymentOptions) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Place_PaymentOptions) GetAcceptsCreditCards() bool {
	if x != nil && x.AcceptsCreditCards != nil {
		return *x.AcceptsCreditCards
	}
	return false
}

func (x *Place_PaymentOptions) GetAcceptsDebitCards() bool {
	if x != nil && x.AcceptsDebitCards != nil {
		return *x.AcceptsDebitCards
	}
	return false
}

func (x *Place_PaymentOptions) GetAcceptsCashOnly() bool {
	if x != nil && x.AcceptsCashOnly != nil {
		return *x.AcceptsCashOnly
	}
	return false
}

func (x *Place_PaymentOptions) GetAcceptsNfc() bool {
	if x != nil && x.AcceptsNfc != nil {
		return *x.AcceptsNfc
	}
	return false
}

// Information about parking options for the place. A parking lot could
// support more than one option at the same time.
type Place_ParkingOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place offers free parking lots.
	FreeParkingLot *bool `protobuf:"varint,1,opt,name=free_parking_lot,json=freeParkingLot,proto3,oneof" json:"free_parking_lot,omitempty"`
	// Place offers paid parking lots.
	PaidParkingLot *bool `protobuf:"varint,2,opt,name=paid_parking_lot,json=paidParkingLot,proto3,oneof" json:"paid_parking_lot,omitempty"`
	// Place offers free street parking.
	FreeStreetParking *bool `protobuf:"varint,3,opt,name=free_street_parking,json=freeStreetParking,proto3,oneof" json:"free_street_parking,omitempty"`
	// Place offers paid street parking.
	PaidStreetParking *bool `protobuf:"varint,4,opt,name=paid_street_parking,json=paidStreetParking,proto3,oneof" json:"paid_street_parking,omitempty"`
	// Place offers valet parking.
	ValetParking *bool `protobuf:"varint,5,opt,name=valet_parking,json=valetParking,proto3,oneof" json:"valet_parking,omitempty"`
	// Place offers free garage parking.
	FreeGarageParking *bool `protobuf:"varint,6,opt,name=free_garage_parking,json=freeGarageParking,proto3,oneof" json:"free_garage_parking,omitempty"`
	// Place offers paid garage parking.
	PaidGarageParking *bool `protobuf:"varint,7,opt,name=paid_garage_parking,json=paidGarageParking,proto3,oneof" json:"paid_garage_parking,omitempty"`
}

func (x *Place_ParkingOptions) Reset() {
	*x = Place_ParkingOptions{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_ParkingOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_ParkingOptions) ProtoMessage() {}

func (x *Place_ParkingOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_ParkingOptions.ProtoReflect.Descriptor instead.
func (*Place_ParkingOptions) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Place_ParkingOptions) GetFreeParkingLot() bool {
	if x != nil && x.FreeParkingLot != nil {
		return *x.FreeParkingLot
	}
	return false
}

func (x *Place_ParkingOptions) GetPaidParkingLot() bool {
	if x != nil && x.PaidParkingLot != nil {
		return *x.PaidParkingLot
	}
	return false
}

func (x *Place_ParkingOptions) GetFreeStreetParking() bool {
	if x != nil && x.FreeStreetParking != nil {
		return *x.FreeStreetParking
	}
	return false
}

func (x *Place_ParkingOptions) GetPaidStreetParking() bool {
	if x != nil && x.PaidStreetParking != nil {
		return *x.PaidStreetParking
	}
	return false
}

func (x *Place_ParkingOptions) GetValetParking() bool {
	if x != nil && x.ValetParking != nil {
		return *x.ValetParking
	}
	return false
}

func (x *Place_ParkingOptions) GetFreeGarageParking() bool {
	if x != nil && x.FreeGarageParking != nil {
		return *x.FreeGarageParking
	}
	return false
}

func (x *Place_ParkingOptions) GetPaidGarageParking() bool {
	if x != nil && x.PaidGarageParking != nil {
		return *x.PaidGarageParking
	}
	return false
}

// Sub-destinations are specific places associated with a main place. These
// provide more specific destinations for users who are searching within a
// large or complex place, like an airport, national park, university, or
// stadium. For example, sub-destinations at an airport might include
// associated terminals and parking lots. Sub-destinations return the place ID
// and place resource name, which can be used in subsequent Place Details
// (New) requests to fetch richer details, including the sub-destination's
// display name and location.
type Place_SubDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the sub-destination.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The place id of the sub-destination.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Place_SubDestination) Reset() {
	*x = Place_SubDestination{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_SubDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_SubDestination) ProtoMessage() {}

func (x *Place_SubDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_SubDestination.ProtoReflect.Descriptor instead.
func (*Place_SubDestination) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Place_SubDestination) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Place_SubDestination) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Information about the accessibility options a place offers.
type Place_AccessibilityOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Place offers wheelchair accessible parking.
	WheelchairAccessibleParking *bool `protobuf:"varint,1,opt,name=wheelchair_accessible_parking,json=wheelchairAccessibleParking,proto3,oneof" json:"wheelchair_accessible_parking,omitempty"`
	// Places has wheelchair accessible entrance.
	WheelchairAccessibleEntrance *bool `protobuf:"varint,2,opt,name=wheelchair_accessible_entrance,json=wheelchairAccessibleEntrance,proto3,oneof" json:"wheelchair_accessible_entrance,omitempty"`
	// Place has wheelchair accessible restroom.
	WheelchairAccessibleRestroom *bool `protobuf:"varint,3,opt,name=wheelchair_accessible_restroom,json=wheelchairAccessibleRestroom,proto3,oneof" json:"wheelchair_accessible_restroom,omitempty"`
	// Place has wheelchair accessible seating.
	WheelchairAccessibleSeating *bool `protobuf:"varint,4,opt,name=wheelchair_accessible_seating,json=wheelchairAccessibleSeating,proto3,oneof" json:"wheelchair_accessible_seating,omitempty"`
}

func (x *Place_AccessibilityOptions) Reset() {
	*x = Place_AccessibilityOptions{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_AccessibilityOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_AccessibilityOptions) ProtoMessage() {}

func (x *Place_AccessibilityOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_AccessibilityOptions.ProtoReflect.Descriptor instead.
func (*Place_AccessibilityOptions) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Place_AccessibilityOptions) GetWheelchairAccessibleParking() bool {
	if x != nil && x.WheelchairAccessibleParking != nil {
		return *x.WheelchairAccessibleParking
	}
	return false
}

func (x *Place_AccessibilityOptions) GetWheelchairAccessibleEntrance() bool {
	if x != nil && x.WheelchairAccessibleEntrance != nil {
		return *x.WheelchairAccessibleEntrance
	}
	return false
}

func (x *Place_AccessibilityOptions) GetWheelchairAccessibleRestroom() bool {
	if x != nil && x.WheelchairAccessibleRestroom != nil {
		return *x.WheelchairAccessibleRestroom
	}
	return false
}

func (x *Place_AccessibilityOptions) GetWheelchairAccessibleSeating() bool {
	if x != nil && x.WheelchairAccessibleSeating != nil {
		return *x.WheelchairAccessibleSeating
	}
	return false
}

// AI-generated summary of the place.
type Place_GenerativeSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overview of the place.
	Overview *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=overview,proto3" json:"overview,omitempty"`
	// A link where users can flag a problem with the overview summary.
	OverviewFlagContentUri string `protobuf:"bytes,4,opt,name=overview_flag_content_uri,json=overviewFlagContentUri,proto3" json:"overview_flag_content_uri,omitempty"`
	// The AI disclosure message "Summarized with Gemini"
	// (and its localized variants). This will be in the language specified in
	// the request if available.
	DisclosureText *localized_text.LocalizedText `protobuf:"bytes,6,opt,name=disclosure_text,json=disclosureText,proto3" json:"disclosure_text,omitempty"`
}

func (x *Place_GenerativeSummary) Reset() {
	*x = Place_GenerativeSummary{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_GenerativeSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_GenerativeSummary) ProtoMessage() {}

func (x *Place_GenerativeSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_GenerativeSummary.ProtoReflect.Descriptor instead.
func (*Place_GenerativeSummary) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Place_GenerativeSummary) GetOverview() *localized_text.LocalizedText {
	if x != nil {
		return x.Overview
	}
	return nil
}

func (x *Place_GenerativeSummary) GetOverviewFlagContentUri() string {
	if x != nil {
		return x.OverviewFlagContentUri
	}
	return ""
}

func (x *Place_GenerativeSummary) GetDisclosureText() *localized_text.LocalizedText {
	if x != nil {
		return x.DisclosureText
	}
	return nil
}

// Info about the place in which this place is located.
type Place_ContainingPlace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the place in which this place is located.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The place id of the place in which this place is located.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Place_ContainingPlace) Reset() {
	*x = Place_ContainingPlace{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_ContainingPlace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_ContainingPlace) ProtoMessage() {}

func (x *Place_ContainingPlace) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_ContainingPlace.ProtoReflect.Descriptor instead.
func (*Place_ContainingPlace) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Place_ContainingPlace) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Place_ContainingPlace) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// AI-generated summary of the place using user reviews.
type Place_ReviewSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The summary of user reviews.
	Text *localized_text.LocalizedText `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// A link where users can flag a problem with the summary.
	FlagContentUri string `protobuf:"bytes,2,opt,name=flag_content_uri,json=flagContentUri,proto3" json:"flag_content_uri,omitempty"`
	// The AI disclosure message "Summarized with Gemini"
	// (and its localized variants). This will be in the language specified in
	// the request if available.
	DisclosureText *localized_text.LocalizedText `protobuf:"bytes,3,opt,name=disclosure_text,json=disclosureText,proto3" json:"disclosure_text,omitempty"`
	// A link to show reviews of this place on Google Maps.
	ReviewsUri string `protobuf:"bytes,4,opt,name=reviews_uri,json=reviewsUri,proto3" json:"reviews_uri,omitempty"`
}

func (x *Place_ReviewSummary) Reset() {
	*x = Place_ReviewSummary{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_ReviewSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_ReviewSummary) ProtoMessage() {}

func (x *Place_ReviewSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_ReviewSummary.ProtoReflect.Descriptor instead.
func (*Place_ReviewSummary) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 10}
}

func (x *Place_ReviewSummary) GetText() *localized_text.LocalizedText {
	if x != nil {
		return x.Text
	}
	return nil
}

func (x *Place_ReviewSummary) GetFlagContentUri() string {
	if x != nil {
		return x.FlagContentUri
	}
	return ""
}

func (x *Place_ReviewSummary) GetDisclosureText() *localized_text.LocalizedText {
	if x != nil {
		return x.DisclosureText
	}
	return nil
}

func (x *Place_ReviewSummary) GetReviewsUri() string {
	if x != nil {
		return x.ReviewsUri
	}
	return ""
}

// The summary of amenities near the EV charging station. This only applies to
// places with type `electric_vehicle_charging_station`. The `overview` field
// is guaranteed to be provided while the other fields are optional.
type Place_EvChargeAmenitySummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An overview of the available amenities. This is guaranteed to be
	// provided.
	Overview *ContentBlock `protobuf:"bytes,1,opt,name=overview,proto3" json:"overview,omitempty"`
	// A summary of the nearby coffee options.
	Coffee *ContentBlock `protobuf:"bytes,2,opt,name=coffee,proto3" json:"coffee,omitempty"`
	// A summary of the nearby restaurants.
	Restaurant *ContentBlock `protobuf:"bytes,3,opt,name=restaurant,proto3" json:"restaurant,omitempty"`
	// A summary of the nearby stores.
	Store *ContentBlock `protobuf:"bytes,4,opt,name=store,proto3" json:"store,omitempty"`
	// A link where users can flag a problem with the summary.
	FlagContentUri string `protobuf:"bytes,5,opt,name=flag_content_uri,json=flagContentUri,proto3" json:"flag_content_uri,omitempty"`
	// The AI disclosure message "Summarized with Gemini"
	// (and its localized variants). This will be in the language specified in
	// the request if available.
	DisclosureText *localized_text.LocalizedText `protobuf:"bytes,6,opt,name=disclosure_text,json=disclosureText,proto3" json:"disclosure_text,omitempty"`
}

func (x *Place_EvChargeAmenitySummary) Reset() {
	*x = Place_EvChargeAmenitySummary{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_EvChargeAmenitySummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_EvChargeAmenitySummary) ProtoMessage() {}

func (x *Place_EvChargeAmenitySummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_EvChargeAmenitySummary.ProtoReflect.Descriptor instead.
func (*Place_EvChargeAmenitySummary) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 11}
}

func (x *Place_EvChargeAmenitySummary) GetOverview() *ContentBlock {
	if x != nil {
		return x.Overview
	}
	return nil
}

func (x *Place_EvChargeAmenitySummary) GetCoffee() *ContentBlock {
	if x != nil {
		return x.Coffee
	}
	return nil
}

func (x *Place_EvChargeAmenitySummary) GetRestaurant() *ContentBlock {
	if x != nil {
		return x.Restaurant
	}
	return nil
}

func (x *Place_EvChargeAmenitySummary) GetStore() *ContentBlock {
	if x != nil {
		return x.Store
	}
	return nil
}

func (x *Place_EvChargeAmenitySummary) GetFlagContentUri() string {
	if x != nil {
		return x.FlagContentUri
	}
	return ""
}

func (x *Place_EvChargeAmenitySummary) GetDisclosureText() *localized_text.LocalizedText {
	if x != nil {
		return x.DisclosureText
	}
	return nil
}

// A summary of points of interest near the place.
type Place_NeighborhoodSummary struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An overview summary of the neighborhood.
	Overview *ContentBlock `protobuf:"bytes,1,opt,name=overview,proto3" json:"overview,omitempty"`
	// A detailed description of the neighborhood.
	Description *ContentBlock `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// A link where users can flag a problem with the summary.
	FlagContentUri string `protobuf:"bytes,3,opt,name=flag_content_uri,json=flagContentUri,proto3" json:"flag_content_uri,omitempty"`
	// The AI disclosure message "Summarized with Gemini"
	// (and its localized variants). This will be in the language specified in
	// the request if available.
	DisclosureText *localized_text.LocalizedText `protobuf:"bytes,4,opt,name=disclosure_text,json=disclosureText,proto3" json:"disclosure_text,omitempty"`
}

func (x *Place_NeighborhoodSummary) Reset() {
	*x = Place_NeighborhoodSummary{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_NeighborhoodSummary) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_NeighborhoodSummary) ProtoMessage() {}

func (x *Place_NeighborhoodSummary) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_NeighborhoodSummary.ProtoReflect.Descriptor instead.
func (*Place_NeighborhoodSummary) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 12}
}

func (x *Place_NeighborhoodSummary) GetOverview() *ContentBlock {
	if x != nil {
		return x.Overview
	}
	return nil
}

func (x *Place_NeighborhoodSummary) GetDescription() *ContentBlock {
	if x != nil {
		return x.Description
	}
	return nil
}

func (x *Place_NeighborhoodSummary) GetFlagContentUri() string {
	if x != nil {
		return x.FlagContentUri
	}
	return ""
}

func (x *Place_NeighborhoodSummary) GetDisclosureText() *localized_text.LocalizedText {
	if x != nil {
		return x.DisclosureText
	}
	return nil
}

// The consumer alert message for the place when we detect suspicious review
// activity on a business or a business violates our policies.
type Place_ConsumerAlert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overview of the consumer alert message.
	Overview string `protobuf:"bytes,1,opt,name=overview,proto3" json:"overview,omitempty"`
	// The details of the consumer alert message.
	Details *Place_ConsumerAlert_Details `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
	// The language code of the consumer alert message. This is a BCP 47
	// language code.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *Place_ConsumerAlert) Reset() {
	*x = Place_ConsumerAlert{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_ConsumerAlert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_ConsumerAlert) ProtoMessage() {}

func (x *Place_ConsumerAlert) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_ConsumerAlert.ProtoReflect.Descriptor instead.
func (*Place_ConsumerAlert) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 13}
}

func (x *Place_ConsumerAlert) GetOverview() string {
	if x != nil {
		return x.Overview
	}
	return ""
}

func (x *Place_ConsumerAlert) GetDetails() *Place_ConsumerAlert_Details {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *Place_ConsumerAlert) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// A period the place remains in open_now status.
type Place_OpeningHours_Period struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The time that the place starts to be open.
	Open *Place_OpeningHours_Period_Point `protobuf:"bytes,1,opt,name=open,proto3" json:"open,omitempty"`
	// The time that the place starts to be closed.
	Close *Place_OpeningHours_Period_Point `protobuf:"bytes,2,opt,name=close,proto3" json:"close,omitempty"`
}

func (x *Place_OpeningHours_Period) Reset() {
	*x = Place_OpeningHours_Period{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_OpeningHours_Period) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours_Period) ProtoMessage() {}

func (x *Place_OpeningHours_Period) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours_Period.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours_Period) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Place_OpeningHours_Period) GetOpen() *Place_OpeningHours_Period_Point {
	if x != nil {
		return x.Open
	}
	return nil
}

func (x *Place_OpeningHours_Period) GetClose() *Place_OpeningHours_Period_Point {
	if x != nil {
		return x.Close
	}
	return nil
}

// Structured information for special days that fall within the period that
// the returned opening hours cover. Special days are days that could impact
// the business hours of a place, e.g. Christmas day.
type Place_OpeningHours_SpecialDay struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The date of this special day.
	Date *date.Date `protobuf:"bytes,1,opt,name=date,proto3" json:"date,omitempty"`
}

func (x *Place_OpeningHours_SpecialDay) Reset() {
	*x = Place_OpeningHours_SpecialDay{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_OpeningHours_SpecialDay) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours_SpecialDay) ProtoMessage() {}

func (x *Place_OpeningHours_SpecialDay) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours_SpecialDay.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours_SpecialDay) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *Place_OpeningHours_SpecialDay) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

// Status changing points.
type Place_OpeningHours_Period_Point struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A day of the week, as an integer in the range 0-6.  0 is Sunday, 1 is
	// Monday, etc.
	Day *int32 `protobuf:"varint,1,opt,name=day,proto3,oneof" json:"day,omitempty"`
	// The hour in 24 hour format. Ranges from 0 to 23.
	Hour *int32 `protobuf:"varint,2,opt,name=hour,proto3,oneof" json:"hour,omitempty"`
	// The minute. Ranges from 0 to 59.
	Minute *int32 `protobuf:"varint,3,opt,name=minute,proto3,oneof" json:"minute,omitempty"`
	// Date in the local timezone for the place.
	Date *date.Date `protobuf:"bytes,6,opt,name=date,proto3" json:"date,omitempty"`
	// Whether or not this endpoint was truncated. Truncation occurs when
	// the real hours are outside the times we are willing to return hours
	// between, so we truncate the hours back to these boundaries. This
	// ensures that at most 24 * 7 hours from midnight of the day of the
	// request are returned.
	Truncated bool `protobuf:"varint,5,opt,name=truncated,proto3" json:"truncated,omitempty"`
}

func (x *Place_OpeningHours_Period_Point) Reset() {
	*x = Place_OpeningHours_Period_Point{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_OpeningHours_Period_Point) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_OpeningHours_Period_Point) ProtoMessage() {}

func (x *Place_OpeningHours_Period_Point) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_OpeningHours_Period_Point.ProtoReflect.Descriptor instead.
func (*Place_OpeningHours_Period_Point) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

func (x *Place_OpeningHours_Period_Point) GetDay() int32 {
	if x != nil && x.Day != nil {
		return *x.Day
	}
	return 0
}

func (x *Place_OpeningHours_Period_Point) GetHour() int32 {
	if x != nil && x.Hour != nil {
		return *x.Hour
	}
	return 0
}

func (x *Place_OpeningHours_Period_Point) GetMinute() int32 {
	if x != nil && x.Minute != nil {
		return *x.Minute
	}
	return 0
}

func (x *Place_OpeningHours_Period_Point) GetDate() *date.Date {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *Place_OpeningHours_Period_Point) GetTruncated() bool {
	if x != nil {
		return x.Truncated
	}
	return false
}

// The details of the consumer alert message.
type Place_ConsumerAlert_Details struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The title to show together with the description.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The description of the consumer alert message.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The link to show together with the description to provide more
	// information.
	AboutLink *Place_ConsumerAlert_Details_Link `protobuf:"bytes,3,opt,name=about_link,json=aboutLink,proto3" json:"about_link,omitempty"`
}

func (x *Place_ConsumerAlert_Details) Reset() {
	*x = Place_ConsumerAlert_Details{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_ConsumerAlert_Details) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_ConsumerAlert_Details) ProtoMessage() {}

func (x *Place_ConsumerAlert_Details) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_ConsumerAlert_Details.ProtoReflect.Descriptor instead.
func (*Place_ConsumerAlert_Details) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 13, 0}
}

func (x *Place_ConsumerAlert_Details) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Place_ConsumerAlert_Details) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Place_ConsumerAlert_Details) GetAboutLink() *Place_ConsumerAlert_Details_Link {
	if x != nil {
		return x.AboutLink
	}
	return nil
}

// The link to show together with the description to provide more
// information.
type Place_ConsumerAlert_Details_Link struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The title to show for the link.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The uri of the link.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *Place_ConsumerAlert_Details_Link) Reset() {
	*x = Place_ConsumerAlert_Details_Link{}
	mi := &file_google_maps_places_v1_place_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Place_ConsumerAlert_Details_Link) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Place_ConsumerAlert_Details_Link) ProtoMessage() {}

func (x *Place_ConsumerAlert_Details_Link) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_places_v1_place_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Place_ConsumerAlert_Details_Link.ProtoReflect.Descriptor instead.
func (*Place_ConsumerAlert_Details_Link) Descriptor() ([]byte, []int) {
	return file_google_maps_places_v1_place_proto_rawDescGZIP(), []int{0, 13, 0, 0}
}

func (x *Place_ConsumerAlert_Details_Link) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Place_ConsumerAlert_Details_Link) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

var File_google_maps_places_v1_place_proto protoreflect.FileDescriptor

var file_google_maps_places_v1_place_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65,
	0x6f, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61,
	0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61,
	0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x67,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31,
	0x2f, 0x66, 0x75, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73,
	0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d,
	0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69,
	0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa3, 0x4a, 0x0a, 0x05, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x3d, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x32, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x55, 0x0a, 0x19,
	0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x16, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x54, 0x79, 0x70, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x32, 0x0a, 0x15, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x68, 0x6f, 0x6e,
	0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x3c, 0x0a, 0x1a, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x18, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x11, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74,
	0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x36, 0x0a, 0x17, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x33, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x15, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x74, 0x65, 0x64, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x41, 0x0a, 0x0e, 0x70, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x5a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x52, 0x0d,
	0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x5c, 0x0a,
	0x12, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x09, 0x70,
	0x6c, 0x75, 0x73, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x6c, 0x75,
	0x73, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x08, 0x70, 0x6c, 0x75, 0x73, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x2f, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x35, 0x0a, 0x08, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6f, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x08, 0x76,
	0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x01, 0x52, 0x06, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12,
	0x26, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x4d, 0x61, 0x70, 0x73, 0x55, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0b, 0x77, 0x65, 0x62, 0x73, 0x69,
	0x74, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x77, 0x65,
	0x62, 0x73, 0x69, 0x74, 0x65, 0x55, 0x72, 0x69, 0x12, 0x37, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x18, 0x35, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x07, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x12, 0x5d, 0x0a, 0x15, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x6f, 0x70, 0x65,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f,
	0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x13, 0x72, 0x65, 0x67,
	0x75, 0x6c, 0x61, 0x72, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73,
	0x12, 0x31, 0x0a, 0x12, 0x75, 0x74, 0x63, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x5f, 0x6d,
	0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x18, 0x16, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x10,
	0x75, 0x74, 0x63, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x32, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x58, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x08, 0x74,
	0x69, 0x6d, 0x65, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f,
	0x73, 0x18, 0x36, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x68, 0x6f, 0x74, 0x6f, 0x52, 0x06, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x73, 0x12, 0x2c, 0x0a,
	0x12, 0x61, 0x64, 0x72, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x5f, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x18, 0x18, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x64, 0x72, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x54, 0x0a, 0x0f, 0x62,
	0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x19,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x2e, 0x42, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x0e, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x42, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x1a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63, 0x65,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x4c, 0x0a, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x1b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01,
	0x52, 0x0f, 0x75, 0x73, 0x65, 0x72, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x12, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x69, 0x63, 0x6f, 0x6e, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x61, 0x73, 0x65, 0x55, 0x72,
	0x69, 0x12, 0x32, 0x0a, 0x15, 0x69, 0x63, 0x6f, 0x6e, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72,
	0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x13, 0x69, 0x63, 0x6f, 0x6e, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
	0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x07, 0x74, 0x61, 0x6b, 0x65, 0x6f, 0x75, 0x74,
	0x18, 0x21, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x07, 0x74, 0x61, 0x6b, 0x65, 0x6f, 0x75,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x18, 0x22, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x08, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x07, 0x64, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6e,
	0x18, 0x23, 0x20, 0x01, 0x28, 0x08, 0x48, 0x04, 0x52, 0x06, 0x64, 0x69, 0x6e, 0x65, 0x49, 0x6e,
	0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x75, 0x72, 0x62, 0x73, 0x69, 0x64, 0x65, 0x5f,
	0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x24, 0x20, 0x01, 0x28, 0x08, 0x48, 0x05, 0x52, 0x0e,
	0x63, 0x75, 0x72, 0x62, 0x73, 0x69, 0x64, 0x65, 0x50, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x88, 0x01,
	0x01, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x26, 0x20, 0x01, 0x28, 0x08, 0x48, 0x06, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x61,
	0x62, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73,
	0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x74, 0x18, 0x27, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x07, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x66,
	0x61, 0x73, 0x74, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73,
	0x5f, 0x6c, 0x75, 0x6e, 0x63, 0x68, 0x18, 0x28, 0x20, 0x01, 0x28, 0x08, 0x48, 0x08, 0x52, 0x0b,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x4c, 0x75, 0x6e, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x28,
	0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x6e, 0x6e, 0x65, 0x72, 0x18,
	0x29, 0x20, 0x01, 0x28, 0x08, 0x48, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x44,
	0x69, 0x6e, 0x6e, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x73, 0x5f, 0x62, 0x65, 0x65, 0x72, 0x18, 0x2a, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0a, 0x52,
	0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x42, 0x65, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x24,
	0x0a, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x6e, 0x65, 0x18, 0x2b, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x0b, 0x52, 0x0a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x57, 0x69, 0x6e,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x62,
	0x72, 0x75, 0x6e, 0x63, 0x68, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0c, 0x52, 0x0c, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x73, 0x42, 0x72, 0x75, 0x6e, 0x63, 0x68, 0x88, 0x01, 0x01, 0x12, 0x39,
	0x0a, 0x16, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x76, 0x65, 0x67, 0x65, 0x74, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x5f, 0x66, 0x6f, 0x6f, 0x64, 0x18, 0x2d, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0d,
	0x52, 0x14, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x56, 0x65, 0x67, 0x65, 0x74, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x46, 0x6f, 0x6f, 0x64, 0x88, 0x01, 0x01, 0x12, 0x5d, 0x0a, 0x15, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75,
	0x72, 0x73, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f,
	0x75, 0x72, 0x73, 0x52, 0x13, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x6e,
	0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x70, 0x0a, 0x1f, 0x63, 0x75, 0x72, 0x72,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x6f, 0x70,
	0x65, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x2f, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e,
	0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x1c, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x4f, 0x70,
	0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x70, 0x0a, 0x1f, 0x72, 0x65,
	0x67, 0x75, 0x6c, 0x61, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x18, 0x31, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63,
	0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x52, 0x1c,
	0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x47, 0x0a, 0x11,
	0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54,
	0x65, 0x78, 0x74, 0x52, 0x10, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x2c, 0x0a, 0x0f, 0x6f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72,
	0x5f, 0x73, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x37, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0e,
	0x52, 0x0e, 0x6f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x53, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x75, 0x73, 0x69,
	0x63, 0x18, 0x38, 0x20, 0x01, 0x28, 0x08, 0x48, 0x0f, 0x52, 0x09, 0x6c, 0x69, 0x76, 0x65, 0x4d,
	0x75, 0x73, 0x69, 0x63, 0x88, 0x01, 0x01, 0x12, 0x2f, 0x0a, 0x11, 0x6d, 0x65, 0x6e, 0x75, 0x5f,
	0x66, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x18, 0x39, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x10, 0x52, 0x0f, 0x6d, 0x65, 0x6e, 0x75, 0x46, 0x6f, 0x72, 0x43, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x73, 0x5f, 0x63, 0x6f, 0x63, 0x6b, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x3a, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x11, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x43, 0x6f, 0x63, 0x6b,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x73, 0x65, 0x72, 0x74, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x12, 0x52, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x44, 0x65, 0x73, 0x73, 0x65, 0x72,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x63,
	0x6f, 0x66, 0x66, 0x65, 0x65, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x08, 0x48, 0x13, 0x52, 0x0c, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x73, 0x43, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x88, 0x01, 0x01, 0x12, 0x2f,
	0x0a, 0x11, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x69, 0x6c, 0x64,
	0x72, 0x65, 0x6e, 0x18, 0x3e, 0x20, 0x01, 0x28, 0x08, 0x48, 0x14, 0x52, 0x0f, 0x67, 0x6f, 0x6f,
	0x64, 0x46, 0x6f, 0x72, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x5f, 0x64, 0x6f, 0x67, 0x73, 0x18, 0x3f,
	0x20, 0x01, 0x28, 0x08, 0x48, 0x15, 0x52, 0x0a, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x44, 0x6f,
	0x67, 0x73, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x6f,
	0x6d, 0x18, 0x40, 0x20, 0x01, 0x28, 0x08, 0x48, 0x16, 0x52, 0x08, 0x72, 0x65, 0x73, 0x74, 0x72,
	0x6f, 0x6f, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x2b, 0x0a, 0x0f, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x66,
	0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x41, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x17, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x64, 0x46, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x88, 0x01, 0x01, 0x12, 0x3c, 0x0a, 0x18, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x5f,
	0x77, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18,
	0x42, 0x20, 0x01, 0x28, 0x08, 0x48, 0x18, 0x52, 0x15, 0x67, 0x6f, 0x6f, 0x64, 0x46, 0x6f, 0x72,
	0x57, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x54, 0x0a, 0x0f, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x43, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x54, 0x0a, 0x0f, 0x70, 0x61, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x46, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x50,
	0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0e, 0x70,
	0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x56, 0x0a,
	0x10, 0x73, 0x75, 0x62, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x47, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x53, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6b, 0x0a, 0x15, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x48,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x48, 0x19, 0x52, 0x14, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x45, 0x0a, 0x0c, 0x66, 0x75, 0x65, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x4e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x75, 0x65, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0b, 0x66, 0x75,
	0x65, 0x6c, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a, 0x11, 0x65, 0x76, 0x5f,
	0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x4f,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61,
	0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x56, 0x43,
	0x68, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x65, 0x76,
	0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5d, 0x0a,
	0x12, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x18, 0x50, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x59, 0x0a, 0x11,
	0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x18, 0x52, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e,
	0x67, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x1a, 0x70, 0x75, 0x72, 0x65, 0x5f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x72, 0x65, 0x61, 0x5f, 0x62, 0x75, 0x73,
	0x69, 0x6e, 0x65, 0x73, 0x73, 0x18, 0x53, 0x20, 0x01, 0x28, 0x08, 0x48, 0x1a, 0x52, 0x17, 0x70,
	0x75, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x72, 0x65, 0x61, 0x42, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x88, 0x01, 0x01, 0x12, 0x57, 0x0a, 0x12, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x18,
	0x54, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64,
	0x64, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52,
	0x11, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x6f, 0x72, 0x12, 0x42, 0x0a, 0x0b, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67,
	0x65, 0x18, 0x56, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0a, 0x70, 0x72, 0x69, 0x63,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x57, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x0d, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x6e, 0x0a, 0x19, 0x65, 0x76, 0x5f,
	0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x61, 0x6d, 0x65, 0x6e, 0x69, 0x74, 0x79, 0x5f, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x59, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x45, 0x76, 0x43, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x41, 0x6d, 0x65, 0x6e, 0x69, 0x74, 0x79, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x52, 0x16, 0x65, 0x76, 0x43, 0x68, 0x61, 0x72, 0x67, 0x65, 0x41, 0x6d, 0x65, 0x6e, 0x69,
	0x74, 0x79, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x14, 0x6e, 0x65, 0x69,
	0x67, 0x68, 0x62, 0x6f, 0x72, 0x68, 0x6f, 0x6f, 0x64, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x18, 0x5b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x68, 0x6f,
	0x6f, 0x64, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x52, 0x13, 0x6e, 0x65, 0x69, 0x67, 0x68,
	0x62, 0x6f, 0x72, 0x68, 0x6f, 0x6f, 0x64, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x51,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74,
	0x18, 0x5c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x6c, 0x65,
	0x72, 0x74, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x12, 0x41, 0x0a, 0x0b, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x18, 0x5d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a, 0x1b, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x0a, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x6f, 0x76, 0x65, 0x64, 0x5f, 0x70, 0x6c,
	0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x5e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6d, 0x6f,
	0x76, 0x65, 0x64, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x1a, 0x89, 0x01, 0x0a, 0x10, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x6e, 0x67, 0x54, 0x65, 0x78, 0x74, 0x12, 0x1d, 0x0a, 0x0a,
	0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x54, 0x65, 0x78, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x50, 0x0a, 0x08, 0x50, 0x6c, 0x75, 0x73, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x5f,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70,
	0x6f, 0x75, 0x6e, 0x64, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0x99, 0x09, 0x0a, 0x0c, 0x4f, 0x70, 0x65,
	0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x70, 0x65,
	0x6e, 0x5f, 0x6e, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x6f,
	0x70, 0x65, 0x6e, 0x4e, 0x6f, 0x77, 0x88, 0x01, 0x01, 0x12, 0x4a, 0x0a, 0x07, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67,
	0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x07, 0x70, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x73, 0x12, 0x31, 0x0a, 0x14, 0x77, 0x65, 0x65, 0x6b, 0x64, 0x61, 0x79,
	0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x13, 0x77, 0x65, 0x65, 0x6b, 0x64, 0x61, 0x79, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6e, 0x0a, 0x14, 0x73, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72,
	0x73, 0x2e, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x75, 0x72, 0x73,
	0x54, 0x79, 0x70, 0x65, 0x52, 0x12, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48,
	0x6f, 0x75, 0x72, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x0c, 0x73, 0x70, 0x65, 0x63,
	0x69, 0x61, 0x6c, 0x5f, 0x64, 0x61, 0x79, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65,
	0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61,
	0x6c, 0x44, 0x61, 0x79, 0x52, 0x0b, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x44, 0x61, 0x79,
	0x73, 0x12, 0x40, 0x0a, 0x0e, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x6e, 0x65, 0x78, 0x74, 0x4f, 0x70, 0x65, 0x6e, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x43, 0x6c,
	0x6f, 0x73, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0xda, 0x02, 0x0a, 0x06, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x12, 0x4a, 0x0a, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f,
	0x70, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x04, 0x6f, 0x70, 0x65, 0x6e, 0x12, 0x4c,
	0x0a, 0x05, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x6e,
	0x69, 0x6e, 0x67, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x2e,
	0x50, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x05, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x1a, 0xb5, 0x01, 0x0a,
	0x05, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x03, 0x64, 0x61, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x03, 0x64, 0x61, 0x79, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a,
	0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x04, 0x68,
	0x6f, 0x75, 0x72, 0x88, 0x01, 0x01, 0x12, 0x1b, 0x0a, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x02, 0x52, 0x06, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x44, 0x61, 0x74, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x74, 0x72,
	0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x74,
	0x72, 0x75, 0x6e, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x64, 0x61, 0x79,
	0x42, 0x07, 0x0a, 0x05, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x6d, 0x69,
	0x6e, 0x75, 0x74, 0x65, 0x1a, 0x33, 0x0a, 0x0a, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x44,
	0x61, 0x79, 0x12, 0x25, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x22, 0xfb, 0x01, 0x0a, 0x12, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x48, 0x6f, 0x75, 0x72, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x24, 0x0a, 0x20, 0x53, 0x45, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x52, 0x59, 0x5f, 0x48, 0x4f,
	0x55, 0x52, 0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x52, 0x49, 0x56, 0x45, 0x5f,
	0x54, 0x48, 0x52, 0x4f, 0x55, 0x47, 0x48, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x41, 0x50,
	0x50, 0x59, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c,
	0x49, 0x56, 0x45, 0x52, 0x59, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x41, 0x4b, 0x45, 0x4f,
	0x55, 0x54, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x4b, 0x49, 0x54, 0x43, 0x48, 0x45, 0x4e, 0x10,
	0x05, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x46, 0x41, 0x53, 0x54, 0x10, 0x06,
	0x12, 0x09, 0x0a, 0x05, 0x4c, 0x55, 0x4e, 0x43, 0x48, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x44,
	0x49, 0x4e, 0x4e, 0x45, 0x52, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x42, 0x52, 0x55, 0x4e, 0x43,
	0x48, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x49, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x0a, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x0b, 0x12, 0x10, 0x0a, 0x0c, 0x53,
	0x45, 0x4e, 0x49, 0x4f, 0x52, 0x5f, 0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x18, 0x0a,
	0x14, 0x4f, 0x4e, 0x4c, 0x49, 0x4e, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x48, 0x4f, 0x55, 0x52, 0x53, 0x10, 0x0d, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6f, 0x70, 0x65, 0x6e,
	0x5f, 0x6e, 0x6f, 0x77, 0x1a, 0x4c, 0x0a, 0x0b, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12,
	0x21, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x55,
	0x72, 0x69, 0x1a, 0xaa, 0x02, 0x0a, 0x0e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73,
	0x5f, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x63, 0x61, 0x72, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x12, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x43, 0x72,
	0x65, 0x64, 0x69, 0x74, 0x43, 0x61, 0x72, 0x64, 0x73, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x64, 0x65, 0x62, 0x69, 0x74, 0x5f, 0x63, 0x61,
	0x72, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x11, 0x61, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x73, 0x44, 0x65, 0x62, 0x69, 0x74, 0x43, 0x61, 0x72, 0x64, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x2f, 0x0a, 0x11, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x63, 0x61, 0x73,
	0x68, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x0f,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x43, 0x61, 0x73, 0x68, 0x4f, 0x6e, 0x6c, 0x79, 0x88,
	0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x6e, 0x66,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x70,
	0x74, 0x73, 0x4e, 0x66, 0x63, 0x88, 0x01, 0x01, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x73, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x5f, 0x63, 0x61, 0x72, 0x64,
	0x73, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x64, 0x65,
	0x62, 0x69, 0x74, 0x5f, 0x63, 0x61, 0x72, 0x64, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x63, 0x61, 0x73, 0x68, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x6e, 0x66, 0x63, 0x1a,
	0x88, 0x04, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0e,
	0x66, 0x72, 0x65, 0x65, 0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x2d, 0x0a, 0x10, 0x70, 0x61, 0x69, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x5f, 0x6c, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x0e, 0x70,
	0x61, 0x69, 0x64, 0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x4c, 0x6f, 0x74, 0x88, 0x01, 0x01,
	0x12, 0x33, 0x0a, 0x13, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52,
	0x11, 0x66, 0x72, 0x65, 0x65, 0x53, 0x74, 0x72, 0x65, 0x65, 0x74, 0x50, 0x61, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x61, 0x69, 0x64, 0x5f, 0x73, 0x74,
	0x72, 0x65, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x03, 0x52, 0x11, 0x70, 0x61, 0x69, 0x64, 0x53, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61,
	0x6c, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x04, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x65, 0x74, 0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x67, 0x61, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x05, 0x52, 0x11, 0x66, 0x72, 0x65, 0x65, 0x47, 0x61, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a, 0x13, 0x70, 0x61, 0x69,
	0x64, 0x5f, 0x67, 0x61, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x06, 0x52, 0x11, 0x70, 0x61, 0x69, 0x64, 0x47, 0x61,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x88, 0x01, 0x01, 0x42, 0x13,
	0x0a, 0x11, 0x5f, 0x66, 0x72, 0x65, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x6c, 0x6f, 0x74, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70, 0x61, 0x69, 0x64, 0x5f, 0x70, 0x61, 0x72,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x6c, 0x6f, 0x74, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x66, 0x72, 0x65,
	0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67,
	0x42, 0x16, 0x0a, 0x14, 0x5f, 0x70, 0x61, 0x69, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74,
	0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x76, 0x61, 0x6c,
	0x65, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x66,
	0x72, 0x65, 0x65, 0x5f, 0x67, 0x61, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69,
	0x6e, 0x67, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x70, 0x61, 0x69, 0x64, 0x5f, 0x67, 0x61, 0x72, 0x61,
	0x67, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x1a, 0x56, 0x0a, 0x0e, 0x53, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41, 0x1d, 0x0a,
	0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x69, 0x64, 0x1a, 0xc8, 0x03, 0x0a, 0x14, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x0a, 0x1d, 0x77,
	0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x1b, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x50, 0x61, 0x72, 0x6b, 0x69, 0x6e,
	0x67, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x1e, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61,
	0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x6e,
	0x74, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x48, 0x01, 0x52, 0x1c,
	0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x45, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x49, 0x0a, 0x1e, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x6f,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x1c, 0x77, 0x68, 0x65, 0x65, 0x6c,
	0x63, 0x68, 0x61, 0x69, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x6d, 0x88, 0x01, 0x01, 0x12, 0x47, 0x0a, 0x1d, 0x77, 0x68,
	0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x08, 0x48, 0x03, 0x52, 0x1b, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x88, 0x01, 0x01, 0x42, 0x20, 0x0a, 0x1e, 0x5f, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61,
	0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x70, 0x61,
	0x72, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x63,
	0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f,
	0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x21, 0x0a, 0x1f, 0x5f, 0x77, 0x68, 0x65,
	0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62,
	0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x6f, 0x6d, 0x42, 0x20, 0x0a, 0x1e, 0x5f,
	0x77, 0x68, 0x65, 0x65, 0x6c, 0x63, 0x68, 0x61, 0x69, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x1a, 0xcb, 0x01,
	0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x79, 0x12, 0x36, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78,
	0x74, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x39, 0x0a, 0x19, 0x6f,
	0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16,
	0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x46, 0x6c, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x63, 0x6c, 0x6f,
	0x73, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f,
	0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x64, 0x69, 0x73,
	0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x57, 0x0a, 0x0f, 0x43,
	0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x12, 0x34,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x20, 0xfa, 0x41,
	0x1d, 0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x1a, 0xcf, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74,
	0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x66, 0x6c, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69,
	0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x64, 0x69, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72,
	0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x55, 0x72, 0x69, 0x1a, 0x85, 0x03, 0x0a, 0x16, 0x45, 0x76, 0x43, 0x68, 0x61,
	0x72, 0x67, 0x65, 0x41, 0x6d, 0x65, 0x6e, 0x69, 0x74, 0x79, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x79, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69,
	0x65, 0x77, 0x12, 0x3b, 0x0a, 0x06, 0x63, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73,
	0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x06, 0x63, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x12,
	0x43, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x74, 0x61, 0x75,
	0x72, 0x61, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70,
	0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x05, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x12,
	0x28, 0x0a, 0x10, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x66, 0x6c, 0x61, 0x67, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73,
	0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0e,
	0x64, 0x69, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x54, 0x65, 0x78, 0x74, 0x1a, 0x8c,
	0x02, 0x0a, 0x13, 0x4e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x68, 0x6f, 0x6f, 0x64, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x3f, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69,
	0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x08, 0x6f,
	0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x45, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x6c, 0x6f, 0x63,
	0x6b, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28,
	0x0a, 0x10, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x66, 0x6c, 0x61, 0x67, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x12, 0x43, 0x0a, 0x0f, 0x64, 0x69, 0x73, 0x63,
	0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x52, 0x0e, 0x64,
	0x69, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x54, 0x65, 0x78, 0x74, 0x1a, 0xea, 0x02,
	0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x12, 0x4c, 0x0a, 0x07, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75,
	0x6d, 0x65, 0x72, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x1a, 0xc9,
	0x01, 0x0a, 0x07, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x56, 0x0a, 0x0a, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x5f, 0x6c, 0x69, 0x6e, 0x6b,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x41, 0x6c, 0x65,
	0x72, 0x74, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x52,
	0x09, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x1a, 0x2e, 0x0a, 0x04, 0x4c, 0x69,
	0x6e, 0x6b, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x22, 0x72, 0x0a, 0x0e, 0x42, 0x75,
	0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x1f, 0x0a, 0x1b,
	0x42, 0x55, 0x53, 0x49, 0x4e, 0x45, 0x53, 0x53, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a,
	0x0b, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x16,
	0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44, 0x5f, 0x54, 0x45, 0x4d, 0x50, 0x4f, 0x52, 0x41,
	0x52, 0x49, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x43, 0x4c, 0x4f, 0x53, 0x45, 0x44,
	0x5f, 0x50, 0x45, 0x52, 0x4d, 0x41, 0x4e, 0x45, 0x4e, 0x54, 0x4c, 0x59, 0x10, 0x03, 0x3a, 0x42,
	0xea, 0x41, 0x3f, 0x0a, 0x1b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x12, 0x11, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f,
	0x69, 0x64, 0x7d, 0x2a, 0x06, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x32, 0x05, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x75, 0x74, 0x63, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42,
	0x0a, 0x0a, 0x08, 0x5f, 0x74, 0x61, 0x6b, 0x65, 0x6f, 0x75, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x5f,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x64, 0x69, 0x6e,
	0x65, 0x5f, 0x69, 0x6e, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x75, 0x72, 0x62, 0x73, 0x69, 0x64,
	0x65, 0x5f, 0x70, 0x69, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x72, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x61, 0x62, 0x6c, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x73, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x66, 0x61, 0x73, 0x74, 0x42, 0x0f, 0x0a, 0x0d,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x6c, 0x75, 0x6e, 0x63, 0x68, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x64, 0x69, 0x6e, 0x6e, 0x65, 0x72, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x62, 0x65, 0x65, 0x72, 0x42,
	0x0e, 0x0a, 0x0c, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x77, 0x69, 0x6e, 0x65, 0x42,
	0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x62, 0x72, 0x75, 0x6e, 0x63,
	0x68, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x76, 0x65, 0x67,
	0x65, 0x74, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x5f, 0x66, 0x6f, 0x6f, 0x64, 0x42, 0x12, 0x0a, 0x10,
	0x5f, 0x6f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x5f, 0x73, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x65, 0x6e, 0x75, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73,
	0x5f, 0x63, 0x6f, 0x63, 0x6b, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x73, 0x65, 0x72, 0x74, 0x42, 0x10, 0x0a,
	0x0e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x69,
	0x6c, 0x64, 0x72, 0x65, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73,
	0x5f, 0x64, 0x6f, 0x67, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x6f,
	0x6f, 0x6d, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x67, 0x6f, 0x6f, 0x64, 0x5f, 0x66, 0x6f, 0x72, 0x5f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x42, 0x1b, 0x0a, 0x19, 0x5f, 0x67, 0x6f, 0x6f, 0x64, 0x5f,
	0x66, 0x6f, 0x72, 0x5f, 0x77, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x6f,
	0x72, 0x74, 0x73, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x1d, 0x0a,
	0x1b, 0x5f, 0x70, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x72, 0x65, 0x61, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x2a, 0xb1, 0x01, 0x0a,
	0x0a, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x1b, 0x0a, 0x17, 0x50,
	0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x52, 0x49, 0x43,
	0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x46, 0x52, 0x45, 0x45, 0x10, 0x01, 0x12, 0x1b,
	0x0a, 0x17, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x49, 0x4e,
	0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x50,
	0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x52,
	0x41, 0x54, 0x45, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c,
	0x45, 0x56, 0x45, 0x4c, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45, 0x10, 0x04,
	0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x52, 0x49, 0x43, 0x45, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x5f,
	0x56, 0x45, 0x52, 0x59, 0x5f, 0x45, 0x58, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x56, 0x45, 0x10, 0x05,
	0x42, 0x9b, 0x01, 0x0a, 0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6d, 0x61, 0x70, 0x73, 0x2e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0a,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x70, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x70, 0x62, 0xa2, 0x02, 0x06, 0x47, 0x4d, 0x50, 0x53, 0x56, 0x31, 0xaa, 0x02,
	0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x4d, 0x61, 0x70, 0x73, 0x5c, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_places_v1_place_proto_rawDescOnce sync.Once
	file_google_maps_places_v1_place_proto_rawDescData = file_google_maps_places_v1_place_proto_rawDesc
)

func file_google_maps_places_v1_place_proto_rawDescGZIP() []byte {
	file_google_maps_places_v1_place_proto_rawDescOnce.Do(func() {
		file_google_maps_places_v1_place_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_places_v1_place_proto_rawDescData)
	})
	return file_google_maps_places_v1_place_proto_rawDescData
}

var file_google_maps_places_v1_place_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_maps_places_v1_place_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_maps_places_v1_place_proto_goTypes = []any{
	(PriceLevel)(0),                            // 0: google.maps.places.v1.PriceLevel
	(Place_BusinessStatus)(0),                  // 1: google.maps.places.v1.Place.BusinessStatus
	(Place_OpeningHours_SecondaryHoursType)(0), // 2: google.maps.places.v1.Place.OpeningHours.SecondaryHoursType
	(*Place)(nil),                              // 3: google.maps.places.v1.Place
	(*Place_AddressComponent)(nil),             // 4: google.maps.places.v1.Place.AddressComponent
	(*Place_PlusCode)(nil),                     // 5: google.maps.places.v1.Place.PlusCode
	(*Place_OpeningHours)(nil),                 // 6: google.maps.places.v1.Place.OpeningHours
	(*Place_Attribution)(nil),                  // 7: google.maps.places.v1.Place.Attribution
	(*Place_PaymentOptions)(nil),               // 8: google.maps.places.v1.Place.PaymentOptions
	(*Place_ParkingOptions)(nil),               // 9: google.maps.places.v1.Place.ParkingOptions
	(*Place_SubDestination)(nil),               // 10: google.maps.places.v1.Place.SubDestination
	(*Place_AccessibilityOptions)(nil),         // 11: google.maps.places.v1.Place.AccessibilityOptions
	(*Place_GenerativeSummary)(nil),            // 12: google.maps.places.v1.Place.GenerativeSummary
	(*Place_ContainingPlace)(nil),              // 13: google.maps.places.v1.Place.ContainingPlace
	(*Place_ReviewSummary)(nil),                // 14: google.maps.places.v1.Place.ReviewSummary
	(*Place_EvChargeAmenitySummary)(nil),       // 15: google.maps.places.v1.Place.EvChargeAmenitySummary
	(*Place_NeighborhoodSummary)(nil),          // 16: google.maps.places.v1.Place.NeighborhoodSummary
	(*Place_ConsumerAlert)(nil),                // 17: google.maps.places.v1.Place.ConsumerAlert
	(*Place_OpeningHours_Period)(nil),          // 18: google.maps.places.v1.Place.OpeningHours.Period
	(*Place_OpeningHours_SpecialDay)(nil),      // 19: google.maps.places.v1.Place.OpeningHours.SpecialDay
	(*Place_OpeningHours_Period_Point)(nil),    // 20: google.maps.places.v1.Place.OpeningHours.Period.Point
	(*Place_ConsumerAlert_Details)(nil),        // 21: google.maps.places.v1.Place.ConsumerAlert.Details
	(*Place_ConsumerAlert_Details_Link)(nil),   // 22: google.maps.places.v1.Place.ConsumerAlert.Details.Link
	(*localized_text.LocalizedText)(nil),       // 23: google.type.LocalizedText
	(*postaladdress.PostalAddress)(nil),        // 24: google.type.PostalAddress
	(*latlng.LatLng)(nil),                      // 25: google.type.LatLng
	(*viewport.Viewport)(nil),                  // 26: google.geo.type.Viewport
	(*Review)(nil),                             // 27: google.maps.places.v1.Review
	(*datetime.TimeZone)(nil),                  // 28: google.type.TimeZone
	(*Photo)(nil),                              // 29: google.maps.places.v1.Photo
	(*FuelOptions)(nil),                        // 30: google.maps.places.v1.FuelOptions
	(*EVChargeOptions)(nil),                    // 31: google.maps.places.v1.EVChargeOptions
	(*AddressDescriptor)(nil),                  // 32: google.maps.places.v1.AddressDescriptor
	(*PriceRange)(nil),                         // 33: google.maps.places.v1.PriceRange
	(*timestamppb.Timestamp)(nil),              // 34: google.protobuf.Timestamp
	(*ContentBlock)(nil),                       // 35: google.maps.places.v1.ContentBlock
	(*date.Date)(nil),                          // 36: google.type.Date
}
var file_google_maps_places_v1_place_proto_depIdxs = []int32{
	23, // 0: google.maps.places.v1.Place.display_name:type_name -> google.type.LocalizedText
	23, // 1: google.maps.places.v1.Place.primary_type_display_name:type_name -> google.type.LocalizedText
	24, // 2: google.maps.places.v1.Place.postal_address:type_name -> google.type.PostalAddress
	4,  // 3: google.maps.places.v1.Place.address_components:type_name -> google.maps.places.v1.Place.AddressComponent
	5,  // 4: google.maps.places.v1.Place.plus_code:type_name -> google.maps.places.v1.Place.PlusCode
	25, // 5: google.maps.places.v1.Place.location:type_name -> google.type.LatLng
	26, // 6: google.maps.places.v1.Place.viewport:type_name -> google.geo.type.Viewport
	27, // 7: google.maps.places.v1.Place.reviews:type_name -> google.maps.places.v1.Review
	6,  // 8: google.maps.places.v1.Place.regular_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	28, // 9: google.maps.places.v1.Place.time_zone:type_name -> google.type.TimeZone
	29, // 10: google.maps.places.v1.Place.photos:type_name -> google.maps.places.v1.Photo
	1,  // 11: google.maps.places.v1.Place.business_status:type_name -> google.maps.places.v1.Place.BusinessStatus
	0,  // 12: google.maps.places.v1.Place.price_level:type_name -> google.maps.places.v1.PriceLevel
	7,  // 13: google.maps.places.v1.Place.attributions:type_name -> google.maps.places.v1.Place.Attribution
	6,  // 14: google.maps.places.v1.Place.current_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	6,  // 15: google.maps.places.v1.Place.current_secondary_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	6,  // 16: google.maps.places.v1.Place.regular_secondary_opening_hours:type_name -> google.maps.places.v1.Place.OpeningHours
	23, // 17: google.maps.places.v1.Place.editorial_summary:type_name -> google.type.LocalizedText
	8,  // 18: google.maps.places.v1.Place.payment_options:type_name -> google.maps.places.v1.Place.PaymentOptions
	9,  // 19: google.maps.places.v1.Place.parking_options:type_name -> google.maps.places.v1.Place.ParkingOptions
	10, // 20: google.maps.places.v1.Place.sub_destinations:type_name -> google.maps.places.v1.Place.SubDestination
	11, // 21: google.maps.places.v1.Place.accessibility_options:type_name -> google.maps.places.v1.Place.AccessibilityOptions
	30, // 22: google.maps.places.v1.Place.fuel_options:type_name -> google.maps.places.v1.FuelOptions
	31, // 23: google.maps.places.v1.Place.ev_charge_options:type_name -> google.maps.places.v1.EVChargeOptions
	12, // 24: google.maps.places.v1.Place.generative_summary:type_name -> google.maps.places.v1.Place.GenerativeSummary
	13, // 25: google.maps.places.v1.Place.containing_places:type_name -> google.maps.places.v1.Place.ContainingPlace
	32, // 26: google.maps.places.v1.Place.address_descriptor:type_name -> google.maps.places.v1.AddressDescriptor
	33, // 27: google.maps.places.v1.Place.price_range:type_name -> google.maps.places.v1.PriceRange
	14, // 28: google.maps.places.v1.Place.review_summary:type_name -> google.maps.places.v1.Place.ReviewSummary
	15, // 29: google.maps.places.v1.Place.ev_charge_amenity_summary:type_name -> google.maps.places.v1.Place.EvChargeAmenitySummary
	16, // 30: google.maps.places.v1.Place.neighborhood_summary:type_name -> google.maps.places.v1.Place.NeighborhoodSummary
	17, // 31: google.maps.places.v1.Place.consumer_alert:type_name -> google.maps.places.v1.Place.ConsumerAlert
	18, // 32: google.maps.places.v1.Place.OpeningHours.periods:type_name -> google.maps.places.v1.Place.OpeningHours.Period
	2,  // 33: google.maps.places.v1.Place.OpeningHours.secondary_hours_type:type_name -> google.maps.places.v1.Place.OpeningHours.SecondaryHoursType
	19, // 34: google.maps.places.v1.Place.OpeningHours.special_days:type_name -> google.maps.places.v1.Place.OpeningHours.SpecialDay
	34, // 35: google.maps.places.v1.Place.OpeningHours.next_open_time:type_name -> google.protobuf.Timestamp
	34, // 36: google.maps.places.v1.Place.OpeningHours.next_close_time:type_name -> google.protobuf.Timestamp
	23, // 37: google.maps.places.v1.Place.GenerativeSummary.overview:type_name -> google.type.LocalizedText
	23, // 38: google.maps.places.v1.Place.GenerativeSummary.disclosure_text:type_name -> google.type.LocalizedText
	23, // 39: google.maps.places.v1.Place.ReviewSummary.text:type_name -> google.type.LocalizedText
	23, // 40: google.maps.places.v1.Place.ReviewSummary.disclosure_text:type_name -> google.type.LocalizedText
	35, // 41: google.maps.places.v1.Place.EvChargeAmenitySummary.overview:type_name -> google.maps.places.v1.ContentBlock
	35, // 42: google.maps.places.v1.Place.EvChargeAmenitySummary.coffee:type_name -> google.maps.places.v1.ContentBlock
	35, // 43: google.maps.places.v1.Place.EvChargeAmenitySummary.restaurant:type_name -> google.maps.places.v1.ContentBlock
	35, // 44: google.maps.places.v1.Place.EvChargeAmenitySummary.store:type_name -> google.maps.places.v1.ContentBlock
	23, // 45: google.maps.places.v1.Place.EvChargeAmenitySummary.disclosure_text:type_name -> google.type.LocalizedText
	35, // 46: google.maps.places.v1.Place.NeighborhoodSummary.overview:type_name -> google.maps.places.v1.ContentBlock
	35, // 47: google.maps.places.v1.Place.NeighborhoodSummary.description:type_name -> google.maps.places.v1.ContentBlock
	23, // 48: google.maps.places.v1.Place.NeighborhoodSummary.disclosure_text:type_name -> google.type.LocalizedText
	21, // 49: google.maps.places.v1.Place.ConsumerAlert.details:type_name -> google.maps.places.v1.Place.ConsumerAlert.Details
	20, // 50: google.maps.places.v1.Place.OpeningHours.Period.open:type_name -> google.maps.places.v1.Place.OpeningHours.Period.Point
	20, // 51: google.maps.places.v1.Place.OpeningHours.Period.close:type_name -> google.maps.places.v1.Place.OpeningHours.Period.Point
	36, // 52: google.maps.places.v1.Place.OpeningHours.SpecialDay.date:type_name -> google.type.Date
	36, // 53: google.maps.places.v1.Place.OpeningHours.Period.Point.date:type_name -> google.type.Date
	22, // 54: google.maps.places.v1.Place.ConsumerAlert.Details.about_link:type_name -> google.maps.places.v1.Place.ConsumerAlert.Details.Link
	55, // [55:55] is the sub-list for method output_type
	55, // [55:55] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_maps_places_v1_place_proto_init() }
func file_google_maps_places_v1_place_proto_init() {
	if File_google_maps_places_v1_place_proto != nil {
		return
	}
	file_google_maps_places_v1_address_descriptor_proto_init()
	file_google_maps_places_v1_content_block_proto_init()
	file_google_maps_places_v1_ev_charging_proto_init()
	file_google_maps_places_v1_fuel_options_proto_init()
	file_google_maps_places_v1_photo_proto_init()
	file_google_maps_places_v1_price_range_proto_init()
	file_google_maps_places_v1_review_proto_init()
	file_google_maps_places_v1_place_proto_msgTypes[0].OneofWrappers = []any{}
	file_google_maps_places_v1_place_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_maps_places_v1_place_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_maps_places_v1_place_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_maps_places_v1_place_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_maps_places_v1_place_proto_msgTypes[17].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_places_v1_place_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_places_v1_place_proto_goTypes,
		DependencyIndexes: file_google_maps_places_v1_place_proto_depIdxs,
		EnumInfos:         file_google_maps_places_v1_place_proto_enumTypes,
		MessageInfos:      file_google_maps_places_v1_place_proto_msgTypes,
	}.Build()
	File_google_maps_places_v1_place_proto = out.File
	file_google_maps_places_v1_place_proto_rawDesc = nil
	file_google_maps_places_v1_place_proto_goTypes = nil
	file_google_maps_places_v1_place_proto_depIdxs = nil
}
