// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

//go:build go1.23

package securitycenter

import (
	"iter"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	securitycenterpb "cloud.google.com/go/securitycenter/apiv1/securitycenterpb"
	"github.com/googleapis/gax-go/v2/iterator"
)

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *AttackPathIterator) All() iter.Seq2[*securitycenterpb.AttackPath, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *BigQueryExportIterator) All() iter.Seq2[*securitycenterpb.BigQueryExport, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EffectiveEventThreatDetectionCustomModuleIterator) All() iter.Seq2[*securitycenterpb.EffectiveEventThreatDetectionCustomModule, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EffectiveSecurityHealthAnalyticsCustomModuleIterator) All() iter.Seq2[*securitycenterpb.EffectiveSecurityHealthAnalyticsCustomModule, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *EventThreatDetectionCustomModuleIterator) All() iter.Seq2[*securitycenterpb.EventThreatDetectionCustomModule, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *GroupResultIterator) All() iter.Seq2[*securitycenterpb.GroupResult, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ListAssetsResponse_ListAssetsResultIterator) All() iter.Seq2[*securitycenterpb.ListAssetsResponse_ListAssetsResult, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ListFindingsResponse_ListFindingsResultIterator) All() iter.Seq2[*securitycenterpb.ListFindingsResponse_ListFindingsResult, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *MuteConfigIterator) All() iter.Seq2[*securitycenterpb.MuteConfig, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *NotificationConfigIterator) All() iter.Seq2[*securitycenterpb.NotificationConfig, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *OperationIterator) All() iter.Seq2[*longrunningpb.Operation, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ResourceValueConfigIterator) All() iter.Seq2[*securitycenterpb.ResourceValueConfig, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SecurityHealthAnalyticsCustomModuleIterator) All() iter.Seq2[*securitycenterpb.SecurityHealthAnalyticsCustomModule, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *SourceIterator) All() iter.Seq2[*securitycenterpb.Source, error] {
	return iterator.RangeAdapter(it.Next)
}

// All returns an iterator. If an error is returned by the iterator, the
// iterator will stop after that iteration.
func (it *ValuedResourceIterator) All() iter.Seq2[*securitycenterpb.ValuedResource, error] {
	return iterator.RangeAdapter(it.Next)
}
