// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestStack_MoveTo(t *testing.T) {
	ms := generateTestStack()
	dest := NewStack()
	ms.MoveTo(dest)
	assert.Equal(t, NewStack(), ms)
	assert.Equal(t, generateTestStack(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestStack(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newStack(internal.NewStack(), sharedState)) })
	assert.Panics(t, func() { newStack(internal.NewStack(), sharedState).MoveTo(dest) })
}

func TestStack_CopyTo(t *testing.T) {
	ms := NewStack()
	orig := NewStack()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestStack()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newStack(internal.NewStack(), sharedState)) })
}

func TestStack_LocationIndices(t *testing.T) {
	ms := NewStack()
	assert.Equal(t, pcommon.NewInt32Slice(), ms.LocationIndices())
	ms.orig.LocationIndices = internal.GenTestInt32Slice()
	assert.Equal(t, pcommon.Int32Slice(internal.GenTestInt32SliceWrapper()), ms.LocationIndices())
}

func generateTestStack() Stack {
	return newStack(internal.GenTestStack(), internal.NewState())
}
