// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
)

type ModifyMonitorStatusRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 监控项ID，请使用describeMonitor接口获取。  */
	MonitorId string `json:"monitorId"`

	/* 暂停stop, 开启start, 手动恢复recover，手动切换switch，手动恢复和手动切换时候不支持批量操作  */
	Action string `json:"action"`

	/* 监控项的主机值, 手动切换时必填 (Optional) */
	SwitchTarget *string `json:"switchTarget"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param monitorId: 监控项ID，请使用describeMonitor接口获取。 (Required)
 * param action: 暂停stop, 开启start, 手动恢复recover，手动切换switch，手动恢复和手动切换时候不支持批量操作 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewModifyMonitorStatusRequest(
	regionId string,
	domainId string,
	monitorId string,
	action string,
) *ModifyMonitorStatusRequest {

	return &ModifyMonitorStatusRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitor/{monitorId}/status",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
		RegionId:  regionId,
		DomainId:  domainId,
		MonitorId: monitorId,
		Action:    action,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param monitorId: 监控项ID，请使用describeMonitor接口获取。 (Required)
 * param action: 暂停stop, 开启start, 手动恢复recover，手动切换switch，手动恢复和手动切换时候不支持批量操作 (Required)
 * param switchTarget: 监控项的主机值, 手动切换时必填 (Optional)
 */
func NewModifyMonitorStatusRequestWithAllParams(
	regionId string,
	domainId string,
	monitorId string,
	action string,
	switchTarget *string,
) *ModifyMonitorStatusRequest {

	return &ModifyMonitorStatusRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitor/{monitorId}/status",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
		RegionId:     regionId,
		DomainId:     domainId,
		MonitorId:    monitorId,
		Action:       action,
		SwitchTarget: switchTarget,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewModifyMonitorStatusRequestWithoutParam() *ModifyMonitorStatusRequest {

	return &ModifyMonitorStatusRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitor/{monitorId}/status",
			Method:  "PUT",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *ModifyMonitorStatusRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *ModifyMonitorStatusRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param monitorId: 监控项ID，请使用describeMonitor接口获取。(Required) */
func (r *ModifyMonitorStatusRequest) SetMonitorId(monitorId string) {
	r.MonitorId = monitorId
}

/* param action: 暂停stop, 开启start, 手动恢复recover，手动切换switch，手动恢复和手动切换时候不支持批量操作(Required) */
func (r *ModifyMonitorStatusRequest) SetAction(action string) {
	r.Action = action
}

/* param switchTarget: 监控项的主机值, 手动切换时必填(Optional) */
func (r *ModifyMonitorStatusRequest) SetSwitchTarget(switchTarget string) {
	r.SwitchTarget = &switchTarget
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r ModifyMonitorStatusRequest) GetRegionId() string {
	return r.RegionId
}

type ModifyMonitorStatusResponse struct {
	RequestID string                    `json:"requestId"`
	Error     core.ErrorResponse        `json:"error"`
	Result    ModifyMonitorStatusResult `json:"result"`
}

type ModifyMonitorStatusResult struct {
}
