package csnexamples

import (
	"fmt"

	"github.com/baidubce/bce-sdk-go/services/csn"
	"github.com/baidubce/bce-sdk-go/util"
)

func BindCsnBp() {
	client, err := csn.NewClient("Your AK", "Your SK", "csn.baidubce.com")
	if err != nil {
		fmt.Printf("Failed to new csn client, err: %v.\n", err)
		return
	}
	request := &csn.BindCsnBpRequest{
		CsnId: "csnId",
	}
	if err = client.BindCsnBp("csnBpId", request, util.NewUUID()); err != nil {
		fmt.Printf("Failed to bind Csn Bp, err: %v.\n", err)
		return
	}
	fmt.Println("Successfully bind csn bp.")
}
