/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.analysis;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.analysis.Utils;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RequiredPluginsPanel
extends JPanel {
    private Set<Analyzer.MissingPlugin> plugins = new HashSet<Analyzer.MissingPlugin>();
    private JButton install;
    private JLabel warning;

    public RequiredPluginsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.warning = new JLabel();
        this.install = new JButton();
        this.warning.setText(NbBundle.getMessage(RequiredPluginsPanel.class, (String)"RequiredPluginsPanel.warning.text"));
        this.install.setText(NbBundle.getMessage(RequiredPluginsPanel.class, (String)"RequiredPluginsPanel.install.text"));
        this.install.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RequiredPluginsPanel.this.installActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.warning).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.install)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.warning).addComponent(this.install)));
    }

    private void installActionPerformed(ActionEvent evt) {
        Utils.installMissingPlugins(this.plugins);
    }

    public void setRequiredPlugins(Set<Analyzer.MissingPlugin> plugins, boolean critical) {
        this.plugins = plugins;
        if (critical) {
            Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
            if (nbErrorForeground == null) {
                nbErrorForeground = new Color(255, 0, 0);
            }
            this.warning.setForeground(nbErrorForeground);
            this.warning.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/error.gif", (boolean)false));
        } else {
            Color nbWarningForeground = UIManager.getColor("nb.warningForeground");
            if (nbWarningForeground == null) {
                nbWarningForeground = new Color(51, 51, 51);
            }
            this.warning.setForeground(nbWarningForeground);
            this.warning.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dialogs/warning.gif", (boolean)false));
        }
    }
}

