/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.php;

import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.lexer.LexUtilities;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.editor.parser.PHPDocCommentParser;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocBlock;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocVarTypeTag;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;

public class PHPTokenList
implements TokenList {
    private final Document doc;
    private boolean hidden = false;
    private int currentBlockStart;
    private int currentOffsetInComment;
    private int currentWordOffset;
    private int nextBlockStart;
    private int startOffset;
    private CharSequence currentWord;
    private String currentBlockText;
    private PHPDocBlock currentDocBlock;
    private final PHPDocCommentParser docParser = new PHPDocCommentParser();

    public PHPTokenList(Document doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentBlockText = null;
        this.currentOffsetInComment = -1;
        this.startOffset = offset;
        this.nextBlockStart = offset;
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/Phpdoc");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    public boolean nextWord() {
        if (this.hidden) {
            return false;
        }
        boolean hasNext = this.nextWordImpl();
        while (hasNext && this.currentWordOffset + this.currentWord.length() < this.startOffset) {
            hasNext = this.nextWordImpl();
        }
        return hasNext;
    }

    private boolean nextWordImpl() {
        try {
            while (true) {
                if (this.currentBlockText == null) {
                    int[] span = this.findNextPHPDocComment();
                    if (span[0] == -1) {
                        return false;
                    }
                    this.currentBlockStart = span[0];
                    this.currentBlockText = this.doc.getText(span[0], span[1] - span[0]);
                    this.currentOffsetInComment = 0;
                    this.nextBlockStart = span[1];
                    this.currentDocBlock = this.docParser.parse(-3, this.currentBlockText.length(), this.currentBlockText);
                }
                String pairTag = null;
                Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment);
                while (data != null) {
                    block18: {
                        block17: {
                            this.currentOffsetInComment = PHPTokenList.getCurrentOffsetInComment(data);
                            if (pairTag != null) break block17;
                            if (Character.isLetter(((CharSequence)data.first()).charAt(0)) && !PHPTokenList.isIdentifierLike((CharSequence)data.first())) {
                                this.currentWordOffset = this.currentBlockStart + (Integer)data.second();
                                this.currentWord = (CharSequence)data.first();
                                return true;
                            }
                            switch (((CharSequence)data.first()).charAt(0)) {
                                case '@': {
                                    this.handlePhpdocTag((CharSequence)data.first());
                                    break;
                                }
                                case '<': {
                                    if (PHPTokenList.startsWith((CharSequence)data.first(), "<a ")) {
                                        pairTag = "</a>";
                                    }
                                    if (PHPTokenList.startsWith((CharSequence)data.first(), "<code>")) {
                                        pairTag = "</code>";
                                    }
                                    if (PHPTokenList.startsWith((CharSequence)data.first(), "<pre>")) {
                                        pairTag = "</pre>";
                                        break;
                                    }
                                    break block18;
                                }
                                case '{': {
                                    pairTag = "}";
                                    break;
                                }
                                case '$': {
                                    break;
                                }
                            }
                            break block18;
                        }
                        if (pairTag.contentEquals((CharSequence)data.first())) {
                            pairTag = null;
                        }
                    }
                    data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment);
                }
                this.currentBlockText = null;
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    private int[] findNextPHPDocComment() throws BadLocationException {
        TokenSequence ts = null;
        if (this.doc instanceof AbstractDocument) {
            AbstractDocument ad = (AbstractDocument)this.doc;
            ad.readLock();
            try {
                ts = LexUtilities.getPHPTokenSequence((Document)ad, (int)this.nextBlockStart);
            }
            finally {
                ad.readUnlock();
            }
        }
        if (ts == null) {
            return new int[]{-1, -1};
        }
        ts.move(this.nextBlockStart);
        while (ts.moveNext()) {
            if (ts.token().id() != PHPTokenId.PHPDOC_COMMENT) continue;
            return new int[]{ts.offset(), ts.offset() + ts.token().length()};
        }
        return new int[]{-1, -1};
    }

    private void handlePhpdocTag(CharSequence tag) {
        if ("@see".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, LetterType.See);
            this.currentOffsetInComment = PHPTokenList.getCurrentOffsetInComment(data);
            return;
        }
        if ("@author".contentEquals(tag)) {
            Pair<CharSequence, Integer> data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment);
            while (data != null) {
                this.currentOffsetInComment = PHPTokenList.getCurrentOffsetInComment(data);
                if ('\n' == ((CharSequence)data.first()).charAt(0)) {
                    return;
                }
                data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment);
            }
            return;
        }
        if (this.currentDocBlock != null) {
            List phpDocTags = this.currentDocBlock.getTags();
            for (PHPDocTag phpDocTag : phpDocTags) {
                if (phpDocTag.getStartOffset() != this.currentOffsetInComment - tag.length()) continue;
                if (!(phpDocTag instanceof PHPDocTypeTag)) break;
                this.handleTypeTag((PHPDocTypeTag)phpDocTag);
                break;
            }
        }
    }

    private void handleTypeTag(PHPDocTypeTag docTypeTag) {
        int endOffset;
        List types = docTypeTag.getTypes();
        PHPDocTypeNode lastType = null;
        for (PHPDocTypeNode type : types) {
            String value = type.getValue();
            if (StringUtils.isEmpty((String)value) || lastType != null && lastType.getEndOffset() >= type.getEndOffset()) continue;
            lastType = type;
        }
        if (lastType != null && this.currentOffsetInComment < (endOffset = lastType.getEndOffset())) {
            this.currentOffsetInComment = endOffset;
        }
        if (docTypeTag instanceof PHPDocMethodTag) {
            PHPDocMethodTag methodTag = (PHPDocMethodTag)docTypeTag;
            List parameters = methodTag.getParameters();
            PHPDocVarTypeTag lastParam = null;
            for (PHPDocVarTypeTag parameter : parameters) {
                if (lastParam != null && lastParam.getEndOffset() >= parameter.getEndOffset()) continue;
                lastParam = parameter;
            }
            if (lastParam != null) {
                int endOffset2 = lastParam.getEndOffset();
                if (this.currentOffsetInComment < endOffset2) {
                    this.currentOffsetInComment = endOffset2;
                }
            } else {
                Pair<CharSequence, Integer> data;
                PHPDocNode methodName = methodTag.getMethodName();
                if (methodName != null && (data = this.wordBroker(this.currentBlockText, this.currentOffsetInComment, LetterType.MethodName)) != null && ((CharSequence)data.first()).equals(methodName.getValue())) {
                    this.currentOffsetInComment = PHPTokenList.getCurrentOffsetInComment(data);
                }
            }
        }
    }

    private Pair<CharSequence, Integer> wordBroker(CharSequence start, int offset) {
        return this.wordBroker(start, offset, LetterType.Normal);
    }

    private Pair<CharSequence, Integer> wordBroker(CharSequence start, int offset, LetterType letterType) {
        int currentOffset;
        State state = State.Start;
        int offsetStart = offset;
        block9: for (currentOffset = offset; start.length() > currentOffset; ++currentOffset) {
            char currentChar = start.charAt(currentOffset);
            switch (state) {
                case Start: {
                    if (PHPTokenList.isLetter(currentChar)) {
                        state = State.Letter;
                        offsetStart = currentOffset;
                        continue block9;
                    }
                    if (currentChar == '@' || currentChar == '#') {
                        state = State.Tag;
                        offsetStart = currentOffset;
                        continue block9;
                    }
                    if (currentChar == '<') {
                        state = State.AngleBracket;
                        offsetStart = currentOffset;
                        continue block9;
                    }
                    if (currentChar == '\n' || currentChar == '}') {
                        return Pair.of((Object)start.subSequence(currentOffset, currentOffset + 1), (Object)currentOffset);
                    }
                    if (currentChar == '{') {
                        state = State.Brace;
                        offsetStart = currentOffset;
                        continue block9;
                    }
                    if (currentChar == '&') {
                        state = State.Entity;
                        offsetStart = currentOffset;
                        continue block9;
                    }
                    if (currentChar != '$') continue block9;
                    state = State.Variable;
                    offsetStart = currentOffset;
                    continue block9;
                }
                case Letter: {
                    if (PHPTokenList.isLetter(currentChar) || letterType.accept(currentChar)) continue block9;
                    return Pair.of((Object)start.subSequence(offsetStart, currentOffset), (Object)offsetStart);
                }
                case Tag: {
                    if (PHPTokenList.isLetter(currentChar) || currentChar == '-') continue block9;
                    return Pair.of((Object)start.subSequence(offsetStart, currentOffset), (Object)offsetStart);
                }
                case AngleBracket: {
                    if (currentChar != '>') continue block9;
                    return Pair.of((Object)start.subSequence(offsetStart, currentOffset + 1), (Object)offsetStart);
                }
                case Brace: {
                    if (currentChar == '@') {
                        state = State.Tag;
                        continue block9;
                    }
                    --currentOffset;
                    state = State.Start;
                    continue block9;
                }
                case Entity: {
                    if (currentChar == ';') {
                        return Pair.of((Object)start.subSequence(offsetStart, currentOffset + 1), (Object)offsetStart);
                    }
                    if (PHPTokenList.isLetter(currentChar) || currentChar == '#' || Character.isDigit(currentChar)) continue block9;
                    return Pair.of((Object)start.subSequence(offsetStart, currentOffset), (Object)offsetStart);
                }
                case Variable: {
                    if (PHPTokenList.isLetter(currentChar) || currentChar == '_' || Character.isDigit(currentChar)) continue block9;
                    return Pair.of((Object)start.subSequence(offsetStart, currentOffset), (Object)offsetStart);
                }
                default: {
                    assert (false);
                    continue block9;
                }
            }
        }
        if (currentOffset > offsetStart) {
            return Pair.of((Object)start.subSequence(offsetStart, currentOffset), (Object)offsetStart);
        }
        return null;
    }

    private static boolean startsWith(CharSequence where, String withWhat) {
        if (where.length() >= withWhat.length()) {
            return withWhat.contentEquals(where.subSequence(0, withWhat.length()));
        }
        return false;
    }

    static boolean isIdentifierLike(CharSequence s) {
        boolean hasCapitalsInside = false;
        for (int offset = 1; offset < s.length() && !hasCapitalsInside; hasCapitalsInside |= Character.isUpperCase(s.charAt(offset)), ++offset) {
        }
        return hasCapitalsInside;
    }

    private static int getCurrentOffsetInComment(Pair<CharSequence, Integer> data) {
        return (Integer)data.second() + ((CharSequence)data.first()).length();
    }

    private static boolean isLetter(char c) {
        return Character.isLetter(c) || c == '\'';
    }

    public int getCurrentWordStartOffset() {
        return this.currentWordOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum LetterType {
        Normal{

            @Override
            public boolean accept(char c) {
                return false;
            }
        }
        ,
        See{

            @Override
            public boolean accept(char c) {
                return c == ':' || c == '/' || c == '.' || c == '_' || c == '-' || c == '?' || c == '&';
            }
        }
        ,
        MethodName{

            @Override
            public boolean accept(char c) {
                return c == '_' || Character.isDigit(c);
            }
        };


        public abstract boolean accept(char var1);
    }

    private static enum State {
        AngleBracket,
        Brace,
        Entity,
        Letter,
        Start,
        Tag,
        Variable;

    }
}

