/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Dialog;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.ProjectUtil;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping25;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.Handler;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChain;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChains;
import org.netbeans.modules.websvc.api.jaxws.project.config.HandlerChainsProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.support.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.WebServiceReference;
import org.netbeans.modules.websvc.core.WebServiceTransferable;
import org.netbeans.modules.websvc.core.WsWsdlCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.AddOperationAction;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestAction;
import org.netbeans.modules.websvc.core.jaxws.actions.ConvertToRestCookieImpl;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsGenWSDLAction;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsGenWSDLImpl;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshAction;
import org.netbeans.modules.websvc.core.jaxws.actions.WsTesterPageAction;
import org.netbeans.modules.websvc.core.jaxws.nodes.HandlerButtonListener;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.RefreshWsDialog;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.websvc.jaxws.api.JaxWsTesterCookie;
import org.netbeans.modules.websvc.spi.support.ConfigureHandlerAction;
import org.netbeans.modules.websvc.spi.support.MessageHandlerPanel;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public class JaxWsNode
extends AbstractNode
implements WsWsdlCookie,
JaxWsTesterCookie,
ConfigureHandlerCookie {
    private static final RequestProcessor RP = new RequestProcessor(JaxWsNode.class);
    Service service;
    FileObject srcRoot;
    JaxWsModel jaxWsModel;
    private FileObject implBeanClass;
    InstanceContent content;
    Project project;
    private final RequestProcessor.Task implClassModifiedTask = RP.create(new Runnable(){

        @Override
        public void run() {
            JaxWsNode.this.setShortDescription(JaxWsNode.this.getWsdlURL());
        }
    });
    private static final String WAITING_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsNode(JaxWsModel jaxWsModel, Service service, FileObject srcRoot, FileObject implBeanClass) {
        this(jaxWsModel, service, srcRoot, implBeanClass, new InstanceContent());
    }

    private JaxWsNode(JaxWsModel jaxWsModel, Service service, FileObject srcRoot, FileObject implBeanClass, InstanceContent content) {
        super((Children)new JaxWsChildren(service, srcRoot, implBeanClass), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.jaxWsModel = jaxWsModel;
        this.service = service;
        this.srcRoot = srcRoot;
        this.content = content;
        this.implBeanClass = implBeanClass;
        this.project = FileOwnerQuery.getOwner((FileObject)srcRoot);
        if (implBeanClass.getAttribute("jax-ws-service") == null || service.isUseProvider() && implBeanClass.getAttribute("jax-ws-service-provider") == null) {
            try {
                if (implBeanClass.getAttribute("jax-ws-service") == null) {
                    implBeanClass.setAttribute("jax-ws-service", (Object)Boolean.TRUE);
                }
                if (service.isUseProvider() && implBeanClass.getAttribute("jax-ws-service-provider") == null) {
                    implBeanClass.setAttribute("jax-ws-service-provider", (Object)Boolean.TRUE);
                }
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            EditorCookie cookie = (EditorCookie)JaxWsNode.this.getDataObject().getCookie(EditorCookie.class);
                            JEditorPane[] panes = cookie.getOpenedPanes();
                            JaxWsNode.this.getDataObject().setValid(false);
                            if (panes != null && panes.length > 0) {
                                ((EditorCookie)JaxWsNode.this.getDataObject().getCookie(EditorCookie.class)).open();
                            }
                        }
                        catch (PropertyVetoException ex) {
                            Logger.getLogger(JaxWsNode.class.getName()).log(Level.WARNING, null, ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        String serviceName = service.getName();
        this.setName(serviceName);
        content.add((Object)this);
        content.add((Object)service);
        content.add((Object)implBeanClass);
        content.add((Object)new EditWSAttributesCookieImpl((Node)this, jaxWsModel));
        if (service.getWsdlUrl() != null && !service.isUseProvider()) {
            content.add((Object)new RefreshServiceImpl());
        } else {
            content.add((Object)new JaxWsGenWSDLImpl(this.project, serviceName));
        }
        if (this.isWebProject()) {
            content.add((Object)new ConvertToRestCookieImpl(this));
        }
        OpenCookie cookie = new OpenCookie(){

            public void open() {
                OpenCookie oc = JaxWsNode.this.getOpenCookie();
                if (oc != null) {
                    oc.open();
                }
            }
        };
        content.add((Object)cookie);
        RP.post(new Runnable(){

            @Override
            public void run() {
                JaxWsNode.this.setValue("wsdl-url", JaxWsNode.this.getWsdlURL());
                JaxWsNode.this.setShortDescription(JaxWsNode.this.getWsdlURL());
            }
        });
        try {
            DataObject dataObject = DataObject.find((FileObject)implBeanClass);
            dataObject.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("modified".equals(evt.getPropertyName())) {
                        JaxWsNode.this.implClassModifiedTask.schedule(500);
                    }
                }
            });
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private boolean isWebProject() {
        J2eeModule.Type moduleType;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        return provider != null && J2eeModule.Type.WAR.equals(moduleType = provider.getJ2eeModule().getType());
    }

    public String getDisplayName() {
        if (this.service.getWsdlUrl() != null) {
            return NbBundle.getMessage(JaxWsNode.class, (String)"LBL_serviceNodeName", (Object)this.service.getServiceName(), (Object)this.service.getPortName());
        }
        return this.service.getName();
    }

    public Image getIcon(int type) {
        WsdlModeler wsdlModeler = ((JaxWsChildren)this.getChildren()).getWsdlModeler();
        if (wsdlModeler == null) {
            return this.getServiceImage();
        }
        if (wsdlModeler.getCreationException() == null) {
            if (((JaxWsChildren)this.getChildren()).isModelGenerationFinished()) {
                return this.getServiceImage();
            }
            return ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getWaitingBadge(), (int)15, (int)8);
        }
        Image dirtyNodeImage = ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getErrorBadge(), (int)6, (int)6);
        if (((JaxWsChildren)this.getChildren()).isModelGenerationFinished()) {
            return dirtyNodeImage;
        }
        return ImageUtilities.mergeImages((Image)dirtyNodeImage, (Image)this.getWaitingBadge(), (int)15, (int)8);
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    private DataObject getDataObject() {
        FileObject f = this.getImplBean();
        if (f != null) {
            try {
                return DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException de) {
                ErrorManager.getDefault().log(1, de.toString());
            }
        }
        return null;
    }

    private OpenCookie getOpenCookie() {
        OpenCookie oc = null;
        FileObject f = this.getImplBean();
        if (f != null) {
            try {
                DataObject d = DataObject.find((FileObject)f);
                oc = (OpenCookie)d.getCookie(OpenCookie.class);
            }
            catch (DataObjectNotFoundException de) {
                ErrorManager.getDefault().log(1, de.toString());
            }
        }
        return oc;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean context) {
        ArrayList<CallableSystemAction> actions = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(JaxWsRefreshAction.class), null, (CallableSystemAction)SystemAction.get(AddOperationAction.class), null, (CallableSystemAction)SystemAction.get(WsTesterPageAction.class), null, (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), null, (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(JaxWsGenWSDLAction.class), null, (CallableSystemAction)SystemAction.get(ConvertToRestAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(actions, "WebServices/Services/Actions");
        return actions.toArray(new Action[0]);
    }

    private void addFromLayers(List<Action> actions, String path) {
        Lookup look = Lookups.forPath((String)path);
        for (Object next : look.lookupAll(Object.class)) {
            if (next instanceof Action) {
                actions.add((Action)next);
                continue;
            }
            if (!(next instanceof JSeparator)) continue;
            actions.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    private ServerContextInfo getServerContextInfo() {
        String portNumber = "8080";
        String hostName = "localhost";
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        String serverInstanceID = provider.getServerInstanceID();
        if (serverInstanceID == null) {
            Logger.getLogger(JaxWsNode.class.getName()).log(Level.INFO, "Can not detect target J2EE server");
            return null;
        }
        ServerInstance serverInstance = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            ServerInstance.Descriptor instanceDescriptor = serverInstance.getDescriptor();
            if (instanceDescriptor != null) {
                int port = instanceDescriptor.getHttpPort();
                portNumber = port == 0 ? "8080" : String.valueOf(port);
                String hstName = instanceDescriptor.getHostname();
                if (hstName != null) {
                    hostName = hstName;
                }
            } else {
                InstanceProperties instanceProperties = provider.getInstanceProperties();
                if (instanceProperties == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_MissingServer"), 0));
                } else {
                    portNumber = this.getPortNumber(instanceProperties);
                    hostName = this.getHostName(instanceProperties);
                }
            }
        }
        catch (InstanceRemovedException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Removed ServerInstance", ex);
        }
        String contextRoot = "";
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        if (J2eeModule.Type.WAR.equals(moduleType)) {
            J2eeModuleProvider.ConfigSupport configSupport = provider.getConfigSupport();
            try {
                contextRoot = configSupport.getWebContextRoot();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            if (contextRoot != null && contextRoot.startsWith("/")) {
                contextRoot = contextRoot.substring(1);
            }
        } else if (J2eeModule.Type.EJB.equals(moduleType) && ServerType.JBOSS == stackUtils.getServerType()) {
            contextRoot = this.project.getProjectDirectory().getName();
        }
        return new ServerContextInfo(hostName, portNumber, contextRoot);
    }

    @SuppressWarnings(value={"DE_MIGHT_IGNORE"})
    private ServiceInfo getServiceInfo() {
        ServiceInfo serviceInfo = new ServiceInfo();
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        boolean isEjb = J2eeModule.Type.EJB.equals(provider.getJ2eeModule().getType());
        try {
            this.resolveServiceInfo(serviceInfo, isEjb);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return serviceInfo;
    }

    private String getServiceUri(String contextRoot) {
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eeModule.Type moduleType = provider.getJ2eeModule().getType();
        String wsURI = null;
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        boolean isJsr109Supported = stackUtils.isJsr109Supported();
        if (J2eeModule.Type.WAR.equals(moduleType) && ServerType.JBOSS == stackUtils.getServerType()) {
            try {
                wsURI = (contextRoot == null ? "" : contextRoot + "/") + this.getUriFromDD(moduleType);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (J2eeModule.Type.EJB.equals(moduleType) && ServerType.JBOSS == stackUtils.getServerType()) {
            wsURI = (contextRoot == null ? "" : contextRoot + "/") + this.getNameFromPackageName(this.service.getImplementationClass());
        } else if (isJsr109Supported && ProjectUtil.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project)) {
            try {
                JaxWs.UriDescriptor uriDescriptor;
                ServiceInfo serviceInfo = new ServiceInfo();
                this.resolveServiceInfo(serviceInfo, J2eeModule.Type.EJB.equals(moduleType));
                boolean fromStack = false;
                WSStack<JaxWs> jaxWsStack = stackUtils.getWsStack(JaxWs.class);
                if (jaxWsStack != null && (uriDescriptor = ((JaxWs)jaxWsStack.get()).getWsUriDescriptor()) != null) {
                    fromStack = true;
                    wsURI = uriDescriptor.getServiceUri(contextRoot, serviceInfo.getServiceName(), serviceInfo.getPortName(), serviceInfo.isEjb());
                }
                if (!fromStack) {
                    String portName = serviceInfo.getPortName();
                    wsURI = (contextRoot == null ? "" : contextRoot + "/") + serviceInfo.getServiceName() + (portName == null ? "" : "/" + portName);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            try {
                wsURI = (contextRoot == null ? "" : contextRoot + "/") + this.getNonJsr109Uri(moduleType);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return wsURI;
    }

    private String getNonJsr109Uri(J2eeModule.Type moduleType) throws UnsupportedEncodingException {
        FileObject sunJaxwsFo;
        WebModule webModule;
        FileObject webInfFo;
        if (J2eeModule.Type.WAR.equals(moduleType) && (webInfFo = (webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory())).getWebInf()) != null && (sunJaxwsFo = webInfFo.getFileObject("sun-jaxws", "xml")) != null) {
            try {
                String urlPattern;
                Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(sunJaxwsFo);
                if (endpoints != null && (urlPattern = this.findUrlPattern(endpoints, this.service.getImplementationClass())) != null) {
                    return URLEncoder.encode(urlPattern, "UTF-8");
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return URLEncoder.encode(this.getNameFromPackageName(this.service.getImplementationClass()), "UTF-8");
    }

    private String getUriFromDD(J2eeModule.Type moduleType) throws UnsupportedEncodingException {
        FileObject ddFo;
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        if (webModule != null && (ddFo = webModule.getDeploymentDescriptor()) != null) {
            try {
                String urlPattern;
                WebApp webApp = DDProvider.getDefault().getDDRoot(ddFo);
                if (webApp != null && (urlPattern = this.findUrlPattern(webApp, this.service.getImplementationClass())) != null) {
                    return URLEncoder.encode(urlPattern, "UTF-8");
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return URLEncoder.encode(this.getNameFromPackageName(this.service.getImplementationClass()), "UTF-8");
    }

    private String findUrlPattern(Endpoints endpoints, String implementationClass) {
        Endpoint[] endp = endpoints.getEndpoints();
        for (int i = 0; i < endp.length; ++i) {
            String urlPattern;
            if (!implementationClass.equals(endp[i].getImplementation()) || (urlPattern = endp[i].getUrlPattern()) == null) continue;
            return urlPattern.startsWith("/") ? urlPattern.substring(1) : urlPattern;
        }
        return null;
    }

    private String findUrlPattern(WebApp webApp, String implementationClass) {
        for (Servlet servlet : webApp.getServlet()) {
            String servletName;
            if (!implementationClass.equals(servlet.getServletClass()) || (servletName = servlet.getServletName()) == null) continue;
            for (ServletMapping servletMapping : webApp.getServletMapping()) {
                if (!servletName.equals(servletMapping.getServletName())) continue;
                String urlPattern = ((ServletMapping25)servletMapping).getUrlPatterns()[0];
                return urlPattern.startsWith("/") ? urlPattern.substring(1) : urlPattern;
            }
        }
        return null;
    }

    private void resolveServiceInfo(final ServiceInfo serviceInfo, final boolean inEjbProject) throws UnsupportedEncodingException {
        final String[] serviceName = new String[1];
        final String[] name = new String[1];
        final boolean[] isProvider = new boolean[]{false};
        serviceInfo.setEjb(inEjbProject);
        JavaSource javaSource = this.getImplBeanJavaSource();
        if (javaSource != null) {
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    if (typeElement == null) {
                        return;
                    }
                    boolean foundWsAnnotation = JaxWsNode.this.resolveServiceUrl(controller, typeElement, serviceName, name);
                    if (!foundWsAnnotation) {
                        isProvider[0] = JaxWsUtils.hasAnnotation(typeElement, "javax.xml.ws.WebServiceProvider");
                    }
                    if (!inEjbProject) {
                        serviceInfo.setEjb(JaxWsNode.this.isStatelessEjb(typeElement));
                    }
                }

                public void cancel() {
                }
            };
            try {
                javaSource.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        String qualifiedImplClassName = this.service.getImplementationClass();
        String implClassName = this.getNameFromPackageName(qualifiedImplClassName);
        if (serviceName[0] == null) {
            serviceName[0] = URLEncoder.encode(implClassName + "Service", "UTF-8");
        }
        serviceInfo.setServiceName(serviceName[0]);
        if (name[0] == null) {
            name[0] = isProvider[0] ? qualifiedImplClassName : implClassName;
            name[0] = URLEncoder.encode(name[0], "UTF-8");
        }
        serviceInfo.setPortName(name[0]);
    }

    private boolean resolveServiceUrl(CompilationController controller, TypeElement targetElement, String[] serviceName, String[] name) throws IOException {
        boolean foundWsAnnotation = false;
        List<? extends AnnotationMirror> annotations = targetElement.getAnnotationMirrors();
        block0: for (AnnotationMirror annotationMirror : annotations) {
            boolean isWebMethodAnnotation = JaxWsUtils.hasFqn(annotationMirror, "javax.jws.WebService");
            if (!isWebMethodAnnotation) continue;
            foundWsAnnotation = true;
            Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = annotationMirror.getElementValues();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                if (entry.getKey().getSimpleName().contentEquals("serviceName")) {
                    serviceName[0] = (String)expressions.get(entry.getKey()).getValue();
                    if (serviceName[0] != null) {
                        serviceName[0] = URLEncoder.encode(serviceName[0], "UTF-8");
                    }
                } else if (entry.getKey().getSimpleName().contentEquals("name")) {
                    name[0] = (String)expressions.get(entry.getKey()).getValue();
                    if (name[0] != null) {
                        name[0] = URLEncoder.encode(name[0], "UTF-8");
                    }
                }
                if (serviceName[0] == null || name[0] == null) continue;
                break block0;
            }
        }
        return foundWsAnnotation;
    }

    private boolean isStatelessEjb(TypeElement targetElement) {
        return JaxWsUtils.hasAnnotation(targetElement, "javax.ejb.Stateless");
    }

    private String getNameFromPackageName(String packageName) {
        int index = packageName.lastIndexOf(".");
        return index >= 0 ? packageName.substring(index + 1) : packageName;
    }

    @Override
    public String getWsdlURL() {
        String wsdlUrl = this.getWebServiceURL();
        return wsdlUrl.length() == 0 ? "" : wsdlUrl + "?wsdl";
    }

    private String getWebServiceURL() {
        ServerContextInfo serverContextInfo = this.getServerContextInfo();
        if (serverContextInfo == null) {
            return "";
        }
        String contextRoot = serverContextInfo.getContextRoot();
        return "http://" + serverContextInfo.getHost() + ":" + serverContextInfo.getPort() + "/" + this.getServiceUri(contextRoot);
    }

    public String getTesterPageURL() {
        ServerContextInfo serverContextInfo = this.getServerContextInfo();
        ServiceInfo serviceInfo = this.getServiceInfo();
        WSStackUtils stackUtils = new WSStackUtils(this.project);
        boolean isJsr109Supported = stackUtils.isJsr109Supported();
        if (isJsr109Supported && ProjectUtil.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project)) {
            JaxWs.UriDescriptor uriDescriptor;
            WSStack<JaxWs> jaxWsStack = stackUtils.getWsStack(JaxWs.class);
            if (jaxWsStack != null && (uriDescriptor = ((JaxWs)jaxWsStack.get()).getWsUriDescriptor()) != null) {
                return uriDescriptor.getTesterPageUri(serverContextInfo.getHost(), serverContextInfo.getPort(), serverContextInfo.getContextRoot(), serviceInfo.getServiceName(), serviceInfo.getPortName(), serviceInfo.isEjb());
            }
        } else if (!serviceInfo.isEjb()) {
            try {
                String serviceUri = this.getNonJsr109Uri(J2eeModule.Type.WAR);
                String contextRoot = serverContextInfo.getContextRoot();
                return "http://" + serverContextInfo.getHost() + ":" + serverContextInfo.getPort() + "/" + (contextRoot == null ? "" : contextRoot + "/") + serviceUri;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.getWebServiceURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        JAXWSSupport wss;
        String serviceName = this.service.getName();
        NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_CONFIRM_DELETE", (Object)serviceName));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
        if (notifyDesc.getValue() == NotifyDescriptor.YES_OPTION && (wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory())) != null) {
            FileObject localWsdlFolder = wss.getLocalWsdlFolderForService(serviceName, false);
            if (localWsdlFolder != null) {
                FileObject serviceWsdlFolder;
                FileLock lock = null;
                FileObject clientArtifactsFolder = localWsdlFolder.getParent();
                try {
                    lock = clientArtifactsFolder.lock();
                    clientArtifactsFolder.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
                FileObject wsdlFolder = wss.getWsdlFolder(false);
                if (wsdlFolder != null && (serviceWsdlFolder = wsdlFolder.getFileObject(serviceName)) != null) {
                    try {
                        lock = serviceWsdlFolder.lock();
                        serviceWsdlFolder.delete(lock);
                    }
                    finally {
                        if (lock != null) {
                            lock.releaseLock();
                        }
                    }
                }
                FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("build.xml");
                try {
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-service-clean-" + serviceName}, null);
                    wsimportTask.waitFinished();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
                catch (IllegalArgumentException ex) {
                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                }
            }
            wss.removeService(serviceName);
            Boolean isJsr109 = this.jaxWsModel.getJsr109();
            if (isJsr109 != null && !isJsr109.booleanValue()) {
                if (this.service.getWsdlUrl() != null) {
                    serviceName = this.service.getServiceName();
                }
                wss.removeNonJsr109Entries(serviceName);
            }
            super.destroy();
        }
    }

    private FileObject getImplBean() {
        String implBean = this.service.getImplementationClass();
        if (implBean != null) {
            return this.srcRoot.getFileObject(implBean.replace('.', '/') + ".java");
        }
        return null;
    }

    private JavaSource getImplBeanJavaSource() {
        FileObject implBean = this.getImplBean();
        if (implBean != null) {
            return JavaSource.forFileObject((FileObject)implBean);
        }
        return null;
    }

    public Object getValue(String attributeName) {
        Object retValue = attributeName.equals("customDelete") ? Boolean.TRUE : super.getValue(attributeName);
        return retValue;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void configureHandler() {
        boolean[] isNew;
        HandlerChains handlerChains;
        FileObject handlerFO;
        ArrayList<String> handlerClasses;
        FileObject implBeanFo;
        block11: {
            implBeanFo = this.getImplBean();
            if (implBeanFo == null) {
                NotifyDescriptor.Message dialogDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingImplementationClass"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
                return;
            }
            handlerClasses = new ArrayList<String>();
            handlerFO = null;
            handlerChains = null;
            Object[] handlerFileName = new String[1];
            isNew = new boolean[]{true};
            JavaSource implBeanJavaSrc = JavaSource.forFileObject((FileObject)implBeanFo);
            CancellableTask<CompilationController> task = new CancellableTask<CompilationController>(){
                final /* synthetic */ String[] val$handlerFileName;
                {
                    this.val$handlerFileName = stringArray;
                }

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)controller);
                    AnnotationMirror handlerAnnotation = JaxWsUtils.getAnnotation(typeElement, "javax.jws.HandlerChain");
                    if (handlerAnnotation != null) {
                        isNew[0] = false;
                        Map<? extends ExecutableElement, ? extends AnnotationValue> expressions = handlerAnnotation.getElementValues();
                        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : expressions.entrySet()) {
                            ExecutableElement ex = entry.getKey();
                            if (!ex.getSimpleName().contentEquals("file")) continue;
                            this.val$handlerFileName[0] = (String)entry.getValue().getValue();
                            break;
                        }
                    }
                }

                public void cancel() {
                }
            };
            try {
                implBeanJavaSrc.runUserActionTask((Task)task, true);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (!isNew[0] && handlerFileName[0] != null) {
                try {
                    FileObject parent = implBeanFo.getParent();
                    File parentFile = FileUtil.toFile((FileObject)parent);
                    File file = new File(parentFile, handlerFileName[0]);
                    if (file.exists()) {
                        file = file.getCanonicalFile();
                        handlerFO = FileUtil.toFileObject((File)file);
                    }
                    if (handlerFO != null) {
                        try {
                            handlerChains = HandlerChainsProvider.getDefault().getHandlerChains(handlerFO);
                        }
                        catch (Exception e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                            return;
                        }
                        HandlerChain[] handlerChainArray = handlerChains.getHandlerChains();
                        HandlerChain chain = handlerChainArray[0];
                        Handler[] handlers = chain.getHandlers();
                        for (int i = 0; i < handlers.length; ++i) {
                            handlerClasses.add(handlers[i].getHandlerClass());
                        }
                        break block11;
                    }
                    NotifyDescriptor.Message dialogDesc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsNode.class, (String)"MSG_HANDLER_FILE_NOT_FOUND", (Object[])handlerFileName), 1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        }
        MessageHandlerPanel panel = new MessageHandlerPanel(this.project, handlerClasses, true, this.service.getName());
        String title = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)panel, title);
        dialogDesc.setButtonListener((ActionListener)new HandlerButtonListener(panel, handlerChains, handlerFO, implBeanFo, this.service, isNew[0]));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
    }

    void refreshImplClass() {
        if (this.implBeanClass != null) {
            this.content.remove((Object)this.implBeanClass);
        }
        this.implBeanClass = this.getImplBean();
        this.content.add((Object)this.implBeanClass);
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable clipboardCopy() throws IOException {
        URL url;
        block9: {
            url = new URL(this.getWsdlURL());
            boolean connectionOK = false;
            try {
                URLConnection connection = url.openConnection();
                if (!(connection instanceof HttpURLConnection)) break block9;
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                try {
                    httpConnection.setRequestMethod("GET");
                    httpConnection.connect();
                    if (200 == httpConnection.getResponseCode()) {
                        connectionOK = true;
                    }
                }
                catch (ConnectException ex) {
                    url = null;
                }
                finally {
                    httpConnection.disconnect();
                }
                if (!connectionOK) {
                    url = null;
                }
            }
            catch (IOException ex) {
                url = null;
            }
        }
        return new WebServiceTransferable(new WebServiceReference(url, this.service.getWsdlUrl() != null ? this.service.getServiceName() : this.service.getName(), this.project.getProjectDirectory().getName()));
    }

    private String getPortNumber(InstanceProperties instanceProperties) {
        String portNumber = instanceProperties.getProperty("httpportnumber");
        if (portNumber == null || portNumber.equals("")) {
            String serverURL = instanceProperties.getProperty("url");
            if (serverURL == null) {
                return "8080";
            }
            String port = this.parseServerURL(serverURL);
            return port == null ? "8080" : port;
        }
        return portNumber;
    }

    private String parseServerURL(String serverURL) {
        String s;
        int index2;
        int index1 = serverURL.indexOf("http://");
        if (index1 >= 0 && (index2 = (s = serverURL.substring(index1 + 7)).indexOf(":")) > 0 && (s = s.substring(index2 + 1)).length() > 0) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (Character.isDigit(s.charAt(i)) && i < s.length()) {
                buf.append(s.charAt(i++));
            }
            if (buf.length() > 0) {
                return buf.toString();
            }
        }
        return null;
    }

    private String getHostName(InstanceProperties instanceProperties) {
        String serverUrl = instanceProperties.getProperty("url");
        String hostName = "localhost";
        if (serverUrl != null && serverUrl.indexOf("::") > 0) {
            int index1 = serverUrl.indexOf("::");
            int index2 = serverUrl.lastIndexOf(":");
            if (index2 > index1 + 2) {
                hostName = serverUrl.substring(index1 + 2, index2);
            }
        }
        return hostName;
    }

    private class RefreshServiceImpl
    implements JaxWsRefreshCookie {
        private RefreshServiceImpl() {
        }

        public void refreshService(boolean downloadWsdl) {
            if (downloadWsdl) {
                String result = RefreshWsDialog.open(downloadWsdl, JaxWsNode.this.service.getImplementationClass(), JaxWsNode.this.service.getWsdlUrl());
                if ("0".equals(result)) {
                    return;
                }
                if (result.startsWith("4")) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(true, true, result.substring(1));
                } else if (result.startsWith("2")) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(true, false, result.substring(1));
                } else if ("3".equals(result)) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, true, null);
                } else {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, false, null);
                }
            } else {
                String result = RefreshWsDialog.openWithOKButtonOnly(downloadWsdl, JaxWsNode.this.service.getImplementationClass(), JaxWsNode.this.service.getWsdlUrl());
                if ("3".equals(result)) {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, true, null);
                } else {
                    ((JaxWsChildren)JaxWsNode.this.getChildren()).refreshKeys(false, false, null);
                }
            }
        }
    }

    private static class ServerContextInfo {
        private String host;
        private String port;
        private String contextRoot;

        public ServerContextInfo(String host, String port, String contextRoot) {
            this.host = host;
            this.port = port;
            this.contextRoot = contextRoot;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getContextRoot() {
            return this.contextRoot;
        }
    }

    private static class ServiceInfo {
        private String serviceName;
        private String portName;
        private boolean ejb;

        private ServiceInfo() {
        }

        public void setEjb(boolean ejb) {
            this.ejb = ejb;
        }

        public void setPortName(String portName) {
            this.portName = portName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public boolean isEjb() {
            return this.ejb;
        }

        public String getPortName() {
            return this.portName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }
}

