/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.execute;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.gradle.api.execute.GradleExecConfiguration;
import org.netbeans.modules.gradle.execute.GradleExecAccessor;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ConfigPersistenceUtils {
    public static final String CONFIG_NAMESPACE = "http://www.netbeans.org/ns/gradle-config/data/1";
    private static final String CONFIG_ELEMENT_CONFIGURATIONS = "configurations";
    private static final String CONFIG_ELEMENT_CONFIGURATION = "configuration";
    private static final String CONFIG_ATTRIBUTE_ACTIVE = "active";
    public static final String CONFIG_ELEMENT_ARGS = "args";
    public static final String CONFIG_ELEMENT_PROPERTY = "property";
    public static final String CONFIG_ATTRIBUTE_ID = "id";
    public static final String CONFIG_ATTRIBUTE_NAME = "name";
    public static final String CONFIG_ATTRIBUTE_DISPLAY = "displayName";

    public static void writeConfigurations(List<GradleExecConfiguration> configs, AuxiliaryConfiguration aux, String configId, boolean shared) {
        ConfigPersistenceUtils.writeConfigurations0(configs, aux, configId, shared);
    }

    static Element writeConfigurations0(List<GradleExecConfiguration> configs, AuxiliaryConfiguration aux, String configId, boolean shared) {
        boolean defConfig;
        Element el = aux.getConfigurationFragment(CONFIG_ELEMENT_CONFIGURATIONS, CONFIG_NAMESPACE, shared);
        boolean bl = defConfig = shared || null == configId || "%%DEFAULT%%".equals(configId);
        if (el == null) {
            if (configs.isEmpty() && defConfig) {
                return null;
            }
            el = XMLUtil.createDocument((String)CONFIG_ELEMENT_CONFIGURATIONS, (String)CONFIG_NAMESPACE, null, null).getDocumentElement();
            if (!defConfig) {
                el.setAttribute(CONFIG_ATTRIBUTE_ACTIVE, configId);
            }
        } else if (configs.isEmpty() && defConfig) {
            aux.removeConfigurationFragment(CONFIG_ELEMENT_CONFIGURATIONS, CONFIG_NAMESPACE, shared);
            return null;
        }
        NodeList list = el.getElementsByTagNameNS(CONFIG_NAMESPACE, CONFIG_ELEMENT_CONFIGURATION);
        for (int i = 0; i < list.getLength(); ++i) {
            el.removeChild(list.item(i));
        }
        for (GradleExecConfiguration cfg : configs) {
            String args;
            Map<String, String> projectProps;
            Element child = el.getOwnerDocument().createElementNS(CONFIG_NAMESPACE, CONFIG_ELEMENT_CONFIGURATION);
            el.appendChild(child);
            child.setAttribute(CONFIG_ATTRIBUTE_ID, cfg.getId());
            if (cfg.getName() != null) {
                child.setAttribute(CONFIG_ATTRIBUTE_DISPLAY, cfg.getName());
            }
            if ((projectProps = cfg.getProjectProperties()) != null && !projectProps.isEmpty()) {
                for (Map.Entry<String, String> it : projectProps.entrySet()) {
                    String s = it.getKey();
                    if (s == null || s.trim().isEmpty()) continue;
                    String k = s.trim();
                    String v = it.getValue();
                    if (v == null) {
                        v = "";
                    }
                    Element prop = el.getOwnerDocument().createElementNS(CONFIG_NAMESPACE, CONFIG_ELEMENT_PROPERTY);
                    prop.setAttribute(CONFIG_ATTRIBUTE_NAME, k);
                    prop.setTextContent(v);
                    child.appendChild(prop);
                }
            }
            if ((args = cfg.getCommandLineArgs()) == null || args.trim().isEmpty()) continue;
            Element argsEl = el.getOwnerDocument().createElementNS(CONFIG_NAMESPACE, CONFIG_ELEMENT_ARGS);
            argsEl.setTextContent(args.trim());
            child.appendChild(argsEl);
        }
        aux.putConfigurationFragment(el, shared);
        return null;
    }

    public static Map<String, GradleExecConfiguration> readConfigurations(Map<String, GradleExecConfiguration> result, AuxiliaryConfiguration aux, boolean shared) {
        Element el = aux.getConfigurationFragment(CONFIG_ELEMENT_CONFIGURATIONS, CONFIG_NAMESPACE, shared);
        if (el != null) {
            NodeList nl = el.getElementsByTagNameNS(CONFIG_NAMESPACE, CONFIG_ELEMENT_CONFIGURATION);
            for (int i = 0; i < nl.getLength(); ++i) {
                Element c = (Element)nl.item(i);
                String id = c.getAttribute(CONFIG_ATTRIBUTE_ID);
                if (id == null) continue;
                String dispString = c.getAttribute(CONFIG_ATTRIBUTE_DISPLAY);
                LinkedHashMap<String, String> projectProps = new LinkedHashMap<String, String>();
                String cmdArgs = null;
                NodeList props = c.getElementsByTagNameNS(CONFIG_NAMESPACE, CONFIG_ELEMENT_PROPERTY);
                for (int pi = 0; pi < props.getLength(); ++pi) {
                    Element p = (Element)props.item(pi);
                    String n = p.getAttribute(CONFIG_ATTRIBUTE_NAME);
                    String v = p.getTextContent();
                    if (n == null || n.isEmpty()) continue;
                    if (v == null) {
                        v = "";
                    }
                    projectProps.put(n, v);
                }
                Element argsEl = XMLUtil.findElement((Element)c, (String)CONFIG_ELEMENT_ARGS, (String)CONFIG_NAMESPACE);
                if (argsEl != null) {
                    cmdArgs = argsEl.getTextContent();
                }
                result.put(id, GradleExecAccessor.instance().create(id, dispString, projectProps, cmdArgs));
            }
        }
        return result;
    }

    public static void writeActiveConfiguration(AuxiliaryConfiguration aux, String s, boolean emptyConfigs) {
        Element el = aux.getConfigurationFragment(CONFIG_ELEMENT_CONFIGURATIONS, CONFIG_NAMESPACE, false);
        if (s == null || "%%DEFAULT%%".equals(s)) {
            if (el != null && emptyConfigs) {
                aux.removeConfigurationFragment(CONFIG_ELEMENT_CONFIGURATIONS, CONFIG_NAMESPACE, false);
                return;
            }
            el.removeAttribute(CONFIG_ATTRIBUTE_ACTIVE);
        } else {
            if (el == null) {
                el = XMLUtil.createDocument((String)CONFIG_ELEMENT_CONFIGURATIONS, (String)CONFIG_NAMESPACE, null, null).getDocumentElement();
            }
            el.setAttribute(CONFIG_ATTRIBUTE_ACTIVE, s);
        }
        aux.putConfigurationFragment(el, false);
    }

    public static String readActiveConfiguration(AuxiliaryConfiguration aux) {
        Element el = aux.getConfigurationFragment(CONFIG_ELEMENT_CONFIGURATIONS, CONFIG_NAMESPACE, false);
        if (el == null) {
            return "%%DEFAULT%%";
        }
        String c = el.getAttribute(CONFIG_ATTRIBUTE_ACTIVE);
        return c == null ? "%%DEFAULT%%" : c;
    }
}

