/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.util;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.input.MouseRobotDriver;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.DefaultVisualizer;

public class MouseVisualizer
extends DefaultVisualizer {
    private static final long BEFORE_CLICK = 100L;
    public static int TOP = 0;
    public static int BOTTOM = 1;
    public static int LEFT = 2;
    public static int RIGHT = 3;
    private int place = 0;
    private double pointLocation = 0.0;
    private int depth = 0;

    public MouseVisualizer() {
    }

    public MouseVisualizer(int place, double pointLocation, int depth, boolean checkMouse) {
        this.place = place;
        this.pointLocation = pointLocation;
        this.depth = depth;
    }

    @Override
    protected boolean isWindowActive(WindowOperator winOper) {
        return super.isWindowActive(winOper) && (winOper.getSource() instanceof Frame || winOper.getSource() instanceof Dialog);
    }

    @Override
    protected void makeWindowActive(WindowOperator winOper) {
        JemmyProperties.getCurrentTimeouts().create("MouseVisualiser.BeforeClickTimeout").sleep();
        super.makeWindowActive(winOper);
        if (!System.getProperty("java.version").startsWith("1.2")) {
            Point p = this.getClickPoint(winOper);
            new MouseRobotDriver(winOper.getTimeouts().create("EventDispatcher.RobotAutoDelay")).clickMouse(winOper, p.x, p.y, 1, winOper.getDefaultMouseButton(), 0, winOper.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
        }
    }

    private Point getClickPoint(WindowOperator win) {
        int x;
        int y;
        if (this.place == LEFT || this.place == RIGHT) {
            y = (int)((double)win.getHeight() * this.pointLocation - 1.0);
            x = this.place == RIGHT ? win.getWidth() - 1 - this.depth : this.depth;
        } else {
            x = (int)((double)win.getWidth() * this.pointLocation - 1.0);
            y = this.place == BOTTOM ? win.getHeight() - 1 - this.depth : this.depth;
        }
        if (x < 0) {
            x = 0;
        }
        if (x >= win.getWidth()) {
            x = win.getWidth() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= win.getHeight()) {
            y = win.getHeight() - 1;
        }
        return new Point(x, y);
    }

    static {
        Timeouts.initDefault("MouseVisualiser.BeforeClickTimeout", 100L);
    }
}

