/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.EventQueue;
import java.io.File;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.diff.Bundle;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.diff.DiffCurrentToTrackedAction;
import org.netbeans.modules.git.ui.fetch.FetchUtils;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;

public class DiffCurrentToRepositoryAction
extends GitAction {
    @Override
    protected boolean enableFull(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        return GitUtils.getRepositoryRoots(context).size() == 1;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = this.getCurrentContext(nodes);
        this.diffToRepositoryHead(context);
    }

    public void diffToRepositoryHead(final VCSContext context) {
        if (GitUtils.getRepositoryRoots(context).size() == 1) {
            final File repository = GitUtils.getRootFile(context);
            new GitProgressSupport(){

                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(repository);
                    GitBranch branch = info.getActiveBranch();
                    try {
                        final Revision fetchedHead = FetchUtils.fetchToTemp(this.getClient(), this.getProgressMonitor(), branch);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (fetchedHead == null) {
                                    ((DiffCurrentToTrackedAction)SystemAction.get(DiffCurrentToTrackedAction.class)).diffToTracked(context);
                                    return;
                                }
                                ((DiffAction)SystemAction.get(DiffAction.class)).diff(context, new Revision.BranchReference(Bundle.CTL_RemoteRepository_HEAD(fetchedHead.getRevision()), fetchedHead.getCommitId()), Revision.HEAD);
                            }
                        });
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                        return;
                    }
                }
            }.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.LBL_DiffCurrentToRepositoryAction_progress());
        }
    }
}

