/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.spring.api.beans.model.FileSpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ConfigModelSpringBeans
implements SpringBeans {
    private final Map<File, SpringBeanSource> file2BeanSource;

    public ConfigModelSpringBeans(Map<File, SpringBeanSource> file2BeanSource) {
        this.file2BeanSource = file2BeanSource;
    }

    @Override
    public SpringBean findBean(String name) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        return this.findBean(name, new HashSet<String>());
    }

    private SpringBean findBean(String name, Set<String> visitedNames) {
        if (visitedNames.contains(name)) {
            return null;
        }
        for (SpringBeanSource beanSource : this.file2BeanSource.values()) {
            SpringBean bean = beanSource.findBean(name);
            if (bean == null) continue;
            return bean;
        }
        visitedNames.add(name);
        for (SpringBeanSource beanSource : this.file2BeanSource.values()) {
            String aliasName = beanSource.findAliasName(name);
            if (aliasName == null) continue;
            return this.findBean(aliasName, visitedNames);
        }
        return null;
    }

    @Override
    public FileSpringBeans getFileBeans(FileObject fo) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        File file = FileUtil.toFile((FileObject)fo);
        if (file != null) {
            return this.file2BeanSource.get(file);
        }
        return null;
    }

    @Override
    public List<SpringBean> getBeans() {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        ArrayList<SpringBean> result = new ArrayList<SpringBean>(this.file2BeanSource.size() * 20);
        for (SpringBeanSource beanSource : this.file2BeanSource.values()) {
            result.addAll(beanSource.getBeans());
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Set<String> getAliases() {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        HashSet<String> aliases = new HashSet<String>(this.file2BeanSource.size() * 5);
        for (SpringBeanSource beanSource : this.file2BeanSource.values()) {
            aliases.addAll(beanSource.getAliases());
        }
        return Collections.unmodifiableSet(aliases);
    }
}

