/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.java.JavaUtils;

public class JavaPackageCompletor
extends Completor {
    private static final Set<ClassIndex.SearchScope> ALL = EnumSet.allOf(ClassIndex.SearchScope.class);
    private static final Set<ClassIndex.SearchScope> LOCAL = EnumSet.of(ClassIndex.SearchScope.SOURCE);

    public JavaPackageCompletor(int invocationOffset) {
        super(invocationOffset);
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        int idx = context.getCurrentTokenOffset() + 1;
        String typedChars = context.getTypedPrefix();
        if (typedChars.contains(".") || typedChars.equals("")) {
            int dotIndex = typedChars.lastIndexOf(".");
            idx += dotIndex + 1;
        }
        return idx;
    }

    @Override
    protected void compute(CompletionContext context) throws IOException {
        String typedChars = context.getTypedPrefix();
        JavaSource js = JavaUtils.getJavaSource(context.getFileObject());
        if (js == null) {
            return;
        }
        this.doPackageCompletion(js, typedChars, context.getCurrentTokenOffset() + 1);
    }

    private void doPackageCompletion(JavaSource js, final String typedPrefix, final int substitutionOffset) throws IOException {
        js.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController cc) throws Exception {
                if (JavaPackageCompletor.this.isCancelled()) {
                    return;
                }
                cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassIndex ci = cc.getClasspathInfo().getClassIndex();
                int index = substitutionOffset;
                int dotIndex = typedPrefix.lastIndexOf(46);
                if (dotIndex != -1) {
                    index += dotIndex + 1;
                }
                JavaPackageCompletor.this.addPackages(ci, typedPrefix, index, 9);
            }
        }, true);
    }

    private void addPackages(ClassIndex ci, String typedPrefix, int substitutionOffset, int queryType) {
        Set<ClassIndex.SearchScope> scope = queryType == 9 ? ALL : LOCAL;
        Set packages = ci.getPackageNames(typedPrefix, true, scope);
        for (String pkg : packages) {
            if (pkg.length() <= 0) continue;
            SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createPackageItem(substitutionOffset, pkg, false);
            this.addCacheItem(item);
        }
    }
}

