/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TargetModuleConverter
extends DOMConvertor {
    private static final String PUBLIC_ID = "-//org_netbeans_modules_j2ee//DTD TargetModule 1.0//EN";
    private static final String SYSTEM_ID = "nbres:/org/netbeans/modules/j2ee/deployment/impl/target-module.dtd";
    private static final String E_TARGET_MODULE_LIST = "target-module-list";
    private static final String E_TARGET_MODULE = "target-module";
    private static final String A_ID = "id";
    private static final String A_INSTANCE_URL = "instance-url";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TIMESTAMP = "timestamp";
    private static final String A_CONTENT_DIR = "content-dir";
    private static final String A_CONTEXT_ROOT = "context-root";
    private static final String CHARSET = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(TargetModuleConverter.class.getName());
    private static final String DIR_TARGETMODULES = "TargetModules";
    private static FileObject targetModulesDir = null;

    public static DOMConvertor create() {
        return new TargetModuleConverter();
    }

    protected TargetModuleConverter() {
        super(PUBLIC_ID, SYSTEM_ID, E_TARGET_MODULE_LIST);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        NodeList targetModuleElements = element.getElementsByTagName(E_TARGET_MODULE);
        TargetModule[] targetModules = new TargetModule[targetModuleElements.getLength()];
        for (int i = 0; i < targetModules.length; ++i) {
            Element te = (Element)targetModuleElements.item(i);
            String id = te.getAttribute(A_ID);
            String url = te.getAttribute(A_INSTANCE_URL);
            String targetName = te.getAttribute(A_TARGET_NAME);
            String timestamp = te.getAttribute(A_TIMESTAMP);
            String contentDir = te.getAttribute(A_CONTENT_DIR);
            String contextRoot = te.getAttribute(A_CONTEXT_ROOT);
            if (id == null || url == null || targetName == null) {
                throw new IOException(NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_TargetModuleParseError"));
            }
            try {
                targetModules[i] = new TargetModule(id, url, targetName, Long.parseLong(timestamp), contentDir, contextRoot);
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new IOException(nfe);
            }
        }
        return new TargetModule.List(targetModules);
    }

    protected void writeElement(Document doc, Element element, Object obj) throws IOException, DOMException {
        if (obj == null) {
            return;
        }
        if (!(obj instanceof TargetModule.List)) {
            throw new DOMException(9, NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_NotSupportedObject", obj.getClass()));
        }
        TargetModule.List tmList = (TargetModule.List)obj;
        TargetModule[] targetModules = tmList.getTargetModules();
        for (int i = 0; i < targetModules.length; ++i) {
            Element tmElement = doc.createElement(E_TARGET_MODULE);
            tmElement.setAttribute(A_ID, targetModules[i].getId());
            tmElement.setAttribute(A_INSTANCE_URL, targetModules[i].getInstanceUrl());
            tmElement.setAttribute(A_TARGET_NAME, targetModules[i].getTargetName());
            tmElement.setAttribute(A_TIMESTAMP, String.valueOf(targetModules[i].getTimestamp()));
            tmElement.setAttribute(A_CONTENT_DIR, targetModules[i].getContentDirectory());
            tmElement.setAttribute(A_CONTEXT_ROOT, targetModules[i].getContextRoot());
            element.appendChild(tmElement);
        }
    }

    public void registerSaver(Object inst, Saver s) {
    }

    public void unregisterSaver(Object inst, Saver s) {
    }

    private static FileObject getTargetModulesDir() throws IOException {
        FileObject j2eeDir;
        assert (Thread.holdsLock(TargetModuleConverter.class));
        if (targetModulesDir == null && (targetModulesDir = (j2eeDir = FileUtil.getConfigFile((String)"J2EE")).getFileObject(DIR_TARGETMODULES)) == null) {
            targetModulesDir = j2eeDir.createFolder(DIR_TARGETMODULES);
        }
        return targetModulesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean writeTargetModule(TargetModule instance, String managerDir, String targetDir, String tmFileName) {
        try {
            FileObject targetDirFO;
            FileObject managerDirFO = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (managerDirFO == null) {
                managerDirFO = TargetModuleConverter.getTargetModulesDir().createFolder(managerDir);
            }
            if ((targetDirFO = managerDirFO.getFileObject(targetDir)) == null) {
                targetDirFO = managerDirFO.createFolder(targetDir);
            }
            FileObject fo = FileUtil.createData((FileObject)targetDirFO, (String)tmFileName);
            FileLock lock = fo.lock();
            try (OutputStreamWriter writer = new OutputStreamWriter(fo.getOutputStream(lock), CHARSET);){
                TargetModuleConverter.create().write((Writer)writer, (Object)new TargetModule.List(instance));
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            return true;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public static synchronized TargetModule readTargetModule(String managerDir, String targetDir, String tmFileName) {
        try {
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir == null) return null;
            if ((dir = dir.getFileObject(targetDir)) == null) return null;
            FileObject fo = dir.getFileObject(tmFileName);
            if (fo == null) return null;
            try (InputStreamReader reader = new InputStreamReader(fo.getInputStream(), CHARSET);){
                TargetModule.List tml = (TargetModule.List)TargetModuleConverter.create().read((Reader)reader);
                if (tml == null || tml.getTargetModules().length < 1) {
                    TargetModule targetModule = null;
                    return targetModule;
                }
                TargetModule targetModule = tml.getTargetModules()[0];
                return targetModule;
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Could not read {0}", tmFileName);
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static synchronized List<TargetModule> getTargetModulesByContextRoot(String managerDir, String targetDir, String contextRoot) {
        try {
            FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
            if (dir != null && (dir = dir.getFileObject(targetDir)) != null) {
                Enumeration fos = dir.getChildren(false);
                ArrayList<TargetModule> result = new ArrayList<TargetModule>();
                while (fos.hasMoreElements()) {
                    FileObject fo = (FileObject)fos.nextElement();
                    AtomicInteger exceptions = new AtomicInteger();
                    try (InputStreamReader reader = new InputStreamReader(fo.getInputStream(), CHARSET);){
                        TargetModule tm;
                        TargetModule.List tml = (TargetModule.List)TargetModuleConverter.create().read((Reader)reader);
                        if (tml == null || tml.getTargetModules().length <= 0 || !contextRoot.equals((tm = tml.getTargetModules()[0]).getContextRoot())) continue;
                        result.add(tm);
                    }
                    catch (IOException ioe) {
                        if (exceptions.getAndIncrement() < 1) {
                            LOGGER.log(Level.WARNING, fo.getName(), ioe);
                            continue;
                        }
                        LOGGER.log(Level.INFO, fo.getName(), ioe);
                    }
                }
                return result;
            }
            return Collections.emptyList();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return Collections.emptyList();
        }
        catch (ClassNotFoundException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void remove(String managerDir, String targetDir, String tmFileName) {
        block6: {
            try {
                FileObject fo;
                FileObject dir = TargetModuleConverter.getTargetModulesDir().getFileObject(managerDir);
                if (dir == null || (dir = dir.getFileObject(targetDir)) == null || (fo = dir.getFileObject(tmFileName)) == null) break block6;
                FileLock lock = fo.lock();
                try {
                    fo.delete(lock);
                }
                finally {
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
    }
}

