/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

final class JspELEmbeddingProvider
extends EmbeddingProvider {
    private static final String ATTRIBUTE_EL_MARKER = "A";

    JspELEmbeddingProvider() {
    }

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        TokenHierarchy th = snapshot.getTokenHierarchy();
        TokenSequence sequence = th.tokenSequence(JspTokenId.language());
        ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
        sequence.moveStart();
        boolean inAttributeValueWithEL = false;
        while (sequence.moveNext()) {
            Token t = sequence.token();
            if (t.id() == JspTokenId.ATTR_VALUE && t.length() == 1 && (t.text().charAt(0) == '\"' || t.text().charAt(0) == '\'')) {
                boolean bl = inAttributeValueWithEL = !inAttributeValueWithEL;
            }
            if (t.id() != JspTokenId.EL) continue;
            embeddings.add(snapshot.create(sequence.offset(), t.length(), "text/x-el"));
            if (inAttributeValueWithEL) {
                embeddings.add(snapshot.create((CharSequence)ATTRIBUTE_EL_MARKER, "text/x-el"));
            }
            embeddings.add(snapshot.create((CharSequence)"@@@", "text/x-el"));
        }
        if (embeddings.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Embedding.create(embeddings));
    }

    public int getPriority() {
        return 100;
    }

    public void cancel() {
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<SchedulerTask> create(Snapshot snapshot) {
            return Arrays.asList(new SchedulerTask[]{new JspELEmbeddingProvider()});
        }
    }
}

