/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.impl.facesmodel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class JSFConfigModelUtilities {
    private static final Logger LOGGER = Logger.getLogger(JSFConfigModelUtilities.class.getName());

    private JSFConfigModelUtilities() {
    }

    public static void saveChanges(DocumentModel<?> model) throws IOException {
        if (model.isIntransaction()) {
            try {
                model.endTransaction();
            }
            catch (IllegalStateException ex) {
                IOException io = new IOException("Cannot save faces config", ex);
                throw (IOException)Exceptions.attachLocalizedMessage((Throwable)io, (String)NbBundle.getMessage(JSFConfigModelUtilities.class, (String)"ERR_Save_FacesConfig", (Object)Exceptions.findLocalizedMessage((Throwable)ex)));
            }
        }
        model.sync();
        DataObject dobj = (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        if (dobj == null) {
            FileObject fParentFo;
            final Document doc = (Document)model.getModelSource().getLookup().lookup(Document.class);
            final File file = (File)model.getModelSource().getLookup().lookup(File.class);
            LOGGER.log(Level.FINE, "saving changes in {0}", file);
            File parent = file.getParentFile();
            FileObject parentFo = FileUtil.toFileObject((File)parent);
            if (parentFo == null) {
                parent.mkdirs();
                FileUtil.refreshFor((File[])new File[]{parent});
                parentFo = FileUtil.toFileObject((File)parent);
            }
            if ((fParentFo = parentFo) != null) {
                FileSystem fs = parentFo.getFileSystem();
                fs.runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() throws IOException {
                        String text;
                        try {
                            text = doc.getText(0, doc.getLength());
                        }
                        catch (BadLocationException x) {
                            throw new IOException(x);
                        }
                        FileObject fo = fParentFo.getFileObject(file.getName());
                        if (fo == null) {
                            fo = fParentFo.createData(file.getName());
                        }
                        try (OutputStream os = fo.getOutputStream();){
                            os.write(text.getBytes(FileEncodingQuery.getEncoding((FileObject)fo)));
                        }
                    }
                });
            }
        } else {
            SaveCookie save = (SaveCookie)dobj.getLookup().lookup(SaveCookie.class);
            if (save != null) {
                LOGGER.log(Level.FINE, "saving changes in {0}", dobj);
                save.save();
            } else {
                LOGGER.log(Level.FINE, "no changes in {0}", dobj);
            }
        }
    }

    public static boolean doInTransaction(JSFConfigModel model, Runnable job) {
        model.startTransaction();
        try {
            job.run();
        }
        finally {
            try {
                model.endTransaction();
            }
            catch (IllegalStateException ex) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JSFConfigModelUtilities.class, (String)"ERR_UpdateFacesConfigModel", (Object)Exceptions.findLocalizedMessage((Throwable)ex)));
                return false;
            }
        }
        return true;
    }
}

