/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.modules.php.editor.codegen.DatabaseURL;
import org.netbeans.modules.php.editor.codegen.InvocationContextResolver;
import org.netbeans.modules.php.editor.sql.DatabaseConnectionSupport;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConnectionGenerator
implements CodeGenerator {
    private static final String TEMPLATE_TEXT = "$$${CONN newVarName default=\"conn\"} = mysqli_connect(${PARAMETERS});\nif (!$$${CONN}) {\n    die('Could not connect to MySQL: ' . mysqli_connect_error());\n}\nmysqli_query($$${CONN}, 'SET NAMES \\'utf8\\'');\n${cursor}// TODO: insert your code here.\nmysqli_close($$${CONN});";
    private final JTextComponent component;

    public ConnectionGenerator(JTextComponent component) {
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ConnectionGenerator.class, (String)"LBL_ConnectionToDatabase");
    }

    public void invoke() {
        DatabaseConnection dbconn = DatabaseConnectionSupport.selectDatabaseConnection(true, true);
        if (dbconn != null && dbconn.getPassword() == null) {
            dbconn = null;
        }
        if (dbconn == null) {
            return;
        }
        String url = dbconn.getDatabaseURL();
        DatabaseURL parsed = DatabaseURL.detect(url);
        if (parsed == null || parsed.getServer() != DatabaseURL.Server.MYSQL) {
            return;
        }
        String host = parsed.getHost();
        String port = parsed.getPort();
        String database = parsed.getDatabase();
        String user = dbconn.getUser();
        String password = dbconn.getPassword();
        StringBuilder parameters = new StringBuilder();
        ConnectionGenerator.appendParameter(parameters, host);
        parameters.append(", ");
        ConnectionGenerator.appendParameter(parameters, user);
        parameters.append(", ");
        ConnectionGenerator.appendParameter(parameters, password);
        if (database != null) {
            parameters.append(", ");
            ConnectionGenerator.appendParameter(parameters, database);
        }
        if (port != null) {
            parameters.append(", ");
            ConnectionGenerator.appendParameter(parameters, port);
        }
        String text = TEMPLATE_TEXT.replace("${PARAMETERS}", parameters);
        CodeTemplateManager manager = CodeTemplateManager.get((Document)this.component.getDocument());
        CodeTemplate template = manager.createTemporary(text);
        template.insert(this.component);
    }

    private static void appendParameter(StringBuilder builder, String value) {
        builder.append('\'').append(value).append('\'');
    }

    public static final class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            List<Object> retval = Collections.emptyList();
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            InvocationContextResolver invocationContextResolver = InvocationContextResolver.create(component);
            if (!invocationContextResolver.isExactlyIn(InvocationContextResolver.InvocationContext.CLASS) && !invocationContextResolver.isExactlyIn(InvocationContextResolver.InvocationContext.EMPTY_STATEMENT)) {
                retval = Collections.singletonList(new ConnectionGenerator(component));
            }
            return retval;
        }
    }
}

