/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.micronaut.hints.Bundle;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class AddArgForRouteVar
implements ErrorRule<String> {
    private static Pattern PATTERN = Pattern.compile("The route declares a uri variable named \\[(\\S*)\\]");

    public Set<String> getCodes() {
        return Collections.singleton("compiler.err.proc.messager");
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<String> data) {
        Matcher matcher = PATTERN.matcher((CharSequence)data.getData());
        if (matcher.find() && matcher.groupCount() == 1) {
            return Collections.singletonList(new AddArgForRouteVarFix(compilationInfo, offset, matcher.group(1)).toEditorFix());
        }
        return Collections.emptyList();
    }

    public String getId() {
        return AddArgForRouteVar.class.getName();
    }

    public String getDisplayName() {
        return Bundle.LBL_AddPathVarParam();
    }

    public void cancel() {
    }

    private static class AddArgForRouteVarFix
    extends JavaFix {
        private final String name;

        private AddArgForRouteVarFix(CompilationInfo info, int offset, String name) {
            super(info, info.getTreeUtilities().pathFor(offset));
            this.name = name;
        }

        protected String getText() {
            return Bundle.LBL_FIX_AddPathVarParam(this.name);
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy working = ctx.getWorkingCopy();
            TreeMaker make = working.getTreeMaker();
            TreePath tp = ctx.getPath();
            if (tp.getLeaf().getKind() == Tree.Kind.METHOD) {
                MethodTree targetTree = (MethodTree)tp.getLeaf();
                int index = targetTree.getParameters().size();
                Element el = working.getTrees().getElement(tp);
                if (el != null && el.getKind() == ElementKind.METHOD) {
                    ExecutableElement ee = (ExecutableElement)el;
                    if (ee.isVarArgs()) {
                        index = ee.getParameters().size() - 1;
                    }
                    MethodTree result = make.insertMethodParameter(targetTree, index, make.Variable(make.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)this.name, (Tree)make.QualIdent("java.lang.String"), null));
                    working.rewrite((Tree)targetTree, (Tree)result);
                }
            }
        }
    }
}

