/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToRelativeTemporalObjectNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getRelativeToNode;
    @Node.Child
    private PropertyGetNode getOffsetNode;
    @Node.Child
    private PropertyGetNode getTimeZoneNode;
    @Node.Child
    private GetMethodNode getGetOffsetNanosecondsFor;
    @Node.Child
    private GetMethodNode getGetPossibleInstantsFor;

    protected ToRelativeTemporalObjectNode() {
        JSContext ctx = JavaScriptLanguage.get(null).getJSContext();
        this.getRelativeToNode = PropertyGetNode.create(TemporalConstants.RELATIVE_TO, ctx);
        this.getOffsetNode = PropertyGetNode.create(TemporalConstants.OFFSET, ctx);
        this.getTimeZoneNode = PropertyGetNode.create(TemporalConstants.TIME_ZONE, ctx);
        this.getGetOffsetNanosecondsFor = GetMethodNode.create(ctx, TemporalUtil.GET_OFFSET_NANOSECONDS_FOR);
        this.getGetPossibleInstantsFor = GetMethodNode.create(ctx, TemporalUtil.GET_POSSIBLE_INSTANTS_FOR);
    }

    public abstract Result execute(JSDynamicObject var1);

    @Specialization
    protected Result toRelativeTemporalObject(JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile valueIsObject, @Cached InlinedConditionProfile valueIsUndefined, @Cached InlinedBranchProfile valueIsPlainDate, @Cached InlinedBranchProfile valueIsZonedDateTime, @Cached InlinedConditionProfile valueIsPlainDateTime, @Cached InlinedConditionProfile timeZoneAvailable, @Cached JSToStringNode toStringNode, @Cached IsObjectNode isObjectNode, @Cached ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached ToTemporalTimeZoneNode toTemporalTimeZoneNode, @Cached GetTemporalCalendarWithISODefaultNode getTemporalCalendarWithISODefaultNode, @Cached TemporalGetOptionNode getOptionNode) {
        Object offset;
        JSTemporalDateTimeRecord result;
        JSDynamicObject calendar;
        Object value = this.getRelativeToNode.getValue((Object)options);
        if (valueIsUndefined.profile((Node)this, value == Undefined.instance)) {
            return ToRelativeTemporalObjectNode.none();
        }
        JSDynamicObject timeZone = Undefined.instance;
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        if (value instanceof JSTemporalPlainDateObject) {
            JSTemporalPlainDateObject plainDate = (JSTemporalPlainDateObject)((Object)value);
            valueIsPlainDate.enter((Node)this);
            return ToRelativeTemporalObjectNode.plainDate(plainDate);
        }
        if (value instanceof JSTemporalZonedDateTimeObject) {
            JSTemporalZonedDateTimeObject zonedDateTime = (JSTemporalZonedDateTimeObject)((Object)value);
            valueIsZonedDateTime.enter((Node)this);
            return ToRelativeTemporalObjectNode.zonedDateTime(zonedDateTime, this.createTimeZoneMethodsRecord(zonedDateTime.getTimeZone()));
        }
        if (valueIsObject.profile((Node)this, isObjectNode.executeBoolean(value) && value instanceof JSObject)) {
            JSObject valueObj = (JSObject)((Object)value);
            if (valueIsPlainDateTime.profile((Node)this, valueObj instanceof JSTemporalPlainDateTimeObject)) {
                JSTemporalPlainDateTimeObject pd = (JSTemporalPlainDateTimeObject)valueObj;
                return ToRelativeTemporalObjectNode.plainDate(JSTemporalPlainDate.create(ctx, realm, pd.getYear(), pd.getMonth(), pd.getDay(), pd.getCalendar(), this, errorBranch));
            }
            calendar = getTemporalCalendarWithISODefaultNode.execute((Object)valueObj);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDHMMMMMNSY);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, valueObj, fieldNames, TemporalUtil.listEmpty);
            JSObject dateOptions = JSOrdinary.createWithNullPrototype(ctx);
            JSObjectUtil.putDataProperty(dateOptions, TemporalConstants.OVERFLOW, TemporalConstants.CONSTRAIN);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, dateOptions, getOptionNode, dateFromFieldsNode);
            offset = this.getOffsetNode.getValue((Object)valueObj);
            Object timeZoneTemp = this.getTimeZoneNode.getValue((Object)valueObj);
            if (timeZoneTemp != Undefined.instance) {
                timeZone = toTemporalTimeZoneNode.execute(timeZoneTemp);
            }
            if (offset == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            }
        } else {
            TruffleString string = toStringNode.executeString(value);
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalRelativeToString(string);
            result = resultZDT;
            calendar = toTemporalCalendarWithISODefaultNode.execute(result.getCalendar());
            offset = resultZDT.getTimeZoneResult().getOffsetString();
            TruffleString timeZoneName = resultZDT.getTimeZoneResult().getName();
            if (timeZoneName != null) {
                if (!TemporalUtil.isValidTimeZoneName(timeZoneName)) {
                    errorBranch.enter((Node)this);
                    throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
                }
                timeZoneName = TemporalUtil.canonicalizeTimeZoneName(timeZoneName);
                timeZone = TemporalUtil.createTemporalTimeZone(ctx, realm, timeZoneName);
            }
            offsetBehaviour = resultZDT.getTimeZoneResult().isZ() ? TemporalUtil.OffsetBehaviour.EXACT : TemporalUtil.OffsetBehaviour.WALL;
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
        }
        assert (timeZone != null);
        if (timeZoneAvailable.profile((Node)this, timeZone != Undefined.instance)) {
            TimeZoneMethodsRecord timeZoneRec = this.createTimeZoneMethodsRecord(timeZone);
            Object offsetNs = 0;
            offsetNs = offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION ? Long.valueOf(TemporalUtil.parseTimeZoneOffsetString(toStringNode.executeString(offset))) : Undefined.instance;
            BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNs, timeZoneRec, TemporalUtil.Disambiguation.COMPATIBLE, TemporalUtil.OffsetOption.REJECT, matchBehaviour);
            return ToRelativeTemporalObjectNode.zonedDateTime(JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar), timeZoneRec);
        }
        return ToRelativeTemporalObjectNode.plainDate(JSTemporalPlainDate.create(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), calendar, this, errorBranch));
    }

    private static Result none() {
        return new Result(null, null, null, null);
    }

    private static Result plainDate(JSTemporalPlainDateObject plainDate) {
        return new Result(plainDate, null, null, plainDate.getCalendar());
    }

    private static Result zonedDateTime(JSTemporalZonedDateTimeObject zonedDateTime, TimeZoneMethodsRecord timeZoneRec) {
        return new Result(null, zonedDateTime, timeZoneRec, zonedDateTime.getCalendar());
    }

    private TimeZoneMethodsRecord createTimeZoneMethodsRecord(JSDynamicObject timeZone) {
        return new TimeZoneMethodsRecord(timeZone, this.getGetOffsetNanosecondsFor.executeWithTarget((Object)timeZone), this.getGetPossibleInstantsFor.executeWithTarget((Object)timeZone));
    }

    public record Result(JSTemporalPlainDateObject plainRelativeTo, JSTemporalZonedDateTimeObject zonedRelativeTo, TimeZoneMethodsRecord timeZoneRec, JSDynamicObject calendar) {
        public JSTemporalCalendarHolder relativeTo() {
            return this.plainRelativeTo != null ? this.plainRelativeTo : this.zonedRelativeTo;
        }

        public CalendarMethodsRecord createCalendarMethodsRecord(GetMethodNode dateAddNode) {
            if (this.calendar == null) {
                return null;
            }
            Object dateAdd = dateAddNode.executeWithTarget((Object)this.calendar);
            return CalendarMethodsRecord.forDateAdd(this.calendar, dateAdd);
        }

        public CalendarMethodsRecord createCalendarMethodsRecord(GetMethodNode dateAddNode, GetMethodNode dateUntilNode) {
            if (this.calendar == null) {
                return null;
            }
            Object dateAdd = dateAddNode.executeWithTarget((Object)this.calendar);
            Object dateUntil = dateUntilNode.executeWithTarget((Object)this.calendar);
            return CalendarMethodsRecord.forDateAddDateUntil(this.calendar, dateAdd, dateUntil);
        }
    }
}

