/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.platforms.android;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cordova.platforms.android.AVD;
import org.netbeans.modules.cordova.platforms.android.AndroidPlatform;
import org.netbeans.modules.cordova.platforms.android.Browser;
import org.netbeans.modules.cordova.platforms.android.Bundle;
import org.netbeans.modules.cordova.platforms.api.ClientProjectUtilities;
import org.netbeans.modules.cordova.platforms.spi.Device;
import org.netbeans.modules.cordova.platforms.spi.PropertyProvider;
import org.netbeans.modules.web.clientproject.spi.platform.ProjectConfigurationCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AndroidConfigurationPanel
extends JPanel {
    private PropertyProvider config;
    final RequestProcessor RP = new RequestProcessor(AndroidConfigurationPanel.class);
    private JComboBox avdCombo;
    private JLabel avdLabel;
    private JComboBox browserCombo;
    private JCheckBox debuggerCheckBox;
    private JComboBox deviceCombo;
    private JLabel deviceLabel;
    private JLabel jLabel1;
    private JButton manageButton;

    private void initControls() {
        this.initComponents();
        String device = this.config.getProperty("device");
        if ("device".equals(device)) {
            this.deviceCombo.setSelectedIndex("device".equals(device) ? 1 : 0);
        }
        this.setAVDComboVisible(!"device".equals(device));
        this.debuggerCheckBox.setVisible(false);
        this.deviceLabel.setVisible(false);
        this.deviceCombo.setVisible(false);
        String property = this.config.getProperty("browser");
        if (property != null && property.equals(Browser.CHROME.getName())) {
            this.browserCombo.setSelectedIndex(1);
        }
        this.validate();
    }

    public AndroidConfigurationPanel(PropertyProvider config) {
        assert (config != null);
        this.config = config;
        if (!AndroidPlatform.getDefault().isReady()) {
            this.setLayout(new BorderLayout());
            this.add((Component)ClientProjectUtilities.createMobilePlatformsSetupPanel(), "Center");
            this.validate();
            AndroidPlatform.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (AndroidPlatform.getDefault().isReady()) {
                        AndroidConfigurationPanel.this.removeAll();
                        AndroidConfigurationPanel.this.initControls();
                        AndroidConfigurationPanel.this.validate();
                    }
                }
            });
        } else {
            this.initControls();
        }
    }

    private void setAVDComboVisible(boolean visible) {
        if (visible) {
            this.avdCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{Bundle.LBL_PleaseWait()}));
            this.avdCombo.setEnabled(false);
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Collection<Device> avDs = AndroidPlatform.getDefault().getVirtualDevices();
                        AndroidConfigurationPanel.this.refreshCombo(avDs);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
        this.avdLabel.setVisible(visible);
        this.avdCombo.setVisible(visible);
        this.manageButton.setVisible(visible);
    }

    private void refreshCombo(final Collection<? extends Device> avDs) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AndroidConfigurationPanel.this.avdCombo.setEnabled(true);
                AndroidConfigurationPanel.this.avdCombo.setRenderer(new DeviceRenderer());
                AVD[] avds = avDs.toArray(new AVD[0]);
                AndroidConfigurationPanel.this.avdCombo.setModel(new DefaultComboBoxModel<AVD>(avds));
                for (AVD avd : avds) {
                    if (!avd.getName().equals(AndroidConfigurationPanel.this.config.getProperty("device"))) continue;
                    AndroidConfigurationPanel.this.avdCombo.setSelectedItem(avd);
                    break;
                }
            }
        });
    }

    private void initComponents() {
        this.deviceLabel = new JLabel();
        this.manageButton = new JButton();
        this.deviceCombo = new JComboBox();
        this.avdCombo = new JComboBox();
        this.avdLabel = new JLabel();
        this.debuggerCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.browserCombo = new JComboBox();
        this.deviceLabel.setLabelFor(this.deviceCombo);
        Mnemonics.setLocalizedText((JLabel)this.deviceLabel, (String)NbBundle.getMessage(AndroidConfigurationPanel.class, (String)"AndroidConfigurationPanel.deviceLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(AndroidConfigurationPanel.class, (String)"AndroidConfigurationPanel.manageButton.text"));
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndroidConfigurationPanel.this.manageButtonActionPerformed(evt);
            }
        });
        this.deviceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.LBL_AndroidEmulator(), Bundle.LBL_AndroidConnectedDevice()}));
        this.deviceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndroidConfigurationPanel.this.deviceComboActionPerformed(evt);
            }
        });
        this.avdCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.LBL_PleaseWait()}));
        this.avdCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndroidConfigurationPanel.this.avdComboActionPerformed(evt);
            }
        });
        this.avdLabel.setLabelFor(this.avdCombo);
        Mnemonics.setLocalizedText((JLabel)this.avdLabel, (String)NbBundle.getMessage(AndroidConfigurationPanel.class, (String)"AndroidConfigurationPanel.avdLabel.text"));
        this.debuggerCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.debuggerCheckBox, (String)NbBundle.getMessage(AndroidConfigurationPanel.class, (String)"AndroidConfigurationPanel.debuggerCheckBox.text"));
        this.debuggerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndroidConfigurationPanel.this.debuggerCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AndroidConfigurationPanel.class, (String)"AndroidConfigurationPanel.jLabel1.text"));
        this.browserCombo.setModel(new DefaultComboBoxModel<String>(new String[]{Bundle.LBL_DefaultBrowser(), Bundle.LBL_Chrome()}));
        this.browserCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AndroidConfigurationPanel.this.browserComboActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.debuggerCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deviceLabel).addComponent(this.avdLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.deviceCombo, 0, 174, Short.MAX_VALUE).addComponent(this.avdCombo, 0, -1, Short.MAX_VALUE).addComponent(this.browserCombo, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manageButton))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.deviceLabel).addComponent(this.deviceCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.avdCombo, -2, -1, -2).addComponent(this.manageButton).addComponent(this.avdLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.browserCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggerCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void manageButtonActionPerformed(ActionEvent evt) {
        this.manageButton.setEnabled(false);
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                AndroidPlatform.getDefault().manageDevices();
                try {
                    Collection<Device> avDs = AndroidPlatform.getDefault().getVirtualDevices();
                    AndroidConfigurationPanel.this.refreshCombo(avDs);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AndroidConfigurationPanel.this.manageButton.setEnabled(true);
                    }
                });
            }
        });
    }

    private void avdComboActionPerformed(ActionEvent evt) {
        this.config.putProperty("avd", ((AVD)this.avdCombo.getSelectedItem()).getName());
    }

    private void deviceComboActionPerformed(ActionEvent evt) {
        if (this.deviceCombo.getSelectedIndex() == 0) {
            this.config.putProperty("device", "emulator");
            this.setAVDComboVisible(true);
        } else {
            this.config.putProperty("device", "device");
            this.setAVDComboVisible(false);
        }
    }

    private void debuggerCheckBoxActionPerformed(ActionEvent evt) {
        this.config.putProperty("debug.enabled", Boolean.toString(this.debuggerCheckBox.isSelected()));
    }

    private void browserComboActionPerformed(ActionEvent evt) {
        this.config.putProperty("browser", this.browserCombo.getSelectedIndex() == 0 ? Browser.DEFAULT.getName() : Browser.CHROME.getName());
    }

    private static class DeviceRenderer
    extends DefaultListCellRenderer {
        private DeviceRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof AVD) {
                this.setText(((AVD)value).getName());
            }
            return this;
        }
    }

    public static class AndroidConfigurationCustomizer
    implements ProjectConfigurationCustomizer {
        private final Project p;
        private final PropertyProvider config;

        public AndroidConfigurationCustomizer(Project p, PropertyProvider config) {
            this.p = p;
            this.config = config;
        }

        public JPanel createPanel() {
            return new AndroidConfigurationPanel(this.config);
        }

        public EnumSet<ProjectConfigurationCustomizer.HiddenProperties> getHiddenProperties() {
            return EnumSet.of(ProjectConfigurationCustomizer.HiddenProperties.WEB_SERVER);
        }
    }
}

