/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.sun.dd.api.ASDDVersion;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.VersionNotSupportedException;
import org.netbeans.modules.j2ee.sun.dd.api.common.LoginConfig;
import org.netbeans.modules.j2ee.sun.dd.api.common.MessageSecurityBinding;
import org.netbeans.modules.j2ee.sun.dd.api.common.WebserviceEndpoint;
import org.netbeans.modules.j2ee.sun.ddloaders.SunDescriptorDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.BaseSectionNodeInnerPanel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.DDTextFieldEditorModel;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.MappingComboBoxHelper;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.webservice.EndpointNode;
import org.netbeans.modules.j2ee.sun.share.configbean.Utils;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.common.TextMapping;
import org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.EditBindingMultiview;
import org.netbeans.modules.xml.multiview.ItemCheckBoxHelper;
import org.netbeans.modules.xml.multiview.ItemEditorHelper;
import org.netbeans.modules.xml.multiview.Refreshable;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class EndpointPanel
extends BaseSectionNodeInnerPanel {
    private static final int SECURITY_NONE = 0;
    private static final int SECURITY_AUTHENTICATION = 1;
    private static final int SECURITY_MESSAGE = 2;
    private final ResourceBundle webserviceBundle = NbBundle.getBundle((String)"org.netbeans.modules.j2ee.sun.share.configbean.customizers.webservice.Bundle");
    private final TextMapping[] authMethodTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("BASIC", this.webserviceBundle.getString("AUTHORIZATION_Basic")), new TextMapping("CLIENT-CERT", this.webserviceBundle.getString("AUTHORIZATION_ClientCert"))};
    private final TextMapping[] transportTypes = new TextMapping[]{new TextMapping("", ""), new TextMapping("NONE", this.webserviceBundle.getString("TRANSPORT_None")), new TextMapping("INTEGRAL", this.webserviceBundle.getString("TRANSPORT_Integral")), new TextMapping("CONFIDENTIAL", this.webserviceBundle.getString("TRANSPORT_Confidential"))};
    private EndpointNode endpointNode;
    private boolean isWebApp;
    private WebserviceEndpoint endpoint;
    private LoginConfig savedLoginConfig;
    private MessageSecurityBinding savedMessageBinding;
    private DefaultComboBoxModel authMethodModel;
    private DefaultComboBoxModel transportGuaranteeModel;
    private boolean setup;
    private XmlMultiViewDataSynchronizer synchronizer;
    private ButtonGroup bgSecurity;
    private JButton jBtnEditBindings;
    private JComboBox jCbxAuthentication;
    private JComboBox jCbxTransportGuarantee;
    private JCheckBox jChkDebugEnabled;
    private JCheckBox jChkEnableMsgSecurity;
    private JLabel jLblAuthentication;
    private JLabel jLblDebugEnabled;
    private JLabel jLblEnableMsgSecurity;
    private JLabel jLblEndpointAddressURI;
    private JLabel jLblName;
    private JLabel jLblRealm;
    private JLabel jLblSecuritySettings;
    private JLabel jLblTransportGuarantee;
    private JRadioButton jRBnLoginConfig;
    private JRadioButton jRBnMessageSecurity;
    private JRadioButton jRBnNoSecurity;
    private JTextField jTxtEndpointAddressURI;
    private JTextField jTxtName;
    private JTextField jTxtRealm;

    public EndpointPanel(SectionNodeView sectionNodeView, EndpointNode endpointNode, ASDDVersion version) {
        super(sectionNodeView, version);
        this.endpointNode = endpointNode;
        this.setup = true;
        this.endpoint = (WebserviceEndpoint)endpointNode.getBinding().getSunBean();
        this.initComponents();
        this.initUserComponents(sectionNodeView);
    }

    private void initUserComponents(SectionNodeView sectionNodeView) {
        int i;
        SunDescriptorDataObject dataObject = (SunDescriptorDataObject)sectionNodeView.getDataObject();
        this.synchronizer = dataObject.getModelSynchronizer();
        this.isWebApp = J2eeModule.Type.WAR.equals(dataObject.getModuleType());
        this.authMethodModel = new DefaultComboBoxModel();
        for (i = 0; i < this.authMethodTypes.length; ++i) {
            this.authMethodModel.addElement(this.authMethodTypes[i]);
        }
        this.jCbxAuthentication.setModel(this.authMethodModel);
        this.transportGuaranteeModel = new DefaultComboBoxModel();
        for (i = 0; i < this.transportTypes.length; ++i) {
            this.transportGuaranteeModel.addElement(this.transportTypes[i]);
        }
        this.jCbxTransportGuarantee.setModel(this.transportGuaranteeModel);
        this.handleUIVisibility();
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.jTxtName, (ItemEditorHelper.ItemEditorModel)new EndpointTextFieldEditorModel(this.synchronizer, "PortComponentName")));
        this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.jTxtEndpointAddressURI, (ItemEditorHelper.ItemEditorModel)new EndpointTextFieldEditorModel(this.synchronizer, "EndpointAddressUri")));
        if (!this.isWebApp) {
            this.addRefreshable(new AuthMethodComboBoxHelper(this.synchronizer, this.jCbxAuthentication));
            if (this.as90FeaturesVisible) {
                this.addRefreshable((Refreshable)new ItemEditorHelper((JTextComponent)this.jTxtRealm, (ItemEditorHelper.ItemEditorModel)new RealmTextFieldEditorModel(this.synchronizer)));
            }
        }
        this.addRefreshable(new TransportComboBoxHelper(this.synchronizer, this.jCbxTransportGuarantee));
        if (this.as90FeaturesVisible) {
            this.addRefreshable((Refreshable)new DebugEnabledCheckboxHelper(this.synchronizer, this.jChkDebugEnabled));
        }
        this.jTxtName.setEditable(!this.endpointNode.getBinding().isBound());
    }

    public void handleUIVisibility() {
        this.handleAS90FieldVisibility(this.as90FeaturesVisible);
        this.showSecurityUI(this.isWebApp, !this.isWebApp);
        if (this.as90FeaturesVisible) {
            boolean debugEnabled;
            try {
                debugEnabled = Utils.booleanValueOf(this.endpoint.getDebuggingEnabled());
            }
            catch (VersionNotSupportedException ex) {
                debugEnabled = false;
            }
            this.jChkDebugEnabled.setSelected(debugEnabled);
        }
        boolean authenticationEnabled = false;
        boolean messageSecurityEnabled = false;
        this.savedLoginConfig = this.endpoint.getLoginConfig();
        if (this.savedLoginConfig != null) {
            authenticationEnabled = true;
        } else {
            this.savedLoginConfig = this.endpoint.newLoginConfig();
        }
        try {
            this.savedMessageBinding = this.endpoint.getMessageSecurityBinding();
            if (this.savedMessageBinding != null) {
                messageSecurityEnabled = true;
            } else {
                this.savedMessageBinding = this.endpoint.newMessageSecurityBinding();
            }
        }
        catch (VersionNotSupportedException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.savedMessageBinding = null;
        }
        if (this.isWebApp) {
            this.jChkEnableMsgSecurity.setSelected(messageSecurityEnabled);
            this.enableMessageSecurityUI(messageSecurityEnabled);
        } else if (!this.isWebApp) {
            if (messageSecurityEnabled) {
                this.jRBnMessageSecurity.setSelected(true);
                this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
                this.jTxtRealm.setText("");
            } else if (authenticationEnabled) {
                this.jRBnLoginConfig.setSelected(true);
                String authMethod = this.savedLoginConfig.getAuthMethod();
                this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(authMethod));
                if (this.as90FeaturesVisible) {
                    try {
                        String realm = this.savedLoginConfig.getRealm();
                        this.jTxtRealm.setText(realm);
                    }
                    catch (VersionNotSupportedException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
            } else {
                this.jRBnNoSecurity.setSelected(true);
                this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
                this.jTxtRealm.setText("");
            }
            this.enableMessageSecurityUI(messageSecurityEnabled);
            this.enableAuthenticationUI(authenticationEnabled);
        }
    }

    private void initComponents() {
        this.bgSecurity = new ButtonGroup();
        this.jLblName = new JLabel();
        this.jTxtName = new JTextField();
        this.jLblEndpointAddressURI = new JLabel();
        this.jTxtEndpointAddressURI = new JTextField();
        this.jLblTransportGuarantee = new JLabel();
        this.jCbxTransportGuarantee = new JComboBox();
        this.jLblDebugEnabled = new JLabel();
        this.jChkDebugEnabled = new JCheckBox();
        this.jLblSecuritySettings = new JLabel();
        this.jRBnNoSecurity = new JRadioButton();
        this.jRBnMessageSecurity = new JRadioButton();
        this.jLblEnableMsgSecurity = new JLabel();
        this.jChkEnableMsgSecurity = new JCheckBox();
        this.jBtnEditBindings = new JButton();
        this.jRBnLoginConfig = new JRadioButton();
        this.jLblRealm = new JLabel();
        this.jTxtRealm = new JTextField();
        this.jLblAuthentication = new JLabel();
        this.jCbxAuthentication = new JComboBox();
        this.setAlignmentX(0.0f);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.jLblName.setLabelFor(this.jTxtName);
        this.jLblName.setText(this.webserviceBundle.getString("LBL_PortComponentName_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add(this.jLblName, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add(this.jTxtName, gridBagConstraints);
        this.jTxtName.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_PortComponentName"));
        this.jTxtName.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_PortComponentName"));
        this.jLblEndpointAddressURI.setLabelFor(this.jTxtEndpointAddressURI);
        this.jLblEndpointAddressURI.setText(this.webserviceBundle.getString("LBL_EndpointAddressURI_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add(this.jLblEndpointAddressURI, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add(this.jTxtEndpointAddressURI, gridBagConstraints);
        this.jTxtEndpointAddressURI.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_EndpointAddressURI"));
        this.jTxtEndpointAddressURI.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_EndpointAddressURI"));
        this.jLblTransportGuarantee.setLabelFor(this.jCbxTransportGuarantee);
        this.jLblTransportGuarantee.setText(this.webserviceBundle.getString("LBL_TransportGuarantee_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add(this.jLblTransportGuarantee, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add(this.jCbxTransportGuarantee, gridBagConstraints);
        this.jCbxTransportGuarantee.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_TransportGuarantee"));
        this.jCbxTransportGuarantee.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_TransportGuarantee"));
        this.jLblDebugEnabled.setLabelFor(this.jChkDebugEnabled);
        this.jLblDebugEnabled.setText(this.webserviceBundle.getString("LBL_DebugEnabled_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add(this.jLblDebugEnabled, gridBagConstraints);
        this.jChkDebugEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.jChkDebugEnabled.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 5);
        this.add(this.jChkDebugEnabled, gridBagConstraints);
        this.jChkDebugEnabled.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_DebugEnabled"));
        this.jChkDebugEnabled.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_DebugEnabled"));
        this.jLblSecuritySettings.setText(this.webserviceBundle.getString("LBL_SecuritySettings"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 6, 0, 0);
        this.add(this.jLblSecuritySettings, gridBagConstraints);
        this.bgSecurity.add(this.jRBnNoSecurity);
        this.jRBnNoSecurity.setText(this.webserviceBundle.getString("LBL_NoSecurity"));
        this.jRBnNoSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jRBnNoSecurity.setOpaque(false);
        this.jRBnNoSecurity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndpointPanel.this.jRBnNoSecurityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 0, 0);
        this.add(this.jRBnNoSecurity, gridBagConstraints);
        this.jRBnNoSecurity.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_NoSecurity"));
        this.jRBnNoSecurity.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_NoSecurity"));
        this.bgSecurity.add(this.jRBnMessageSecurity);
        this.jRBnMessageSecurity.setText(this.webserviceBundle.getString("LBL_EnableMsgSecurity"));
        this.jRBnMessageSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jRBnMessageSecurity.setOpaque(false);
        this.jRBnMessageSecurity.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndpointPanel.this.jRBnMessageSecurityActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 5, 0);
        this.add(this.jRBnMessageSecurity, gridBagConstraints);
        this.jRBnMessageSecurity.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_MessageSecurity"));
        this.jRBnMessageSecurity.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_MessageSecurity"));
        this.jLblEnableMsgSecurity.setLabelFor(this.jChkEnableMsgSecurity);
        this.jLblEnableMsgSecurity.setText(this.webserviceBundle.getString("LBL_EnableMsgSecurity_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.add(this.jLblEnableMsgSecurity, gridBagConstraints);
        this.jChkEnableMsgSecurity.setMargin(new Insets(0, 0, 0, 0));
        this.jChkEnableMsgSecurity.setOpaque(false);
        this.jChkEnableMsgSecurity.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                EndpointPanel.this.jChkEnableMsgSecurityItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 12);
        this.add(this.jChkEnableMsgSecurity, gridBagConstraints);
        this.jChkEnableMsgSecurity.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_EnableMsgSecurity"));
        this.jChkEnableMsgSecurity.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_EnableMsgSecurity"));
        this.jBtnEditBindings.setText(this.webserviceBundle.getString("LBL_EditMsgSecBindings"));
        this.jBtnEditBindings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndpointPanel.this.jBtnEditBindingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add(this.jBtnEditBindings, gridBagConstraints);
        this.jBtnEditBindings.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_EditMsgSecBindings"));
        this.jBtnEditBindings.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_EditMsgSecBindings"));
        this.bgSecurity.add(this.jRBnLoginConfig);
        this.jRBnLoginConfig.setText(this.webserviceBundle.getString("LBL_LoginConfiguration"));
        this.jRBnLoginConfig.setMargin(new Insets(0, 0, 0, 0));
        this.jRBnLoginConfig.setOpaque(false);
        this.jRBnLoginConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndpointPanel.this.jRBnLoginConfigActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 12, 0, 0);
        this.add(this.jRBnLoginConfig, gridBagConstraints);
        this.jRBnLoginConfig.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_LoginConfiguration"));
        this.jRBnLoginConfig.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_LoginConfiguration"));
        this.jLblRealm.setLabelFor(this.jTxtRealm);
        this.jLblRealm.setText(this.webserviceBundle.getString("LBL_Realm_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 6, 0, 0);
        this.add(this.jLblRealm, gridBagConstraints);
        this.jTxtRealm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                EndpointPanel.this.jTxtRealmKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 6, 0, 5);
        this.add(this.jTxtRealm, gridBagConstraints);
        this.jTxtRealm.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_Realm"));
        this.jTxtRealm.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_Realm"));
        this.jLblAuthentication.setLabelFor(this.jCbxAuthentication);
        this.jLblAuthentication.setText(this.webserviceBundle.getString("LBL_AuthenticationMethod_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 5, 0);
        this.add(this.jLblAuthentication, gridBagConstraints);
        this.jCbxAuthentication.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndpointPanel.this.jCbxAuthenticationActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 5, 5);
        this.add(this.jCbxAuthentication, gridBagConstraints);
        this.jCbxAuthentication.getAccessibleContext().setAccessibleName(this.webserviceBundle.getString("ACSN_AuthenticationMethod"));
        this.jCbxAuthentication.getAccessibleContext().setAccessibleDescription(this.webserviceBundle.getString("ACSD_AuthenticationMethod"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jRBnLoginConfigActionPerformed(ActionEvent evt) {
        if (!this.setup) {
            try {
                this.startUIChange();
                this.endpoint.setLoginConfig((LoginConfig)this.savedLoginConfig.clone());
                String authMethod = this.savedLoginConfig.getAuthMethod();
                this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(authMethod));
                if (this.as90FeaturesVisible) {
                    try {
                        String realm = this.savedLoginConfig.getRealm();
                        this.jTxtRealm.setText(realm);
                    }
                    catch (VersionNotSupportedException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                this.enableMessageSecurityUI(false);
                this.enableAuthenticationUI(true);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
        }
    }

    private void jRBnMessageSecurityActionPerformed(ActionEvent evt) {
        if (!this.setup) {
            try {
                this.startUIChange();
                try {
                    this.endpoint.setMessageSecurityBinding((MessageSecurityBinding)this.savedMessageBinding.clone());
                }
                catch (VersionNotSupportedException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
                this.jTxtRealm.setText("");
                this.enableMessageSecurityUI(true);
                this.enableAuthenticationUI(false);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
        }
    }

    private void jRBnNoSecurityActionPerformed(ActionEvent evt) {
        if (!this.setup) {
            try {
                this.startUIChange();
                this.endpoint.setLoginConfig(null);
                try {
                    this.endpoint.setMessageSecurityBinding(null);
                }
                catch (VersionNotSupportedException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                this.jCbxAuthentication.setSelectedItem(this.getAuthorizationMethodMapping(""));
                this.jTxtRealm.setText("");
                this.enableMessageSecurityUI(false);
                this.enableAuthenticationUI(false);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jTxtRealmKeyReleased(KeyEvent evt) {
        block8: {
            if (!this.setup && this.jRBnLoginConfig.isSelected() && this.jRBnLoginConfig.isVisible()) {
                String newRealm = this.jTxtRealm.getText();
                if (newRealm != null) {
                    newRealm = newRealm.trim();
                }
                try {
                    String oldRealm = this.savedLoginConfig.getRealm();
                    if (Utils.strEquivalent(newRealm, oldRealm)) break block8;
                    try {
                        this.startUIChange();
                        this.savedLoginConfig.setRealm(newRealm);
                        LoginConfig lc = this.endpoint.getLoginConfig();
                        if (lc != null) {
                            lc.setRealm(newRealm);
                        }
                    }
                    finally {
                        this.endUIChange();
                        this.synchronizer.requestUpdateData();
                    }
                }
                catch (VersionNotSupportedException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jCbxAuthenticationActionPerformed(ActionEvent evt) {
        if (!this.setup && this.jRBnLoginConfig.isSelected() && this.jRBnLoginConfig.isVisible()) {
            TextMapping authMapping = (TextMapping)this.authMethodModel.getSelectedItem();
            String oldAuthMethod = this.savedLoginConfig.getAuthMethod();
            String newAuthMethod = authMapping.getXMLString();
            if (!Utils.strEquals(newAuthMethod, oldAuthMethod)) {
                try {
                    this.startUIChange();
                    this.savedLoginConfig.setAuthMethod(newAuthMethod);
                    LoginConfig lc = this.endpoint.getLoginConfig();
                    if (lc != null) {
                        lc.setAuthMethod(newAuthMethod);
                    }
                }
                finally {
                    this.endUIChange();
                    this.synchronizer.requestUpdateData();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jChkEnableMsgSecurityItemStateChanged(ItemEvent evt) {
        if (!this.setup) {
            boolean hasMessageSecurity = Utils.interpretCheckboxState(evt);
            try {
                this.startUIChange();
                MessageSecurityBinding newBinding = null;
                if (hasMessageSecurity) {
                    if (this.savedMessageBinding != null) {
                        newBinding = (MessageSecurityBinding)this.savedMessageBinding.clone();
                        this.endpoint.setMessageSecurityBinding(newBinding);
                    }
                } else {
                    this.savedMessageBinding = this.endpoint.getMessageSecurityBinding();
                    this.endpoint.setMessageSecurityBinding(null);
                }
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
            this.enableMessageSecurityUI(hasMessageSecurity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jBtnEditBindingsActionPerformed(ActionEvent evt) {
        if (!this.setup) {
            try {
                this.startUIChange();
                String asCloneVersion = this.isWebApp ? this.version.getWebAppVersionAsString() : this.version.getEjbJarVersionAsString();
                MessageSecurityBinding binding = this.endpoint.getMessageSecurityBinding();
                if (binding == null) {
                    binding = this.endpoint.newMessageSecurityBinding();
                    this.endpoint.setMessageSecurityBinding(binding);
                }
                EditBindingMultiview.editMessageSecurityBinding((JPanel)((Object)this), false, binding, this.version, asCloneVersion);
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                this.endUIChange();
                this.synchronizer.requestUpdateData();
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        this.setup = false;
    }

    private void handleAS90FieldVisibility(boolean visible) {
        this.jLblDebugEnabled.setVisible(visible);
        this.jChkDebugEnabled.setVisible(visible);
    }

    private void showSecurityUI(boolean showForWebApp, boolean showForEjbJar) {
        this.jLblEnableMsgSecurity.setVisible(showForWebApp);
        this.jChkEnableMsgSecurity.setVisible(showForWebApp);
        this.jLblSecuritySettings.setVisible(showForEjbJar);
        this.jRBnNoSecurity.setVisible(showForEjbJar);
        this.jRBnMessageSecurity.setVisible(showForEjbJar);
        this.jRBnLoginConfig.setVisible(showForEjbJar);
        this.jLblRealm.setVisible(showForEjbJar && this.as90FeaturesVisible);
        this.jTxtRealm.setVisible(showForEjbJar && this.as90FeaturesVisible);
        this.jLblAuthentication.setVisible(showForEjbJar);
        this.jCbxAuthentication.setVisible(showForEjbJar);
        this.jBtnEditBindings.setVisible(showForWebApp || showForEjbJar);
    }

    private void enableMessageSecurityUI(boolean enable) {
        this.jBtnEditBindings.setEnabled(enable);
    }

    private void enableAuthenticationUI(boolean enable) {
        this.jLblRealm.setEnabled(enable);
        this.jTxtRealm.setEnabled(enable);
        this.jLblAuthentication.setEnabled(enable);
        this.jCbxAuthentication.setEnabled(enable);
    }

    private TextMapping getAuthorizationMethodMapping(String xmlKey) {
        TextMapping result = this.authMethodTypes[0];
        if (xmlKey == null) {
            xmlKey = "";
        }
        for (int i = 0; i < this.authMethodTypes.length; ++i) {
            if (this.authMethodTypes[i].getXMLString().compareTo(xmlKey) != 0) continue;
            result = this.authMethodTypes[i];
            break;
        }
        return result;
    }

    private TextMapping getTransportGuaranteeMapping(String xmlKey) {
        TextMapping result = this.transportTypes[0];
        if (xmlKey == null) {
            xmlKey = "";
        }
        for (int i = 0; i < this.transportTypes.length; ++i) {
            if (this.transportTypes[i].getXMLString().compareTo(xmlKey) != 0) continue;
            result = this.transportTypes[i];
            break;
        }
        return result;
    }

    protected void endUIChange() {
        if (this.endpointNode.addVirtualBean()) {
            // empty if block
        }
        super.endUIChange();
    }

    public String getHelpId() {
        return "AS_CFG_WebserviceEndpoint";
    }

    private class EndpointTextFieldEditorModel
    extends DDTextFieldEditorModel {
        public EndpointTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName) {
            super(synchronizer, propertyName);
        }

        public EndpointTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer, String propertyName, String attributeName) {
            super(synchronizer, propertyName, attributeName);
        }

        @Override
        protected CommonDDBean getBean() {
            return EndpointPanel.this.endpointNode.getBinding().getSunBean();
        }

        @Override
        protected void setValue(String value) {
            super.setValue(value);
            if (EndpointPanel.this.endpointNode.addVirtualBean()) {
                // empty if block
            }
        }
    }

    private class AuthMethodComboBoxHelper
    extends MappingComboBoxHelper {
        public AuthMethodComboBoxHelper(XmlMultiViewDataSynchronizer synchronizer, JComboBox comboxBox) {
            super(synchronizer, comboxBox);
        }

        @Override
        public TextMapping getItemValue() {
            WebserviceEndpoint endpoint = (WebserviceEndpoint)EndpointPanel.this.endpointNode.getBinding().getSunBean();
            LoginConfig lc = endpoint.getLoginConfig();
            return EndpointPanel.this.getAuthorizationMethodMapping(lc != null ? lc.getAuthMethod() : null);
        }

        @Override
        public void setItemValue(TextMapping value) {
            String am;
            WebserviceEndpoint endpoint = (WebserviceEndpoint)EndpointPanel.this.endpointNode.getBinding().getSunBean();
            LoginConfig lc = endpoint.getLoginConfig();
            if (lc == null) {
                lc = endpoint.newLoginConfig();
                endpoint.setLoginConfig(lc);
            }
            lc.setAuthMethod(Utils.notEmpty(am = value.getXMLString()) ? am : null);
            if (EndpointPanel.this.endpointNode.addVirtualBean()) {
                // empty if block
            }
        }
    }

    private class RealmTextFieldEditorModel
    extends DDTextFieldEditorModel {
        public RealmTextFieldEditorModel(XmlMultiViewDataSynchronizer synchronizer) {
            super(synchronizer, "Realm");
        }

        @Override
        protected CommonDDBean getBean() {
            return this.getBean(false);
        }

        @Override
        protected CommonDDBean getBean(boolean create) {
            WebserviceEndpoint endpoint = (WebserviceEndpoint)EndpointPanel.this.endpointNode.getBinding().getSunBean();
            LoginConfig lc = endpoint.getLoginConfig();
            if (create && lc == null) {
                lc = endpoint.newLoginConfig();
                endpoint.setLoginConfig(lc);
            }
            return lc;
        }

        @Override
        protected void setValue(String value) {
            super.setValue(value);
            if (EndpointPanel.this.endpointNode.addVirtualBean()) {
                // empty if block
            }
        }
    }

    private class TransportComboBoxHelper
    extends MappingComboBoxHelper {
        public TransportComboBoxHelper(XmlMultiViewDataSynchronizer synchronizer, JComboBox comboxBox) {
            super(synchronizer, comboxBox);
        }

        @Override
        public TextMapping getItemValue() {
            WebserviceEndpoint endpoint = (WebserviceEndpoint)EndpointPanel.this.endpointNode.getBinding().getSunBean();
            return EndpointPanel.this.getTransportGuaranteeMapping(endpoint.getTransportGuarantee());
        }

        @Override
        public void setItemValue(TextMapping value) {
            WebserviceEndpoint endpoint = (WebserviceEndpoint)EndpointPanel.this.endpointNode.getBinding().getSunBean();
            String tg = value.getXMLString();
            endpoint.setTransportGuarantee(Utils.notEmpty(tg) ? tg : null);
            if (EndpointPanel.this.endpointNode.addVirtualBean()) {
                // empty if block
            }
        }
    }

    private class DebugEnabledCheckboxHelper
    extends ItemCheckBoxHelper {
        public DebugEnabledCheckboxHelper(XmlMultiViewDataSynchronizer synchronizer, JCheckBox component) {
            super(synchronizer, component);
        }

        public boolean getItemValue() {
            try {
                return Utils.booleanValueOf(EndpointPanel.this.endpoint.getDebuggingEnabled());
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return false;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setItemValue(boolean value) {
            try {
                String newDebugEnabled = value ? "true" : null;
                EndpointPanel.this.endpoint.setDebuggingEnabled(newDebugEnabled);
                if (!EndpointPanel.this.endpointNode.addVirtualBean()) return;
            }
            catch (VersionNotSupportedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }
}

