/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.ForeignKeyElement;
import org.netbeans.modules.dbschema.SchemaElement;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.UniqueKeyElement;
import org.netbeans.modules.j2ee.persistence.entitygenerator.CMPMappingModel;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityClass;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityMember;
import org.netbeans.modules.j2ee.persistence.entitygenerator.EntityRelation;
import org.netbeans.modules.j2ee.persistence.entitygenerator.GeneratedTables;
import org.netbeans.modules.j2ee.persistence.entitygenerator.RelationshipRole;

public class DbSchemaEjbGenerator {
    private GeneratedTables genTables;
    private Map<String, EntityClass> beans = new HashMap<String, EntityClass>();
    private List<EntityRelation> relations = new ArrayList<EntityRelation>();
    private SchemaElement schemaElement;
    private Set<String> tablesReferecedByOtherTables;
    private Set<String> primaryKeyIsForeignKeyTables;
    private final EntityRelation.CollectionType colectionType;
    private static final Logger LOGGER = Logger.getLogger(DbSchemaEjbGenerator.class.getName());
    private boolean useColumNamesInRelations = false;
    private final boolean generateUnresolvedRelationships;
    private final boolean useDefaults;

    public DbSchemaEjbGenerator(GeneratedTables genTables, SchemaElement schemaElement) {
        this(genTables, schemaElement, EntityRelation.CollectionType.COLLECTION, false, false, false);
    }

    public DbSchemaEjbGenerator(GeneratedTables genTables, SchemaElement schemaElement, EntityRelation.CollectionType collectionType, boolean useColumnNamesInRelationships, boolean useDefaults, boolean generateUnresolvedRelationships) {
        this.schemaElement = schemaElement;
        this.genTables = genTables;
        this.colectionType = collectionType;
        this.useColumNamesInRelations = useColumnNamesInRelationships;
        this.generateUnresolvedRelationships = generateUnresolvedRelationships;
        this.useDefaults = useDefaults;
        this.tablesReferecedByOtherTables = DbSchemaEjbGenerator.getTablesReferecedByOtherTables(schemaElement);
        this.primaryKeyIsForeignKeyTables = DbSchemaEjbGenerator.getTablesReferencesOtherTablesWithPrimaryKeyMatch(schemaElement);
        this.buildCMPSet();
    }

    public static Set<String> getTablesReferecedByOtherTables(SchemaElement schemaElement) {
        HashSet<String> tableNames = new HashSet<String>();
        TableElement[] allTables = schemaElement.getTables();
        for (int i = 0; i < allTables.length; ++i) {
            ForeignKeyElement[] fkElements = allTables[i].getForeignKeys();
            for (int fkix = 0; fkix < fkElements.length; ++fkix) {
                tableNames.add(fkElements[fkix].getReferencedTable().getName().getName());
            }
        }
        return tableNames;
    }

    public static Set<String> getTablesReferencesOtherTablesWithPrimaryKeyMatch(SchemaElement schemaElement) {
        HashSet<String> tableNames = new HashSet<String>();
        TableElement[] allTables = schemaElement.getTables();
        for (int i = 0; i < allTables.length; ++i) {
            TableElement table0 = allTables[i];
            UniqueKeyElement pk0 = table0.getPrimaryKey();
            if (pk0 == null) continue;
            ForeignKeyElement[] fkElements = table0.getForeignKeys();
            for (int fkix = 0; fkix < fkElements.length; ++fkix) {
                ForeignKeyElement fk = fkElements[fkix];
                TableElement table = fk.getReferencedTable();
                UniqueKeyElement pk = table.getPrimaryKey();
                if (pk == null || 1 != pk0.getColumns().length || fk.getLocalColumns().length != 1 || pk.getColumns().length != 1 || !fk.getLocalColumns()[0].equals((Object)pk0.getColumns()[0])) continue;
                tableNames.add(table0.getName().getName());
            }
        }
        return tableNames;
    }

    public static boolean isJoinTable(TableElement e, Set<String> tablesReferecedByOtherTables) {
        ForeignKeyElement[] foreignKeys = e.getForeignKeys();
        if (foreignKeys == null || foreignKeys.length != 2) {
            return false;
        }
        int foreignKeySize = foreignKeys[0].getColumns().length + foreignKeys[1].getColumns().length;
        if (foreignKeySize < e.getColumns().length) {
            return false;
        }
        String tableName = e.getName().getName();
        for (int i = 0; i < 2; ++i) {
            if (!tableName.equals(foreignKeys[i].getReferencedTable().getName().getName())) continue;
            return false;
        }
        if (DbSchemaEjbGenerator.isFkUnique(foreignKeys[0]) || DbSchemaEjbGenerator.isFkUnique(foreignKeys[1])) {
            return false;
        }
        return !tablesReferecedByOtherTables.contains(e.getName().getName());
    }

    private boolean isForeignKey(ForeignKeyElement[] fks, ColumnElement col) {
        if (fks == null) {
            return false;
        }
        for (int i = 0; i < fks.length; ++i) {
            if (fks[i].getColumn(col.getName()) == null) continue;
            return true;
        }
        return false;
    }

    public EntityClass[] getBeans() {
        return this.beans.values().toArray(new EntityClass[this.beans.size()]);
    }

    public EntityRelation[] getRelations() {
        return this.relations.toArray(new EntityRelation[0]);
    }

    private EntityClass getBean(String tableName) {
        return this.beans.get(tableName);
    }

    private EntityClass addBean(String tableName) {
        EntityClass bean = this.getBean(tableName);
        if (bean != null) {
            return bean;
        }
        bean = new EntityClass(this.genTables.getCatalog(), this.genTables.getSchema(), tableName, this.genTables.getRootFolder(tableName), this.genTables.getPackageName(tableName), this.genTables.getClassName(tableName), this.genTables.getUpdateType(tableName), this.useDefaults, this.genTables.getUniqueConstraints(tableName));
        this.beans.put(tableName, bean);
        return bean;
    }

    private void addAllTables() {
        LinkedList<TableElement> joinTables = new LinkedList<TableElement>();
        for (String tableName : this.genTables.getTableNames()) {
            TableElement tableElement = this.schemaElement.getTable(DBIdentifier.create((String)tableName));
            if (DbSchemaEjbGenerator.isJoinTable(tableElement, this.tablesReferecedByOtherTables)) {
                joinTables.add(tableElement);
                continue;
            }
            this.addBean(tableName);
        }
        for (TableElement joinTable : joinTables) {
            this.addJoinTable(joinTable);
        }
    }

    private CMPMappingModel.ColumnData[] getLocalColumnData(ForeignKeyElement key) {
        ColumnPairElement[] pkPairs = key.getColumnPairs();
        CMPMappingModel.ColumnData[] localColumns = new CMPMappingModel.ColumnData[pkPairs.length];
        for (int i = 0; i < pkPairs.length; ++i) {
            localColumns[i] = new CMPMappingModel.ColumnData(pkPairs[i].getLocalColumn().getName().getName(), pkPairs[i].getLocalColumn().isNullable());
        }
        return localColumns;
    }

    private CMPMappingModel.ColumnData[] getReferencedColumnData(ForeignKeyElement key) {
        ColumnPairElement[] pkPairs = key.getColumnPairs();
        CMPMappingModel.ColumnData[] refColumns = new CMPMappingModel.ColumnData[pkPairs.length];
        for (int i = 0; i < pkPairs.length; ++i) {
            refColumns[i] = new CMPMappingModel.ColumnData(pkPairs[i].getReferencedColumn().getName().getName(), pkPairs[i].getReferencedColumn().isNullable());
        }
        return refColumns;
    }

    private String getRoleName(ForeignKeyElement fk, String defaultName) {
        ColumnPairElement[] pkPairs = fk.getColumnPairs();
        if (pkPairs == null || pkPairs.length > 1) {
            return defaultName;
        }
        return EntityMember.makeClassName(pkPairs[0].getLocalColumn().getName().getName());
    }

    private void addJoinTable(TableElement table) {
        String roleBClassName;
        ForeignKeyElement[] foreignKeys = table.getForeignKeys();
        if (foreignKeys[0].getKeyName() != null && foreignKeys[1].getKeyName() != null && foreignKeys[0].getKeyName().compareTo(foreignKeys[1].getKeyName()) > 0) {
            ForeignKeyElement tmp = foreignKeys[0];
            foreignKeys[0] = foreignKeys[1];
            foreignKeys[1] = tmp;
        }
        String tableAName = foreignKeys[0].getReferencedTable().getName().getName();
        String tableBName = foreignKeys[1].getReferencedTable().getName().getName();
        EntityClass roleAHelper = this.getBean(tableAName);
        EntityClass roleBHelper = this.getBean(tableBName);
        String roleAClassName = roleAHelper != null ? roleAHelper.getClassName() : null;
        String string = roleBClassName = roleBHelper != null ? roleBHelper.getClassName() : null;
        if (roleAClassName == null || roleBClassName == null) {
            LOGGER.log(Level.INFO, "Skip relationships generation for \"" + table.getName().getName() + "\" join table, next referenced tables was not selected in new wizard: " + (roleAClassName == null ? tableAName : "") + (roleAClassName == null && roleBClassName == null ? ", " : "") + (roleBClassName == null ? tableBName : ""));
            return;
        }
        String roleAname = this.getRoleName(foreignKeys[0], roleAClassName);
        String roleBname = this.getRoleName(foreignKeys[1], roleBClassName);
        String roleACmr = EntityMember.makeRelationshipFieldName(roleBClassName, this.colectionType, true);
        String roleBCmr = EntityMember.makeRelationshipFieldName(roleAClassName, this.colectionType, true);
        roleACmr = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(roleAHelper), roleACmr, null);
        List roleBFieldNames = this.getFieldNames(roleBHelper);
        if (tableAName.equals(tableBName)) {
            roleBFieldNames.add(roleACmr);
        }
        roleBCmr = DbSchemaEjbGenerator.uniqueAlgorithm(roleBFieldNames, roleBCmr, null);
        RelationshipRole roleA = new RelationshipRole(roleAname, roleAHelper.getClassName(), roleACmr, true, true, false);
        roleA.setEntityPkgName(roleAHelper.getPackage());
        roleAHelper.addRole(roleA);
        RelationshipRole roleB = new RelationshipRole(roleBname, roleBHelper.getClassName(), roleBCmr, true, true, false);
        roleB.setEntityPkgName(roleBHelper.getPackage());
        roleBHelper.addRole(roleB);
        EntityRelation relation = new EntityRelation(roleA, roleB);
        this.relations.add(relation);
        relation.setRelationName(EntityMember.makeClassName(table.getName().getName()));
        roleAHelper.getCMPMapping().getJoinTableMapping().put(roleACmr, table.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinColMapA = new CMPMappingModel.JoinTableColumnMapping();
        joinColMapA.setColumns(this.getColumnData(foreignKeys[0].getColumns()));
        joinColMapA.setReferencedColumns(this.getColumnData(foreignKeys[0].getReferencedColumns()));
        joinColMapA.setInverseColumns(this.getColumnData(foreignKeys[1].getColumns()));
        joinColMapA.setReferencedInverseColumns(this.getColumnData(foreignKeys[1].getReferencedColumns()));
        roleAHelper.getCMPMapping().getJoinTableColumnMppings().put(roleACmr, joinColMapA);
        roleBHelper.getCMPMapping().getJoinTableMapping().put(roleBCmr, table.getName().getName());
        CMPMappingModel.JoinTableColumnMapping joinColMapB = new CMPMappingModel.JoinTableColumnMapping();
        joinColMapB.setColumns(this.getColumnData(foreignKeys[1].getColumns()));
        joinColMapB.setReferencedColumns(this.getColumnData(foreignKeys[1].getReferencedColumns()));
        joinColMapB.setInverseColumns(this.getColumnData(foreignKeys[0].getColumns()));
        joinColMapB.setReferencedInverseColumns(this.getColumnData(foreignKeys[0].getReferencedColumns()));
        roleBHelper.getCMPMapping().getJoinTableColumnMppings().put(roleBCmr, joinColMapB);
    }

    private CMPMappingModel.ColumnData[] getColumnData(ColumnElement[] cols) {
        CMPMappingModel.ColumnData[] columns = new CMPMappingModel.ColumnData[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            columns[i] = new CMPMappingModel.ColumnData(cols[i].getName().getName(), cols[i].isNullable());
        }
        return columns;
    }

    private static boolean containsSameColumns(ColumnElement[] fkColumns, UniqueKeyElement uk) {
        if (fkColumns.length == uk.getColumns().length) {
            for (int i = 0; i < fkColumns.length; ++i) {
                if (uk.getColumn(fkColumns[i].getName()) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean containsColumns(ColumnElement[] fkColumns, UniqueKeyElement uk) {
        if (uk == null) {
            return false;
        }
        for (int i = 0; i < fkColumns.length; ++i) {
            if (uk.getColumn(fkColumns[i].getName()) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isFkUnique(ForeignKeyElement key) {
        UniqueKeyElement[] uk = key.getDeclaringTable().getUniqueKeys();
        if (uk == null) {
            return false;
        }
        ColumnElement[] columns = key.getColumns();
        for (int uin = 0; uin < uk.length; ++uin) {
            if (!DbSchemaEjbGenerator.containsSameColumns(columns, uk[uin])) continue;
            return true;
        }
        return false;
    }

    private boolean isNullable(ForeignKeyElement key) {
        ColumnElement[] columns = key.getColumns();
        int count = columns != null ? columns.length : 0;
        for (int i = 0; i < count; ++i) {
            if (columns[i].isNullable()) continue;
            return false;
        }
        return true;
    }

    private static UniqueKeyElement getPrimaryOrCandidateKey(TableElement table) {
        UniqueKeyElement pk = table.getPrimaryKey();
        if (pk != null) {
            return pk;
        }
        UniqueKeyElement[] keys = table.getUniqueKeys();
        if (keys == null || keys.length == 0) {
            return null;
        }
        pk = keys[0];
        for (int i = 1; i < keys.length; ++i) {
            if (keys[i].getColumns().length >= pk.getColumns().length) continue;
            pk = keys[i];
        }
        return pk;
    }

    private void generatePkField(ColumnElement column, boolean inPk, boolean pkField) {
        EntityMember m = EntityMember.create(column);
        m.setPrimaryKey(inPk, pkField);
        EntityClass bean = this.getBean(column.getDeclaringTable().getName().getName());
        if (this.primaryKeyIsForeignKeyTables.contains(column.getDeclaringTable().getName().getName())) {
            bean.setDerivedIdCandidate(true);
        }
        m.setMemberName(DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(bean), m.getMemberName(), null));
        bean.getFields().add(m);
    }

    private void generateRelationship(ForeignKeyElement key) {
        String keyTableName = key.getDeclaringTable().getName().getName();
        String keyRefName = key.getReferencedTable().getName().getName();
        boolean oneToOne = DbSchemaEjbGenerator.isFkUnique(key);
        EntityClass roleAHelper = this.getBean(keyTableName);
        if (roleAHelper == null) {
            return;
        }
        EntityClass roleBHelper = this.getBean(keyRefName);
        if (roleBHelper == null) {
            if (this.generateUnresolvedRelationships) {
                for (ColumnElement col : key.getLocalColumns()) {
                    this.generatePkField(col, false, false);
                }
            }
            return;
        }
        String roleBCmr = EntityMember.makeRelationshipFieldName(roleAHelper.getClassName(), this.colectionType, !oneToOne);
        roleBCmr = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(roleBHelper), roleBCmr, null);
        RelationshipRole roleB = new RelationshipRole(this.getRoleName(key, roleBHelper.getClassName()), roleBHelper.getClassName(), roleBCmr, false, !oneToOne, !this.isNullable(key), this.isNullable(key));
        roleB.setEntityPkgName(roleBHelper.getPackage());
        roleBHelper.addRole(roleB);
        String roleACmr = EntityMember.makeRelationshipFieldName(roleBHelper.getClassName(), this.colectionType, false);
        if (this.useColumNamesInRelations && !this.containsColumns(key.getColumns(), DbSchemaEjbGenerator.getPrimaryOrCandidateKey(key.getDeclaringTable()))) {
            roleACmr = EntityMember.makeRelationshipFieldName(roleB.getRoleName(), this.colectionType, false);
        }
        roleACmr = DbSchemaEjbGenerator.uniqueAlgorithm(this.getFieldNames(roleAHelper), roleACmr, null);
        RelationshipRole roleA = new RelationshipRole(this.getRoleName(key, roleAHelper.getClassName()), roleAHelper.getClassName(), roleACmr, !oneToOne, false, false, this.isNullable(key));
        roleA.setEntityPkgName(roleAHelper.getPackage());
        roleAHelper.addRole(roleA);
        EntityRelation relation = new EntityRelation(roleA, roleB);
        relation.setRelationName(roleA.getEntityName() + "-" + roleB.getEntityName());
        this.relations.add(relation);
        roleAHelper.getCMPMapping().getCmrFieldMapping().put(roleACmr, this.getLocalColumnData(key));
        roleBHelper.getCMPMapping().getCmrFieldMapping().put(roleBCmr, this.getReferencedColumnData(key));
    }

    private void reset() {
        this.beans.clear();
        this.relations.clear();
    }

    private void buildCMPSet() {
        this.reset();
        this.addAllTables();
        for (String tableName : this.beans.keySet()) {
            TableElement table = this.schemaElement.getTable(DBIdentifier.create((String)tableName));
            ColumnElement[] cols = table.getColumns();
            UniqueKeyElement pk = DbSchemaEjbGenerator.getPrimaryOrCandidateKey(table);
            ForeignKeyElement[] fkeys = table.getForeignKeys();
            fkeys = this.removeDuplicateFK(fkeys);
            for (int col = 0; col < cols.length; ++col) {
                if (pk != null && pk.getColumn(cols[col].getName()) != null) {
                    this.generatePkField(cols[col], true, pk.getColumns().length == 1);
                    continue;
                }
                if (this.isForeignKey(fkeys, cols[col])) continue;
                this.generatePkField(cols[col], false, false);
            }
            for (int fk = 0; fkeys != null && fkeys.length > fk; ++fk) {
                this.generateRelationship(fkeys[fk]);
            }
            EntityClass helperData = this.getBean(tableName);
            helperData.usePkField(pk != null && pk.getColumns().length == 1);
            helperData.setIsForTable(table.isTable());
        }
        this.makeRelationsUnique();
    }

    private List getFieldNames(EntityClass bean) {
        ArrayList<String> result = new ArrayList<String>();
        for (EntityMember member : bean.getFields()) {
            result.add(member.getMemberName());
        }
        for (RelationshipRole role : bean.getRoles()) {
            result.add(role.getFieldName());
        }
        return result;
    }

    private EntityRelation[] makeRelationsUnique() {
        EntityRelation[] r = this.getRelations();
        ArrayList<String> relationNames = new ArrayList<String>(r.length);
        for (int i = 0; i < r.length; ++i) {
            r[i].makeRoleNamesUnique();
            String baseName = r[i].getRelationName();
            r[i].setRelationName(DbSchemaEjbGenerator.uniqueAlgorithm(relationNames, baseName, "-"));
        }
        return r;
    }

    private static String uniqueAlgorithm(List<String> names, String baseName, String sep) {
        Object newName = baseName;
        int unique = 0;
        while (names.contains(newName)) {
            String ins = sep == null ? "" : sep;
            newName = baseName + ins + String.valueOf(++unique);
        }
        names.add((String)newName);
        return newName;
    }

    private ForeignKeyElement[] removeDuplicateFK(ForeignKeyElement[] fkeys) {
        if (fkeys == null || fkeys.length == 0) {
            return fkeys;
        }
        HashMap<ComparableFK, ForeignKeyElement> ret = new HashMap<ComparableFK, ForeignKeyElement>();
        for (int i = 0; i < fkeys.length; ++i) {
            ForeignKeyElement key = fkeys[i];
            ComparableFK fkc = new ComparableFK(key);
            if (ret.get(fkc) != null) {
                LOGGER.log(Level.INFO, key.getName().getFullName() + " key in " + key.getDeclaringTable().getName().getFullName() + " is considered as a duplicate, you may need to verify your schema or database structure.");
                continue;
            }
            ret.put(fkc, key);
        }
        return ret.values().toArray(new ForeignKeyElement[0]);
    }

    public boolean isUseDefaults() {
        return this.useDefaults;
    }

    private class ComparableFK {
        private ForeignKeyElement key;
        private String tableName;
        private String refName;
        private ColumnElement[] lc;
        private ColumnElement[] rc;

        ComparableFK(ForeignKeyElement fk) {
            this.key = fk;
            this.tableName = this.key.getDeclaringTable().getName().getName();
            this.refName = this.key.getReferencedTable().getName().getName();
            this.lc = this.key.getLocalColumns();
            this.rc = this.key.getReferencedColumns();
            Arrays.sort(this.lc);
            Arrays.sort(this.rc);
        }

        public int hashCode() {
            return this.tableName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComparableFK other = (ComparableFK)obj;
            if (this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName)) {
                return false;
            }
            if (this.refName == null ? other.refName != null : !this.refName.equals(other.refName)) {
                return false;
            }
            if (!Arrays.deepEquals(this.lc, other.lc)) {
                return false;
            }
            return Arrays.deepEquals(this.rc, other.rc);
        }
    }
}

