/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.actions;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.nativeimage.debugger.actions.Bundle;
import org.netbeans.modules.java.nativeimage.debugger.actions.Processes;
import org.netbeans.modules.java.nativeimage.debugger.api.NIDebugRunner;
import org.netbeans.modules.nativeimage.api.debug.StartDebugParameters;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.PersistentController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.ModuleInfo;
import org.openide.modules.Modules;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NIAttachCustomizer
extends JPanel {
    private final ConnectController controller;
    private final ValidityDocumentListener validityDocumentListener = new ValidityDocumentListener();
    private final RequestProcessor RP = new RequestProcessor(NIAttachCustomizer.class.getName(), 2);
    private Processes.ProcessInfo processInfo = null;
    private JLabel attachLabel;
    private JLabel dbgLabel;
    private JTextField dbgTextField;
    private JButton fileButton;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JScrollPane jScrollPane1;
    private JTable processTable;
    RequestProcessor.Task validationTask = new RequestProcessor(NIAttachCustomizer.class).create((Runnable)new FileValidationTask());
    private static final String CPPLITE_DEBUGGER = "org.netbeans.modules.cpplite.debugger";

    public NIAttachCustomizer() {
        this.controller = new ConnectController();
        this.initComponents();
        this.fileTextField.getDocument().addDocumentListener(this.validityDocumentListener);
        this.initNIFile();
        this.initProcesses();
    }

    private void initNIFile() {
        this.RP.post(() -> {
            FileObject currentFO = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
            if (currentFO != null) {
                String path;
                File currentFile = FileUtil.toFile((FileObject)currentFO);
                if (currentFile != null && currentFile.canExecute()) {
                    path = currentFile.getAbsolutePath();
                } else {
                    Project project = FileOwnerQuery.getOwner((FileObject)currentFO);
                    if (project != null) {
                        currentFO = project.getProjectDirectory();
                        currentFile = FileUtil.toFile((FileObject)currentFO);
                        path = currentFile.getAbsolutePath();
                    } else {
                        path = null;
                    }
                }
                if (path != null) {
                    SwingUtilities.invokeLater(() -> this.fileTextField.setText(path));
                }
            }
        });
    }

    private void initProcesses() {
        this.processTable.setSelectionMode(0);
        int spacing = 8;
        this.processTable.setIntercellSpacing(new Dimension(8, 0));
        Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.attachLabel.text", (Object)0L));
        this.RP.post(() -> {
            List<Processes.ProcessInfo> processes = Processes.getAllProcesses();
            int size = processes.size();
            Object[][] processValues = new Object[size][];
            for (int i = 0; i < size; ++i) {
                Processes.ProcessInfo info = processes.get(i);
                processValues[i] = new Object[]{info.getPid(), info.getCommand()};
            }
            SwingUtilities.invokeLater(() -> {
                this.processTable.setModel(new DefaultTableModel(processValues, new String[]{NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.processPID.text"), NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.processCommand.text")}){
                    Class<?>[] types;
                    {
                        this.types = new Class[]{Long.class, String.class};
                    }

                    @Override
                    public Class<?> getColumnClass(int columnIndex) {
                        return this.types[columnIndex];
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return false;
                    }
                });
                if (!processes.isEmpty()) {
                    int width = this.processTable.getGraphics().getFontMetrics().stringWidth(Long.toString(((Processes.ProcessInfo)processes.get(0)).getPid()));
                    this.processTable.getColumnModel().getColumn(0).setPreferredWidth(width += 16);
                    this.processTable.getColumnModel().getColumn(0).setMaxWidth(width);
                    this.processTable.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
                        int index = this.processTable.getSelectedRow();
                        if (index < 0) {
                            Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.attachLabel.text", (Object)0L));
                            this.processInfo = null;
                        } else {
                            Processes.ProcessInfo info = (Processes.ProcessInfo)processes.get(index);
                            Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.attachLabel.text", (Object)info.getPid()));
                            this.fileTextField.setText(info.getExecutable());
                            this.processInfo = info;
                        }
                    });
                }
            });
        });
    }

    private void initComponents() {
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.fileButton = new JButton();
        this.dbgLabel = new JLabel();
        this.dbgTextField = new JTextField();
        this.attachLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.processTable = new JTable();
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.fileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fileButton, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.fileButton.text"));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NIAttachCustomizer.this.fileButtonActionPerformed(evt);
            }
        });
        this.dbgLabel.setLabelFor(this.dbgTextField);
        Mnemonics.setLocalizedText((JLabel)this.dbgLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.dbgLabel.text"));
        this.dbgTextField.setText("gdb");
        this.attachLabel.setLabelFor(this.processTable);
        Mnemonics.setLocalizedText((JLabel)this.attachLabel, (String)NbBundle.getMessage(NIAttachCustomizer.class, (String)"NIAttachCustomizer.attachLabel.text"));
        this.jScrollPane1.setViewportView(this.processTable);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fileLabel).addComponent(this.dbgLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dbgTextField).addComponent(this.fileTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileButton)).addGroup(layout.createSequentialGroup().addComponent(this.attachLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fileLabel).addComponent(this.fileTextField, -2, -1, -2).addComponent(this.fileButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.dbgLabel).addComponent(this.dbgTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attachLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 139, Short.MAX_VALUE).addContainerGap()));
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.fileTextField.getText());
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.canExecute();
            }

            @Override
            public String getDescription() {
                return Bundle.CTL_ExecutableFiles();
            }
        });
        if (chooser.showOpenDialog(this) == 0) {
            this.fileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void checkValid() {
        assert (SwingUtilities.isEventDispatchThread()) : "Called outside of AWT.";
        if (this.fileTextField.getText().isEmpty()) {
            this.controller.setInformationMessage(Bundle.MSG_NoFile());
            this.controller.setValid(false);
            return;
        }
        this.validationTask.schedule(200);
    }

    Controller getController() {
        return this.controller;
    }

    private static boolean checkCPPLite() {
        ModuleInfo cppliteDebugger = Modules.getDefault().findCodeNameBase(CPPLITE_DEBUGGER);
        if (cppliteDebugger != null && !cppliteDebugger.isEnabled()) {
            Action pluginsManager = Actions.forID((String)"System", (String)"org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction");
            String moduleDisplayName = cppliteDebugger.getDisplayName();
            NotifyDescriptor.Confirmation messageDescriptor = new NotifyDescriptor.Confirmation((Object)Bundle.MSG_EnableNativeDebugger(moduleDisplayName), Bundle.TTL_EnableNativeDebugger(), 2);
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)messageDescriptor))) {
                SwingUtilities.invokeLater(() -> {
                    ActionEvent ev = new ActionEvent(pluginsManager, 100, "installed");
                    pluginsManager.actionPerformed(ev);
                });
            }
            return false;
        }
        return true;
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            NIAttachCustomizer.this.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NIAttachCustomizer.this.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NIAttachCustomizer.this.checkValid();
        }
    }

    private class FileValidationTask
    implements Runnable {
        private FileValidationTask() {
        }

        @Override
        public void run() {
            String filePath = NIAttachCustomizer.this.fileTextField.getText();
            File file = new File(filePath);
            boolean canExecute = file.isFile() && file.canExecute();
            SwingUtilities.invokeLater(() -> {
                NIAttachCustomizer.this.controller.setValid(canExecute);
                String message = canExecute ? null : Bundle.MSG_NoFile();
                NIAttachCustomizer.this.controller.setInformationMessage(message);
            });
        }
    }

    public class ConnectController
    implements PersistentController {
        private static final String NI_ATTACH_PROPERTIES = "native_image_attach_settings";
        private static final String PROP_NI_FILE = "niFile";
        private static final String PROP_DBG = "debugger";
        private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private boolean valid = true;

        public String getDisplayName() {
            return NIAttachCustomizer.this.dbgTextField.getText() + " " + new File(NIAttachCustomizer.this.fileTextField.getText()).getName();
        }

        public boolean load(Properties props) {
            assert (!SwingUtilities.isEventDispatchThread());
            final Properties attachProps = props.getProperties(NI_ATTACH_PROPERTIES);
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        NIAttachCustomizer.this.fileTextField.setText(attachProps.getString(ConnectController.PROP_NI_FILE, ""));
                        NIAttachCustomizer.this.dbgTextField.setText(attachProps.getString(ConnectController.PROP_DBG, "DBG"));
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return true;
        }

        public void save(Properties props) {
            final Properties attachProps = props.getProperties(NI_ATTACH_PROPERTIES);
            if (SwingUtilities.isEventDispatchThread()) {
                this.saveToProps(attachProps);
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ConnectController.this.saveToProps(attachProps);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        private void saveToProps(Properties attachProps) {
            attachProps.setString(PROP_NI_FILE, NIAttachCustomizer.this.fileTextField.getText());
            attachProps.setString(PROP_DBG, NIAttachCustomizer.this.dbgTextField.getText());
        }

        public boolean ok() {
            String filePath = NIAttachCustomizer.this.fileTextField.getText();
            String debuggerCommand = NIAttachCustomizer.this.dbgTextField.getText();
            Processes.ProcessInfo attach2Process = NIAttachCustomizer.this.processInfo;
            NIAttachCustomizer.this.RP.post(() -> {
                if (!NIAttachCustomizer.checkCPPLite()) {
                    return;
                }
                File file = new File(filePath);
                String displayName = "debug " + file.getName();
                StartDebugParameters startParams = StartDebugParameters.newBuilder(Collections.singletonList(file.getAbsolutePath())).debugger(debuggerCommand).debuggerDisplayObjects(false).displayName(displayName).processID(attach2Process != null ? Long.valueOf(attach2Process.getPid()) : null).workingDirectory(new File(System.getProperty("user.dir", ""))).build();
                NIDebugRunner.start(file, startParams, null, null);
            });
            return true;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isValid() {
            return this.valid;
        }

        void setValid(boolean valid) {
            this.valid = valid;
            this.firePropertyChange("valid", !valid, valid);
        }

        void setErrorMessage(String msg) {
            this.firePropertyChange("errorNotification", null, msg);
        }

        void setInformationMessage(String msg) {
            this.firePropertyChange("infoNotification", null, msg);
        }

        private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pcs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }
    }
}

