/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSecurityListRequest
extends BmcRequest<Void> {
    private String securityListId;

    public String getSecurityListId() {
        return this.securityListId;
    }

    public Builder toBuilder() {
        return new Builder().securityListId(this.securityListId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityListId=").append(String.valueOf(this.securityListId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecurityListRequest)) {
            return false;
        }
        GetSecurityListRequest other = (GetSecurityListRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityListId, other.securityListId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityListId == null ? 43 : this.securityListId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecurityListRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityListId = null;

        public Builder securityListId(String securityListId) {
            this.securityListId = securityListId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecurityListRequest o) {
            this.securityListId(o.getSecurityListId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecurityListRequest build() {
            GetSecurityListRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSecurityListRequest buildWithoutInvocationCallback() {
            GetSecurityListRequest request = new GetSecurityListRequest();
            request.securityListId = this.securityListId;
            return request;
        }
    }
}

