/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.util;

public class NameUtil {
    private static final char columnPairSeparator = ';';
    public static final char dbElementSeparator = '.';

    public static String getSchemaResourceName(String schemaName) {
        return schemaName + ".dbschema";
    }

    public static String getTableName(String memberName) {
        int index = memberName.indexOf(59);
        String tempString = index != -1 ? memberName.substring(0, index) : memberName;
        return tempString.substring(0, tempString.lastIndexOf(46));
    }

    public static String getSchemaName(String memberName) {
        if (memberName == null) {
            return null;
        }
        int index = memberName.indexOf(59);
        String tempString = index != -1 ? memberName.substring(0, index) : memberName;
        return tempString.substring(0, tempString.indexOf(46));
    }

    public static String getRelativeTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        if (NameUtil.isRelativeTableName(tableName)) {
            return tableName;
        }
        return tableName.substring(tableName.indexOf(46) + 1);
    }

    public static String getRelativeMemberName(String memberName) {
        if (memberName == null) {
            return null;
        }
        int semicolonIndex = memberName.indexOf(59);
        if (semicolonIndex != -1) {
            String firstColumn = memberName.substring(0, semicolonIndex);
            String secondColumn = memberName.substring(semicolonIndex + 1);
            return NameUtil.getRelativeMemberNameInternal(firstColumn) + ";" + NameUtil.getRelativeMemberNameInternal(secondColumn);
        }
        return NameUtil.getRelativeMemberNameInternal(memberName);
    }

    private static String getRelativeMemberNameInternal(String memberName) {
        if (memberName == null) {
            return null;
        }
        if (NameUtil.isRelativeMemberName(memberName)) {
            return memberName;
        }
        return memberName.substring(memberName.indexOf(46) + 1);
    }

    public static String getAbsoluteTableName(String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        if (!NameUtil.isRelativeTableName(tableName)) {
            return tableName;
        }
        return schemaName + "." + tableName;
    }

    public static String getAbsoluteMemberName(String schemaName, String memberName) {
        if (memberName == null) {
            return null;
        }
        int semicolonIndex = memberName.indexOf(59);
        if (semicolonIndex != -1) {
            String firstColumn = memberName.substring(0, semicolonIndex);
            String secondColumn = memberName.substring(semicolonIndex + 1);
            return NameUtil.getAbsoluteMemberNameInternal(schemaName, firstColumn) + ";" + NameUtil.getAbsoluteMemberNameInternal(schemaName, secondColumn);
        }
        return NameUtil.getAbsoluteMemberNameInternal(schemaName, memberName);
    }

    private static String getAbsoluteMemberNameInternal(String schemaName, String memberName) {
        if (memberName == null) {
            return null;
        }
        if (!NameUtil.isRelativeMemberName(memberName)) {
            return memberName;
        }
        return schemaName + "." + memberName;
    }

    private static boolean isRelativeTableName(String tableName) {
        return tableName.indexOf(46) == -1;
    }

    private static boolean isRelativeMemberName(String columnName) {
        int first = columnName.indexOf(46);
        return columnName.indexOf(46, first + 1) == -1;
    }
}

