/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.netbeans.libs.git.GitClassFactoryImpl;
import org.netbeans.libs.git.GitLineDetails;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;

public final class GitBlameResult {
    private final File blamedFile;
    private final int lineCount;
    private GitLineDetails[] lineDetails;

    GitBlameResult(BlameResult result, Repository repository) {
        this.lineCount = result.getResultContents().size();
        this.lineDetails = new GitLineDetails[this.lineCount];
        HashMap<String, File> cachedFiles = new HashMap<String, File>(this.lineCount);
        this.blamedFile = this.getFile(cachedFiles, result.getResultPath(), repository.getWorkTree());
        HashMap<RevCommit, GitRevisionInfo> cachedRevisions = new HashMap<RevCommit, GitRevisionInfo>(this.lineCount);
        HashMap<PersonIdent, GitUser> cachedUsers = new HashMap<PersonIdent, GitUser>(this.lineCount * 2);
        for (int i = 0; i < this.lineCount; ++i) {
            RevCommit commit = result.getSourceCommit(i);
            if (commit == null) {
                this.lineDetails[i] = null;
                continue;
            }
            GitRevisionInfo revInfo = (GitRevisionInfo)cachedRevisions.get(commit);
            if (revInfo == null) {
                revInfo = new GitRevisionInfo(commit, repository);
                cachedRevisions.put(commit, revInfo);
            }
            GitUser author = this.getUser(cachedUsers, result.getSourceAuthor(i));
            GitUser committer = this.getUser(cachedUsers, result.getSourceCommitter(i));
            File sourceFile = this.getFile(cachedFiles, result.getSourcePath(i), repository.getWorkTree());
            String content = result.getResultContents().getString(i);
            this.lineDetails[i] = new GitLineDetails(content, revInfo, author, committer, sourceFile, result.getSourceLine(i));
        }
    }

    public File getBlamedFile() {
        return this.blamedFile;
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public GitLineDetails getLineDetails(int lineNumber) {
        return lineNumber < this.lineCount ? this.lineDetails[lineNumber] : null;
    }

    private GitUser getUser(Map<PersonIdent, GitUser> cached, PersonIdent ident) {
        GitUser user = cached.get(ident);
        if (user == null) {
            user = GitClassFactoryImpl.getInstance().createUser(ident);
            cached.put(ident, user);
        }
        return user;
    }

    private File getFile(Map<String, File> cached, String relativePath, File workTree) {
        File file = cached.get(relativePath);
        if (file == null) {
            file = new File(workTree, relativePath.replace("/", File.separator));
            cached.put(relativePath, file);
        }
        return file;
    }
}

