/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

public abstract class LaunchSuite {
    private static final Logger LOGGER = Logger.getLogger(LaunchSuite.class);
    protected boolean m_temporary;

    protected LaunchSuite(boolean bl) {
        this.m_temporary = bl;
    }

    public boolean isTemporary() {
        return this.m_temporary;
    }

    public abstract File save(File var1);

    public abstract XMLStringBuffer getSuiteBuffer();

    static class ClassListSuite
    extends CustomizedSuite {
        protected Collection<String> m_packageNames;
        protected Collection<String> m_classNames;
        protected Collection<String> m_groupNames;
        protected int m_logLevel;

        ClassListSuite(String string, Collection<String> collection, Collection<String> collection2, Collection<String> collection3, Map<String, String> map, String string2, int n) {
            super(string, "Custom suite", map, string2);
            this.m_packageNames = collection;
            this.m_classNames = collection2;
            this.m_groupNames = collection3;
            this.m_logLevel = n;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer xMLStringBuffer) {
            Properties properties;
            Properties properties2 = new Properties();
            properties2.setProperty("name", this.m_projectName);
            properties2.setProperty("verbose", String.valueOf(this.m_logLevel));
            xMLStringBuffer.push("test", properties2);
            if (null != this.m_groupNames) {
                xMLStringBuffer.push("groups");
                xMLStringBuffer.push("run");
                for (String string : this.m_groupNames) {
                    properties = new Properties();
                    properties.setProperty("name", string);
                    xMLStringBuffer.addEmptyElement("include", properties);
                }
                xMLStringBuffer.pop("run");
                xMLStringBuffer.pop("groups");
            }
            if (this.m_packageNames != null && this.m_packageNames.size() > 0) {
                xMLStringBuffer.push("packages");
                for (String string : this.m_packageNames) {
                    properties = new Properties();
                    properties.setProperty("name", string);
                    xMLStringBuffer.addEmptyElement("package", properties);
                }
                xMLStringBuffer.pop("packages");
            }
            if (this.m_classNames != null && this.m_classNames.size() > 0) {
                xMLStringBuffer.push("classes");
                for (String string : this.m_classNames) {
                    properties = new Properties();
                    properties.setProperty("name", string);
                    xMLStringBuffer.addEmptyElement("class", properties);
                }
                xMLStringBuffer.pop("classes");
            }
            xMLStringBuffer.pop("test");
        }
    }

    static class ClassesAndMethodsSuite
    extends CustomizedSuite {
        protected Map<String, Collection<String>> m_classes;
        protected int m_logLevel;

        ClassesAndMethodsSuite(String string, Map<String, Collection<String>> map, Map<String, String> map2, String string2, int n) {
            super(string, "Custom suite", map2, string2);
            this.m_classes = map;
            this.m_logLevel = n;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer xMLStringBuffer) {
            Properties properties = new Properties();
            properties.setProperty("name", this.m_projectName);
            properties.setProperty("verbose", String.valueOf(this.m_logLevel));
            xMLStringBuffer.push("test", properties);
            xMLStringBuffer.push("classes");
            for (Map.Entry<String, Collection<String>> entry : this.m_classes.entrySet()) {
                Properties properties2 = new Properties();
                properties2.setProperty("name", entry.getKey());
                Collection<String> collection = this.sanitize(entry.getValue());
                if (null != collection && collection.size() > 0) {
                    xMLStringBuffer.push("class", properties2);
                    xMLStringBuffer.push("methods");
                    for (String string : collection) {
                        Properties properties3 = new Properties();
                        properties3.setProperty("name", string);
                        xMLStringBuffer.addEmptyElement("include", properties3);
                    }
                    xMLStringBuffer.pop("methods");
                    xMLStringBuffer.pop("class");
                    continue;
                }
                xMLStringBuffer.addEmptyElement("class", properties2);
            }
            xMLStringBuffer.pop("classes");
            xMLStringBuffer.pop("test");
        }

        private Collection<String> sanitize(Collection<String> collection) {
            if (null == collection) {
                return null;
            }
            List<String> list = Lists.newArrayList();
            for (String string : collection) {
                if (!Utils.isStringNotBlank(string)) continue;
                list.add(string);
            }
            return list;
        }
    }

    static class MethodsSuite
    extends CustomizedSuite {
        protected Collection<String> m_methodNames;
        protected String m_className;
        protected int m_logLevel;

        MethodsSuite(String string, String string2, Collection<String> collection, Map<String, String> map, String string3, int n) {
            super(string, string2, map, string3);
            this.m_className = string2;
            this.m_methodNames = collection;
            this.m_logLevel = n;
        }

        @Override
        protected void initContentBuffer(XMLStringBuffer xMLStringBuffer) {
            Properties properties = new Properties();
            properties.setProperty("name", this.m_className);
            properties.setProperty("verbose", String.valueOf(this.m_logLevel));
            xMLStringBuffer.push("test", properties);
            xMLStringBuffer.push("classes");
            Properties properties2 = new Properties();
            properties2.setProperty("name", this.m_className);
            if (null != this.m_methodNames && this.m_methodNames.size() > 0) {
                xMLStringBuffer.push("class", properties2);
                xMLStringBuffer.push("methods");
                for (String string : this.m_methodNames) {
                    Properties properties3 = new Properties();
                    properties3.setProperty("name", string);
                    xMLStringBuffer.addEmptyElement("include", properties3);
                }
                xMLStringBuffer.pop("methods");
                xMLStringBuffer.pop("class");
            } else {
                xMLStringBuffer.addEmptyElement("class", properties2);
            }
            xMLStringBuffer.pop("classes");
            xMLStringBuffer.pop("test");
        }
    }

    private static abstract class CustomizedSuite
    extends LaunchSuite {
        protected String m_projectName;
        protected String m_suiteName;
        protected Map<String, String> m_parameters;
        private XMLStringBuffer m_suiteBuffer;

        private CustomizedSuite(String string, String string2, Map<String, String> map, String string3) {
            super(true);
            this.m_projectName = string;
            this.m_suiteName = string2;
            this.m_parameters = map;
        }

        protected XMLStringBuffer createContentBuffer() {
            XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
            xMLStringBuffer.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
            Properties properties = new Properties();
            properties.setProperty("parallel", XmlSuite.ParallelMode.NONE.toString());
            properties.setProperty("name", this.m_suiteName);
            xMLStringBuffer.push("suite", properties);
            if (this.m_parameters != null) {
                for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
                    Properties properties2 = new Properties();
                    properties2.setProperty("name", entry.getKey());
                    properties2.setProperty("value", entry.getValue());
                    xMLStringBuffer.push("parameter", properties2);
                    xMLStringBuffer.pop("parameter");
                }
            }
            this.initContentBuffer(xMLStringBuffer);
            xMLStringBuffer.pop("suite");
            return xMLStringBuffer;
        }

        @Override
        public XMLStringBuffer getSuiteBuffer() {
            if (null == this.m_suiteBuffer) {
                this.m_suiteBuffer = this.createContentBuffer();
            }
            return this.m_suiteBuffer;
        }

        protected abstract void initContentBuffer(XMLStringBuffer var1);

        @Override
        public File save(File file) {
            File file2 = new File(file, "temp-testng-customsuite.xml");
            this.saveSuiteContent(file2, this.getSuiteBuffer());
            return file2;
        }

        protected void saveSuiteContent(File file, XMLStringBuffer xMLStringBuffer) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8"));){
                outputStreamWriter.write(xMLStringBuffer.getStringBuffer().toString());
            }
            catch (IOException iOException) {
                LOGGER.error("IO Exception", iOException);
            }
        }
    }

    public static class ExistingSuite
    extends LaunchSuite {
        private File m_suitePath;

        public ExistingSuite(File file) {
            super(false);
            this.m_suitePath = file;
        }

        @Override
        public XMLStringBuffer getSuiteBuffer() {
            throw new UnsupportedOperationException("Not implemented yet");
        }

        @Override
        public File save(File file) {
            return this.m_suitePath;
        }
    }
}

