/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.DebuggerOptions;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;

public abstract class DbgpCommand {
    private static final Logger LOGGER = Logger.getLogger(DbgpCommand.class.getName());
    protected static final String SPACE = " ";
    private static final String DATA_SEPARATOR = " -- ";
    private static final String TRANSACTION_OPT = " -i ";
    private String command;
    private String transactionId;

    DbgpCommand(String command, String transactionId) {
        this.command = command;
        this.transactionId = transactionId;
    }

    public void send(OutputStream out) throws IOException {
        String encodedData = null;
        if (this.getData() != null) {
            encodedData = this.encodeData();
        }
        StringBuilder dataToSend = new StringBuilder(this.getCommand());
        dataToSend.append(this.getArgumentString());
        if (encodedData != null) {
            dataToSend.append(DATA_SEPARATOR);
            dataToSend.append(encodedData);
        }
        LOGGER.log(Level.FINE, "command to send : {0}", dataToSend);
        byte[] bytes = dataToSend.toString().getBytes(Charset.defaultCharset());
        byte[] sendBytes = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, sendBytes, 0, bytes.length);
        sendBytes[bytes.length] = 0;
        out.write(sendBytes);
        out.flush();
    }

    private String encodeData() throws IOException {
        DebuggerOptions options;
        DebugSession debugSession;
        SessionId sessionId;
        Session session = DebuggerManager.getDebuggerManager().getCurrentSession();
        byte[] bytes = this.getData().getBytes(Charset.defaultCharset());
        if (session != null && (sessionId = (SessionId)session.lookupFirst(null, SessionId.class)) != null && (debugSession = SessionManager.getInstance().getSession(sessionId)) != null && (options = debugSession.getOptions()) != null) {
            String projectEncoding = options.getProjectEncoding();
            bytes = this.getData().getBytes(projectEncoding);
        }
        return Base64.getEncoder().encodeToString(bytes);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public abstract boolean wantAcknowledgment();

    protected String getData() {
        return null;
    }

    public String getCommand() {
        return this.command;
    }

    protected String getArguments() {
        return "";
    }

    private String getArgumentString() {
        if (this.getArguments() != null && this.getArguments().length() > 0) {
            return TRANSACTION_OPT + this.transactionId + SPACE + this.getArguments();
        }
        return TRANSACTION_OPT + this.transactionId;
    }

    public String toString() {
        StringBuilder dataToSend = new StringBuilder(this.getCommand());
        dataToSend.append(this.getArgumentString());
        String encodedData = null;
        if (this.getData() != null) {
            try {
                encodedData = this.encodeData();
            }
            catch (IOException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
        }
        if (encodedData != null) {
            dataToSend.append(DATA_SEPARATOR);
            dataToSend.append(encodedData);
        }
        return dataToSend.toString();
    }
}

