/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.DocTreePathHandle;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlock;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.RefactoringModule;
import org.netbeans.modules.refactoring.java.plugins.FindLocalUsagesQuery;
import org.netbeans.modules.refactoring.java.ui.ComputeOffAWT;
import org.netbeans.modules.refactoring.java.ui.InstantRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.JavaRenameProperties;
import org.netbeans.modules.refactoring.java.ui.RenamePanel;
import org.netbeans.modules.refactoring.java.ui.RenameRefactoringUI;
import org.netbeans.modules.refactoring.java.ui.instant.InstantOption;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class InstantRefactoringUIImpl
implements InstantRefactoringUI {
    private String newName;
    private final String oldName;
    private final RenameRefactoring refactoring;
    private final TreePathHandle tph;
    private final DocTreePathHandle dtph;
    private final ArrayList<InstantOption> options;
    private InstantOption searchComments;
    private final Set<MutablePositionRegion> usages;
    private final Set<MutablePositionRegion> comments;
    private static Set<JavaTokenId> IGNORE_TOKES = EnumSet.of(JavaTokenId.WHITESPACE, JavaTokenId.BLOCK_COMMENT, JavaTokenId.LINE_COMMENT);

    private InstantRefactoringUIImpl(Set<MutablePositionRegion> usages, Set<MutablePositionRegion> comments, String oldName, FileObject file, TreePathHandle tph) throws BadLocationException {
        this(usages, comments, oldName, file != null ? new RenameRefactoring(Lookups.fixed((Object[])new Object[]{tph, file})) : new RenameRefactoring(Lookups.singleton((Object)tph)), tph, null);
    }

    private InstantRefactoringUIImpl(Set<MutablePositionRegion> usages, Set<MutablePositionRegion> comments, String oldName, DocTreePathHandle dtph) throws BadLocationException {
        this(usages, comments, oldName, new RenameRefactoring(Lookups.singleton((Object)dtph)), null, dtph);
    }

    private InstantRefactoringUIImpl(Set<MutablePositionRegion> usages, Set<MutablePositionRegion> comments, String oldName, RenameRefactoring refactoring, TreePathHandle tph, DocTreePathHandle dtph) throws BadLocationException {
        this.refactoring = refactoring;
        this.tph = tph;
        this.dtph = dtph;
        this.usages = usages;
        this.comments = comments;
        this.oldName = oldName;
        this.options = new ArrayList(3);
        this.searchComments = new InstantOption(NbBundle.getMessage(RenamePanel.class, (String)"LBL_RenameComments").replace("&", ""), null, RefactoringModule.getOption("searchInComments.rename", true));
        this.options.add(this.searchComments);
        this.updateInput(oldName);
    }

    @Override
    public KeyStroke getKeyStroke() {
        Object value = RefactoringActionsFactory.renameAction().getValue("AcceleratorKey");
        return value instanceof KeyStroke ? (KeyStroke)value : null;
    }

    @Override
    public void updateInput(CharSequence text) {
        this.newName = text.toString();
        this.refactoring.setNewName(this.newName);
        this.refactoring.setSearchInComments(this.searchComments.selected());
        JavaRenameProperties properties = (JavaRenameProperties)this.refactoring.getContext().lookup(JavaRenameProperties.class);
        if (properties == null) {
            properties = new JavaRenameProperties();
            this.refactoring.getContext().add((Object)properties);
        }
        properties.setIsRenameGettersSetters(false);
        properties.setIsRenameTestClass(false);
        properties.setIsRenameTestClassMethod(false);
    }

    @Override
    public List<InstantOption> getOptions() {
        return this.options;
    }

    @Override
    public Set<MutablePositionRegion> getRegions() {
        HashSet<MutablePositionRegion> regions = new HashSet<MutablePositionRegion>(this.usages);
        if (this.searchComments.selected()) {
            regions.addAll(this.comments);
        }
        return regions;
    }

    public static InstantRefactoringUI create(JavaSource js, final int caret) {
        InstantRefactoringUI ui = ComputeOffAWT.computeOffAWT(new ComputeOffAWT.Worker<InstantRefactoringUI>(){

            @Override
            public InstantRefactoringUI process(final CompilationInfo info) {
                try {
                    InstantRefactoringUIImpl ui;
                    long end;
                    Element el;
                    Document doc = info.getDocument();
                    final DocSourcePositions docSourcePositions = (DocSourcePositions)info.getTrees().getSourcePositions();
                    if (doc == null) {
                        return null;
                    }
                    TreePath[] path = new TreePath[]{null};
                    final DocTreePath[] docPath = new DocTreePath[]{null};
                    final int[] adjustedCaret = new int[]{caret};
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            TokenSequence ts = SourceUtils.getJavaTokenSequence((TokenHierarchy)info.getTokenHierarchy(), (int)caret);
                            ts.move(caret);
                            if (ts.moveNext() && ts.token() != null) {
                                if (ts.token().id() == JavaTokenId.IDENTIFIER) {
                                    adjustedCaret[0] = ts.offset() + ts.token().length() / 2 + 1;
                                } else if (ts.token().id() == JavaTokenId.JAVADOC_COMMENT) {
                                    int offsetBehindJavadoc = ts.offset() + ts.token().length();
                                    while (ts.moveNext()) {
                                        TokenId tid = ts.token().id();
                                        if (tid == JavaTokenId.BLOCK_COMMENT) {
                                            if (!"/**/".contentEquals(ts.token().text())) continue;
                                            return;
                                        }
                                        if (tid == JavaTokenId.JAVADOC_COMMENT) {
                                            if (ts.token().partType() != PartType.COMPLETE) continue;
                                            return;
                                        }
                                        if (IGNORE_TOKES.contains(tid)) continue;
                                        offsetBehindJavadoc = ts.offset();
                                        ++offsetBehindJavadoc;
                                        break;
                                    }
                                    TreePath path = info.getTreeUtilities().pathFor(offsetBehindJavadoc);
                                    while (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getLeaf().getKind()) && path.getLeaf().getKind() != Tree.Kind.METHOD && path.getLeaf().getKind() != Tree.Kind.VARIABLE && path.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && (path = path.getParentPath()) != null) {
                                    }
                                    if (path != null) {
                                        DocCommentTree docComment = ((DocTrees)info.getTrees()).getDocCommentTree(path);
                                        DocTreePath docTreePath = info.getTreeUtilities().pathFor(new DocTreePath(path, docComment), caret);
                                        long start = docSourcePositions.getStartPosition(info.getCompilationUnit(), docComment, docTreePath.getLeaf());
                                        long end = docSourcePositions.getEndPosition(info.getCompilationUnit(), docComment, docTreePath.getLeaf());
                                        adjustedCaret[0] = (int)(start + (end - start) / 2L + 1L);
                                        docPath[0] = docTreePath;
                                    }
                                }
                            }
                        }
                    });
                    TreePath treePath = path[0] = docPath[0] != null ? docPath[0].getTreePath() : info.getTreeUtilities().pathFor(adjustedCaret[0]);
                    if (path[0] != null && path[0].getParentPath() != null) {
                        long variableEnd;
                        long typeEnd;
                        Tree.Kind leafKind = path[0].getLeaf().getKind();
                        Tree.Kind parentKind = path[0].getParentPath().getLeaf().getKind();
                        if (leafKind == Tree.Kind.ARRAY_TYPE && parentKind == Tree.Kind.VARIABLE && (typeEnd = docSourcePositions.getEndPosition(info.getCompilationUnit(), path[0].getLeaf())) == (variableEnd = docSourcePositions.getEndPosition(info.getCompilationUnit(), path[0].getLeaf()))) {
                            path[0] = path[0].getParentPath();
                        }
                    }
                    Element element = el = docPath[0] != null ? ((DocTrees)info.getTrees()).getElement(docPath[0]) : info.getTrees().getElement(path[0]);
                    if (el == null || path[0] == null) {
                        Set<MutablePositionRegion> labelPoints;
                        if (path[0] != null && (labelPoints = InstantRefactoringUIImpl.computeLabelChangePoints(path, info, adjustedCaret, doc)) != null) {
                            return new InstantRefactoringUIImpl(labelPoints, Collections.EMPTY_SET, labelPoints.iterator().next().getText(doc).toString(), null, TreePathHandle.create((TreePath)path[0], (CompilationInfo)info));
                        }
                        return null;
                    }
                    long start = docPath[0] != null ? docSourcePositions.getStartPosition(info.getCompilationUnit(), docPath[0].getDocComment(), docPath[0].getLeaf()) : docSourcePositions.getStartPosition(info.getCompilationUnit(), path[0].getLeaf());
                    long l = end = docPath[0] != null ? docSourcePositions.getEndPosition(info.getCompilationUnit(), docPath[0].getDocComment(), docPath[0].getLeaf()) : docSourcePositions.getEndPosition(info.getCompilationUnit(), path[0].getLeaf());
                    if (start > (long)caret || (long)caret > end) {
                        return null;
                    }
                    TreePathHandle tph = null;
                    FileObject file = null;
                    if (docPath[0] == null) {
                        tph = TreePathHandle.create((TreePath)path[0], (CompilationInfo)info);
                        Element selected = info.getTrees().getElement(path[0]);
                        if (selected instanceof TypeElement && !((TypeElement)selected).getNestingKind().isNested()) {
                            ElementHandle handle = ElementHandle.create((Element)((TypeElement)selected));
                            file = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo());
                        }
                    }
                    if (el.getKind() == ElementKind.CONSTRUCTOR) {
                        el = el.getEnclosingElement();
                    }
                    FindLocalUsagesQuery findLocalUsagesQuery = new FindLocalUsagesQuery();
                    findLocalUsagesQuery.findUsages(el, info, doc, true);
                    Set<MutablePositionRegion> usages = new HashSet<MutablePositionRegion>(findLocalUsagesQuery.getUsages());
                    Set<MutablePositionRegion> comments = new HashSet<MutablePositionRegion>(findLocalUsagesQuery.getComments());
                    if (el.getKind().isClass()) {
                        for (ExecutableElement c : ElementFilter.constructorsIn(el.getEnclosedElements())) {
                            int[] span;
                            TreePath t = info.getTrees().getPath(c);
                            if (t == null || (span = info.getTreeUtilities().findNameSpan((MethodTree)t.getLeaf())) == null) continue;
                            try {
                                usages.add(FindLocalUsagesQuery.createRegion(doc, span[0], span[1]));
                            }
                            catch (BadLocationException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                    usages = InstantRefactoringUIImpl.removeOverlapsWithGuardedBlocks(doc, usages);
                    comments = InstantRefactoringUIImpl.removeOverlapsWithGuardedBlocks(doc, comments);
                    if (docPath[0] == null) {
                        ui = new InstantRefactoringUIImpl(usages, comments, el.getSimpleName().toString(), file, tph);
                    } else {
                        DocTreePathHandle dtph = DocTreePathHandle.create((DocTreePath)docPath[0], (CompilationInfo)info);
                        ui = new InstantRefactoringUIImpl(usages, comments, el.getSimpleName().toString(), dtph);
                    }
                    return ui;
                }
                catch (IOException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }
        }, "Instant Rename", js, JavaSource.Phase.RESOLVED);
        return ui;
    }

    @Override
    public Set<MutablePositionRegion> optionChanged(InstantOption instantOption) {
        if (instantOption == this.searchComments) {
            RefactoringModule.setOption("searchInComments.rename", this.searchComments.selected());
            HashSet<MutablePositionRegion> regions = new HashSet<MutablePositionRegion>(this.usages);
            if (this.searchComments.selected()) {
                regions.addAll(this.comments);
            }
            return regions;
        }
        return null;
    }

    @Override
    public RefactoringUI getRefactoringUI() {
        RenameRefactoringUI renameRefactoringUI = new RenameRefactoringUI(this.refactoring, this.oldName, this.newName, this.tph, this.dtph);
        return renameRefactoringUI;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    @Override
    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    private static Set<MutablePositionRegion> removeOverlapsWithGuardedBlocks(Document doc, Set<MutablePositionRegion> points) {
        if (!(doc instanceof GuardedDocument)) {
            return points;
        }
        GuardedDocument gd = (GuardedDocument)doc;
        for (MarkBlock current = gd.getGuardedBlockChain().getChain(); current != null && !points.isEmpty(); current = current.getNext()) {
            Iterator<MutablePositionRegion> iterator = points.iterator();
            while (iterator.hasNext()) {
                MutablePositionRegion region = iterator.next();
                if ((current.compare(region.getStartOffset(), region.getEndOffset()) & 1) == 0) continue;
                iterator.remove();
            }
        }
        return points;
    }

    private static Set<MutablePositionRegion> computeLabelChangePoints(TreePath[] path, final CompilationInfo info, int[] adjustedCaret, final Document doc) throws IllegalArgumentException {
        Tree tree = path[0].getLeaf();
        int[] nameSpan = null;
        switch (tree.getKind()) {
            case LABELED_STATEMENT: {
                nameSpan = info.getTreeUtilities().findNameSpan((LabeledStatementTree)tree);
                break;
            }
            case BREAK: {
                nameSpan = info.getTreeUtilities().findNameSpan((BreakTree)tree);
                break;
            }
            case CONTINUE: {
                nameSpan = info.getTreeUtilities().findNameSpan((ContinueTree)tree);
            }
        }
        if (nameSpan != null && nameSpan[0] <= adjustedCaret[0] && adjustedCaret[0] <= nameSpan[1]) {
            if (path[0].getLeaf().getKind() != Tree.Kind.LABELED_STATEMENT) {
                Tree tgt = info.getTreeUtilities().getBreakContinueTargetTree(path[0]);
                TreePath treePath = path[0] = tgt != null ? info.getTrees().getPath(info.getCompilationUnit(), tgt) : null;
            }
            if (path[0] != null) {
                TreePath labeledStatement = path[0];
                final LinkedHashSet<MutablePositionRegion> result = new LinkedHashSet<MutablePositionRegion>();
                if (labeledStatement.getLeaf().getKind() == Tree.Kind.LABELED_STATEMENT) {
                    int[] span = info.getTreeUtilities().findNameSpan((LabeledStatementTree)path[0].getLeaf());
                    if (span != null) {
                        try {
                            result.add(FindLocalUsagesQuery.createRegion(doc, span[0], span[1]));
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    final Name label = ((LabeledStatementTree)labeledStatement.getLeaf()).getLabel();
                    new ErrorAwareTreePathScanner<Void, Void>(){

                        public Void visitBreak(BreakTree node, Void p) {
                            int[] span;
                            if (node.getLabel() != null && label.contentEquals(node.getLabel()) && (span = info.getTreeUtilities().findNameSpan(node)) != null) {
                                try {
                                    result.add(FindLocalUsagesQuery.createRegion(doc, span[0], span[1]));
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            return (Void)super.visitBreak(node, (Object)p);
                        }

                        public Void visitContinue(ContinueTree node, Void p) {
                            int[] span;
                            if (node.getLabel() != null && label.contentEquals(node.getLabel()) && (span = info.getTreeUtilities().findNameSpan(node)) != null) {
                                try {
                                    result.add(FindLocalUsagesQuery.createRegion(doc, span[0], span[1]));
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            return (Void)super.visitContinue(node, (Object)p);
                        }
                    }.scan(labeledStatement, null);
                }
                return result;
            }
        }
        return null;
    }
}

