/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.jpda.truffle.MIMETypes;
import org.netbeans.modules.debugger.jpda.truffle.breakpoints.TruffleLineBreakpoint;
import org.netbeans.modules.javascript2.debug.EditorLineHandlerFactory;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

public class ToggleBreakpointsInLanguagesActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set<String> IGNORED_MIME_TYPES = new HashSet<String>(Arrays.asList("text/javascript", "text/x-java", "text/x-groovy"));
    private volatile Line postedLine;

    public ToggleBreakpointsInLanguagesActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
        EditorContextDispatcher.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorContextDispatcher.getDefault()));
        MIMETypes.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)MIMETypes.getDefault()));
    }

    public void postAction(Object action, final Runnable actionPerformedNotifier) {
        assert (action == ActionsManager.ACTION_TOGGLE_BREAKPOINT) : action;
        EditorContextDispatcher context = EditorContextDispatcher.getDefault();
        this.postedLine = context.getCurrentLine();
        if (this.postedLine == null) {
            actionPerformedNotifier.run();
            return;
        }
        super.postAction(action, new Runnable(){

            @Override
            public void run() {
                try {
                    actionPerformedNotifier.run();
                }
                finally {
                    ToggleBreakpointsInLanguagesActionProvider.this.postedLine = null;
                }
            }
        });
    }

    public void doAction(Object action) {
        assert (action == ActionsManager.ACTION_TOGGLE_BREAKPOINT) : action;
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        Line line = this.postedLine;
        if (line == null && (line = EditorContextDispatcher.getDefault().getCurrentLine()) == null) {
            return;
        }
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        if (fo == null) {
            return;
        }
        if (IGNORED_MIME_TYPES.contains(fo.getMIMEType())) {
            return;
        }
        Set<String> mts = MIMETypes.getDefault().get();
        if (!mts.contains(fo.getMIMEType())) {
            return;
        }
        this.toggleBreakpoint(fo, line);
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if ("MIME types".equals(propertyName)) {
            this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        } else if ("file".equals(propertyName)) {
            Set<String> mts;
            boolean enabled = false;
            FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
            if (fo != null && !IGNORED_MIME_TYPES.contains(fo.getMIMEType()) && ((mts = MIMETypes.getDefault().getCached()) == null || mts.contains(fo.getMIMEType()))) {
                enabled = true;
            }
            this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
        }
    }

    private void toggleBreakpoint(FileObject fo, Line line) {
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        boolean add = true;
        int lineNumber = line.getLineNumber() + 1;
        for (Breakpoint breakpoint : d.getBreakpoints()) {
            if (!(breakpoint instanceof TruffleLineBreakpoint) || !((TruffleLineBreakpoint)breakpoint).getFileObject().equals(fo) || ((TruffleLineBreakpoint)breakpoint).getLineNumber() != lineNumber) continue;
            d.removeBreakpoint(breakpoint);
            add = false;
            break;
        }
        if (add) {
            d.addBreakpoint(this.createLineBreakpoint(line));
        }
    }

    private Breakpoint createLineBreakpoint(Line line) {
        FileObject fo = (FileObject)line.getLookup().lookup(FileObject.class);
        return new TruffleLineBreakpoint(EditorLineHandlerFactory.getHandler((FileObject)fo, (int)(line.getLineNumber() + 1)));
    }
}

