/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings.refactoring;

import java.awt.Component;
import javax.swing.event.ChangeListener;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.modules.lsp.client.bindings.refactoring.Bundle;
import org.netbeans.modules.lsp.client.bindings.refactoring.LSPBindingsCollection;
import org.netbeans.modules.lsp.client.bindings.refactoring.RenamePanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUIImpl
implements RefactoringUI {
    private final LSPBindingsCollection servers;
    private final FileObject file;
    private final Position position;
    private final String name;
    private final RenameParams params;
    private RenamePanel panel;

    public RenameRefactoringUIImpl(LSPBindingsCollection servers, FileObject file, Position position, String name) {
        this.servers = servers;
        this.file = file;
        this.position = position;
        this.name = name;
        this.params = new RenameParams();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return Bundle.DESC_Rename(this.name);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            this.panel = new RenamePanel();
        }
        this.panel.setName(this.name);
        return new CustomRefactoringPanel(){

            public void initialize() {
            }

            public Component getComponent() {
                return RenameRefactoringUIImpl.this.panel;
            }
        };
    }

    public Problem setParameters() {
        this.params.setTextDocument(new TextDocumentIdentifier(Utils.toURI(this.file)));
        this.params.setPosition(this.position);
        this.params.setNewName(this.panel.getName());
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return new RenameRefactoring(Lookups.fixed((Object[])new Object[]{this.servers, this.params}));
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

