/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.test;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.element.ElementKind;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.test.Destination;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;
import org.gradle.tooling.events.test.TestFailureResult;
import org.gradle.tooling.events.test.TestFinishEvent;
import org.gradle.tooling.events.test.TestOperationDescriptor;
import org.gradle.tooling.events.test.TestOperationResult;
import org.gradle.tooling.events.test.TestOutputDescriptor;
import org.gradle.tooling.events.test.TestOutputEvent;
import org.gradle.tooling.events.test.TestProgressEvent;
import org.gradle.tooling.events.test.TestSkippedResult;
import org.gradle.tooling.events.test.TestStartEvent;
import org.gradle.tooling.events.test.TestSuccessResult;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.spi.GradleProgressListenerProvider;
import org.netbeans.modules.gradle.test.GradleTestSuite;
import org.netbeans.modules.gradle.test.GradleTestcase;
import org.netbeans.modules.gsf.testrunner.api.CoreManager;
import org.netbeans.modules.gsf.testrunner.api.Report;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public final class GradleTestProgressListener
implements ProgressListener,
GradleProgressListenerProvider {
    private final Project project;
    private final Map<String, TestSession> sessions = new ConcurrentHashMap<String, TestSession>();
    private final Map<TestSession, Map<String, TestSuite>> runningSuites = new ConcurrentHashMap<TestSession, Map<String, TestSuite>>();
    private final Map<TestSession, Map<String, Testcase>> runningTests = new ConcurrentHashMap<TestSession, Map<String, Testcase>>();
    private static final String GRADLE_TEST_RUN = "Gradle Test Run :";
    private static String TEST = ":test";

    public GradleTestProgressListener(Project project) {
        this.project = project;
    }

    public void statusChanged(ProgressEvent evt) {
        if (evt instanceof TestOutputEvent) {
            this.processTestOutput((TestOutputEvent)evt);
        }
        if (evt instanceof TestProgressEvent) {
            this.processTestProgress((TestProgressEvent)evt);
        }
    }

    private void processTestProgress(TestProgressEvent evt) {
        JvmTestOperationDescriptor jvmTest;
        TestOperationDescriptor desc = evt.getDescriptor();
        if (evt instanceof TestStartEvent) {
            TestStartEvent start = (TestStartEvent)evt;
            if (desc.getParent() == null) {
                this.sessionStart(start);
            } else if (desc instanceof JvmTestOperationDescriptor) {
                jvmTest = (JvmTestOperationDescriptor)desc;
                switch (jvmTest.getJvmTestKind()) {
                    case ATOMIC: {
                        this.caseStart(start, jvmTest);
                        break;
                    }
                    case SUITE: {
                        this.suiteStart(start, jvmTest);
                        break;
                    }
                }
            }
        }
        if (evt instanceof TestFinishEvent) {
            TestFinishEvent finish = (TestFinishEvent)evt;
            if (desc.getParent() == null) {
                this.sessionFinish(finish);
            } else if (desc instanceof JvmTestOperationDescriptor) {
                jvmTest = (JvmTestOperationDescriptor)desc;
                switch (jvmTest.getJvmTestKind()) {
                    case ATOMIC: {
                        this.caseFinish(finish, jvmTest);
                        break;
                    }
                    case SUITE: {
                        this.suiteFinish(finish, jvmTest);
                        break;
                    }
                }
            }
        }
    }

    private void processTestOutput(TestOutputEvent evt) {
        TestSession session = this.sessions.get(GradleTestProgressListener.getSessionKey((OperationDescriptor)evt.getDescriptor()));
        assert (session != null);
        if (session == null) {
            throw new IllegalArgumentException("TestSession is null");
        }
        TestOutputDescriptor desc = evt.getDescriptor();
        OperationDescriptor parent = desc.getParent();
        CoreManager manager = GradleTestProgressListener.getManager();
        String msg = desc.getMessage();
        if (msg != null && msg.endsWith("\n")) {
            Testcase tc;
            msg = msg.substring(0, msg.length() - 1);
            if (manager != null && session != null) {
                manager.displayOutput(session, msg, desc.getDestination().equals((Object)Destination.StdErr));
            }
            if (parent instanceof JvmTestOperationDescriptor && (tc = this.runningTests.get(session).get(GradleTestProgressListener.getTestOpKey((JvmTestOperationDescriptor)parent))) != null) {
                tc.addOutputLines(Arrays.asList(msg.split("\\R")));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionStart(TestStartEvent evt) {
        TestSession session;
        String key = GradleTestProgressListener.getSessionKey((OperationDescriptor)evt.getDescriptor());
        GradleTestProgressListener gradleTestProgressListener = this;
        synchronized (gradleTestProgressListener) {
            session = this.sessions.computeIfAbsent(key, name -> new TestSession(name, this.getProject(key), TestSession.SessionType.TEST));
            this.runningTests.put(session, new ConcurrentHashMap());
        }
        CoreManager manager = GradleTestProgressListener.getManager();
        if (manager != null) {
            manager.registerNodeFactory();
            manager.testStarted(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionFinish(TestFinishEvent evt) {
        TestSession session;
        GradleTestProgressListener gradleTestProgressListener = this;
        synchronized (gradleTestProgressListener) {
            session = this.sessions.remove(GradleTestProgressListener.getSessionKey((OperationDescriptor)evt.getDescriptor()));
            assert (session != null);
            this.runningTests.remove(session);
        }
        CoreManager manager = GradleTestProgressListener.getManager();
        if (manager != null) {
            manager.sessionFinished(session);
        }
    }

    private void suiteStart(TestStartEvent evt, JvmTestOperationDescriptor op) {
    }

    private void suiteFinish(TestFinishEvent evt, JvmTestOperationDescriptor op) {
        TestSuite testSuite;
        TestSession session = this.sessions.get(GradleTestProgressListener.getSessionKey((OperationDescriptor)evt.getDescriptor()));
        assert (session != null);
        TestOperationResult result = evt.getResult();
        String suiteName = GradleTestSuite.suiteName((OperationDescriptor)op);
        Map<String, TestSuite> suitesByName = this.runningSuites.get(session);
        TestSuite testSuite2 = testSuite = suitesByName != null ? suitesByName.remove(suiteName) : null;
        if (testSuite != null) {
            Report report = session.getReport(result.getEndTime() - result.getStartTime());
            session.finishSuite(testSuite);
            CoreManager manager = GradleTestProgressListener.getManager();
            if (manager != null) {
                manager.displaySuiteRunning(session, testSuite);
                manager.displayReport(session, report, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseStart(TestStartEvent evt, JvmTestOperationDescriptor op) {
        TestSession session = this.sessions.get(GradleTestProgressListener.getSessionKey((OperationDescriptor)evt.getDescriptor()));
        assert (session != null);
        assert (op.getParent() != null);
        String suiteName = GradleTestSuite.suiteName(op.getParent());
        Map sessionSuites = this.runningSuites.computeIfAbsent(session, s -> new ConcurrentHashMap());
        TestSuite ts = sessionSuites.computeIfAbsent(suiteName, s -> {
            GradleTestSuite suite = new GradleTestSuite(GradleTestProgressListener.getSuiteOpDesc((JvmTestOperationDescriptor)op.getParent(), op.getClassName()));
            session.addSuite((TestSuite)suite);
            return suite;
        });
        CoreManager manager = GradleTestProgressListener.getManager();
        if (manager != null && sessionSuites.size() == 1) {
            manager.displaySuiteRunning(session, ts);
        }
        GradleTestcase tc = new GradleTestcase(op, session);
        GradleTestProgressListener gradleTestProgressListener = this;
        synchronized (gradleTestProgressListener) {
            this.runningTests.get(session).put(GradleTestProgressListener.getTestOpKey(op), (Testcase)tc);
            session.addTestCase((Testcase)tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caseFinish(TestFinishEvent evt, JvmTestOperationDescriptor op) {
        Testcase tc;
        GradleTestProgressListener gradleTestProgressListener = this;
        synchronized (gradleTestProgressListener) {
            TestSession session = this.sessions.get(GradleTestProgressListener.getSessionKey((OperationDescriptor)evt.getDescriptor()));
            assert (session != null);
            tc = this.runningTests.get(session).remove(GradleTestProgressListener.getTestOpKey(op));
        }
        if (tc != null) {
            TestOperationResult result = evt.getResult();
            long time = result.getEndTime() - result.getStartTime();
            tc.setTimeMillis(time);
            tc.setLocation(this.searchLocation(tc, op.getClassName(), op.getMethodName(), null));
            if (result instanceof TestSuccessResult) {
                tc.setStatus(Status.PASSED);
            }
            if (result instanceof TestSkippedResult) {
                tc.setStatus(Status.SKIPPED);
            }
            if (result instanceof TestFailureResult) {
                Failure failure;
                tc.setStatus(Status.ERROR);
                TestFailureResult fail = (TestFailureResult)result;
                Failure failure2 = failure = fail.getFailures().isEmpty() ? null : (Failure)fail.getFailures().iterator().next();
                if (failure != null) {
                    Trouble trouble = new Trouble(failure.getMessage() == null);
                    if (failure.getMessage() != null) {
                        tc.setStatus(Status.FAILED);
                        Matcher m = Pattern.compile("expected:(.+) but was:(.+)").matcher(failure.getMessage());
                        if (m.matches()) {
                            trouble.setComparisonFailure(new Trouble.ComparisonFailure(m.group(1), m.group(2)));
                        }
                    }
                    String desc = failure.getDescription();
                    String[] stackTrace = null;
                    if (desc != null) {
                        stackTrace = desc.split("\\n");
                        trouble.setStackTrace(stackTrace);
                    }
                    tc.setLocation(this.searchLocation(tc, op.getClassName(), op.getMethodName(), stackTrace));
                    tc.setTrouble(trouble);
                }
            }
        }
    }

    private Project getProject(String key) {
        if (key != null && key.startsWith(GRADLE_TEST_RUN) && (key = key.substring(GRADLE_TEST_RUN.length())).endsWith(TEST) && !(key = key.substring(0, key.length() - TEST.length()).trim()).isEmpty()) {
            for (Project containedPrj : ProjectUtils.getContainedProjects((Project)this.project, (boolean)true)) {
                if (!key.equals(containedPrj.getProjectDirectory().getName())) continue;
                return containedPrj;
            }
        }
        return this.project;
    }

    private static String getSessionKey(OperationDescriptor op) {
        String id = "";
        for (OperationDescriptor descriptor = op; descriptor != null; descriptor = descriptor.getParent()) {
            id = descriptor.getName();
        }
        return id;
    }

    private static JvmTestOperationDescriptor getSuiteOpDesc(JvmTestOperationDescriptor op, String className) {
        for (JvmTestOperationDescriptor descriptor = op; descriptor != null; descriptor = (JvmTestOperationDescriptor)descriptor.getParent()) {
            if (className != null && !className.equals(descriptor.getClassName())) continue;
            return descriptor;
        }
        return op;
    }

    private static String getTestOpKey(JvmTestOperationDescriptor op) {
        return op.getClassName() + "." + op.getMethodName();
    }

    private static CoreManager getManager() {
        Collection providers = Lookup.getDefault().lookupResult(CoreManager.class).allItems();
        for (Lookup.Item provider : providers) {
            if (!provider.getDisplayName().equals("org-netbeans-modules-gradle".concat("_").concat("junit"))) continue;
            return (CoreManager)provider.getInstance();
        }
        return null;
    }

    private String searchLocation(Testcase tc, String className, String methodName, String[] stackTrace) {
        int lastDot;
        String pkg;
        GradleJavaProject gradleJavaProject;
        Map<Object, Object> classpathInfo = Map.of();
        NbGradleProject nbGradleProject = (NbGradleProject)tc.getSession().getProject().getLookup().lookup(NbGradleProject.class);
        GradleJavaProject gradleJavaProject2 = gradleJavaProject = nbGradleProject != null ? (GradleJavaProject)nbGradleProject.projectLookup(GradleJavaProject.class) : null;
        if (gradleJavaProject != null) {
            classpathInfo = gradleJavaProject.getSourceSets().values().stream().flatMap(gradleJavaSourceSet -> gradleJavaSourceSet.getSourceDirs(GradleJavaSourceSet.SourceType.JAVA).stream()).distinct().collect(Collectors.toMap(f -> ClasspathInfo.create((File)f), f -> f.toPath(), (f1, f2) -> f1));
        }
        String relativePath = null;
        for (Map.Entry ci : classpathInfo.entrySet()) {
            FileObject fo;
            if (ci.getKey() == null || (fo = SourceUtils.getFile((ElementHandle)ElementHandle.createTypeElementHandle((ElementKind)ElementKind.CLASS, (String)className), (ClasspathInfo)((ClasspathInfo)ci.getKey()))) == null) continue;
            relativePath = ((Path)ci.getValue()).relativize(FileUtil.toFile((FileObject)fo).toPath()).toString();
            break;
        }
        if (relativePath != null) {
            return relativePath;
        }
        StringBuilder ret = new StringBuilder(className.length() + methodName.length() + 10);
        String fileName = null;
        String line = null;
        if (stackTrace != null) {
            String fullMethodName = className + "." + methodName;
            String failedAt = null;
            for (String st : stackTrace) {
                int i = st.indexOf(fullMethodName);
                if (i <= 0) continue;
                failedAt = st.substring(i + fullMethodName.length() + 1, st.length() - 1);
                break;
            }
            if (failedAt != null && failedAt.contains(":")) {
                int sepa = failedAt.indexOf(58);
                fileName = failedAt.substring(0, sepa);
                line = failedAt.substring(sepa + 1);
                try {
                    Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    line = null;
                }
            }
        }
        String string = pkg = (lastDot = className.lastIndexOf(46)) > 0 ? className.substring(0, lastDot) : "";
        if (fileName != null) {
            ret.append(pkg.replace('.', '/')).append('/').append(fileName);
        } else {
            ret.append(className.replace('.', '/')).append(".java");
        }
        ret.append(':');
        ret.append(line != null ? line : methodName);
        return ret.toString();
    }

    public ProgressListener getProgressListener() {
        return this;
    }

    public Set<OperationType> getSupportedOperationTypes() {
        return EnumSet.of(OperationType.TEST, OperationType.TEST_OUTPUT);
    }
}

