/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.jaxb.actions.JAXBRegenerateCodeAction;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEvent;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListener;
import org.netbeans.modules.xml.jaxb.api.model.events.JAXBWizEventListenerAdapter;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schema;
import org.netbeans.modules.xml.jaxb.cfg.schema.Schemas;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizardSchemaNode;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JAXBWizardRootNode
extends AbstractNode {
    private Project project;
    private static Action[] actions = null;

    public JAXBWizardRootNode(Project prj) {
        this(prj, new InstanceContent());
        this.project = prj;
        Children cs = this.getChildren();
        this.initActions();
    }

    private JAXBWizardRootNode(Project prj, InstanceContent content) {
        super((Children)new JAXBWizardRootNodeChildren(prj), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        content.add((Object)this);
        content.add((Object)prj);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JAXBWizardRootNode.class, (String)"LBL_JAXB_Bindings");
    }

    public String getName() {
        return "JAXB Bindings";
    }

    public Node.Cookie getCookie(Class clz) {
        if (clz == Project.class && this.project instanceof Node.Cookie) {
            return (Node.Cookie)this.project;
        }
        return super.getCookie(clz);
    }

    private void initActions() {
        if (actions == null) {
            actions = new Action[]{new JAXBRegenerateCodeAction()};
        }
    }

    public Action[] getActions(boolean b) {
        return actions;
    }

    public Image getIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/jaxb/resources/packageRoot.gif");
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/xml/jaxb/resources/packageRootOpen.gif");
    }

    public static class JAXBWizardRootNodeChildren
    extends Children.Keys {
        private Project project;
        private Schemas schemas;
        private Map<String, Schema> nameSchemaMap = new HashMap<String, Schema>();
        private JAXBWizEventListener modelListener = new ModelListener();

        public JAXBWizardRootNodeChildren(Project prj) {
            this.project = prj;
            this.addNodify();
        }

        public void addNodify() {
            Schema[] sc;
            this.schemas = ProjectHelper.getXMLBindingSchemas(this.project);
            this.nameSchemaMap.clear();
            for (Schema s : sc = this.schemas.getSchema()) {
                this.nameSchemaMap.put(s.getName(), s);
            }
            this.updateKeys();
            super.addNotify();
            ProjectHelper.addModelListener(this.project, this.modelListener);
        }

        public void removeNotify() {
            ProjectHelper.removeModelListener(this.project, this.modelListener);
        }

        public void updateKeys() {
            if (this.schemas == null) {
                return;
            }
            this.setKeys(this.nameSchemaMap.keySet());
        }

        private void updateBindingKeys(Schemas ss) {
            Schema[] sc;
            this.schemas = ss;
            this.nameSchemaMap.clear();
            for (Schema s : sc = this.schemas.getSchema()) {
                this.nameSchemaMap.put(s.getName(), s);
            }
            this.updateKeys();
        }

        protected Node[] createNodes(Object key) {
            Node[] nodes = null;
            if (key instanceof String) {
                Schema schema = this.nameSchemaMap.get((String)key);
                JAXBWizardSchemaNode bindingNode = new JAXBWizardSchemaNode(this.project, schema);
                nodes = new Node[]{bindingNode};
            }
            return nodes;
        }

        private final class ModelListener
        extends JAXBWizEventListenerAdapter {
            private ModelListener() {
            }

            @Override
            public void bindingAdded(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)event.getSource());
                }
            }

            @Override
            public void bindingChanged(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    Schema schema = (Schema)event.getNewValue();
                    Schema oSchema = (Schema)event.getOldValue();
                    String nName = schema.getName();
                    String oName = oSchema.getName();
                    if (nName != null && !nName.equals(oName)) {
                        JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)event.getSource());
                    }
                }
            }

            @Override
            public void bindingDeleted(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)event.getSource());
                }
            }

            @Override
            public void configFileEdited(JAXBWizEvent event) {
                if (event.getSource() instanceof Schemas) {
                    JAXBWizardRootNodeChildren.this.updateBindingKeys((Schemas)event.getSource());
                }
            }
        }
    }
}

