/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.jaxb.ui;

import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.xml.jaxb.spi.SchemaCompiler;
import org.netbeans.modules.xml.jaxb.ui.CompilerFinder;
import org.netbeans.modules.xml.jaxb.ui.JAXBWizBindingCfgPanel;
import org.netbeans.modules.xml.jaxb.util.ProjectHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class JAXBWizardIterator
implements TemplateWizard.Iterator {
    private WizardDescriptor wizardDescriptor;
    private WizardDescriptor.Panel[] panels = null;
    private int cursor;
    private Project project;

    public JAXBWizardIterator() {
    }

    public JAXBWizardIterator(Project project) {
        this.project = project;
        this.initWizardPanels();
    }

    public static JAXBWizardIterator create() {
        return new JAXBWizardIterator();
    }

    private void initWizardPanels() {
        this.cursor = 0;
        this.panels = new WizardDescriptor.Panel[]{new JAXBWizBindingCfgPanel()};
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.cursor];
    }

    public boolean hasNext() {
        return this.cursor < this.panels.length - 1;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public String name() {
        return NbBundle.getMessage(this.getClass(), (String)"LBL_JAXBWizTitle");
    }

    public void nextPanel() {
        ++this.cursor;
    }

    public void previousPanel() {
        --this.cursor;
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wizardDescriptor = wiz;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public Set instantiate() throws IOException {
        return new HashSet();
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = null;
    }

    public Set<DataObject> instantiate(TemplateWizard wiz) throws IOException {
        wiz.setMessage(null);
        FileObject template = Templates.getTemplate((WizardDescriptor)wiz);
        DataObject dTemplate = DataObject.find((FileObject)template);
        SchemaCompiler schemaCompiler = CompilerFinder.findCompiler(this.project);
        if (schemaCompiler != null) {
            try {
                schemaCompiler.importResources((WizardDescriptor)wiz);
            }
            catch (Throwable ex) {
                String msg = NbBundle.getMessage(JAXBWizardIterator.class, (String)"MSG_ErrorReadingSchema");
                wiz.putProperty("WizardPanel_errorMessage", (Object)msg);
                wiz.setMessage((Object)msg);
                wiz.setMessageType(0);
                wiz.setValid(false);
                this.project.getProjectDirectory().getFileSystem().refresh(true);
                throw new IOException(msg, ex);
            }
        } else {
            String msg = NbBundle.getMessage(JAXBWizardIterator.class, (String)"MSG_NoSchemaCompiler");
            wiz.putProperty("WizardPanel_errorMessage", (Object)msg);
            wiz.setMessage((Object)msg);
            wiz.setMessageType(0);
            wiz.setValid(false);
            this.project.getProjectDirectory().getFileSystem().refresh(true);
            throw new IOException(msg);
        }
        schemaCompiler.compileSchema((WizardDescriptor)wiz);
        ProjectHelper.addJaxbApiEndorsed(this.project);
        ProjectHelper.disableCoS(this.project, true);
        return Collections.singleton(dTemplate);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public void initialize(TemplateWizard wiz) {
        this.project = Templates.getProject((WizardDescriptor)wiz);
        List<String> schemas = ProjectHelper.getSchemaNames(this.project);
        wiz.putProperty("jaxb.cfg.existingSchemaNames", schemas);
        this.initWizardPanels();
        Object prop = wiz.getProperty("WizardPanel_contentData");
        String[] beforeSteps = null;
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        String name = ProjectUtils.getInformation((Project)this.project).getName();
        wiz.putProperty("project.name", (Object)name);
        wiz.putProperty("project.dir", (Object)FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(TemplateWizard wiz) {
        if (wiz.getValue() == TemplateWizard.FINISH_OPTION) {
            this.project = null;
        }
    }
}

