/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.monitoring.model.UpdateAlarmDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAlarmRequest
extends BmcRequest<UpdateAlarmDetails> {
    private String alarmId;
    private UpdateAlarmDetails updateAlarmDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getAlarmId() {
        return this.alarmId;
    }

    public UpdateAlarmDetails getUpdateAlarmDetails() {
        return this.updateAlarmDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateAlarmDetails getBody$() {
        return this.updateAlarmDetails;
    }

    public Builder toBuilder() {
        return new Builder().alarmId(this.alarmId).updateAlarmDetails(this.updateAlarmDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",alarmId=").append(String.valueOf(this.alarmId));
        sb.append(",updateAlarmDetails=").append(String.valueOf((Object)this.updateAlarmDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAlarmRequest)) {
            return false;
        }
        UpdateAlarmRequest other = (UpdateAlarmRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.alarmId, other.alarmId) && Objects.equals((Object)this.updateAlarmDetails, (Object)other.updateAlarmDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.alarmId == null ? 43 : this.alarmId.hashCode());
        result = result * 59 + (this.updateAlarmDetails == null ? 43 : this.updateAlarmDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAlarmRequest, UpdateAlarmDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String alarmId = null;
        private UpdateAlarmDetails updateAlarmDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder updateAlarmDetails(UpdateAlarmDetails updateAlarmDetails) {
            this.updateAlarmDetails = updateAlarmDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAlarmRequest o) {
            this.alarmId(o.getAlarmId());
            this.updateAlarmDetails(o.getUpdateAlarmDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAlarmRequest build() {
            UpdateAlarmRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAlarmDetails body) {
            this.updateAlarmDetails(body);
            return this;
        }

        public UpdateAlarmRequest buildWithoutInvocationCallback() {
            UpdateAlarmRequest request = new UpdateAlarmRequest();
            request.alarmId = this.alarmId;
            request.updateAlarmDetails = this.updateAlarmDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

