/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.mx.project;

import java.awt.Image;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.mx.project.Bundle;
import org.netbeans.modules.java.mx.project.SuiteEnvEdit;
import org.netbeans.modules.java.mx.project.SuiteProject;
import org.netbeans.modules.java.mx.project.SuiteSources;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.ImageDecorator;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class SuiteLogicalView
implements LogicalViewProvider {
    private final SuiteProject p;

    public SuiteLogicalView(SuiteProject p) {
        this.p = p;
    }

    public Node createLogicalView() {
        return new SuiteRootNode(this.p);
    }

    public Node findPath(Node root, Object target) {
        Project prj = (Project)root.getLookup().lookup(Project.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            if (SuiteLogicalView.isOtherProjectSource(fo, prj)) {
                return null;
            }
            for (Node n : root.getChildren().getNodes(true)) {
                Node result = PackageView.findPath((Node)n, (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private static boolean isOtherProjectSource(FileObject fo, Project me) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fo);
        if (owner == null) {
            return false;
        }
        if (me.equals(owner)) {
            return false;
        }
        for (SourceGroup sg : ProjectUtils.getSources((Project)owner).getSourceGroups("java")) {
            if (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fo)) continue;
            return true;
        }
        return false;
    }

    private static final class SuiteRootNode
    extends AbstractNode {
        private final SuiteProject project;

        public SuiteRootNode(SuiteProject p) {
            super(Children.create((ChildFactory)new RootChildFactory(p), (boolean)true), Lookups.fixed((Object[])new Object[]{p, new SuiteEnvEdit(p)}));
            this.project = p;
            this.setDisplayName();
            this.setIconBaseWithExtension("org/netbeans/modules/java/mx/project/mx-knife.png");
        }

        private void setDisplayName() {
            this.setDisplayName(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }

        public String getHtmlDisplayName() {
            return null;
        }

        public Action[] getActions(boolean context) {
            return CommonProjectActions.forType((String)"mxprojects");
        }
    }

    static class SuiteWithoutJDKNode
    extends FilterNode {
        private final SuiteSources.Group group;
        private final DataObject od;

        public SuiteWithoutJDKNode(SuiteProject suite, DataObject od, SuiteSources.Group group) {
            this(suite, od, group, od.getNodeDelegate());
        }

        private SuiteWithoutJDKNode(SuiteProject suite, DataObject od, SuiteSources.Group group, Node n) {
            super(n, (Children)new FilterNode.Children(n), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)new SuiteEnvEdit(suite)), od.getLookup()}));
            this.od = od;
            this.group = group;
        }

        public Image getIcon(int type) {
            Image icon = ImageUtilities.loadImage((String)"org/netbeans/modules/java/mx/project/mx-knife.png");
            try {
                ImageDecorator decorator = FileUIUtils.getImageDecorator((FileSystem)this.od.getPrimaryFile().getFileSystem());
                return decorator.annotateIcon(icon, type, this.od.files());
            }
            catch (FileStateInvalidException ex) {
                return icon;
            }
        }

        public String getDisplayName() {
            return this.group.getDisplayName();
        }

        public String getShortDescription() {
            return Bundle.CTL_MissingJDK(this.group.getCompliance());
        }

        public Action[] getActions(boolean context) {
            return new Action[]{Actions.forID((String)"System", (String)"org.openide.actions.EditAction")};
        }
    }

    private static final class RootChildFactory
    extends ChildFactory<Key>
    implements ChangeListener {
        private final SuiteProject suite;
        private final SuiteSources sources;

        RootChildFactory(SuiteProject project) {
            this.suite = project;
            this.sources = project.getSources();
            this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
        }

        protected boolean createKeys(List<Key> toPopulate) {
            for (SuiteSources.Group sg : this.sources.groups()) {
                if (sg.getJavaPlatform() != null) {
                    toPopulate.add(new Key(sg){

                        @Override
                        public Node createNode() {
                            return new FilterNode(PackageView.createPackageView((SourceGroup)this.group)){

                                public String getShortDescription() {
                                    return Bundle.CTL_Compliance(group.getCompliance());
                                }
                            };
                        }
                    });
                    continue;
                }
                toPopulate.add(new Key(sg){

                    @Override
                    public Node createNode() {
                        try {
                            DataObject od = DataObject.find((FileObject)this.group.getRootFolder());
                            return new SuiteWithoutJDKNode(suite, od, this.group);
                        }
                        catch (DataObjectNotFoundException ex) {
                            return Node.EMPTY;
                        }
                    }
                });
            }
            return true;
        }

        protected Node createNodeForKey(Key key) {
            return key.createNode();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }

        private static abstract class Key {
            public final SuiteSources.Group group;

            public Key(SuiteSources.Group group) {
                this.group = group;
            }

            public abstract Node createNode();

            public int hashCode() {
                int hash = 7;
                hash = 53 * hash + Objects.hashCode(this.group);
                return hash;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Key other = (Key)obj;
                return Objects.equals(this.group, other.group);
            }
        }
    }
}

