/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.ide.ergonomics.fod.BrokenProjectInfo;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;

final class BrokenProject
implements Project,
ProjectInformation,
LogicalViewProvider {
    private final FileObject pd;
    final String msg;

    public BrokenProject(FileObject projectDirectory, String error) {
        this.pd = projectDirectory;
        this.msg = error;
    }

    public FileObject getProjectDirectory() {
        return this.pd;
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this);
    }

    public int hashCode() {
        return this.pd.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Project) {
            return this.pd.equals(((Project)obj).getProjectDirectory());
        }
        return false;
    }

    public String getName() {
        return this.pd.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(BrokenProject.class, (String)"MSG_BrokenProject", (Object)this.pd.getName());
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/ide/ergonomics/fod/BrokenProject.png", (boolean)true);
    }

    public Project getProject() {
        return this;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public Node createLogicalView() {
        BrokenNode n = new BrokenNode(Children.LEAF, this.getLookup());
        n.setName(this.getName());
        n.setDisplayName(this.getDisplayName());
        n.setIconBaseWithExtension("org/netbeans/modules/ide/ergonomics/fod/BrokenProject.png");
        return n;
    }

    public Node findPath(Node root, Object target) {
        return null;
    }

    private static final class BrokenNode
    extends AbstractNode {
        public BrokenNode(Children children, Lookup lookup) {
            super(children, lookup);
        }

        public Action[] getActions(boolean context) {
            return new Action[]{CommonProjectActions.closeProjectAction(), null, BrokenActionInfo.ACTION};
        }
    }

    private static final class BrokenActionInfo
    extends AbstractAction
    implements ContextAwareAction {
        private final Lookup context;
        static final Action ACTION = new BrokenActionInfo(Utilities.actionsGlobalContext());

        private BrokenActionInfo(Lookup c) {
            this.context = c;
            this.putValue("Name", NbBundle.getMessage(BrokenProject.class, (String)"MSG_BrokenActionInfo"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrokenProject p = (BrokenProject)this.context.lookup(BrokenProject.class);
            if (p == null) {
                return;
            }
            BrokenProjectInfo.showInfo(p);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new BrokenActionInfo(actionContext);
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && this.getClass().equals(obj.getClass());
        }
    }
}

