/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class TemporalGetOptionNode
extends JavaScriptBaseNode {
    protected TemporalGetOptionNode() {
    }

    public abstract Object execute(JSDynamicObject var1, TruffleString var2, TemporalUtil.OptionType var3, List<?> var4, Object var5);

    @Specialization
    protected Object getOption(JSDynamicObject options, TruffleString property, TemporalUtil.OptionType types, List<?> values, Object fallback, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isFallbackProfile, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached JSToStringNode toStringNode, @Cached JSToNumberNode toNumberNode) {
        assert (JSRuntime.isObject((Object)options));
        Object value = JSObject.get(options, property);
        if (isFallbackProfile.profile((Node)this, value == Undefined.instance)) {
            return fallback;
        }
        TemporalUtil.OptionType type = value instanceof Boolean && types.allowsBoolean() ? TemporalUtil.OptionType.BOOLEAN : (Strings.isTString(value) && types.allowsString() ? TemporalUtil.OptionType.STRING : (JSRuntime.isNumber(value) && types.allowsNumber() ? TemporalUtil.OptionType.NUMBER : types.getLast()));
        if (type.allowsBoolean()) {
            value = toBooleanNode.executeBoolean(this, value);
        } else if (type.allowsNumber()) {
            if (JSRuntime.isNaN(value = toNumberNode.executeNumber(value))) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorNumberIsNaN();
            }
        } else if (type.allowsString()) {
            value = toStringNode.executeString(value);
        }
        if (value != Undefined.instance && values != null && !Boundaries.listContainsUnchecked(values, value)) {
            errorBranch.enter((Node)this);
            throw TemporalErrors.createRangeErrorOptionsNotContained(values, value);
        }
        return value;
    }
}

