/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.transform.stc.StaticTypeCheckingVisitor;

class NbGroovyErrorCollector
extends ErrorCollector {
    private static final String RESOURCE_FILTERED_ERRORS = "FilteredStaticErrors.lst";
    private List<Message> filteredErrors = new ArrayList<Message>();
    private List<Message> staticAnalysisErrors = new ArrayList<Message>();
    private Map<Message, ASTNode> errorSources;
    private boolean showStaticCompileErrors;
    private boolean showFilteredErrors;
    private boolean disableErrors;
    private List<Message> combinedErrors;
    private Map<Message, ASTNode> error2Node = new HashMap<Message, ASTNode>();
    private Map<ASTNode, List<Message>> node2Errors = new HashMap<ASTNode, List<Message>>();
    private Map<ASTNode, AmbiguousReference> amiguousCandidates = new HashMap<ASTNode, AmbiguousReference>();
    private ASTNode closureContext;
    private ASTNode errNode = null;
    private static Pattern errorFilter;

    public NbGroovyErrorCollector(CompilerConfiguration configuration) {
        super(configuration);
        this.initErrorFilter();
    }

    public List<Message> getFilteredErrors() {
        return this.filteredErrors;
    }

    public void setFilteredErrors(List<Message> filteredErrors) {
        this.filteredErrors = filteredErrors;
        this.combinedErrors = null;
    }

    public boolean isShowAllErrors() {
        return this.showStaticCompileErrors;
    }

    public void setShowAllErrors(boolean showAllErrors) {
        this.showStaticCompileErrors = showAllErrors;
        this.combinedErrors = null;
    }

    protected void failIfErrors() throws CompilationFailedException {
        super.failIfErrors();
    }

    public boolean isDisableErrors() {
        return this.disableErrors;
    }

    public void setDisableErrors(boolean disableErrors) {
        this.disableErrors = disableErrors;
    }

    public boolean hasErrors() {
        if (this.disableErrors) {
            return false;
        }
        List<? extends Message> errs = this.getErrors();
        return errs != null && !errs.isEmpty();
    }

    public List<? extends Message> getErrors() {
        if (this.disableErrors) {
            return Collections.emptyList();
        }
        return this.showStaticCompileErrors ? this.getAllErrors() : super.getErrors();
    }

    public Message getError(int index) {
        List<? extends Message> errs = this.getErrors();
        return index >= errs.size() ? null : errs.get(index);
    }

    public int getErrorCount() {
        if (this.disableErrors) {
            return 0;
        }
        List<? extends Message> errs = this.getErrors();
        return errs.size();
    }

    private void addStaticTypingError(SyntaxErrorMessage m) {
        String msg = m.getCause().getMessage();
        if (!msg.startsWith("[Static type checking] - ")) {
            super.addErrorAndContinue((Message)m);
            return;
        }
        if (this.filtersError(msg)) {
            this.filteredErrors.add((Message)m);
            return;
        }
        if (this.getClosureContext() != null && (msg.startsWith("[Static type checking] - No such ") || msg.startsWith("[Static type checking] - The variable "))) {
            return;
        }
        this.staticAnalysisErrors.add((Message)m);
    }

    public List<Message> getAllErrors() {
        if (this.disableErrors) {
            return Collections.emptyList();
        }
        if (this.combinedErrors == null) {
            List base = super.getErrors();
            this.combinedErrors = new ArrayList<Message>();
            if (base != null) {
                this.combinedErrors.addAll(base);
            }
            this.combinedErrors.addAll(this.staticAnalysisErrors);
            if (this.showFilteredErrors) {
                this.combinedErrors.addAll(this.filteredErrors);
            }
        }
        return this.combinedErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addErrorAndContinue(String error, ASTNode node, SourceUnit source) {
        ASTNode n = this.errNode;
        this.errNode = node;
        try {
            super.addErrorAndContinue(error, node, source);
        }
        finally {
            this.errNode = n;
        }
    }

    public void addErrorAndContinue(Message message) {
        this.combinedErrors = null;
        if (this.errNode != null) {
            this.error2Node.put(message, this.errNode);
            this.node2Errors.computeIfAbsent(this.errNode, n -> new ArrayList(2)).add(message);
        }
        if (message instanceof SyntaxErrorMessage) {
            SyntaxErrorMessage sm = (SyntaxErrorMessage)message;
            this.addStaticTypingError(sm);
            return;
        }
        super.addErrorAndContinue(message);
    }

    public ASTNode getClosureContext() {
        return this.closureContext;
    }

    public ASTNode setClosureContext(ASTNode closureContext) {
        ASTNode save = this.closureContext;
        this.closureContext = closureContext;
        return save;
    }

    private void initErrorFilter() {
        if (errorFilter != null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        try (InputStream is = NbGroovyErrorCollector.class.getResourceAsStream(RESOURCE_FILTERED_ERRORS);
             BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("#") || (line = line.trim()).isEmpty()) continue;
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(line.trim());
            }
            errorFilter = Pattern.compile(sb.toString());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void markAmbiguous(Expression node, List<MethodNode> candidates, List<ClassNode> types) {
        this.amiguousCandidates.put(this.errNode, new AmbiguousReference(node, candidates, types));
    }

    public boolean filtersError(String msg) {
        if (!msg.startsWith("[Static type checking] - ")) {
            return false;
        }
        msg = msg.substring("[Static type checking] - ".length()).trim();
        return errorFilter.matcher(msg).matches();
    }

    static class AmbiguousReference {
        private final Expression astNode;
        private final List<MethodNode> candidates;
        private final List<ClassNode> parameterTypes;

        public AmbiguousReference(Expression astNode, List<MethodNode> candidates, List<ClassNode> parameterTypes) {
            this.astNode = astNode;
            this.candidates = candidates;
            this.parameterTypes = parameterTypes;
        }

        public Expression getAstNode() {
            return this.astNode;
        }

        public List<MethodNode> getCandidates() {
            return this.candidates;
        }

        public List<ClassNode> getParameterTypes() {
            return this.parameterTypes;
        }
    }

    static class NbStaticTypeCheckingVisitor
    extends StaticTypeCheckingVisitor {
        private final NbGroovyErrorCollector errCollector;

        NbStaticTypeCheckingVisitor(SourceUnit source, ClassNode classNode, NbGroovyErrorCollector errorCollector) {
            super(source, classNode);
            this.errCollector = errorCollector;
        }

        public void visitClosureExpression(ClosureExpression expression) {
            ASTNode save = this.errCollector.getClosureContext();
            try {
                this.errCollector.setClosureContext((ASTNode)expression);
                super.visitClosureExpression(expression);
            }
            finally {
                this.errCollector.setClosureContext(save);
            }
        }

        protected void addAmbiguousErrorMessage(List<MethodNode> foundMethods, String name, ClassNode[] args, Expression expr) {
            this.errCollector.markAmbiguous(expr, foundMethods, Arrays.asList(args));
            super.addAmbiguousErrorMessage(foundMethods, name, args, expr);
        }
    }
}

