/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.AtomicLockEvent;
import org.netbeans.api.editor.document.AtomicLockListener;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.impl.EmbeddingProviderFactory;
import org.netbeans.modules.parsing.impl.RunWhenScanFinishedSupport;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.Utilities;
import org.netbeans.modules.parsing.impl.indexing.ArchiveTimeStamps;
import org.netbeans.modules.parsing.impl.indexing.CacheFolder;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.ClusteredIndexables;
import org.netbeans.modules.parsing.impl.indexing.Crawler;
import org.netbeans.modules.parsing.impl.indexing.Debug;
import org.netbeans.modules.parsing.impl.indexing.DeletedIndexable;
import org.netbeans.modules.parsing.impl.indexing.EventKind;
import org.netbeans.modules.parsing.impl.indexing.FileEventLog;
import org.netbeans.modules.parsing.impl.indexing.FileObjectCrawler;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.FilteringIterable;
import org.netbeans.modules.parsing.impl.indexing.IndexBinaryWorkPool;
import org.netbeans.modules.parsing.impl.indexing.IndexabilityQuery;
import org.netbeans.modules.parsing.impl.indexing.IndexabilitySupport;
import org.netbeans.modules.parsing.impl.indexing.IndexerCache;
import org.netbeans.modules.parsing.impl.indexing.IndexingTask;
import org.netbeans.modules.parsing.impl.indexing.InjectedTasksSupport;
import org.netbeans.modules.parsing.impl.indexing.LogContext;
import org.netbeans.modules.parsing.impl.indexing.PathRecognizerRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryEvent;
import org.netbeans.modules.parsing.impl.indexing.PathRegistryListener;
import org.netbeans.modules.parsing.impl.indexing.ProxyIterable;
import org.netbeans.modules.parsing.impl.indexing.RootsListener;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.SuspendSupport;
import org.netbeans.modules.parsing.impl.indexing.TimeStamps;
import org.netbeans.modules.parsing.impl.indexing.TransientUpdateSupport;
import org.netbeans.modules.parsing.impl.indexing.URLCache;
import org.netbeans.modules.parsing.impl.indexing.Util;
import org.netbeans.modules.parsing.impl.indexing.errors.TaskCache;
import org.netbeans.modules.parsing.impl.indexing.friendapi.DownloadedIndexPatcher;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexDownloader;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingActivityInterceptor;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.impl.indexing.implspi.ActiveDocumentProvider;
import org.netbeans.modules.parsing.impl.indexing.implspi.CacheFolderProvider;
import org.netbeans.modules.parsing.impl.indexing.implspi.ContextProvider;
import org.netbeans.modules.parsing.impl.indexing.lucene.LayeredDocumentIndex;
import org.netbeans.modules.parsing.implspi.ProfilerSupport;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.DocumentIndexCache;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.PathRecognizer;
import org.netbeans.modules.parsing.spi.indexing.SourceIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.SuspendStatus;
import org.netbeans.modules.project.indexingbridge.IndexingBridge;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.lookup.Lookups;

public final class RepositoryUpdater
implements PathRegistryListener,
PropertyChangeListener,
DocumentListener,
AtomicLockListener,
ActiveDocumentProvider.ActiveDocumentListener {
    private static final int PROFILE_EXECUTION_DELAY_TRESHOLD = 120000;
    static final String PROP_SAMPLING = RepositoryUpdater.class.getName() + ".indexerSampling";
    private final FileEventLog eventQueue = new FileEventLog();
    private static RepositoryUpdater instance;
    private static final Logger LOGGER;
    private static final Logger TEST_LOGGER;
    private static final Logger PERF_LOGGER;
    private static final Logger SFEC_LOGGER;
    private static final Logger UI_LOGGER;
    private static final RequestProcessor RP;
    private static final RequestProcessor WORKER;
    private static final boolean NOT_INTERRUPTIBLE;
    private static final int FILE_LOCKS_DELAY;
    private static final String PROP_LAST_INDEXED_VERSION;
    private static final String PROP_LAST_DIRTY_VERSION;
    private static final String PROP_MODIFIED_UNDER_WRITE_LOCK;
    private static final String PROP_OWNING_SOURCE_ROOT_URL;
    private static final String PROP_OWNING_SOURCE_ROOT;
    private static final String PROP_OWNING_SOURCE_UNKNOWN_IN;
    private static final String INDEX_DOWNLOAD_FOLDER = "index-download";
    private static final boolean[] FD_NEW_SFB_ROOT;
    static final List<URL> UNKNOWN_ROOT;
    static final List<URL> NONEXISTENT_ROOT;
    static volatile Source unitTestActiveSource;
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Map<URL, List<URL>> scannedRoots2Dependencies = Collections.synchronizedMap(new TreeMap(new LexicographicComparator(true)));
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Map<URL, List<URL>> scannedBinaries2InvDependencies = Collections.synchronizedMap(new HashMap());
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Map<URL, List<URL>> scannedRoots2Peers = Collections.synchronizedMap(new TreeMap(new LexicographicComparator(true)));
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Set<URL> incompleteSeenRoots = Collections.synchronizedSet(new HashSet());
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Set<URL> scannedUnknown = Collections.synchronizedSet(new HashSet());
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    private final Set<URL> sourcesForBinaryRoots = Collections.synchronizedSet(new HashSet());
    private volatile State state = State.CREATED;
    private volatile Reference<Document> activeDocumentRef = null;
    private Lookup.Result<? extends IndexingActivityInterceptor> indexingActivityInterceptors = null;
    private IndexingController controller;
    private final Object lastOwningSourceRootCacheLock = new Object();
    private boolean ignoreIndexerCacheEvents = false;
    final RootsListener rootsListeners = RootsListener.newInstance();
    private final FileChangeListener sourceRootsListener = new FCL(this.rootsListeners.hasRecursiveListeners() ? Boolean.TRUE : null);
    private final FileChangeListener binaryRootsListener = new FCL(Boolean.FALSE);
    private final ThreadLocal<Boolean> inIndexer = new ThreadLocal();
    private final IndexabilitySupport visibilitySupport = IndexabilitySupport.create(this, RP);
    private final SuspendSupport suspendSupport = new SuspendSupport(WORKER);
    private final AtomicLong scannedRoots2DependenciesLamport = new AtomicLong();
    private final ActiveDocumentProvider activeDocProvider;
    private final OpenProjects globalOpenProjects;
    private final Task worker;
    private static final Map<List<StackTraceElement>, Long> lastRecordedStackTraces;
    private static long stackTraceId;
    private static final RequestProcessor SAMPLER_RP;
    private static volatile SamplerInvoker currentSampler;

    public static synchronized RepositoryUpdater getDefault() {
        if (instance == null) {
            instance = new RepositoryUpdater();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean force) {
        InitialRootsWork work = null;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.CREATED || this.state == State.STOPPED) {
                this.state = State.STARTED;
                this.worker.allCancelled = false;
                LOGGER.fine("Initializing...");
                this.indexingActivityInterceptors = Lookup.getDefault().lookupResult(IndexingActivityInterceptor.class);
                PathRegistry.getDefault().addPathRegistryListener(this);
                this.rootsListeners.setListener(this.sourceRootsListener, this.binaryRootsListener);
                this.activeDocProvider.addActiveDocumentListener(this);
                IndexerCache.getCifCache().addPropertyChangeListener(this);
                IndexerCache.getEifCache().addPropertyChangeListener(this);
                this.visibilitySupport.start();
                if (force) {
                    work = new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.incompleteSeenRoots, this.sourcesForBinaryRoots, false, this.scannedRoots2DependenciesLamport, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.PATH, null));
                }
            }
        }
        if (work != null) {
            this.scheduleWork(work, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@NullAllowed Runnable postCleanTask) throws TimeoutException {
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.STOPPED) {
                throw new IllegalStateException();
            }
            this.state = State.STOPPED;
            LOGGER.fine("Closing...");
            PathRegistry.getDefault().removePathRegistryListener(this);
            this.rootsListeners.setListener(null, null);
            this.activeDocProvider.removeActiveDocumentListener(this);
            this.visibilitySupport.stop();
        }
        this.worker.cancelAll(postCleanTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<IndexingState> getIndexingState() {
        boolean pathChanging;
        boolean openingProjects;
        boolean beforeInitialScanStarted;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            beforeInitialScanStarted = this.state == State.CREATED || this.state == State.STARTED;
        }
        try {
            Future f = this.globalOpenProjects.openProjects();
            openingProjects = !f.isDone() || ((Project[])f.get()).length > 0;
        }
        catch (Exception ie) {
            openingProjects = true;
        }
        EnumSet<IndexingState> result = EnumSet.noneOf(IndexingState.class);
        boolean starting = beforeInitialScanStarted && openingProjects;
        boolean working = this.worker.isWorking();
        boolean bl = pathChanging = !PathRegistry.getDefault().isFinished();
        if (starting) {
            result.add(IndexingState.STARTING);
        }
        if (pathChanging) {
            result.add(IndexingState.PATH_CHANGING);
        }
        if (working) {
            result.add(IndexingState.WORKING);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "IsScanInProgress: (starting: {0} | working: {1} | path are changing: {2})", new Object[]{starting, working, pathChanging});
        }
        return result;
    }

    public boolean isProtectedModeOwner(Thread thread) {
        return this.worker.isProtectedModeOwner(thread);
    }

    public boolean isIndexer() {
        return Objects.equals(this.inIndexer.get(), Boolean.TRUE);
    }

    public void runIndexer(Runnable indexer) {
        assert (indexer != null);
        this.inIndexer.set(Boolean.TRUE);
        try {
            indexer.run();
        }
        finally {
            this.inIndexer.remove();
        }
    }

    public boolean waitUntilFinished(long timeout) throws InterruptedException {
        return this.waitUntilFinished(timeout, false);
    }

    private boolean waitUntilFinished(long timeout, boolean relaxProtectedMode) throws InterruptedException {
        try {
            Callable<Boolean> call = () -> {
                long ts1;
                long ts2 = ts1 = System.currentTimeMillis();
                do {
                    boolean timedOut = !this.worker.waitUntilFinished(timeout);
                    ts2 = System.currentTimeMillis();
                    if (!timedOut) continue;
                    return false;
                } while (!this.getIndexingState().isEmpty() && (timeout <= 0L || ts2 - ts1 < timeout));
                return timeout <= 0L || ts2 - ts1 < timeout;
            };
            return relaxProtectedMode ? this.worker.runOffProtecedMode(call).booleanValue() : call.call().booleanValue();
        }
        catch (InterruptedException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    public void addIndexingJob(@NonNull URL rootUrl, @NullAllowed Collection<? extends URL> fileUrls, boolean followUpJob, boolean checkEditor, boolean wait, boolean forceRefresh, boolean steady, @NonNull LogContext logCtx) {
        FileListWork flw;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "addIndexingJob: rootUrl={0}, fileUrls={1}, followUpJob={2}, checkEditor={3}, wait={4}", new Object[]{rootUrl, fileUrls, followUpJob, checkEditor, wait});
        }
        if ((flw = this.createFileListWork(rootUrl, fileUrls, followUpJob, checkEditor, forceRefresh, steady, logCtx)) != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Scheduling index refreshing: root={0}, files={1}", new Object[]{rootUrl, fileUrls});
            }
            this.scheduleWork(flw, wait);
        }
    }

    void addDeleteJob(@NonNull URL root, @NonNull Set<String> relativePaths, @NonNull LogContext logCtx) {
        DeleteWork wrk = new DeleteWork(root, relativePaths, this.suspendSupport.getSuspendStatus(), logCtx);
        this.scheduleWork(wrk, false);
    }

    void addBinaryJob(@NonNull URL root, @NonNull LogContext logCtx) {
        BinaryWork wrk = new BinaryWork(root, this.suspendSupport.getSuspendStatus(), logCtx);
        this.scheduleWork(wrk, false);
    }

    public void enforcedFileListUpdate(@NonNull URL rootUrl, @NonNull Collection<? extends URL> fileUrls) throws IOException {
        final FileListWork flw = this.createFileListWork(rootUrl, fileUrls, false, true, true, false, null);
        if (flw != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Transient File List Update {0}", flw);
            }
            class T
            implements Callable<Void>,
            Runnable {
                T() {
                }

                @Override
                public void run() {
                    flw.doTheWork();
                }

                @Override
                public Void call() throws Exception {
                    RepositoryUpdater.this.suspendSupport.runWithNoSuspend(this);
                    return null;
                }
            }
            T t = new T();
            try {
                Utilities.runPriorityIO((Callable)t);
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
        }
    }

    @CheckForNull
    private FileListWork createFileListWork(@NonNull URL rootUrl, @NullAllowed Collection<? extends URL> fileUrls, boolean followUpJob, boolean checkEditor, boolean forceRefresh, boolean steady, @NullAllowed LogContext logCtx) {
        assert (rootUrl != null);
        assert (PathRegistry.noHostPart(rootUrl)) : rootUrl;
        FileObject root = URLCache.getInstance().findFileObject(rootUrl, true);
        if (root == null) {
            LOGGER.log(Level.FINE, "{0} can't be translated to FileObject", rootUrl);
            return null;
        }
        FileListWork flw = null;
        if (fileUrls != null && !fileUrls.isEmpty()) {
            HashSet<FileObject> files = new HashSet<FileObject>();
            for (URL uRL : fileUrls) {
                FileObject file = URLMapper.findFileObject((URL)uRL);
                if (file == null) continue;
                if (FileUtil.isParentOf((FileObject)root, (FileObject)file)) {
                    files.add(file);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "{0} does not lie under {1}, not indexing it", new Object[]{file, root});
            }
            if (!files.isEmpty()) {
                flw = new FileListWork(this.scannedRoots2Dependencies, rootUrl, files, followUpJob, checkEditor, forceRefresh, this.sourcesForBinaryRoots.contains(rootUrl), steady, this.suspendSupport.getSuspendStatus(), logCtx);
            }
        } else {
            flw = new FileListWork(this.scannedRoots2Dependencies, rootUrl, followUpJob, checkEditor, forceRefresh, this.sourcesForBinaryRoots.contains(rootUrl), this.suspendSupport.getSuspendStatus(), logCtx);
        }
        return flw;
    }

    public void addIndexingJob(@NonNull String indexerName, @NonNull LogContext logCtx) {
        Work w;
        Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "addIndexingJob: indexerName={0}", indexerName);
        }
        if ((cifInfos = IndexerCache.getCifCache().getIndexersByName(indexerName)) == null) {
            Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos = IndexerCache.getEifCache().getIndexersByName(indexerName);
            if (eifInfos == null) {
                throw new InvalidParameterException("No CustomIndexerFactory or EmbeddingIndexerFactory with name: '" + indexerName + "'");
            }
            w = new RefreshEifIndices(eifInfos, this.scannedRoots2Dependencies, this.incompleteSeenRoots, this.sourcesForBinaryRoots, this.suspendSupport.getSuspendStatus(), logCtx);
        } else {
            w = new RefreshCifIndices(cifInfos, this.scannedRoots2Dependencies, this.incompleteSeenRoots, this.sourcesForBinaryRoots, this.suspendSupport.getSuspendStatus(), logCtx);
        }
        this.scheduleWork(w, false);
    }

    public void refreshAll(boolean fullRescan, boolean wait, boolean logStatistics, @NullAllowed LogContext logCtx, Object ... filesOrFileObjects) {
        boolean ae = false;
        if (!$assertionsDisabled) {
            ae = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (ae) {
            for (Object fileOrFileObject : filesOrFileObjects) {
                if (!(fileOrFileObject instanceof File)) continue;
                File file = (File)fileOrFileObject;
                assert (file.equals(FileUtil.normalizeFile((File)file))) : String.format("File: %s is not normalized.", file.toString());
            }
        }
        FSRefreshInterceptor fsRefreshInterceptor = null;
        for (IndexingActivityInterceptor iai : this.indexingActivityInterceptors.allInstances()) {
            if (!(iai instanceof FSRefreshInterceptor)) continue;
            fsRefreshInterceptor = (FSRefreshInterceptor)iai;
            break;
        }
        this.scheduleWork(new RefreshWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.incompleteSeenRoots, this.sourcesForBinaryRoots, fullRescan, logStatistics, filesOrFileObjects == null ? Collections.emptySet() : Arrays.asList(filesOrFileObjects), fsRefreshInterceptor, this.suspendSupport.getSuspendStatus(), logCtx), wait);
    }

    public void suspend() {
        if (NOT_INTERRUPTIBLE) {
            return;
        }
        this.suspendSupport.suspend();
    }

    public void resume() {
        if (NOT_INTERRUPTIBLE) {
            return;
        }
        this.suspendSupport.resume();
    }

    public synchronized IndexingController getController() {
        if (this.controller == null) {
            this.controller = new Controller();
        }
        return this.controller;
    }

    @Override
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part. Already verified by PathRegistry")
    public void pathsChanged(PathRegistryEvent event) {
        assert (event != null);
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Paths changed:\n");
            for (PathRegistryEvent.Change change : event.getChanges()) {
                sb.append(" event=").append((Object)change.getEventKind());
                sb.append(" pathKind=").append((Object)change.getPathKind());
                sb.append(" pathType=").append(change.getPathId());
                sb.append(" affected paths:\n");
                Set<? extends ClassPath> paths = change.getAffectedPaths();
                if (paths != null) {
                    for (ClassPath classPath : paths) {
                        sb.append("  \"");
                        sb.append(classPath.toString(ClassPath.PathConversionMode.PRINT));
                        sb.append("\"\n");
                    }
                }
                sb.append("--\n");
            }
            sb.append("====\n");
            LOGGER.fine(sb.toString());
        }
        boolean existingPathsChanged = false;
        boolean containsRelevantChanges = false;
        LogContext logContext = event.getLogContext();
        ArrayList<URL> includesChanged = new ArrayList<URL>();
        for (PathRegistryEvent.Change change : event.getChanges()) {
            if (change.getEventKind() == EventKind.INCLUDES_CHANGED) {
                for (ClassPath classPath : change.getAffectedPaths()) {
                    for (ClassPath.Entry e : classPath.entries()) {
                        includesChanged.add(e.getURL());
                    }
                }
                continue;
            }
            containsRelevantChanges = true;
            if (change.getEventKind() != EventKind.PATHS_CHANGED) continue;
            existingPathsChanged = true;
        }
        if (containsRelevantChanges) {
            this.scheduleWork(new RootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.incompleteSeenRoots, this.sourcesForBinaryRoots, !existingPathsChanged, false, this.scannedRoots2DependenciesLamport, this.suspendSupport.getSuspendStatus(), logContext), false);
        }
        for (URL uRL : includesChanged) {
            this.scheduleWork(new FileListWork(this.scannedRoots2Dependencies, uRL, false, false, false, this.sourcesForBinaryRoots.contains(uRL), this.suspendSupport.getSuspendStatus(), logContext), false);
        }
    }

    private void fileFolderCreatedImpl(FileEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize(fe)) {
            return;
        }
        boolean processed = false;
        Pair<URL, FileObject> root = null;
        if (fo != null && fo.isValid()) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(fo)) != null && this.visibilitySupport.canIndex(fo, (FileObject)root.second())) {
                ClassPath.Entry entry;
                if (root.second() == null) {
                    LOGGER.log(Level.INFO, "Ignoring event from non existing FileObject {0}", root.first());
                    return;
                }
                boolean sourcForBinaryRoot = this.sourcesForBinaryRoots.contains(root.first());
                ClassPath.Entry entry2 = entry = sourcForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry((FileObject)root.second());
                if (entry == null || entry.includes(fo)) {
                    Work wrk;
                    if (fo.equals(root.second())) {
                        if (this.scannedRoots2Dependencies.get(root.first()) == NONEXISTENT_ROOT) {
                            wrk = new RootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.incompleteSeenRoots, this.sourcesForBinaryRoots, false, true, this.scannedRoots2DependenciesLamport, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).addRoots(Collections.singleton((URL)root.first())));
                        } else {
                            FileObject[] children = fo.getChildren();
                            List<FileObject> c = Arrays.asList(children);
                            wrk = children.length > 0 ? new FileListWork(this.scannedRoots2Dependencies, (URL)root.first(), c, false, false, true, sourcForBinaryRoot, true, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFileObjects(c)) : null;
                        }
                    } else {
                        Set<FileObject> c = Collections.singleton(fo);
                        wrk = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first(), c, false, false, true, sourcForBinaryRoot, true, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFileObjects(c));
                    }
                    if (wrk != null) {
                        this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first(), FileUtil.getRelativePath((FileObject)((FileObject)root.second()), (FileObject)fo), fe, wrk);
                    }
                    processed = true;
                }
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(fo)) == null || !this.visibilitySupport.canIndex(fo, (FileObject)root.second()))) {
                BinaryWork wrk = new BinaryWork((URL)root.first(), this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFileObjects(Collections.singleton(fo)));
                this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first(), null, fe, wrk);
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Folder created ({0}): {1} Owner: {2}", new Object[]{processed ? "processed" : "ignored", FileUtil.getFileDisplayName((FileObject)fo), root});
        }
    }

    private void fileChangedImpl(FileEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize(fe)) {
            return;
        }
        boolean processed = false;
        Pair<URL, FileObject> root = null;
        if (fo != null && fo.isValid()) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(fo)) != null && this.visibilitySupport.canIndex(fo, (FileObject)root.second())) {
                ClassPath.Entry entry;
                if (root.second() == null) {
                    LOGGER.log(Level.INFO, "Ignoring event from non existing FileObject {0}", root.first());
                    return;
                }
                boolean sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root.first());
                ClassPath.Entry entry2 = entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry((FileObject)root.second());
                if (entry == null || entry.includes(fo)) {
                    FileListWork wrk = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first(), Collections.singleton(fo), false, false, true, sourceForBinaryRoot, true, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFiles(Collections.singleton(fo.toURL())));
                    this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first(), FileUtil.getRelativePath((FileObject)((FileObject)root.second()), (FileObject)fo), fe, wrk);
                    processed = true;
                }
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(fo)) == null || !this.visibilitySupport.canIndex(fo, (FileObject)root.second()))) {
                BinaryWork wrk = new BinaryWork((URL)root.first(), this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFiles(Collections.singleton(fo.toURL())));
                this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first(), null, fe, wrk);
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "File modified ({0}): {1} Owner: {2}", new Object[]{processed ? "processed" : "ignored", FileUtil.getFileDisplayName((FileObject)fo), root});
        }
    }

    private void fileDeletedImpl(FileEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize(fe)) {
            return;
        }
        boolean processed = false;
        Pair<URL, FileObject> root = null;
        if (fo != null) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(fo)) != null && fo.isData() && this.visibilitySupport.canIndex(fo, (FileObject)root.second())) {
                try {
                    String relativePath = root.second() != null ? FileUtil.getRelativePath((FileObject)((FileObject)root.second()), (FileObject)fo) : ((URL)root.first()).toURI().relativize(fo.toURI()).getPath();
                    assert (relativePath != null) : "FileObject not under root: f=" + fo + ", root=" + root;
                    DeleteWork wrk = new DeleteWork((URL)root.first(), Collections.singleton(relativePath), this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFiles(Collections.singleton(fo.toURL())));
                    this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first(), relativePath, fe, wrk);
                    processed = true;
                }
                catch (URISyntaxException use) {
                    Exceptions.printStackTrace((Throwable)use);
                }
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(fo)) == null || !this.visibilitySupport.canIndex(fo, (FileObject)root.second()))) {
                BinaryWork wrk = new BinaryWork((URL)root.first(), this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFiles(Collections.singleton(fo.toURL())));
                this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first(), null, fe, wrk);
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "File deleted ({0}): {1} Owner: {2}", new Object[]{processed ? "processed" : "ignored", FileUtil.getFileDisplayName((FileObject)fo), root});
        }
    }

    private void fileRenamedImpl(FileRenameEvent fe, Boolean source) {
        FileObject fo = fe.getFile();
        if (this.isCacheFile(fo)) {
            return;
        }
        if (!this.authorize((FileEvent)fe)) {
            return;
        }
        FileObject newFile = fe.getFile();
        String oldNameExt = fe.getExt().length() == 0 ? fe.getName() : fe.getName() + "." + fe.getExt();
        Pair<URL, FileObject> root = null;
        boolean processed = false;
        if (newFile != null && newFile.isValid()) {
            if ((source == null || source.booleanValue()) && (root = this.getOwningSourceRoot(newFile)) != null) {
                String oldFilePath;
                if (root.second() == null) {
                    LOGGER.log(Level.INFO, "Ignoring event from non existing FileObject {0}", root.first());
                    return;
                }
                FileObject rootFo = (FileObject)root.second();
                if (rootFo.equals(newFile)) {
                    return;
                }
                String ownerPath = FileUtil.getRelativePath((FileObject)rootFo, (FileObject)newFile.getParent());
                String string = oldFilePath = ownerPath.length() == 0 ? oldNameExt : ownerPath + "/" + oldNameExt;
                if (newFile.isData()) {
                    DeleteWork work = new DeleteWork((URL)root.first(), Collections.singleton(oldFilePath), this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFilePaths(Collections.singleton(oldFilePath)));
                    this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first(), oldFilePath, (FileEvent)fe, work);
                } else {
                    HashSet<String> oldFilePaths = new HashSet<String>();
                    RepositoryUpdater.collectFilePaths(newFile, oldFilePath, oldFilePaths);
                    DeleteWork work = new DeleteWork((URL)root.first(), oldFilePaths, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFilePaths(oldFilePaths));
                    for (String path : oldFilePaths) {
                        this.eventQueue.record(FileEventLog.FileOp.DELETE, (URL)root.first(), path, (FileEvent)fe, work);
                    }
                }
                if (this.visibilitySupport.canIndex(newFile, (FileObject)root.second())) {
                    ClassPath.Entry entry;
                    boolean sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root.first());
                    ClassPath.Entry entry2 = entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                    if (entry == null || entry.includes(newFile)) {
                        FileListWork flw = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first(), Collections.singleton(newFile), false, false, true, sourceForBinaryRoot, true, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFileObjects(Collections.singleton(newFile)));
                        this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first(), FileUtil.getRelativePath((FileObject)rootFo, (FileObject)newFile), (FileEvent)fe, flw);
                    }
                }
                processed = true;
            }
            if (!(processed || source != null && source.booleanValue() || (root = this.getOwningBinaryRoot(newFile)) == null)) {
                File parentFile = FileUtil.toFile((FileObject)newFile.getParent());
                if (parentFile != null) {
                    try {
                        URL oldBinaryRoot = BaseUtilities.toURI((File)new File(parentFile, oldNameExt)).toURL();
                        this.eventQueue.record(FileEventLog.FileOp.DELETE, oldBinaryRoot, null, (FileEvent)fe, new BinaryWork(oldBinaryRoot, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).addRoots(Collections.singleton(oldBinaryRoot))));
                    }
                    catch (MalformedURLException mue) {
                        LOGGER.log(Level.WARNING, null, mue);
                    }
                }
                this.eventQueue.record(FileEventLog.FileOp.CREATE, (URL)root.first(), null, (FileEvent)fe, new BinaryWork((URL)root.first(), this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addRoots(Collections.singleton((URL)root.first()))));
                processed = true;
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "File renamed ({0}): {1} Owner: {2} Original Name: {3}", new Object[]{processed ? "processed" : "ignored", FileUtil.getFileDisplayName((FileObject)newFile), root, oldNameExt});
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != null && evt.getPropertyName().equals(CustomIndexerFactory.class.getName())) {
            if (!this.ignoreIndexerCacheEvents) {
                Set changedIndexers = (Set)evt.getNewValue();
                this.scheduleWork(new RefreshCifIndices(changedIndexers, this.scannedRoots2Dependencies, this.incompleteSeenRoots, this.sourcesForBinaryRoots, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.INDEXER, null)), false);
            }
        } else if (evt.getPropertyName() != null && evt.getPropertyName().equals(EmbeddingIndexerFactory.class.getName()) && !this.ignoreIndexerCacheEvents) {
            Set changedIndexers = (Set)evt.getNewValue();
            this.scheduleWork(new RefreshEifIndices(changedIndexers, this.scannedRoots2Dependencies, this.incompleteSeenRoots, this.sourcesForBinaryRoots, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.INDEXER, null)), false);
        }
    }

    @Override
    public void activeDocumentChanged(@NonNull ActiveDocumentProvider.ActiveDocumentEvent event) {
        this.handleActiveDocumentChange(event.getDeactivatedDocument(), event.getActivatedDocument());
        Collection<? extends Document> docs = event.getDocumentsToRefresh();
        if (!docs.isEmpty()) {
            class DocPropsSnapshot {
                final Document doc;
                final boolean openedInEditor;
                final long version;
                final Long lastIndexedVersion;
                final Long lastDirtyVersion;

                DocPropsSnapshot(Document doc) {
                    this.doc = doc;
                    this.openedInEditor = RepositoryUpdater.this.activeDocProvider.getActiveDocuments().contains(doc);
                    this.version = DocumentUtilities.getDocumentVersion((Document)doc);
                    this.lastIndexedVersion = (Long)doc.getProperty(PROP_LAST_INDEXED_VERSION);
                    this.lastDirtyVersion = (Long)doc.getProperty(PROP_LAST_DIRTY_VERSION);
                }
            }
            List docsProps = docs.stream().map(doc -> new DocPropsSnapshot((Document)doc)).collect(Collectors.toList());
            RP.execute(() -> {
                HashMap<URL, FileListWork> jobs = new HashMap<URL, FileListWork>();
                for (DocPropsSnapshot dp : docsProps) {
                    FileListWork job2;
                    Pair<URL, FileObject> root = this.getOwningSourceRoot(dp.doc);
                    if (root == null) continue;
                    if (root.second() == null) {
                        FileObject file = Utilities.getFileObject((Document)dp.doc);
                        assert (file == null || !file.isValid()) : "Expecting both owningSourceRootUrl=" + root.first() + " and owningSourceRoot=" + root.second();
                        continue;
                    }
                    boolean reindex = dp.openedInEditor ? (dp.lastIndexedVersion == null ? dp.lastDirtyVersion != null : dp.lastIndexedVersion < dp.version) : dp.lastDirtyVersion != null;
                    FileObject docFile = Utilities.getFileObject((Document)dp.doc);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "{0}: version={1}, lastIndexerVersion={2}, lastDirtyVersion={3}, openedInEditor={4} => reindex={5}", new Object[]{docFile.getPath(), dp.version, dp.lastIndexedVersion, dp.lastDirtyVersion, dp.openedInEditor, reindex});
                    }
                    if (!reindex) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Document modified (reindexing): {0} Owner: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)docFile), root.first()});
                    }
                    if ((job2 = (FileListWork)jobs.get(root.first())) == null) {
                        Set<FileObject> c = Collections.singleton(docFile);
                        job2 = new FileListWork(this.scannedRoots2Dependencies, (URL)root.first(), c, false, dp.openedInEditor, true, this.sourcesForBinaryRoots.contains(root.first()), false, this.suspendSupport.getSuspendStatus(), LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFileObjects(c));
                        jobs.put((URL)root.first(), job2);
                        continue;
                    }
                    job2.addFile(docFile);
                }
                jobs.values().forEach(job -> this.scheduleWork((Work)job, false));
            });
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.removeUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        Document d = e.getDocument();
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)d, LineDocument.class);
        if (ld != null) {
            d.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, true);
        } else {
            this.handleDocumentModification(d);
        }
    }

    public void atomicLock(AtomicLockEvent e) {
        Document d = (Document)e.getSource();
        d.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
    }

    public void atomicUnlock(AtomicLockEvent e) {
        Document d = (Document)e.getSource();
        Boolean modified = (Boolean)d.getProperty(PROP_MODIFIED_UNDER_WRITE_LOCK);
        d.putProperty(PROP_MODIFIED_UNDER_WRITE_LOCK, null);
        if (modified != null && modified.booleanValue()) {
            this.handleDocumentModification(d);
        }
    }

    private RepositoryUpdater() {
        LOGGER.log(Level.FINE, "netbeans.indexing.notInterruptible={0}", NOT_INTERRUPTIBLE);
        LOGGER.log(Level.FINE, "netbeans.indexing.recursiveListeners={0}", this.rootsListeners.hasRecursiveListeners());
        LOGGER.log(Level.FINE, "FILE_LOCKS_DELAY={0}", FILE_LOCKS_DELAY);
        this.activeDocProvider = (ActiveDocumentProvider)Lookup.getDefault().lookup(ActiveDocumentProvider.class);
        if (this.activeDocProvider == null) {
            throw new IllegalStateException("No ActiveDocumentProvider instance in global lookup.");
        }
        this.globalOpenProjects = OpenProjects.getDefault();
        this.worker = new Task(Lookup.getDefault());
    }

    private void handleActiveDocumentChange(Document deactivated, Document activated) {
        AtomicLockDocument ald;
        Document activeDocument;
        if (deactivated == null && activated == null) {
            return;
        }
        Document document = activeDocument = this.activeDocumentRef == null ? null : this.activeDocumentRef.get();
        if (activeDocument != null && deactivated == activeDocument) {
            ald = (AtomicLockDocument)LineDocumentUtils.as((Document)activeDocument, AtomicLockDocument.class);
            if (ald != null) {
                ald.removeAtomicLockListener((AtomicLockListener)this);
            }
            activeDocument.removeDocumentListener(this);
            this.activeDocumentRef = null;
            LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", activeDocument);
        }
        if (activated != null && activated != activeDocument) {
            if (activeDocument != null) {
                ald = (AtomicLockDocument)LineDocumentUtils.as((Document)activeDocument, AtomicLockDocument.class);
                if (ald != null) {
                    ald.removeAtomicLockListener((AtomicLockListener)this);
                }
                activeDocument.removeDocumentListener(this);
                LOGGER.log(Level.FINE, "Unregistering active document listener: activeDocument={0}", activeDocument);
            }
            activeDocument = activated;
            this.activeDocumentRef = new WeakReference<Document>(activeDocument);
            ald = (AtomicLockDocument)LineDocumentUtils.as((Document)activeDocument, AtomicLockDocument.class);
            if (ald != null) {
                ald.addAtomicLockListener((AtomicLockListener)this);
            }
            activeDocument.addDocumentListener(this);
            LOGGER.log(Level.FINE, "Registering active document listener: activeDocument={0}", activeDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDocumentModification(@NonNull Document document) {
        Reference<Document> ref = this.activeDocumentRef;
        Document activeDocument = ref == null ? null : ref.get();
        final Pair<URL, FileObject> root = this.getOwningSourceRoot(document);
        if (root != null) {
            if (root.second() == null) {
                LOGGER.log(Level.INFO, "Ignoring event from non existing FileObject {0}", root.first());
                return;
            }
            if (activeDocument == document) {
                long version = DocumentUtilities.getDocumentVersion((Document)activeDocument);
                Long lastDirtyVersion = (Long)activeDocument.getProperty(PROP_LAST_DIRTY_VERSION);
                boolean markDirty = false;
                if (lastDirtyVersion == null || lastDirtyVersion < version) {
                    markDirty = true;
                }
                activeDocument.putProperty(PROP_LAST_DIRTY_VERSION, version);
                if (markDirty) {
                    FileObject docFile = Utilities.getFileObject((Document)document);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Active document modified (marking dirty): {0} Owner: {1}", new Object[]{FileUtil.getFileDisplayName((FileObject)docFile), root.first()});
                    }
                    Set<Indexable> dirty = Collections.singleton(SPIAccessor.getInstance().create(new FileObjectIndexable((FileObject)root.second(), docFile)));
                    String mimeType = DocumentUtilities.getMimeType((Document)document);
                    TransientUpdateSupport.setTransientUpdate(true);
                    try {
                        Callable<FileObject> indexFolderFactory = new Callable<FileObject>(){
                            private FileObject cache;

                            @Override
                            public FileObject call() throws Exception {
                                if (this.cache == null) {
                                    this.cache = CacheFolder.getDataFolder((URL)root.first(), EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.CREATE);
                                }
                                return this.cache;
                            }
                        };
                        Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos = IndexerCache.getCifCache().getIndexersFor(mimeType, true);
                        for (IndexerCache.IndexerInfo<CustomIndexerFactory> info : cifInfos) {
                            try {
                                CustomIndexerFactory customIndexerFactory = info.getIndexerFactory();
                                Context ctx = SPIAccessor.getInstance().createContext(indexFolderFactory, (URL)root.first(), customIndexerFactory.getIndexerName(), customIndexerFactory.getIndexVersion(), null, false, true, false, SuspendSupport.NOP, null, null);
                                customIndexerFactory.filesDirty(dirty, ctx);
                            }
                            catch (IOException iOException) {
                                LOGGER.log(Level.WARNING, null, iOException);
                            }
                        }
                        Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos = RepositoryUpdater.collectEmbeddingIndexers(mimeType);
                        for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> indexerInfo : eifInfos) {
                            try {
                                EmbeddingIndexerFactory factory = indexerInfo.getIndexerFactory();
                                Context ctx = SPIAccessor.getInstance().createContext(indexFolderFactory, (URL)root.first(), factory.getIndexerName(), factory.getIndexVersion(), null, false, true, false, SuspendSupport.NOP, null, null);
                                factory.filesDirty(dirty, ctx);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.WARNING, null, ex);
                            }
                        }
                    }
                    finally {
                        TransientUpdateSupport.setTransientUpdate(false);
                    }
                }
            } else {
                FileObject f = Utilities.getFileObject((Document)document);
                Set<URL> c = Collections.singleton(f.toURL());
                this.addIndexingJob((URL)root.first(), c, false, true, false, true, false, LogContext.create(LogContext.EventType.FILE, null).withRoot((URL)root.first()).addFiles(c));
            }
        }
    }

    @NonNull
    private static Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> collectEmbeddingIndexers(@NonNull String topMimeType) {
        ArrayDeque result = new ArrayDeque();
        RepositoryUpdater.collectEmbeddingIndexers(topMimeType, result);
        return result;
    }

    private static void collectEmbeddingIndexers(@NonNull String mimeType, @NonNull Collection<? super IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> collector) {
        collector.addAll(IndexerCache.getEifCache().getIndexersFor(mimeType, true));
        for (EmbeddingProviderFactory epf : MimeLookup.getLookup((MimePath)MimePath.get((String)mimeType)).lookupAll(EmbeddingProviderFactory.class)) {
            RepositoryUpdater.collectEmbeddingIndexers(epf.getTargetMimeType(), collector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Iterable<? extends Work> multipleWork) {
        boolean canScheduleMultiple;
        RepositoryUpdater.recordCaller();
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            canScheduleMultiple = this.state == State.INITIAL_SCAN_RUNNING || this.state == State.ACTIVE;
        }
        if (canScheduleMultiple) {
            this.worker.schedule(multipleWork);
        } else {
            for (Work work : multipleWork) {
                this.scheduleWork(work, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleWork(Work work, boolean wait) {
        RepositoryUpdater.recordCaller();
        boolean scheduleExtraWork = false;
        RepositoryUpdater repositoryUpdater = this;
        synchronized (repositoryUpdater) {
            if (this.state == State.STARTED) {
                this.state = State.INITIAL_SCAN_RUNNING;
                scheduleExtraWork = !(work instanceof InitialRootsWork);
            }
        }
        if (scheduleExtraWork) {
            this.worker.schedule(new InitialRootsWork(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.incompleteSeenRoots, this.sourcesForBinaryRoots, true, this.scannedRoots2DependenciesLamport, this.suspendSupport.getSuspendStatus(), work == null ? LogContext.create(LogContext.EventType.PATH, null) : work.getLogContext()), false);
            if (work instanceof RootsWork) {
                return;
            }
        }
        if (work != null) {
            this.worker.schedule(work, wait);
        }
    }

    public void runAsWork(final @NonNull Runnable r) {
        assert (r != null);
        Work work = new Work(false, false, false, true, SuspendSupport.NOP, null){

            @Override
            protected boolean getDone() {
                r.run();
                return true;
            }
        };
        this.worker.schedule(work, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<URL, FileObject> getOwningSourceRoot(Object fileOrDoc) {
        ArrayList<URL> clone;
        FileObject file;
        Document doc = null;
        long current = this.scannedRoots2DependenciesLamport.get();
        Object object = this.lastOwningSourceRootCacheLock;
        synchronized (object) {
            if (fileOrDoc instanceof Document) {
                doc = (Document)fileOrDoc;
                file = Utilities.getFileObject((Document)doc);
                if (file == null) {
                    return null;
                }
                URL cachedSourceRootUrl = (URL)doc.getProperty(PROP_OWNING_SOURCE_ROOT_URL);
                FileObject cachedSourceRoot = (FileObject)doc.getProperty(PROP_OWNING_SOURCE_ROOT);
                if (cachedSourceRootUrl != null && cachedSourceRoot != null && cachedSourceRoot.isValid() && FileUtil.isParentOf((FileObject)cachedSourceRoot, (FileObject)file)) {
                    return Pair.of((Object)cachedSourceRootUrl, (Object)cachedSourceRoot);
                }
                Long unknownIn = (Long)doc.getProperty(PROP_OWNING_SOURCE_UNKNOWN_IN);
                if (unknownIn != null && unknownIn == current) {
                    return null;
                }
            } else if (fileOrDoc instanceof FileObject) {
                file = (FileObject)fileOrDoc;
            } else {
                return null;
            }
            clone = new ArrayList<URL>(this.scannedRoots2Dependencies.keySet());
        }
        assert (file != null);
        URL owningSourceRootUrl = null;
        FileObject owningSourceRoot = null;
        for (URL root : clone) {
            FileObject rootFo = URLCache.getInstance().findFileObject(root, false);
            if (rootFo != null) {
                if (!rootFo.equals(file) && !FileUtil.isParentOf((FileObject)rootFo, (FileObject)file)) continue;
                owningSourceRootUrl = root;
                owningSourceRoot = rootFo;
                break;
            }
            if (!file.toURL().toExternalForm().startsWith(root.toExternalForm())) continue;
            owningSourceRootUrl = root;
            owningSourceRoot = rootFo;
            break;
        }
        Object object2 = this.lastOwningSourceRootCacheLock;
        synchronized (object2) {
            if (owningSourceRootUrl != null) {
                if (doc != null && file.isValid()) {
                    assert (owningSourceRoot != null) : "Expecting both owningSourceRootUrl=" + owningSourceRootUrl + " and owningSourceRoot=" + owningSourceRoot;
                    doc.putProperty(PROP_OWNING_SOURCE_ROOT_URL, owningSourceRootUrl);
                    doc.putProperty(PROP_OWNING_SOURCE_ROOT, owningSourceRoot);
                }
                return Pair.of(owningSourceRootUrl, owningSourceRoot);
            }
            if (doc != null) {
                doc.putProperty(PROP_OWNING_SOURCE_UNKNOWN_IN, current);
            }
            return null;
        }
    }

    Pair<URL, FileObject> getOwningBinaryRoot(FileObject fo) {
        if (fo == null) {
            return null;
        }
        String foPath = fo.toURL().getPath();
        ArrayList<URL> clone = new ArrayList<URL>(this.scannedBinaries2InvDependencies.keySet());
        for (URL root : clone) {
            String filePath;
            URL fileURL = FileUtil.getArchiveFile((URL)root);
            boolean archive = true;
            if (fileURL == null) {
                fileURL = root;
                archive = false;
            }
            if ((filePath = fileURL.getPath()).equals(foPath)) {
                return Pair.of((Object)root, null);
            }
            if (archive || !foPath.startsWith(filePath)) continue;
            return Pair.of((Object)root, null);
        }
        return null;
    }

    @SuppressWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="URLs have never host part")
    private static ClassPath.Entry getClassPathEntry(FileObject root) {
        Set<String> ids;
        if (root != null && (ids = PathRegistry.getDefault().getSourceIdsFor(root.toURL())) != null) {
            for (String id : ids) {
                ClassPath cp = ClassPath.getClassPath((FileObject)root, (String)id);
                if (cp == null) continue;
                URL rootURL = root.toURL();
                for (ClassPath.Entry e : cp.entries()) {
                    if (!rootURL.equals(e.getURL())) continue;
                    return e;
                }
            }
        }
        return null;
    }

    private boolean authorize(FileEvent event) {
        Collection interceptors = this.indexingActivityInterceptors.allInstances();
        for (IndexingActivityInterceptor i : interceptors) {
            if (i.authorizeFileSystemEvent(event) != IndexingActivityInterceptor.Authorization.IGNORE) continue;
            return false;
        }
        return true;
    }

    public boolean isCacheFile(FileObject f) {
        return FileUtil.isParentOf((FileObject)CacheFolder.getCacheFolder(), (FileObject)f);
    }

    private static void collectFilePaths(FileObject folder, String pathPrefix, Set<String> collectedPaths) {
        assert (folder.isFolder()) : "Expecting folder: " + folder;
        if (folder.isValid()) {
            for (FileObject kid : folder.getChildren()) {
                if (!kid.isValid()) continue;
                String kidPath = pathPrefix + "/" + kid.getNameExt();
                if (kid.isData()) {
                    collectedPaths.add(kidPath);
                    continue;
                }
                RepositoryUpdater.collectFilePaths(kid, kidPath, collectedPaths);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS", "DMI_BLOCKING_METHODS_ON_URL"}, justification="URLs have never host part")
    private static boolean findDependencies(URL rootURL, DependenciesContext ctx, Set<String> sourceIds, Set<String> libraryIds, Set<String> binaryLibraryIds, @NonNull CancelRequest cancelRequest, @NonNull SuspendStatus suspendStatus) {
        List<URL> deps;
        try {
            suspendStatus.parkWhileSuspended();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (cancelRequest.isRaised()) {
            return false;
        }
        if (ctx.useInitialState && (deps = ctx.initialRoots2Deps.get(rootURL)) != null && deps != UNKNOWN_ROOT && (deps != NONEXISTENT_ROOT || !ctx.refreshNonExistentDeps)) {
            ctx.oldRoots.remove(rootURL);
            return true;
        }
        if (ctx.newRoots2Deps.containsKey(rootURL)) {
            return true;
        }
        FileObject rootFo = URLCache.getInstance().findFileObject(rootURL, true);
        if (rootFo == null) {
            ctx.newRoots2Deps.put(rootURL, NONEXISTENT_ROOT);
            return true;
        }
        LinkedList<URL> deps2 = new LinkedList<URL>();
        LinkedList<URL> peers = new LinkedList<URL>();
        boolean incomplete = false;
        ctx.cycleDetector.push(rootURL);
        try {
            Set<String> ids22;
            if (sourceIds == null || libraryIds == null || binaryLibraryIds == null) {
                ids22 = PathRegistry.getDefault().getSourceIdsFor(rootURL);
                if (null != ids22 && !ids22.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINER)) {
                        LOGGER.log(Level.FINER, "Resolving Ids based on sourceIds for {0}: {1}", new Object[]{rootURL, ids22});
                    }
                    HashSet<String> lids = new HashSet<String>();
                    HashSet blids = new HashSet();
                    for (String id : ids22) {
                        lids.addAll(PathRecognizerRegistry.getDefault().getLibraryIdsForSourceId(id));
                        blids.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForSourceId(id));
                    }
                    if (sourceIds == null) {
                        sourceIds = ids22;
                    }
                    if (libraryIds == null) {
                        libraryIds = lids;
                    }
                    if (binaryLibraryIds == null) {
                        binaryLibraryIds = blids;
                    }
                } else {
                    ids22 = PathRegistry.getDefault().getLibraryIdsFor(rootURL);
                    if (null != ids22 && !ids22.isEmpty()) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINER, "Resolving Ids based on libraryIds for {0}: {1}", new Object[]{rootURL, ids22});
                        }
                        HashSet<String> blids = new HashSet<String>();
                        for (String string : ids22) {
                            blids.addAll(PathRecognizerRegistry.getDefault().getBinaryLibraryIdsForLibraryId(string));
                        }
                        if (sourceIds == null) {
                            sourceIds = Collections.emptySet();
                        }
                        if (libraryIds == null) {
                            libraryIds = ids22;
                        }
                        if (binaryLibraryIds == null) {
                            binaryLibraryIds = blids;
                        }
                    } else if (sourceIds == null) {
                        sourceIds = Collections.emptySet();
                    }
                }
            }
            if (cancelRequest.isRaised()) {
                boolean ids22 = false;
                return ids22;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "SourceIds for {0}: {1}", new Object[]{rootURL, sourceIds});
                LOGGER.log(Level.FINER, "LibraryIds for {0}: {1}", new Object[]{rootURL, libraryIds});
                LOGGER.log(Level.FINER, "BinaryLibraryIds for {0}: {1}", new Object[]{rootURL, binaryLibraryIds});
            }
            for (String id : sourceIds) {
                if (cancelRequest.isRaised()) {
                    boolean blids = false;
                    return blids;
                }
                ClassPath cp2 = ClassPath.getClassPath((FileObject)rootFo, (String)id);
                if (cp2 == null) continue;
                incomplete |= PathRegistry.isIncompleteClassPath(cp2);
                for (ClassPath.Entry entry : cp2.entries()) {
                    if (cancelRequest.isRaised()) {
                        boolean bl = false;
                        return bl;
                    }
                    URL sourceRoot2 = entry.getURL();
                    assert (PathRegistry.noHostPart(sourceRoot2)) : sourceRoot2;
                    if (rootURL.equals(sourceRoot2)) continue;
                    peers.add(entry.getURL());
                }
            }
            if (libraryIds != null) {
                ids22 = libraryIds.iterator();
                while (ids22.hasNext()) {
                    String id;
                    id = (String)ids22.next();
                    if (cancelRequest.isRaised()) {
                        boolean cp2 = false;
                        return cp2;
                    }
                    ClassPath cp = ClassPath.getClassPath((FileObject)rootFo, (String)id);
                    if (cp == null) continue;
                    incomplete |= PathRegistry.isIncompleteClassPath(cp);
                    for (ClassPath.Entry entry : cp.entries()) {
                        if (cancelRequest.isRaised()) {
                            boolean sourceRoot2 = false;
                            return sourceRoot2;
                        }
                        URL sourceRoot = entry.getURL();
                        if (sourceRoot.equals(rootURL) || ctx.cycleDetector.contains(sourceRoot)) continue;
                        deps2.add(sourceRoot);
                        assert (PathRegistry.noHostPart(sourceRoot)) : sourceRoot;
                        if (RepositoryUpdater.findDependencies(sourceRoot, ctx, sourceIds, (Set<String>)libraryIds, binaryLibraryIds, cancelRequest, suspendStatus)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            Set<String> ids = binaryLibraryIds == null ? PathRecognizerRegistry.getDefault().getBinaryLibraryIds() : binaryLibraryIds;
            for (String id : ids) {
                if (cancelRequest.isRaised()) {
                    boolean bl = false;
                    return bl;
                }
                ClassPath classPath = ClassPath.getClassPath((FileObject)rootFo, (String)id);
                if (classPath == null) continue;
                incomplete |= PathRegistry.isIncompleteClassPath(classPath);
                for (ClassPath.Entry entry : classPath.entries()) {
                    Set<String> srcIdsForBinRoot;
                    if (cancelRequest.isRaised()) {
                        boolean bl = false;
                        return bl;
                    }
                    URL binaryRoot = entry.getURL();
                    URL[] sourceRoots = PathRegistry.getDefault().sourceForBinaryQuery(binaryRoot, classPath, false, FD_NEW_SFB_ROOT);
                    boolean newSFBRoot = FD_NEW_SFB_ROOT[0];
                    if (sourceRoots != null) {
                        for (URL sourceRoot3 : sourceRoots) {
                            if (cancelRequest.isRaised()) {
                                boolean bl = false;
                                return bl;
                            }
                            if (newSFBRoot) {
                                ctx.newlySFBTranslated.add(sourceRoot3);
                            }
                            if (sourceRoot3.equals(rootURL)) {
                                ctx.sourcesForBinaryRoots.add(rootURL);
                                continue;
                            }
                            if (ctx.cycleDetector.contains(sourceRoot3)) continue;
                            deps2.add(sourceRoot3);
                            if (RepositoryUpdater.findDependencies(sourceRoot3, ctx, sourceIds, (Set<String>)libraryIds, binaryLibraryIds, cancelRequest, suspendStatus)) continue;
                            boolean bl = false;
                            return bl;
                        }
                        continue;
                    }
                    if (ctx.useInitialState) {
                        if (!ctx.initialBinaries2InvDeps.containsKey(binaryRoot)) {
                            ctx.newBinariesToScan.add(binaryRoot);
                            binDeps = ctx.newBinaries2InvDeps.get(binaryRoot);
                            if (binDeps == null) {
                                binDeps = new LinkedList<URL>();
                                ctx.newBinaries2InvDeps.put(binaryRoot, binDeps);
                            }
                            binDeps.add(rootURL);
                        }
                    } else {
                        ctx.newBinariesToScan.add(binaryRoot);
                        binDeps = ctx.newBinaries2InvDeps.get(binaryRoot);
                        if (binDeps == null) {
                            binDeps = new LinkedList<URL>();
                            ctx.newBinaries2InvDeps.put(binaryRoot, binDeps);
                        }
                        binDeps.add(rootURL);
                    }
                    if ((srcIdsForBinRoot = PathRegistry.getDefault().getSourceIdsFor(binaryRoot)) == null || srcIdsForBinRoot.isEmpty()) {
                        if (binaryRoot.equals(rootURL) || ctx.cycleDetector.contains(binaryRoot)) continue;
                        deps2.add(binaryRoot);
                        continue;
                    }
                    LOGGER.log(Level.INFO, "The root {0} is registered for both {1} and {2}", new Object[]{binaryRoot, id, srcIdsForBinRoot});
                }
            }
        }
        finally {
            ctx.cycleDetector.pop();
        }
        IncompleteStatus incompleteStatus = IncompleteStatus.get(incomplete, rootURL, ctx);
        if (incompleteStatus.active()) {
            ctx.newRoots2Deps.put(rootURL, deps2);
            ctx.newRoots2Peers.put(rootURL, peers);
            if (!incompleteStatus.shouldScan()) {
                ctx.newIncompleteSeenRoots.add(rootURL);
            }
        }
        return true;
    }

    private static Map<FileObject, Document> getEditorFiles() {
        HashMap<FileObject, Document> f2d = new HashMap<FileObject, Document>();
        for (Document document : RepositoryUpdater.getDefault().activeDocProvider.getActiveDocuments()) {
            FileObject f = Utilities.getFileObject((Document)document);
            if (f == null) continue;
            f2d.put(f, document);
        }
        return f2d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordCaller() {
        if (!LOGGER.isLoggable(Level.FINE)) {
            return;
        }
        Map<List<StackTraceElement>, Long> map = lastRecordedStackTraces;
        synchronized (map) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> stackTraceList = new ArrayList<StackTraceElement>(stackTrace.length);
            stackTraceList.addAll(Arrays.asList(stackTrace));
            Long id = lastRecordedStackTraces.get(stackTraceList);
            if (id == null) {
                id = stackTraceId++;
                lastRecordedStackTraces.put(stackTraceList, id);
                StringBuilder sb = new StringBuilder();
                sb.append("RepositoryUpdater caller [id=").append(id).append("] :\n");
                for (StackTraceElement e : stackTraceList) {
                    sb.append(e.toString());
                    sb.append("\n");
                }
                LOGGER.fine(sb.toString());
            } else {
                StackTraceElement caller = Util.findCaller(stackTrace, new Object[0]);
                LOGGER.log(Level.FINE, "RepositoryUpdater caller [refid={0}]: {1}", new Object[]{id, caller});
            }
        }
    }

    @NullUnknown
    private static <T> T runInContext(@NonNull FileObject file, @NonNull Callable<T> action) throws IOException {
        Lookup context = ContextProvider.getContext(file);
        return RepositoryUpdater.runInContext(context, action);
    }

    @NullUnknown
    private static <T> T runInContext(@NonNull URL url, @NonNull Callable<T> action) throws IOException {
        Lookup context = ContextProvider.getContext(url);
        return RepositoryUpdater.runInContext(context, action);
    }

    @NullUnknown
    private static <T> T runInContext(@NonNull Lookup context, @NonNull Callable<T> action) throws IOException {
        assert (context != null);
        assert (action != null);
        ArrayList res = new ArrayList(1);
        try {
            Lookups.executeWith((Lookup)context, () -> {
                try {
                    res.add(action.call());
                }
                catch (Exception e) {
                    RepositoryUpdater.sthrow(e);
                }
            });
            return (T)res.get(0);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    private static <R, T extends Throwable> R sthrow(@NonNull Throwable t) throws T {
        throw t;
    }

    private static Function<Indexable, Boolean> indexableFilter(CustomIndexerFactory factory, URL rootUrl) {
        Function<Indexable, Boolean> canBeIndexed = indexable -> !IndexabilityQuery.getInstance().preventIndexing(factory.getIndexerName(), indexable.getURL(), rootUrl);
        return canBeIndexed;
    }

    private static Function<Indexable, Boolean> notIndexableFilter(CustomIndexerFactory factory, URL rootUrl) {
        Function<Indexable, Boolean> canBeIndexed = indexable -> IndexabilityQuery.getInstance().preventIndexing(factory.getIndexerName(), indexable.getURL(), rootUrl);
        return canBeIndexed;
    }

    State getState() {
        return this.state;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    Set<URL> getScannedBinaries() {
        return this.scannedBinaries2InvDependencies.keySet();
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    Set<URL> getScannedSources() {
        return this.scannedRoots2Dependencies.keySet();
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    Map<URL, List<URL>> getScannedRoots2Dependencies() {
        return this.scannedRoots2Dependencies;
    }

    @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
    Set<URL> getScannedUnknowns() {
        return this.scannedUnknown;
    }

    void ignoreIndexerCacheEvents(boolean ignore) {
        this.ignoreIndexerCacheEvents = ignore;
    }

    static {
        LOGGER = Logger.getLogger(RepositoryUpdater.class.getName());
        TEST_LOGGER = Logger.getLogger(RepositoryUpdater.class.getName() + ".tests");
        PERF_LOGGER = Logger.getLogger(RepositoryUpdater.class.getName() + ".perf");
        SFEC_LOGGER = Logger.getLogger("org.netbeans.ui.ScanForExternalChanges");
        UI_LOGGER = Logger.getLogger("org.netbeans.ui.indexing");
        RP = new RequestProcessor("RepositoryUpdater.delay");
        WORKER = new RequestProcessor("RepositoryUpdater.worker", 1, false, false);
        NOT_INTERRUPTIBLE = Util.getSystemBoolean("netbeans.indexing.notInterruptible", false);
        FILE_LOCKS_DELAY = BaseUtilities.isWindows() ? 2000 : 1000;
        PROP_LAST_INDEXED_VERSION = RepositoryUpdater.class.getName() + "-last-indexed-document-version";
        PROP_LAST_DIRTY_VERSION = RepositoryUpdater.class.getName() + "-last-dirty-document-version";
        PROP_MODIFIED_UNDER_WRITE_LOCK = RepositoryUpdater.class.getName() + "-modified-under-write-lock";
        PROP_OWNING_SOURCE_ROOT_URL = RepositoryUpdater.class.getName() + "-owning-source-root-url";
        PROP_OWNING_SOURCE_ROOT = RepositoryUpdater.class.getName() + "-owning-source-root";
        PROP_OWNING_SOURCE_UNKNOWN_IN = RepositoryUpdater.class.getName() + "-owning-source-root-unknown-in";
        FD_NEW_SFB_ROOT = new boolean[1];
        UNKNOWN_ROOT = Collections.unmodifiableList(new LinkedList());
        NONEXISTENT_ROOT = Collections.unmodifiableList(new LinkedList());
        lastRecordedStackTraces = new HashMap<List<StackTraceElement>, Long>();
        stackTraceId = 0L;
        SAMPLER_RP = new RequestProcessor("Repository Updater Sampler");
    }

    static enum State {
        CREATED,
        STARTED,
        INITIAL_SCAN_RUNNING,
        ACTIVE,
        STOPPED;

    }

    private static final class Task
    implements Runnable {
        private final List<Work> todo = new LinkedList<Work>();
        private final List<Long> protectedOwners = new LinkedList<Long>();
        private final Lookup globalLookup;
        private Thread offProtectedMode;
        private boolean followUpWorksSorted = true;
        private Work workInProgress = null;
        private boolean scheduled = false;
        private boolean allCancelled = false;
        private List<Runnable> followupTasks = null;

        Task(@NonNull Lookup context) {
            Parameters.notNull((CharSequence)"context", (Object)context);
            this.globalLookup = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Iterable<? extends Work> multipleWork) {
            List<Work> list = this.todo;
            synchronized (list) {
                for (Work work : multipleWork) {
                    this.schedule(work, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(Work work, boolean wait) {
            boolean waitForWork = false;
            if (wait && Utilities.holdsParserLock()) {
                throw new IllegalStateException("Caller holds TaskProcessor.parserLock, which may cause deadlock.");
            }
            List<Work> list = this.todo;
            synchronized (list) {
                assert (work != null);
                if (!this.allCancelled) {
                    LogContext wlctx;
                    boolean canceled = false;
                    ArrayList follow = new ArrayList(1);
                    if (this.workInProgress != null && this.workInProgress.cancelBy(work, follow)) {
                        LogContext wplctx = this.workInProgress.getLogContext();
                        if (wplctx != null) {
                            wlctx = work.getLogContext();
                            if (wlctx != null) {
                                wlctx.absorb(wplctx);
                            } else {
                                work.setLogContext(wplctx);
                            }
                        }
                        canceled = true;
                    }
                    Work absorbedBy = null;
                    if (!wait) {
                        Work lastDel = null;
                        if (work instanceof FileListWork) {
                            FileListWork flw = (FileListWork)work;
                            for (Work w : this.todo) {
                                if (!(w instanceof DeleteWork) || !((DeleteWork)w).root.equals(flw.root)) continue;
                                lastDel = w;
                            }
                        }
                        for (Work w : this.todo) {
                            if (lastDel == null) {
                                if (!w.absorb(work)) continue;
                                absorbedBy = w;
                                break;
                            }
                            if (w != lastDel) continue;
                            lastDel = null;
                        }
                    }
                    if (absorbedBy == null) {
                        LOGGER.log(Level.FINE, "Scheduling {0}", work);
                        if (canceled) {
                            this.todo.add(0, work);
                            this.todo.addAll(1, follow);
                        } else {
                            this.todo.add(work);
                        }
                    } else {
                        wlctx = work.getLogContext();
                        LogContext alctx = absorbedBy.getLogContext();
                        if (alctx != null) {
                            if (wlctx != null) {
                                alctx.absorb(wlctx);
                            }
                        } else {
                            absorbedBy.setLogContext(wlctx);
                        }
                        if (canceled) {
                            this.todo.remove(absorbedBy);
                            this.todo.add(0, absorbedBy);
                            this.todo.addAll(1, follow);
                        }
                        LOGGER.log(Level.FINE, "Work absorbed {0}", work);
                    }
                    this.followUpWorksSorted = false;
                    if (!this.scheduled && (this.protectedOwners.isEmpty() || this.offProtectedMode == Thread.currentThread())) {
                        this.scheduled = true;
                        LOGGER.fine("scheduled = true");
                        WORKER.submit((Runnable)this);
                    }
                    waitForWork = wait;
                }
            }
            if (waitForWork) {
                LOGGER.log(Level.FINE, "Waiting for {0}", work);
                work.waitUntilDone();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cancelAll(final @NullAllowed Runnable postCleanTask) throws TimeoutException {
            List<Work> list = this.todo;
            synchronized (list) {
                if (!this.allCancelled) {
                    this.todo.clear();
                    if (postCleanTask != null) {
                        this.schedule(new Work(false, false, false, true, SuspendSupport.NOP, null){

                            @Override
                            protected boolean getDone() {
                                postCleanTask.run();
                                return true;
                            }
                        }, false);
                    }
                    this.allCancelled = true;
                    Work work = this.workInProgress;
                    if (work != null) {
                        work.setCancelled(true);
                    }
                    int cnt = 10;
                    while (this.scheduled && cnt-- > 0) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Waiting for indexing jobs to finish; job in progress: {0}, jobs queue: {1}", new Object[]{work, this.todo});
                        }
                        try {
                            this.todo.wait(1000L);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                            break;
                        }
                    }
                    if (this.scheduled && cnt == 0) {
                        LOGGER.log(Level.INFO, "Waiting for indexing jobs to finish timed out; job in progress {0}, jobs queue: {1}", new Object[]{work, this.todo});
                        throw new TimeoutException();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isWorking() {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.scheduled;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enterProtectedMode(@NullAllowed Long id) {
            List<Work> list = this.todo;
            synchronized (list) {
                this.protectedOwners.add(id);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Entering protected mode: {0}", this.protectedOwners.toString());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exitProtectedMode(@NullAllowed Long id, @NullAllowed Runnable followupTask) {
            List<Work> list = this.todo;
            synchronized (list) {
                if (this.protectedOwners.isEmpty()) {
                    throw new IllegalStateException("Calling exitProtectedMode without enterProtectedMode");
                }
                if (followupTask != null) {
                    if (this.followupTasks == null) {
                        this.followupTasks = new LinkedList<Runnable>();
                    }
                    this.followupTasks.add(followupTask);
                }
                this.protectedOwners.remove(id);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Exiting protected mode: {0}", this.protectedOwners.toString());
                }
                if (this.protectedOwners.isEmpty()) {
                    List<Object> tasks = this.followupTasks != null ? this.followupTasks : Collections.emptyList();
                    this.followupTasks = null;
                    this.scheduleDelayed(tasks, FILE_LOCKS_DELAY);
                    LOGGER.log(Level.FINE, "Protected mode exited, scheduling postprocess tasks: {0}", tasks);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T runOffProtecedMode(@NonNull Callable<T> call) throws Exception {
            List<Work> list = this.todo;
            synchronized (list) {
                this.offProtectedMode = Thread.currentThread();
                this.scheduleDelayed(Collections.emptyList(), 0);
            }
            try {
                list = call.call();
                return (T)list;
            }
            finally {
                List<Work> list2 = this.todo;
                synchronized (list2) {
                    this.offProtectedMode = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInProtectedMode() {
            List<Work> list = this.todo;
            synchronized (list) {
                return !this.protectedOwners.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isProtectedModeOwner(Thread thread) {
            List<Work> list = this.todo;
            synchronized (list) {
                return this.protectedOwners.contains(thread.getId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitUntilFinished(long timeout) throws InterruptedException {
            if (Utilities.holdsParserLock()) {
                throw new IllegalStateException("Can't wait for indexing to finish from inside a running parser task");
            }
            List<Work> list = this.todo;
            synchronized (list) {
                while (this.scheduled) {
                    if (timeout > 0L) {
                        this.todo.wait(timeout);
                        return !this.scheduled;
                    }
                    this.todo.wait();
                }
            }
            return true;
        }

        @Override
        public void run() {
            try {
                Utilities.runPriorityIO((Callable)new Callable<Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call() throws Exception {
                        try {
                            RunWhenScanFinishedSupport.performScan(() -> this._run(), (Lookup)globalLookup);
                        }
                        finally {
                            List<Work> list = todo;
                            synchronized (list) {
                                if (!protectedOwners.isEmpty() && offProtectedMode == null || todo.isEmpty()) {
                                    scheduled = false;
                                    LOGGER.fine("scheduled = false");
                                } else {
                                    WORKER.submit((Callable)this);
                                }
                                todo.notifyAll();
                            }
                            RunWhenScanFinishedSupport.performDeferredTasks();
                        }
                        return null;
                    }
                });
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }

        @NonNull
        public Lookup getGlobalContext() {
            return this.globalLookup;
        }

        /*
         * Exception decompiling
         */
        private void _run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        private Work getWork() {
            List<Work> list = this.todo;
            synchronized (list) {
                Work w;
                if ((this.protectedOwners.isEmpty() || this.offProtectedMode != null) && !this.todo.isEmpty()) {
                    w = this.todo.remove(0);
                    if (w instanceof FileListWork && ((FileListWork)w).isFollowUpJob() && !this.followUpWorksSorted) {
                        ArrayList sortedRoots;
                        HashMap<URL, LinkedList<FileListWork>> toSort = new HashMap<URL, LinkedList<FileListWork>>();
                        toSort.put(((FileListWork)w).root, new LinkedList<FileListWork>(Arrays.asList((FileListWork)w)));
                        Iterator<Work> it = this.todo.iterator();
                        while (it.hasNext()) {
                            Work current = it.next();
                            if (!(current instanceof FileListWork) || !((FileListWork)current).isFollowUpJob()) continue;
                            LinkedList<FileListWork> currentWorks = (LinkedList<FileListWork>)toSort.get(((FileListWork)current).root);
                            if (currentWorks == null) {
                                currentWorks = new LinkedList<FileListWork>();
                                toSort.put(((FileListWork)current).root, currentWorks);
                            }
                            currentWorks.add((FileListWork)current);
                            it.remove();
                        }
                        try {
                            sortedRoots = new ArrayList(BaseUtilities.topologicalSort(toSort.keySet(), RepositoryUpdater.getDefault().scannedRoots2Dependencies));
                        }
                        catch (TopologicalSortException tse) {
                            LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", tse);
                            List partialSort = tse.partialSort();
                            sortedRoots = new ArrayList(partialSort);
                        }
                        Collections.reverse(sortedRoots);
                        for (URL url : sortedRoots) {
                            List flws = (List)toSort.get(url);
                            if (flws == null) continue;
                            this.todo.addAll(flws);
                        }
                        this.followUpWorksSorted = true;
                        w = this.todo.remove(0);
                    }
                } else {
                    w = null;
                }
                this.workInProgress = w;
                return w;
            }
        }

        private void scheduleDelayed(final @NonNull Collection<? extends Runnable> tasks, int delay) {
            Runnable run = () -> this.schedule(new Work(false, false, false, true, SuspendSupport.NOP, null){

                @Override
                protected boolean getDone() {
                    for (Runnable task : tasks) {
                        try {
                            task.run();
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.WARNING, null, t);
                        }
                    }
                    return true;
                }
            }, false);
            if (delay == 0) {
                run.run();
            } else {
                RP.create(run).schedule(delay);
            }
        }

        public static final class IndexingBridgeImpl
        extends IndexingBridge.Ordering {
            protected void enterProtectedMode() {
                RepositoryUpdater.getDefault().worker.enterProtectedMode(null);
            }

            protected void exitProtectedMode() {
                RepositoryUpdater.getDefault().worker.exitProtectedMode(null, null);
            }

            protected void await() throws InterruptedException {
                RepositoryUpdater.getDefault().waitUntilFinished(-1L, true);
            }
        }
    }

    private final class InitialRootsWork
    extends RootsWork {
        private final boolean waitForProjects;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public InitialRootsWork(Map<URL, List<URL>> scannedRoots2Depencencies, Map<URL, List<URL>> scannedBinaries2InvDependencies, Map<URL, List<URL>> scannedRoots2Peers, Set<URL> incompleteSeenRoots, Set<URL> sourcesForBinaryRoots, @NonNull boolean waitForProjects, @NonNull AtomicLong scannedRoots2DependenciesLamport, @NullAllowed SuspendStatus suspendStatus, LogContext logCtx) {
            super(scannedRoots2Depencencies, scannedBinaries2InvDependencies, scannedRoots2Peers, incompleteSeenRoots, sourcesForBinaryRoots, true, true, scannedRoots2DependenciesLamport, suspendStatus, logCtx);
            this.waitForProjects = waitForProjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean getDone() {
            if (this.waitForProjects) {
                boolean retry = true;
                this.suspendProgress(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_OpeningProjects"));
                while (retry) {
                    try {
                        OpenProjects.getDefault().openProjects().get(1000L, TimeUnit.MILLISECONDS);
                        retry = false;
                    }
                    catch (TimeoutException ex) {
                        if (!this.isCancelledExternally()) continue;
                        boolean bl = false;
                        if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                            RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                            synchronized (repositoryUpdater) {
                                if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                                    RepositoryUpdater.this.state = State.ACTIVE;
                                }
                            }
                        }
                        return bl;
                    }
                    catch (Exception ex) {
                        retry = false;
                    }
                }
            }
            this.getSourceIndexers(true);
            boolean bl = super.getDone();
            return bl;
            finally {
                if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                    RepositoryUpdater repositoryUpdater = RepositoryUpdater.this;
                    synchronized (repositoryUpdater) {
                        if (RepositoryUpdater.this.state == State.INITIAL_SCAN_RUNNING) {
                            RepositoryUpdater.this.state = State.ACTIVE;
                        }
                    }
                }
            }
        }
    }

    static abstract class Work {
        private static long lastScanEnded = -1L;
        private final AtomicBoolean cancelled = new AtomicBoolean(false);
        private final AtomicBoolean finished = new AtomicBoolean(false);
        private final AtomicBoolean externalCancel = new AtomicBoolean(false);
        private final boolean followUpJob;
        private final boolean checkEditor;
        private final boolean steady;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final CancelRequestImpl cancelRequest = new CancelRequestImpl(this.cancelled);
        private final String progressTitle;
        private final SuspendStatus suspendStatus;
        private volatile LogContext logCtx;
        private final Object progressLock = new Object();
        private ProgressHandle progressHandle = null;
        private int progress = -1;
        private final Map<String, int[]> indexerStatistics = Collections.synchronizedMap(new HashMap());
        private volatile boolean reportIndexerStatistics;
        private volatile SourceIndexers sourceIndexers;
        protected int modifiedResourceCount;
        protected int allResourceCount;
        private static final String ALL_MIME_TYPES = "";

        protected Work(boolean followUpJob, boolean checkEditor, boolean supportsProgress, boolean steady, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            this(followUpJob, checkEditor, supportsProgress ? NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_BackgroundCompileStart") : null, steady, suspendStatus, logCtx);
        }

        protected Work(boolean followUpJob, boolean checkEditor, String progressTitle, boolean steady, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            assert (suspendStatus != null);
            this.followUpJob = followUpJob;
            this.checkEditor = checkEditor;
            this.progressTitle = progressTitle;
            this.steady = steady;
            this.suspendStatus = suspendStatus;
            this.logCtx = logCtx;
        }

        @NonNull
        protected final SourceIndexers getSourceIndexers(boolean initialRootsWork) {
            assert (!initialRootsWork || this.sourceIndexers == null);
            if (this.sourceIndexers == null) {
                this.sourceIndexers = SourceIndexers.load(initialRootsWork);
            }
            return this.sourceIndexers;
        }

        protected final void inheritChangedIndexers(@NonNull Work from) {
            SourceIndexers si = from.sourceIndexers;
            if (si != null && (si.changedCifs != null && !si.changedCifs.isEmpty() || si.changedEifs != null && !si.changedEifs.isEmpty())) {
                this.sourceIndexers = si;
            }
        }

        @CheckForNull
        protected final LogContext getLogContext() {
            return this.logCtx;
        }

        protected final void setLogContext(@NullAllowed LogContext logContext) {
            this.logCtx = logContext;
        }

        protected final boolean isFollowUpJob() {
            return this.followUpJob;
        }

        protected final boolean hasToCheckEditor() {
            return this.checkEditor;
        }

        protected final boolean isSteady() {
            return this.steady;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void updateProgress(String message) {
            assert (message != null);
            Object object = this.progressLock;
            synchronized (object) {
                if (this.progressHandle == null) {
                    return;
                }
                this.progressHandle.progress(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void updateProgress(URL currentlyScannedRoot, boolean increment) {
            assert (currentlyScannedRoot != null);
            Object object = this.progressLock;
            synchronized (object) {
                if (this.progressHandle == null) {
                    return;
                }
                if (increment && this.progress != -1) {
                    this.progressHandle.progress(this.urlForMessage(currentlyScannedRoot), ++this.progress);
                } else {
                    this.progressHandle.progress(this.urlForMessage(currentlyScannedRoot));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void switchProgressToDeterminate(int workunits) {
            Object object = this.progressLock;
            synchronized (object) {
                if (this.progressHandle == null) {
                    return;
                }
                this.progress = 0;
                this.progressHandle.switchToDeterminate(workunits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void suspendProgress(@NonNull String message) {
            Object object = this.progressLock;
            synchronized (object) {
                if (this.progressHandle == null) {
                    return;
                }
                this.progressHandle.suspend(message);
            }
        }

        private Preferences indexerProfileNode(SourceIndexerFactory srcFactory) {
            Object nn = srcFactory.getIndexerName();
            if (((String)nn).length() >= 80) {
                int i = ((String)nn).lastIndexOf(46);
                if (i >= 0) {
                    nn = ((String)nn).substring(i + 1);
                }
                if (((String)nn).length() < 3 || ((String)nn).length() >= 80) {
                    String hashCode = Integer.toHexString(((String)nn).hashCode());
                    nn = srcFactory.getClass().getSimpleName() + "_" + hashCode;
                }
            }
            return NbPreferences.forModule(srcFactory.getClass()).node("RepositoryUpdater").node((String)nn);
        }

        private int estimateEmbeddingIndexer(SourceIndexerFactory srcFactory) {
            Preferences pref = this.indexerProfileNode(srcFactory);
            int c1 = pref.getInt("modifiedScanTime", 500) + pref.getInt("modifiedBaseTime", 100);
            return this.modifiedResourceCount * c1;
        }

        private int estimateCustomStartTime(CustomIndexerFactory srcFactory) {
            if (this.modifiedResourceCount == 0 && this.allResourceCount == 0) {
                return -1;
            }
            Preferences moduleNode = this.indexerProfileNode(srcFactory);
            int c1 = moduleNode.getInt("modifiedStartTime", 500);
            int c2 = moduleNode.getInt("fileStartTime", 300);
            int c3 = moduleNode.getInt("startBaseTime", 300);
            moduleNode.putBoolean("hello", true);
            int threshold = Math.max(this.modifiedResourceCount * c1, this.allResourceCount * c2) + c3;
            return threshold;
        }

        private int estimateCustomIndexingTime(CustomIndexerFactory srcFactory) {
            if (this.modifiedResourceCount == 0 && this.allResourceCount == 0) {
                return -1;
            }
            Preferences moduleNode = this.indexerProfileNode(srcFactory);
            int c1 = moduleNode.getInt("modifiedScanTime", 500);
            int c2 = moduleNode.getInt("fileScanTime", 300);
            int c3 = moduleNode.getInt("indexingBaseTime", 300);
            int threshold = Math.max(this.modifiedResourceCount * c1, this.allResourceCount * c2) + c3;
            return threshold;
        }

        private int estimateSourceEndTime(SourceIndexerFactory srcFactory) {
            if (this.modifiedResourceCount == 0 && this.allResourceCount == 0) {
                return -1;
            }
            Preferences moduleNode = this.indexerProfileNode(srcFactory);
            int c1 = moduleNode.getInt("modifiedEndTime", 500);
            int c2 = moduleNode.getInt("fileEndTime", 300);
            int c3 = moduleNode.getInt("indexingEndTime", 300);
            int threshold = Math.max(this.modifiedResourceCount * c1, this.allResourceCount * c2) + c3;
            return threshold;
        }

        protected final void scanStarted(URL root, boolean sourceForBinaryRoot, SourceIndexers indexers, Map<SourceIndexerFactory, Boolean> votes, Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> ctxToFinish) throws IOException {
            FileObject cacheRoot = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.CREATE);
            this.customIndexersScanStarted(root, cacheRoot, sourceForBinaryRoot, indexers.cifInfos, votes, ctxToFinish);
            this.embeddingIndexersScanStarted(root, cacheRoot, sourceForBinaryRoot, indexers.eifInfosMap.values(), votes, ctxToFinish);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void customIndexersScanStarted(@NonNull URL root, @NonNull FileObject cacheRoot, boolean sourceForBinaryRoot, Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> indexers, Map<SourceIndexerFactory, Boolean> votes, Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> ctxToFinish) throws IOException {
            for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers) {
                this.parkWhileSuspended();
                CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                Pair key = Pair.of((Object)factory.getIndexerName(), (Object)factory.getIndexVersion());
                Pair value = ctxToFinish.get(key);
                if (TEST_LOGGER.isLoggable(Level.FINEST)) {
                    TEST_LOGGER.log(Level.FINEST, "scanStarting:{0}:{1}", new Object[]{factory.getIndexerName(), root.toString()});
                }
                if (value == null) {
                    Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, this.getSuspendStatus(), this.getCancelRequest(), this.logCtx);
                    value = Pair.of((Object)factory, (Object)ctx);
                    ctxToFinish.put((Pair<String, Integer>)key, (Pair<SourceIndexerFactory, Context>)value);
                }
                this.logStartIndexer(factory.getIndexerName());
                try {
                    boolean vote = this.doStartCustomIndexer(factory, (Context)value.second());
                    votes.put(factory, vote);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    votes.put(factory, false);
                    Exceptions.printStackTrace((Throwable)t);
                }
                finally {
                    this.logFinishIndexer(factory.getIndexerName());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doStartCustomIndexer(CustomIndexerFactory factory, Context factoryContext) {
            int estimate = this.estimateCustomStartTime(factory);
            SamplerInvoker.start(this.getLogContext(), factory.getIndexerName(), estimate, factoryContext.getRootURI());
            try {
                boolean bl = factory.scanStarted(factoryContext);
                return bl;
            }
            finally {
                SamplerInvoker.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void embeddingIndexersScanStarted(@NonNull URL root, @NonNull FileObject cacheRoot, boolean sourceForBinaryRoot, Collection<Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> indexers, Map<SourceIndexerFactory, Boolean> votes, Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> ctxToFinish) throws IOException {
            for (Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos : indexers) {
                for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> eifInfo : eifInfos) {
                    this.parkWhileSuspended();
                    EmbeddingIndexerFactory eif = eifInfo.getIndexerFactory();
                    Pair key = Pair.of((Object)eif.getIndexerName(), (Object)eif.getIndexVersion());
                    Pair value = ctxToFinish.get(key);
                    if (value == null) {
                        Context context = SPIAccessor.getInstance().createContext(cacheRoot, root, eif.getIndexerName(), eif.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, this.getSuspendStatus(), this.getCancelRequest(), this.logCtx);
                        value = Pair.of((Object)eif, (Object)context);
                        ctxToFinish.put((Pair<String, Integer>)key, (Pair<SourceIndexerFactory, Context>)value);
                    }
                    this.logStartIndexer(eif.getIndexerName());
                    try {
                        boolean vote = eif.scanStarted((Context)value.second());
                        votes.put(eif, vote);
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        votes.put(eif, false);
                        Exceptions.printStackTrace((Throwable)t);
                    }
                    finally {
                        this.logFinishIndexer(eif.getIndexerName());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void scanFinished(@NonNull Collection<Pair<SourceIndexerFactory, Context>> ctxToFinish, @NonNull UsedIndexables usedIterables, boolean finished) throws IOException {
            try {
                for (Pair<SourceIndexerFactory, Context> entry : ctxToFinish) {
                    this.parkWhileSuspended();
                    if (TEST_LOGGER.isLoggable(Level.FINEST)) {
                        TEST_LOGGER.log(Level.FINEST, "scanFinishing:{0}:{1}", new Object[]{((SourceIndexerFactory)entry.first()).getIndexerName(), ((Context)entry.second()).getRootURI().toExternalForm()});
                    }
                    this.logStartIndexer(((SourceIndexerFactory)entry.first()).getIndexerName());
                    SPIAccessor.getInstance().putProperty((Context)entry.second(), "ci-delete-set", null);
                    SPIAccessor.getInstance().putProperty((Context)entry.second(), "ci-index-set", null);
                    this.cancelRequest.setResult(finished);
                    try {
                        int estimate = this.estimateSourceEndTime((SourceIndexerFactory)entry.first());
                        SamplerInvoker.start(this.getLogContext(), ((SourceIndexerFactory)entry.first()).getIndexerName(), estimate, ((Context)entry.second()).getRootURI());
                        ((SourceIndexerFactory)entry.first()).scanFinished((Context)entry.second());
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        Exceptions.printStackTrace((Throwable)t);
                        SamplerInvoker.stop();
                    }
                    finally {
                        this.cancelRequest.setResult(null);
                    }
                    this.logFinishIndexer(((SourceIndexerFactory)entry.first()).getIndexerName());
                    if (!TEST_LOGGER.isLoggable(Level.FINEST)) continue;
                    TEST_LOGGER.log(Level.FINEST, "scanFinished:{0}:{1}", new Object[]{((SourceIndexerFactory)entry.first()).getIndexerName(), ((Context)entry.second()).getRootURI().toExternalForm()});
                }
            }
            finally {
                try {
                    boolean indexOk = true;
                    Union2 exception = null;
                    for (Pair<SourceIndexerFactory, Context> entry : ctxToFinish) {
                        try {
                            indexOk &= this.storeChanges(((SourceIndexerFactory)entry.first()).getIndexerName(), (Context)entry.second(), this.isSteady(), usedIterables.get(), finished);
                        }
                        catch (IOException e) {
                            exception = Union2.createFirst((Object)e);
                        }
                        catch (RuntimeException e) {
                            exception = Union2.createSecond((Object)e);
                        }
                    }
                    if (exception != null) {
                        if (exception.hasFirst()) {
                            throw (IOException)exception.first();
                        }
                        throw (RuntimeException)exception.second();
                    }
                    if (!indexOk) {
                        Context ctx = (Context)ctxToFinish.iterator().next().second();
                        RepositoryUpdater.getDefault().addIndexingJob(ctx.getRootURI(), null, false, false, false, true, true, LogContext.create(LogContext.EventType.UI, "Broken Index Found."));
                    }
                }
                finally {
                    InjectedTasksSupport.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void delete(@NonNull List<Indexable> deleted, @NonNull Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> contexts, @NonNull UsedIndexables usedIterables) throws IOException {
            if (deleted.isEmpty()) {
                return;
            }
            ClusteredIndexables ci = new ClusteredIndexables(deleted);
            try {
                for (Pair<SourceIndexerFactory, Context> pair : contexts.values()) {
                    this.parkWhileSuspended();
                    SPIAccessor.getInstance().putProperty((Context)pair.second(), "ci-delete-set", ci);
                    ((SourceIndexerFactory)pair.first()).filesDeleted(ci.getIndexablesFor(null), (Context)pair.second());
                }
            }
            catch (Throwable throwable) {
                for (Pair<SourceIndexerFactory, Context> pair : contexts.values()) {
                    Context ctx = (Context)pair.second();
                    FileObject indexFolder = ctx.getIndexFolder();
                    if (indexFolder == null) {
                        throw new IllegalStateException(String.format("No index folder for context: %s", ctx));
                    }
                    LayeredDocumentIndex index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(indexFolder);
                    if (index == null) continue;
                    usedIterables.offer(ci.getIndexablesFor(null));
                }
                throw throwable;
            }
            for (Pair<SourceIndexerFactory, Context> pair : contexts.values()) {
                Context ctx = (Context)pair.second();
                FileObject indexFolder = ctx.getIndexFolder();
                if (indexFolder == null) {
                    throw new IllegalStateException(String.format("No index folder for context: %s", ctx));
                }
                LayeredDocumentIndex index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(indexFolder);
                if (index == null) continue;
                usedIterables.offer(ci.getIndexablesFor(null));
            }
        }

        protected final boolean index(List<Indexable> resources, List<Indexable> allResources, URL root, boolean sourceForBinaryRoot, SourceIndexers indexers, Map<SourceIndexerFactory, Boolean> votes, @NonNull Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> contexts, @NonNull UsedIndexables usedIterables) throws IOException {
            return (Boolean)TaskCache.getDefault().refreshTransaction(() -> this.doIndex(resources, allResources, root, sourceForBinaryRoot, indexers, votes, contexts, usedIterables));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private boolean doIndex(List<Indexable> resources, List<Indexable> allResources, URL root, boolean sourceForBinaryRoot, SourceIndexers indexers, Map<SourceIndexerFactory, Boolean> votes, @NonNull Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> contexts, @NonNull UsedIndexables usedIterables) throws IOException {
            LinkedList allIndexblesSentToIndexers = new LinkedList();
            SourceAccessor.getINSTANCE().suppressListening(true, !this.checkEditor);
            try {
                FileObject cacheRoot = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.CREATE);
                ClusteredIndexables ci = new ClusteredIndexables(resources);
                ClusteredIndexables allCi = null;
                boolean ae = false;
                if (!$assertionsDisabled) {
                    ae = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                Set<String> rootMimeTypes = PathRegistry.getDefault().getMimeTypesFor(root);
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                    void var24_48;
                    LogContext logContext;
                    boolean allFiles;
                    if (rootMimeTypes != null && !indexerInfo.isAllMimeTypesIndexer() && !Util.containsAny(rootMimeTypes, indexerInfo.getMimeTypes())) {
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.log(Level.FINE, "Not using {0} registered for {1} to scan root {2} marked for {3}", new Object[]{indexerInfo.getIndexerFactory().getIndexerName() + "/" + indexerInfo.getIndexerFactory().getIndexVersion(), Debug.printMimeTypes(indexerInfo.getMimeTypes(), new StringBuilder()), root, PathRegistry.getDefault().getMimeTypesFor(root)});
                        continue;
                    }
                    CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                    Pair key = Pair.of((Object)factory.getIndexerName(), (Object)factory.getIndexVersion());
                    Pair value = contexts.get(key);
                    if (value == null) {
                        Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, this.getSuspendStatus(), this.getCancelRequest(), this.logCtx);
                        value = Pair.of((Object)factory, (Object)ctx);
                        contexts.put((Pair<String, Integer>)key, (Pair<SourceIndexerFactory, Context>)value);
                    }
                    boolean cifIsChanged = indexers.changedCifs != null && indexers.changedCifs.contains(indexerInfo);
                    boolean forceReindex = votes.get(factory) == Boolean.FALSE && allResources != null;
                    boolean bl = allFiles = cifIsChanged || forceReindex || allResources != null && allResources.size() == resources.size();
                    if (forceReindex && resources.size() != allResources.size() && (logContext = this.getLogContext()) != null) {
                        logContext.reindexForced(root, factory.getIndexerName());
                    }
                    if (ae && forceReindex && LOGGER.isLoggable(Level.INFO) && resources.size() != allResources.size() && !indexerInfo.getMimeTypes().isEmpty()) {
                        LOGGER.log(Level.INFO, "Refresh of custom indexer ({0}) for root: {1} forced by: {2}", new Object[]{indexerInfo.getMimeTypes(), root.toExternalForm(), factory});
                    }
                    SPIAccessor.getInstance().setAllFilesJob((Context)value.second(), allFiles);
                    LinkedList<Iterable<Indexable>> linkedList = new LinkedList<Iterable<Indexable>>();
                    Object var24_49 = null;
                    for (String mimeType : indexerInfo.getMimeTypes()) {
                        if ((cifIsChanged || forceReindex) && allResources != null && resources.size() != allResources.size()) {
                            if (allCi == null) {
                                allCi = new ClusteredIndexables(allResources);
                            }
                            linkedList.add(allCi.getIndexablesFor(mimeType));
                            if (var24_48 != null) continue;
                            ClusteredIndexables clusteredIndexables = allCi;
                            continue;
                        }
                        linkedList.add(ci.getIndexablesFor(mimeType));
                        if (var24_48 != null) continue;
                        ClusteredIndexables clusteredIndexables = ci;
                    }
                    FilteringIterable<Indexable> indexables = new FilteringIterable<Indexable>(new ProxyIterable(linkedList), RepositoryUpdater.indexableFilter(factory, ((Context)value.second()).getRootURI()));
                    allIndexblesSentToIndexers.addAll(linkedList);
                    this.parkWhileSuspended();
                    if (this.getCancelRequest().isRaised()) {
                        boolean mimeType = false;
                        return mimeType;
                    }
                    FilteringIterable<Indexable> notIndexables = new FilteringIterable<Indexable>(new ProxyIterable(linkedList), RepositoryUpdater.notIndexableFilter(factory, ((Context)value.second()).getRootURI()));
                    factory.filesDeleted(notIndexables, (Context)value.second());
                    CustomIndexer indexer = factory.createIndexer();
                    this.logStartIndexer(factory.getIndexerName());
                    SPIAccessor.getInstance().putProperty((Context)value.second(), "ci-index-set", var24_48);
                    int estimate = this.estimateCustomIndexingTime(factory);
                    long tm1 = System.currentTimeMillis();
                    try {
                        SamplerInvoker.start(this.getLogContext(), factory.getIndexerName(), estimate, root);
                        SPIAccessor.getInstance().index(indexer, indexables, (Context)value.second());
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                    finally {
                        SamplerInvoker.stop();
                    }
                    long tm2 = System.currentTimeMillis();
                    this.logIndexerTime(factory.getIndexerName(), (int)(tm2 - tm1));
                    if (LOGGER.isLoggable(Level.FINE)) {
                        StringBuilder sb = Debug.printMimeTypes(indexerInfo.getMimeTypes(), new StringBuilder());
                        LOGGER.log(Level.FINE, "Indexing source root {0} using {1}; mimeTypes={2}; took {3}", new Object[]{root, indexer, sb, tm2 - tm1 + "ms"});
                    }
                    InjectedTasksSupport.execute();
                }
                if (this.getCancelRequest().isRaised()) {
                    boolean bl = false;
                    return bl;
                }
                boolean useAllCi = false;
                if (allResources != null) {
                    boolean allFiles;
                    boolean bl;
                    boolean bl2 = false;
                    boolean forceReindex = false;
                    HashSet<EmbeddingIndexerFactory> reindexVoters = new HashSet<EmbeddingIndexerFactory>();
                    LogContext lc = this.getLogContext();
                    for (Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos : indexers.eifInfosMap.values()) {
                        for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> indexerInfo : eifInfos) {
                            EmbeddingIndexerFactory embeddingIndexerFactory;
                            boolean indexerVote;
                            if (indexers.changedEifs != null && indexers.changedEifs.contains(indexerInfo)) {
                                if (lc != null) {
                                    lc.newIndexerSeen(indexerInfo.getIndexerFactory().getIndexerName());
                                }
                                bl = true;
                            }
                            boolean bl3 = indexerVote = votes.get(embeddingIndexerFactory = indexerInfo.getIndexerFactory()) == Boolean.FALSE;
                            if (indexerVote) {
                                if (lc != null) {
                                    lc.reindexForced(root, embeddingIndexerFactory.getIndexerName());
                                }
                                reindexVoters.add(embeddingIndexerFactory);
                            }
                            forceReindex |= indexerVote;
                        }
                    }
                    if ((bl || forceReindex) && resources.size() != allResources.size()) {
                        if (allCi == null) {
                            allCi = new ClusteredIndexables(allResources);
                        }
                        useAllCi = true;
                        if (ae && !reindexVoters.isEmpty() && LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.log(Level.INFO, "Refresh of embedded indexers for root: {0} forced by: {1}", new Object[]{root.toExternalForm(), ((Object)reindexVoters).toString()});
                        }
                    }
                    boolean bl4 = allFiles = bl || forceReindex || allResources.size() == resources.size();
                    if (allFiles) {
                        for (Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos : indexers.eifInfosMap.values()) {
                            for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> indexerInfo : eifInfos) {
                                EmbeddingIndexerFactory factory = indexerInfo.getIndexerFactory();
                                Pair key = Pair.of((Object)factory.getIndexerName(), (Object)factory.getIndexVersion());
                                Pair value = contexts.get(key);
                                if (value == null) {
                                    Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, factory.getIndexerName(), factory.getIndexVersion(), null, this.followUpJob, this.checkEditor, sourceForBinaryRoot, this.getSuspendStatus(), this.getCancelRequest(), this.logCtx);
                                    value = Pair.of((Object)factory, (Object)ctx);
                                    contexts.put((Pair<String, Integer>)key, (Pair<SourceIndexerFactory, Context>)value);
                                }
                                SPIAccessor.getInstance().setAllFilesJob((Context)value.second(), allFiles);
                            }
                        }
                    }
                }
                for (String mimeType : Util.getAllMimeTypes()) {
                    this.parkWhileSuspended();
                    if (this.getCancelRequest().isRaised()) {
                        boolean reindexVoters = false;
                        return reindexVoters;
                    }
                    if (!ParserManager.canBeParsed((String)mimeType)) continue;
                    ClusteredIndexables usedCi = useAllCi ? allCi : ci;
                    Iterable<Indexable> indexables = usedCi.getIndexablesFor(mimeType);
                    allIndexblesSentToIndexers.add(indexables);
                    long tm1 = System.currentTimeMillis();
                    boolean f = this.indexEmbedding(indexers.eifInfosMap, cacheRoot, root, mimeType, indexables, usedCi, contexts, sourceForBinaryRoot);
                    long l = System.currentTimeMillis();
                    if (!f) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, "Indexing {0} embeddables under {1}; took {2}ms", new Object[]{mimeType, root, l - tm1});
                }
                boolean bl = !this.getCancelRequest().isRaised();
                return bl;
            }
            finally {
                SourceAccessor.getINSTANCE().suppressListening(false, false);
                usedIterables.offerAll(allIndexblesSentToIndexers);
            }
        }

        protected void invalidateSources(Iterable<? extends Indexable> toInvalidate) {
            long st = System.currentTimeMillis();
            for (Indexable indexable : toInvalidate) {
                FileObject cheapFo = SPIAccessor.getInstance().getFileObject(indexable);
                if (cheapFo == null) continue;
                Utilities.invalidate((FileObject)cheapFo);
            }
            long et = System.currentTimeMillis();
            LOGGER.log(Level.FINE, "InvalidateSources took: {0}", et - st);
        }

        protected final void binaryScanStarted(@NonNull URL root, boolean upToDate, @NonNull LinkedHashMap<BinaryIndexerFactory, Context> contexts, @NonNull BitSet startedIndexers) throws IOException {
            int index = 0;
            for (Map.Entry<BinaryIndexerFactory, Context> e : contexts.entrySet()) {
                boolean vote;
                Context ctx = e.getValue();
                BinaryIndexerFactory bif = e.getKey();
                SPIAccessor.getInstance().setAllFilesJob(ctx, !upToDate);
                this.parkWhileSuspended();
                long st = System.currentTimeMillis();
                this.logStartIndexer(bif.getIndexerName());
                try {
                    startedIndexers.set(index);
                    vote = bif.scanStarted(ctx);
                }
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    vote = false;
                    Exceptions.printStackTrace((Throwable)t);
                }
                long et = System.currentTimeMillis();
                this.logIndexerTime(bif.getIndexerName(), (int)(et - st));
                if (!vote) {
                    SPIAccessor.getInstance().setAllFilesJob(ctx, true);
                }
                ++index;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void binaryScanFinished(@NonNull BinaryIndexers indexers, @NonNull LinkedHashMap<BinaryIndexerFactory, Context> contexts, @NonNull BitSet startedIndexers, boolean finished) throws IOException {
            try {
                int index = 0;
                for (Map.Entry<BinaryIndexerFactory, Context> entry : contexts.entrySet()) {
                    if (!startedIndexers.get(index++)) continue;
                    try {
                        long st = System.currentTimeMillis();
                        try {
                            this.parkWhileSuspended();
                            this.logStartIndexer(entry.getKey().getIndexerName());
                        }
                        finally {
                            try {
                                entry.getKey().scanFinished(entry.getValue());
                            }
                            finally {
                                long et = System.currentTimeMillis();
                                this.logIndexerTime(entry.getKey().getIndexerName(), (int)(et - st));
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        Exceptions.printStackTrace((Throwable)t);
                    }
                }
            }
            finally {
                boolean indexOk = true;
                Union2 exception = null;
                for (Context ctx : contexts.values()) {
                    try {
                        indexOk &= this.storeChanges(null, ctx, this.isSteady(), null, finished);
                    }
                    catch (IOException e) {
                        exception = Union2.createFirst((Object)e);
                    }
                    catch (RuntimeException e) {
                        exception = Union2.createSecond((Object)e);
                    }
                }
                if (exception != null) {
                    if (exception.hasFirst()) {
                        throw (IOException)exception.first();
                    }
                    throw (RuntimeException)exception.second();
                }
                if (!indexOk) {
                    RepositoryUpdater.getDefault().addBinaryJob(contexts.values().iterator().next().getRootURI(), LogContext.create(LogContext.EventType.UI, "Broken Index Found."));
                }
            }
        }

        protected final void createBinaryContexts(@NonNull URL root, @NonNull BinaryIndexers indexers, @NonNull Map<BinaryIndexerFactory, Context> contexts) throws IOException {
            FileObject cacheRoot = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.BINARIES), CacheFolderProvider.Mode.CREATE);
            for (BinaryIndexerFactory binaryIndexerFactory : indexers.bifs) {
                Context ctx = SPIAccessor.getInstance().createContext(cacheRoot, root, binaryIndexerFactory.getIndexerName(), binaryIndexerFactory.getIndexVersion(), null, false, false, false, this.getSuspendStatus(), this.getCancelRequest(), null);
                contexts.put(binaryIndexerFactory, ctx);
            }
        }

        protected final boolean checkBinaryIndexers(@NullAllowed Pair<Long, Map<Pair<String, Integer>, Integer>> lastState, @NonNull Map<BinaryIndexerFactory, Context> contexts) throws IOException {
            if (lastState == null || (Long)lastState.first() == 0L) {
                return false;
            }
            if (contexts.size() != ((Map)lastState.second()).size()) {
                return false;
            }
            HashMap copy = new HashMap((Map)lastState.second());
            for (Map.Entry<BinaryIndexerFactory, Context> e : contexts.entrySet()) {
                BinaryIndexerFactory bif = e.getKey();
                Integer state = (Integer)copy.remove(Pair.of((Object)bif.getIndexerName(), (Object)bif.getIndexVersion()));
                if (state == null) {
                    return false;
                }
                ArchiveTimeStamps.setIndexerState(e.getValue(), state);
            }
            return copy.isEmpty();
        }

        protected final Pair<Long, Map<Pair<String, Integer>, Integer>> createBinaryIndexersTimeStamp(long currentTimeStamp, @NonNull Map<BinaryIndexerFactory, Context> contexts) {
            HashMap<Pair, Integer> pairs = new HashMap<Pair, Integer>();
            for (Map.Entry<BinaryIndexerFactory, Context> e : contexts.entrySet()) {
                BinaryIndexerFactory bf = e.getKey();
                Context ctx = e.getValue();
                pairs.put(Pair.of((Object)bf.getIndexerName(), (Object)bf.getIndexVersion()), ArchiveTimeStamps.getIndexerState(ctx));
            }
            return Pair.of((Object)currentTimeStamp, pairs);
        }

        protected final boolean indexBinary(URL root, BinaryIndexers indexers, Map<BinaryIndexerFactory, Context> contexts) throws IOException {
            LOGGER.log(Level.FINE, "Scanning binary root: {0}", root);
            if (!RepositoryUpdater.getDefault().rootsListeners.addBinary(root)) {
                return false;
            }
            LOGGER.log(Level.FINER, "Using BinaryIndexerFactories: {0}", indexers.bifs);
            for (BinaryIndexerFactory binaryIndexerFactory : indexers.bifs) {
                if (IndexabilityQuery.getInstance().preventIndexing(binaryIndexerFactory.getIndexerName(), root, null)) {
                    binaryIndexerFactory.rootsRemoved(Collections.singleton(root));
                    continue;
                }
                this.parkWhileSuspended();
                if (this.getCancelRequest().isRaised()) break;
                Context ctx = contexts.get(binaryIndexerFactory);
                assert (ctx != null);
                BinaryIndexer indexer = binaryIndexerFactory.createIndexer();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Indexing binary {0} using {1}", new Object[]{root, indexer});
                }
                long st = System.currentTimeMillis();
                this.logStartIndexer(binaryIndexerFactory.getIndexerName());
                try {
                    SPIAccessor.getInstance().index(indexer, ctx);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, String.format("%s while indexing: %s", t.getClass().getSimpleName(), ctx.getRootURI()), t);
                }
                long et = System.currentTimeMillis();
                this.logIndexerTime(binaryIndexerFactory.getIndexerName(), (int)(et - st));
            }
            return !this.getCancelRequest().isRaised();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean indexEmbedding(final Map<String, Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap, final FileObject cache, final URL rootURL, String mimeType, Iterable<? extends Indexable> files, final ClusteredIndexables usedCi, final Map<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> transactionContexts, final boolean sourceForBinaryRoot) throws IOException {
            final IndexabilityQuery iq = IndexabilityQuery.getInstance();
            final LinkedHashMap<Source, Indexable> sources = new LinkedHashMap<Source, Indexable>();
            for (Indexable indexable : files) {
                Source src;
                FileObject fileObject;
                URL url = indexable.getURL();
                if (url == null || (fileObject = URLMapper.findFileObject((URL)url)) == null || (src = Source.create((FileObject)fileObject)) == null) continue;
                sources.put(src, indexable);
            }
            this.parkWhileSuspended();
            if (this.getCancelRequest().isRaised()) {
                return false;
            }
            if (!sources.isEmpty()) {
                this.logStartIndexer(mimeType);
                try {
                    Map<String, List<Source>> sourcesByMimeType = sources.keySet().stream().collect(Collectors.groupingBy(s -> s.getMimeType()));
                    for (List<Source> l : sourcesByMimeType.values()) {
                        class T
                        extends UserTask
                        implements IndexingTask {
                            T() {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run(ResultIterator resultIterator) throws Exception {
                                Snapshot snapshot = resultIterator.getSnapshot();
                                Indexable dirty = (Indexable)sources.get(snapshot.getSource());
                                String mimeType = snapshot.getMimeType();
                                Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> infos = Work.getIndexerInfos(eifInfosMap, mimeType);
                                if (infos != null && !infos.isEmpty()) {
                                    for (IndexerCache.IndexerInfo indexerInfo : infos) {
                                        EmbeddingIndexer indexer;
                                        int indexerVersion;
                                        Parser.Result pr;
                                        if (Work.this.getCancelRequest().isRaised()) {
                                            return;
                                        }
                                        if (iq.preventIndexing(indexerInfo.getIndexerName(), dirty.getURL(), rootURL)) {
                                            try {
                                                Context context = SPIAccessor.getInstance().createContext(cache, rootURL, indexerInfo.getIndexerName(), indexerInfo.getIndexerVersion(), null, Work.this.followUpJob, Work.this.checkEditor, sourceForBinaryRoot, Work.this.getSuspendStatus(), Work.this.getCancelRequest(), Work.this.logCtx);
                                                ((EmbeddingIndexerFactory)indexerInfo.getIndexerFactory()).filesDeleted(Collections.singleton(dirty), context);
                                            }
                                            catch (IOException ex) {
                                                LOGGER.log(Level.WARNING, null, ex);
                                            }
                                            return;
                                        }
                                        EmbeddingIndexerFactory indexerFactory = (EmbeddingIndexerFactory)indexerInfo.getIndexerFactory();
                                        if (LOGGER.isLoggable(Level.FINE)) {
                                            LOGGER.log(Level.FINE, "Indexing file {0} using {1}; mimeType=''{2}''", new Object[]{snapshot.getSource().getFileObject().getPath(), indexerFactory, mimeType});
                                        }
                                        if ((pr = resultIterator.getParserResult()) == null) continue;
                                        String indexerName = indexerFactory.getIndexerName();
                                        Pair key = Pair.of((Object)indexerName, (Object)(indexerVersion = indexerFactory.getIndexVersion()));
                                        Pair value = (Pair)transactionContexts.get(key);
                                        if (value == null) {
                                            Context context = SPIAccessor.getInstance().createContext(cache, rootURL, indexerName, indexerVersion, null, Work.this.followUpJob, Work.this.checkEditor, sourceForBinaryRoot, Work.this.getSuspendStatus(), Work.this.getCancelRequest(), Work.this.logCtx);
                                            value = Pair.of((Object)indexerFactory, (Object)context);
                                            transactionContexts.put(key, value);
                                        }
                                        if ((indexer = indexerFactory.createIndexer(dirty, pr.getSnapshot())) == null) continue;
                                        SPIAccessor.getInstance().putProperty((Context)value.second(), "ci-index-set", usedCi);
                                        long st = System.currentTimeMillis();
                                        Work.this.logStartIndexer(indexerName);
                                        int estimate = Work.this.estimateEmbeddingIndexer(indexerFactory);
                                        SamplerInvoker.start(Work.this.getLogContext(), indexerFactory.getIndexerName(), estimate, dirty.getURL());
                                        try {
                                            SPIAccessor.getInstance().index(indexer, dirty, pr, (Context)value.second());
                                        }
                                        catch (ThreadDeath td) {
                                            throw td;
                                        }
                                        catch (Throwable t) {
                                            LOGGER.log(Level.WARNING, null, t);
                                        }
                                        finally {
                                            SamplerInvoker.stop();
                                        }
                                        long et = System.currentTimeMillis();
                                        Work.this.logIndexerTime(indexerName, (int)(et - st));
                                    }
                                }
                                for (Embedding embedding : resultIterator.getEmbeddings()) {
                                    if (Work.this.getCancelRequest().isRaised()) {
                                        return;
                                    }
                                    Work.this.logStartIndexer(embedding.getMimeType());
                                    this.run(resultIterator.getResultIterator(embedding));
                                }
                            }
                        }
                        ParserManager.parse(l, (UserTask)new T());
                    }
                }
                catch (ParseException e) {
                    LOGGER.log(Level.WARNING, null, e);
                }
                finally {
                    this.logFinishIndexer(mimeType);
                }
            }
            InjectedTasksSupport.execute();
            return !this.getCancelRequest().isRaised();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean scanFiles(@NonNull URL root, @NonNull Collection<FileObject> files, boolean forceRefresh, boolean sourceForBinaryRoot) {
            FileObject rootFo = URLCache.getInstance().findFileObject(root, true);
            if (rootFo != null) {
                LogContext lctx = this.getLogContext();
                try {
                    boolean bl = RepositoryUpdater.runInContext(rootFo, () -> {
                        ClassPath.Entry entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                        boolean permanentUpdate = this.isSteady();
                        assert (!TransientUpdateSupport.isTransientUpdate() || !permanentUpdate);
                        assert (permanentUpdate || forceRefresh && !files.isEmpty());
                        SourceIndexers indexers = this.getSourceIndexers(false);
                        HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> ctxToFinish = new HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>>();
                        IdentityHashMap<SourceIndexerFactory, Boolean> invalidatedMap = new IdentityHashMap<SourceIndexerFactory, Boolean>();
                        UsedIndexables usedIterables = new UsedIndexables();
                        boolean indexResult = false;
                        if (lctx != null) {
                            lctx.noteRootScanning(root, false);
                        }
                        try {
                            FileObjectCrawler crawler;
                            this.scanStarted(root, sourceForBinaryRoot, indexers, invalidatedMap, ctxToFinish);
                            boolean indexerVeto = false;
                            for (Boolean b : invalidatedMap.values()) {
                                if (b.booleanValue()) continue;
                                indexerVeto = true;
                                break;
                            }
                            EnumSet<Crawler.TimeStampAction> checkTimeStamps = EnumSet.noneOf(Crawler.TimeStampAction.class);
                            if (!forceRefresh) {
                                checkTimeStamps.add(Crawler.TimeStampAction.CHECK);
                            }
                            if (permanentUpdate) {
                                checkTimeStamps.add(Crawler.TimeStampAction.UPDATE);
                            }
                            FileObjectCrawler fileObjectCrawler = crawler = files.isEmpty() || indexerVeto ? new FileObjectCrawler(rootFo, checkTimeStamps, entry, this.getCancelRequest(), this.getSuspendStatus()) : new FileObjectCrawler(rootFo, files.toArray(new FileObject[0]), checkTimeStamps, entry, this.getCancelRequest(), this.getSuspendStatus());
                            if (lctx != null) {
                                lctx.startCrawler();
                            }
                            long t = System.currentTimeMillis();
                            List<Indexable> resources = crawler.getResources();
                            if (crawler.isFinished()) {
                                this.logCrawlerTime(crawler, t);
                                this.delete(crawler.getDeletedResources(), ctxToFinish, usedIterables);
                                indexResult = this.index(resources, crawler.getAllResources(), root, sourceForBinaryRoot, indexers, invalidatedMap, ctxToFinish, usedIterables);
                                this.invalidateSources(resources);
                                if (indexResult) {
                                    crawler.storeTimestamps();
                                    Boolean bl = true;
                                    return bl;
                                }
                            }
                        }
                        finally {
                            this.scanFinished(ctxToFinish.values(), usedIterables, indexResult);
                        }
                        return false;
                    });
                    return bl;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
                finally {
                    if (lctx != null) {
                        lctx.finishScannedRoot(root);
                    }
                }
            }
            return true;
        }

        protected abstract boolean getDone();

        protected boolean isCancelledBy(Work newWork, Collection<? super Work> follow) {
            return false;
        }

        public boolean absorb(Work newWork) {
            return false;
        }

        protected final boolean isCancelledExternally() {
            return this.externalCancel.get();
        }

        protected final CancelRequest getCancelRequest() {
            return this.cancelRequest;
        }

        @NonNull
        protected final SuspendStatus getSuspendStatus() {
            return this.suspendStatus;
        }

        protected final void parkWhileSuspended() {
            try {
                this.suspendStatus.parkWhileSuspended();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        protected final void logCrawlerTime(Crawler crawler, long start) throws IOException {
            LogContext lctx = this.getLogContext();
            if (lctx == null) {
                return;
            }
            List<Indexable> c = crawler.getResources();
            List<Indexable> ac = crawler.getAllResources();
            lctx.addCrawlerTime(System.currentTimeMillis() - start, c.size(), ac == null ? -1 : ac.size());
        }

        protected final void logStartIndexer(String iName) {
            LogContext lc = this.getLogContext();
            if (lc != null) {
                lc.startIndexer(iName);
            }
        }

        protected final void logFinishIndexer(String iName) {
            LogContext lc = this.getLogContext();
            if (lc != null) {
                lc.finishIndexer(iName);
            }
        }

        protected final void logIndexerTime(@NonNull String indexerName, int time) {
            LogContext lc = this.getLogContext();
            if (lc != null) {
                lc.addIndexerTime(indexerName, time);
            }
            if (!this.reportIndexerStatistics) {
                return;
            }
            int[] itime = this.indexerStatistics.get(indexerName);
            if (itime == null) {
                itime = new int[]{0, 0};
                this.indexerStatistics.put(indexerName, itime);
            }
            itime[0] = itime[0] + 1;
            itime[1] = itime[1] + time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void doTheWork() {
            try {
                long startTime = -1L;
                if (UI_LOGGER.isLoggable(Level.INFO) || PERF_LOGGER.isLoggable(Level.FINE)) {
                    Work.reportIndexingStart(UI_LOGGER, Level.INFO, lastScanEnded);
                    if (this.logCtx != null) {
                        this.logCtx.recordExecuted();
                    }
                    startTime = System.currentTimeMillis();
                    this.reportIndexerStatistics = true;
                }
                try {
                    this.finished.compareAndSet(false, this.getDone());
                }
                finally {
                    SamplerInvoker.release();
                    if (this.reportIndexerStatistics) {
                        lastScanEnded = System.currentTimeMillis();
                        Object[] stats = Work.createIndexerStatLogData(lastScanEnded - startTime, this.indexerStatistics);
                        Work.reportIndexerStatistics(UI_LOGGER, Level.INFO, stats);
                        Work.reportIndexerStatistics(PERF_LOGGER, Level.FINE, stats);
                    }
                    if (this.logCtx != null) {
                        this.logCtx.recordFinished();
                    }
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, null, t);
                this.finished.set(true);
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
            }
            finally {
                this.latch.countDown();
            }
        }

        public final void waitUntilDone() {
            while (this.latch.getCount() != 0L) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.FINE, null, e);
                }
            }
        }

        public final void setCancelled(boolean cancelled) {
            this.cancelled.set(cancelled);
            this.externalCancel.set(cancelled);
        }

        public final boolean cancelBy(Work newWork, Collection<? super Work> follow) {
            if (this.isCancelledBy(newWork, follow)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "{0} cancelled by {1}", new Object[]{this, newWork});
                }
                this.cancelled.set(true);
                this.finished.set(true);
                return true;
            }
            return false;
        }

        public final boolean isFinished() {
            return this.finished.get();
        }

        public final String getProgressTitle() {
            return this.progressTitle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setProgressHandle(ProgressHandle progressHandle) {
            Object object = this.progressLock;
            synchronized (object) {
                this.progressHandle = progressHandle;
            }
        }

        private String urlForMessage(URL currentlyScannedRoot) {
            File file = FileUtil.archiveOrDirForURL((URL)currentlyScannedRoot);
            String msg = file != null ? file.getAbsolutePath() : currentlyScannedRoot.toExternalForm();
            return msg;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[followUpJob=" + this.followUpJob + ", checkEditor=" + this.checkEditor;
        }

        protected final Source getActiveSource() {
            Source utActiveSrc = unitTestActiveSource;
            if (utActiveSrc != null) {
                return utActiveSrc;
            }
            Document doc = RepositoryUpdater.getDefault().activeDocProvider.getActiveDocument();
            return doc == null ? null : (DocumentUtilities.getMimeType((Document)doc) == null ? null : Source.create((Document)doc));
        }

        protected void refreshAffectedDocuments(Set<URL> roots) {
            Collection toNotify = Lookup.getDefault().lookupAll(ActiveDocumentProvider.IndexingAware.class);
            for (ActiveDocumentProvider.IndexingAware o : toNotify) {
                o.indexingComplete(roots);
            }
            this.refreshActiveDocument();
        }

        protected void refreshActiveDocument() {
            Source source = this.getActiveSource();
            if (source != null) {
                LOGGER.log(Level.FINE, "Invalidating source: {0} due to RootsWork", source);
                Utilities.revalidate((Source)source);
            }
        }

        private static void reportIndexerStatistics(@NonNull Logger logger, @NonNull Level level, @NonNull Object[] data) {
            if (logger.isLoggable(level)) {
                LogRecord r = new LogRecord(level, "INDEXING_FINISHED");
                r.setParameters(data);
                r.setResourceBundle(NbBundle.getBundle(RepositoryUpdater.class));
                r.setResourceBundleName(RepositoryUpdater.class.getPackage().getName() + ".Bundle");
                r.setLoggerName(logger.getName());
                logger.log(r);
            }
        }

        private static void reportIndexingStart(@NonNull Logger logger, @NonNull Level level, long lastScanEnded) {
            if (logger.isLoggable(level)) {
                LogRecord r = new LogRecord(level, "INDEXING_STARTED");
                r.setParameters(new Object[]{lastScanEnded == -1L ? 0L : System.currentTimeMillis() - lastScanEnded});
                r.setResourceBundle(NbBundle.getBundle(RepositoryUpdater.class));
                r.setResourceBundleName(RepositoryUpdater.class.getPackage().getName() + ".Bundle");
                r.setLoggerName(logger.getName());
                logger.log(r);
            }
        }

        private static Object[] createIndexerStatLogData(long indexingTime, Map<String, int[]> stats) {
            Object[] result = new Object[3 * stats.size() + 1];
            result[0] = indexingTime;
            Iterator<Map.Entry<String, int[]>> it = stats.entrySet().iterator();
            int i = 1;
            while (it.hasNext()) {
                Map.Entry<String, int[]> e = it.next();
                result[i] = e.getKey();
                int[] countTimePair = e.getValue();
                result[i + 1] = countTimePair[0];
                result[i + 2] = countTimePair[1];
                i += 3;
            }
            return result;
        }

        private static Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> getIndexerInfos(Map<String, Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap, String mimeType) {
            ArrayList<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> infos = new ArrayList<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>();
            if (eifInfosMap.containsKey(mimeType)) {
                infos.addAll(eifInfosMap.get(mimeType));
            }
            if (eifInfosMap.containsKey(ALL_MIME_TYPES)) {
                infos.addAll(eifInfosMap.get(ALL_MIME_TYPES));
            }
            return infos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final boolean storeChanges(@NullAllowed String indexerName, @NonNull Context ctx, boolean optimize, @NullAllowed Iterable<? extends Indexable> indexables, boolean finished) throws IOException {
            try {
                FileObject indexFolder = ctx.getIndexFolder();
                if (indexFolder == null) {
                    throw new IllegalStateException(String.format("No index folder for context: %s", ctx));
                }
                LayeredDocumentIndex index = SPIAccessor.getInstance().getIndexFactory(ctx).getIndex(indexFolder);
                if (index != null) {
                    TEST_LOGGER.log(Level.FINEST, "indexCommit:{0}:{1}", new Object[]{indexerName, ctx.getRootURI()});
                    try {
                        if (finished) {
                            this.storeChanges((DocumentIndex)index, optimize, indexables);
                        } else {
                            this.rollBackChanges((DocumentIndex.Transactional)index);
                        }
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.WARNING, "Broken index for root: {0} reason: {1}, recovering.", new Object[]{ctx.getRootURI(), ioe.getMessage()});
                        index.clear();
                        boolean bl = false;
                        DocumentIndexCache cache = SPIAccessor.getInstance().getIndexFactory(ctx).getCache(ctx);
                        if (cache instanceof ClusteredIndexables.AttachableDocumentIndexCache) {
                            ((ClusteredIndexables.AttachableDocumentIndexCache)cache).detach();
                        }
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                DocumentIndexCache cache = SPIAccessor.getInstance().getIndexFactory(ctx).getCache(ctx);
                if (cache instanceof ClusteredIndexables.AttachableDocumentIndexCache) {
                    ((ClusteredIndexables.AttachableDocumentIndexCache)cache).detach();
                }
            }
        }

        private void storeChanges(@NonNull DocumentIndex docIndex, boolean optimize, @NullAllowed Iterable<? extends Indexable> indexables) throws IOException {
            this.parkWhileSuspended();
            long t = System.currentTimeMillis();
            if (indexables != null) {
                ArrayList<String> keysToRemove = new ArrayList<String>();
                for (Indexable indexable : indexables) {
                    keysToRemove.add(indexable.getRelativePath());
                }
                docIndex.removeDirtyKeys(keysToRemove);
            }
            docIndex.store(optimize);
            long span = System.currentTimeMillis() - t;
            LogContext logContext = this.getLogContext();
            if (logContext != null) {
                logContext.addStoreTime(span);
            }
        }

        private void rollBackChanges(@NonNull DocumentIndex.Transactional docIndex) throws IOException {
            docIndex.rollback();
        }

        private static final class CancelRequestImpl
        implements CancelRequest {
            private final AtomicBoolean cancelled;
            private Boolean successStatus;

            CancelRequestImpl(@NonNull AtomicBoolean cancelled) {
                Parameters.notNull((CharSequence)"cancelled", (Object)cancelled);
                this.cancelled = cancelled;
            }

            void setResult(@NullAllowed Boolean result) {
                this.successStatus = result;
            }

            @Override
            public boolean isRaised() {
                return this.successStatus != null ? !this.successStatus.booleanValue() : this.cancelled.get();
            }
        }

        final class UsedIndexables {
            private final Collection<Iterable<? extends Indexable>> usedIndexables = new ArrayDeque<Iterable<? extends Indexable>>();
            private Iterable<? extends Indexable> cache;

            UsedIndexables() {
            }

            void offer(@NonNull Iterable<? extends Indexable> indexables) {
                this.usedIndexables.add(indexables);
                this.cache = null;
            }

            void offerAll(@NonNull Collection<? extends Iterable<? extends Indexable>> indexables) {
                this.usedIndexables.addAll(indexables);
                this.cache = null;
            }

            Iterable<? extends Indexable> get() {
                if (this.usedIndexables.isEmpty()) {
                    return null;
                }
                if (this.cache == null) {
                    this.cache = new ProxyIterable<Indexable>(this.usedIndexables, false, true);
                }
                return this.cache;
            }
        }
    }

    public static enum IndexingState {
        STARTING,
        PATH_CHANGING,
        WORKING;

    }

    static final class FileListWork
    extends Work {
        private final URL root;
        private final Collection<FileObject> files = new HashSet<FileObject>();
        private final boolean forceRefresh;
        private final boolean sourceForBinaryRoot;
        private final Map<URL, List<URL>> scannedRoots2Depencencies;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public FileListWork(Map<URL, List<URL>> scannedRoots2Depencencies, URL root, boolean followUpJob, boolean checkEditor, boolean forceRefresh, boolean sourceForBinaryRoot, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(followUpJob, checkEditor, true, true, suspendStatus, logCtx);
            assert (root != null);
            this.root = root;
            this.forceRefresh = forceRefresh;
            this.sourceForBinaryRoot = sourceForBinaryRoot;
            this.scannedRoots2Depencencies = scannedRoots2Depencencies;
        }

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public FileListWork(Map<URL, List<URL>> scannedRoots2Depencencies, URL root, Collection<FileObject> files, boolean followUpJob, boolean checkEditor, boolean forceRefresh, boolean sourceForBinaryRoot, boolean steady, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(followUpJob, checkEditor, followUpJob, steady, suspendStatus, logCtx);
            assert (root != null);
            assert (files != null && !files.isEmpty());
            this.root = root;
            this.files.addAll(files);
            this.forceRefresh = forceRefresh;
            this.sourceForBinaryRoot = sourceForBinaryRoot;
            this.scannedRoots2Depencencies = scannedRoots2Depencencies;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "FileListWork@{0}: root={1}, file={2}", new Object[]{Integer.toHexString(System.identityHashCode(this)), root, files});
            }
        }

        public void addFile(FileObject f) {
            assert (f != null);
            assert (FileUtil.isParentOf((FileObject)URLMapper.findFileObject((URL)this.root), (FileObject)f)) : "File " + f + " does not belong under the root: " + this.root;
            this.files.add(f);
        }

        @Override
        protected boolean getDone() {
            if (this.scannedRoots2Depencencies.containsKey(this.root) || !PathRegistry.getDefault().isIncompleteRoot(this.root)) {
                this.updateProgress(this.root, false);
                if (this.scanFiles(this.root, this.files, this.forceRefresh, this.sourceForBinaryRoot)) {
                    if (!this.files.isEmpty()) {
                        Map<FileObject, Document> f2d = RepositoryUpdater.getEditorFiles();
                        for (FileObject f : this.files) {
                            Document d = f2d.get(f);
                            if (d == null) continue;
                            long version = DocumentUtilities.getDocumentVersion((Document)d);
                            d.putProperty(PROP_LAST_INDEXED_VERSION, version);
                            if (!this.isSteady()) continue;
                            d.putProperty(PROP_LAST_DIRTY_VERSION, null);
                        }
                    }
                    if (!this.scannedRoots2Depencencies.containsKey(this.root)) {
                        this.scannedRoots2Depencencies.put(this.root, UNKNOWN_ROOT);
                    }
                }
                TEST_LOGGER.log(Level.FINEST, "filelist");
                this.refreshAffectedDocuments(Collections.singleton(this.root));
            }
            return true;
        }

        @Override
        @SuppressWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="URLs have never host part")
        public boolean absorb(Work newWork) {
            if (newWork instanceof FileListWork) {
                FileListWork nflw = (FileListWork)newWork;
                if (nflw.root.equals(this.root) && nflw.isFollowUpJob() == this.isFollowUpJob() && nflw.hasToCheckEditor() == this.hasToCheckEditor()) {
                    this.files.addAll(nflw.files);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "{0}, root={1} absorbed: {2}", new Object[]{this, this.root, nflw.files});
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        protected void refreshAffectedDocuments(Set<URL> roots) {
            if (this.shouldRefresh()) {
                super.refreshAffectedDocuments(roots);
            }
        }

        @Override
        protected void refreshActiveDocument() {
            if (this.shouldRefresh()) {
                super.refreshActiveDocument();
            }
        }

        @Override
        protected void invalidateSources(Iterable<? extends Indexable> toInvalidate) {
            if (this.shouldRefresh()) {
                super.invalidateSources(toInvalidate);
            }
        }

        private boolean shouldRefresh() {
            return !TransientUpdateSupport.isTransientUpdate();
        }
    }

    private static final class DeleteWork
    extends Work {
        private final URL root;
        private final Set<String> relativePaths = new HashSet<String>();

        public DeleteWork(URL root, Set<String> relativePaths, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(false, false, false, true, suspendStatus, logCtx);
            Parameters.notNull((CharSequence)"root", (Object)root);
            Parameters.notNull((CharSequence)"relativePath", relativePaths);
            this.root = root;
            this.relativePaths.addAll(relativePaths);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "DeleteWork@{0}: root={1}, files={2}", new Object[]{Integer.toHexString(System.identityHashCode(this)), root, relativePaths});
            }
        }

        @Override
        public boolean getDone() {
            try {
                Callable<Boolean> action = () -> {
                    LogContext lctx = this.getLogContext();
                    if (lctx != null) {
                        lctx.noteRootScanning(this.root, false);
                    }
                    try {
                        boolean finished;
                        ArrayList<Indexable> indexables = new ArrayList<Indexable>();
                        for (String path : this.relativePaths) {
                            indexables.add(SPIAccessor.getInstance().create(new DeletedIndexable(this.root, path)));
                        }
                        HashMap<SourceIndexerFactory, Boolean> votes = new HashMap<SourceIndexerFactory, Boolean>();
                        HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> contexts = new HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>>();
                        Work.UsedIndexables usedIterables = new Work.UsedIndexables();
                        SourceIndexers indexers = this.getSourceIndexers(false);
                        TimeStamps ts = TimeStamps.forRoot(this.root, false);
                        try {
                            this.scanStarted(this.root, false, indexers, votes, contexts);
                            this.delete(indexables, contexts, usedIterables);
                            ts.remove(this.relativePaths);
                            boolean bl = finished = !this.getCancelRequest().isRaised();
                        }
                        catch (Throwable throwable) {
                            boolean finished2;
                            boolean bl = finished2 = !this.getCancelRequest().isRaised();
                            if (finished2) {
                                ts.store();
                                this.scanFinished(contexts.values(), usedIterables, finished2);
                            }
                            throw throwable;
                        }
                        if (finished) {
                            ts.store();
                            this.scanFinished(contexts.values(), usedIterables, finished);
                        }
                        TEST_LOGGER.log(Level.FINEST, "delete");
                    }
                    finally {
                        if (lctx != null) {
                            lctx.finishScannedRoot(this.root);
                        }
                    }
                    return true;
                };
                return RepositoryUpdater.runInContext(this.root, action);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
                return true;
            }
        }

        @Override
        @SuppressWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="URLs have never host part")
        public boolean absorb(Work newWork) {
            if (newWork instanceof DeleteWork) {
                DeleteWork ndw = (DeleteWork)newWork;
                if (ndw.root.equals(this.root)) {
                    this.relativePaths.addAll(ndw.relativePaths);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "{0}, root={1} absorbed: {2}", new Object[]{this, this.root, ndw.relativePaths});
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static final class BinaryWork
    extends AbstractRootsWork {
        private final URL root;

        public BinaryWork(URL root, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(false, suspendStatus, logCtx);
            this.root = root;
        }

        @Override
        protected boolean getDone() {
            boolean result = this.scanBinary(this.root, BinaryIndexers.load(), null);
            TEST_LOGGER.log(Level.FINEST, "binary", Collections.singleton(this.root));
            this.refreshAffectedDocuments(Collections.singleton(this.root));
            return result;
        }

        @Override
        @SuppressWarnings(value={"DMI_BLOCKING_METHODS_ON_URL"}, justification="URLs have never host part")
        public boolean absorb(Work newWork) {
            if (newWork instanceof BinaryWork) {
                return this.root.equals(((BinaryWork)newWork).root);
            }
            return false;
        }
    }

    private static class RefreshEifIndices
    extends Work {
        private final Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> incompleteSeenRoots;
        private final Set<URL> sourcesForBinaryRoots;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public RefreshEifIndices(Collection<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> eifInfos, Map<URL, List<URL>> scannedRoots2Depencencies, Set<URL> incompleteSeenRoots, Set<URL> sourcesForBinaryRoots, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(false, false, NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingIndices"), true, suspendStatus, logCtx);
            if (eifInfos == null) {
                throw new IllegalArgumentException("eifInfos must not be null");
            }
            this.eifInfos = eifInfos;
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.incompleteSeenRoots = incompleteSeenRoots;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
        }

        @Override
        protected boolean isCancelledBy(Work newWork, Collection<? super Work> follow) {
            boolean b = newWork instanceof RootsWork;
            if (b) {
                LogContext lctx = this.getLogContext();
                follow.add(new RefreshEifIndices(this.eifInfos, this.scannedRoots2Dependencies, this.incompleteSeenRoots, this.sourcesForBinaryRoots, this.getSuspendStatus(), lctx == null ? null : LogContext.createAndAbsorb(lctx)));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cancelling {0}, because of {1}", new Object[]{this, newWork});
                }
            }
            if (newWork instanceof RefreshEifIndices) {
                boolean b2 = ((RefreshEifIndices)newWork).eifInfos.containsAll(this.eifInfos);
                if (b2 && LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cancelling {0}, because of {1}", new Object[]{this, newWork});
                }
                b |= b2;
            }
            return b;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof RefreshEifIndices && this.eifInfos.containsAll(((RefreshEifIndices)newWork).eifInfos)) {
                LOGGER.log(Level.FINE, "Absorbing {0}", newWork);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        protected boolean getDone() {
            this.switchProgressToDeterminate(this.scannedRoots2Dependencies.size());
            for (URL root : this.scannedRoots2Dependencies.keySet()) {
                if (this.getCancelRequest().isRaised()) {
                    return false;
                }
                LogContext lctx = this.getLogContext();
                if (lctx != null) {
                    lctx.noteRootScanning(root, false);
                }
                this.updateProgress(root, true);
                try {
                    Callable<Boolean> action;
                    FileObject rootFo;
                    if (this.incompleteSeenRoots.contains(root) || (rootFo = URLCache.getInstance().findFileObject(root, true)) == null || RepositoryUpdater.runInContext(rootFo, action = () -> {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 22[WHILELOOP]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }).booleanValue()) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
                finally {
                    if (lctx == null) continue;
                    lctx.finishScannedRoot(root);
                }
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<? extends IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> it = this.eifInfos.iterator();
            while (it.hasNext()) {
                IndexerCache.IndexerInfo<EmbeddingIndexerFactory> eifInfo = it.next();
                sb.append(" indexer=").append(eifInfo.getIndexerName()).append('/').append(eifInfo.getIndexerVersion());
                sb.append(" (");
                Debug.printMimeTypes(eifInfo.getMimeTypes(), sb);
                sb.append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            return super.toString() + sb.toString();
        }
    }

    private static class RefreshCifIndices
    extends Work {
        private final Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Set<URL> incompleteSeenRoots;
        private final Set<URL> sourcesForBinaryRoots;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public RefreshCifIndices(Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos, Map<URL, List<URL>> scannedRoots2Depencencies, Set<URL> incompleteSeenRoots, Set<URL> sourcesForBinaryRoots, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(false, false, NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_RefreshingIndices"), true, suspendStatus, logCtx);
            this.cifInfos = cifInfos;
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.incompleteSeenRoots = incompleteSeenRoots;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof RefreshCifIndices && this.cifInfos.equals(((RefreshCifIndices)newWork).cifInfos)) {
                LOGGER.log(Level.FINE, "Absorbing {0}", newWork);
                return true;
            }
            return false;
        }

        @Override
        protected boolean isCancelledBy(Work newWork, Collection<? super Work> follow) {
            boolean b = newWork instanceof RootsWork;
            if (b) {
                LogContext lctx = this.getLogContext();
                follow.add(new RefreshCifIndices(this.cifInfos, this.scannedRoots2Dependencies, this.incompleteSeenRoots, this.sourcesForBinaryRoots, this.getSuspendStatus(), lctx == null ? null : LogContext.createAndAbsorb(lctx)));
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cancelling {0}, because of {1}", new Object[]{this, newWork});
                }
            }
            return b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        protected boolean getDone() {
            this.switchProgressToDeterminate(this.scannedRoots2Dependencies.size());
            for (URL root : this.scannedRoots2Dependencies.keySet()) {
                if (this.getCancelRequest().isRaised()) {
                    return false;
                }
                LogContext lctx = this.getLogContext();
                if (lctx != null) {
                    lctx.noteRootScanning(root, false);
                }
                this.updateProgress(root, true);
                try {
                    Callable<Boolean> action;
                    FileObject rootFo;
                    if (this.incompleteSeenRoots.contains(root) || (rootFo = URLCache.getInstance().findFileObject(root, true)) == null || RepositoryUpdater.runInContext(rootFo, action = () -> this.lambda$getDone$0(root, rootFo)).booleanValue()) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.WARNING, null, ioe);
                }
                finally {
                    if (lctx == null) continue;
                    lctx.finishScannedRoot(root);
                }
            }
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> it = this.cifInfos.iterator();
            while (it.hasNext()) {
                IndexerCache.IndexerInfo<CustomIndexerFactory> cifInfo = it.next();
                sb.append(" indexer=").append(cifInfo.getIndexerName()).append('/').append(cifInfo.getIndexerVersion());
                sb.append(" (");
                Debug.printMimeTypes(cifInfo.getMimeTypes(), sb);
                sb.append(')');
                if (!it.hasNext()) continue;
                sb.append(',');
            }
            return super.toString() + sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private /* synthetic */ Boolean lambda$getDone$0(URL root, FileObject rootFo) throws Exception {
            block17: {
                block16: {
                    time = System.currentTimeMillis();
                    sourceForBinaryRoot = this.sourcesForBinaryRoots.contains(root);
                    entry = sourceForBinaryRoot != false ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                    crawler = new FileObjectCrawler(rootFo, EnumSet.of(Crawler.TimeStampAction.UPDATE), entry, this.getCancelRequest(), this.getSuspendStatus());
                    resources = crawler.getResources();
                    deleted = crawler.getDeletedResources();
                    this.logCrawlerTime(crawler, time);
                    if (crawler.isFinished() == false) return true;
                    cacheRoot = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.CREATE);
                    transactionContexts = new HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>>();
                    usedIterables = new Work.UsedIndexables();
                    votes = new HashMap<SourceIndexerFactory, Boolean>();
                    try {
                        this.customIndexersScanStarted(root, cacheRoot, sourceForBinaryRoot, this.cifInfos, votes, transactionContexts);
                        if (!deleted.isEmpty()) {
                            this.delete(deleted, transactionContexts, usedIterables);
                        }
                        allIndexblesSentToIndexers = new LinkedList<E>();
                        try {
                            ci = new ClusteredIndexables(resources);
lbl20:
                            // 2 sources

                            for (IndexerCache.IndexerInfo<CustomIndexerFactory> var17_17 : this.cifInfos) {
                                indexerIndexablesList = new LinkedList<Iterable<Indexable>>();
                                for (String mimeType : var17_17.getMimeTypes()) {
                                    indexerIndexablesList.add(ci.getIndexablesFor(mimeType));
                                }
                                allIndexblesSentToIndexers.addAll(indexerIndexablesList);
                                this.parkWhileSuspended();
                                if (this.getCancelRequest().isRaised()) {
                                    var19_19 = false;
                                    usedIterables.offerAll(allIndexblesSentToIndexers);
                                    v0 = !this.getCancelRequest().isRaised();
                                    break block16;
                                }
                                ** GOTO lbl-1000
                            }
                            break block17;
                        }
                        catch (Throwable var29_31) {
                            usedIterables.offerAll(allIndexblesSentToIndexers);
                            throw var29_31;
                        }
                    }
                    catch (Throwable var30_32) {
                        commit = this.getCancelRequest().isRaised() == false;
                        this.scanFinished(transactionContexts.values(), usedIterables, commit);
                        if (commit == false) throw var30_32;
                        crawler.storeTimestamps();
                        throw var30_32;
                    }
                }
                commit = v0;
                this.scanFinished(transactionContexts.values(), usedIterables, commit);
                if (commit == false) return var19_19;
                crawler.storeTimestamps();
                return var19_19;
lbl-1000:
                // 1 sources

                {
                    factory = var17_17.getIndexerFactory();
                    indexerKey = Pair.of((Object)factory.getIndexerName(), (Object)factory.getIndexVersion());
                    ctx = (Pair)transactionContexts.get(indexerKey);
                    if (ctx != null) {
                        indexables = new FilteringIterable<Indexable>(new ProxyIterable<T>(indexerIndexablesList), RepositoryUpdater.indexableFilter(factory, ((Context)ctx.second()).getRootURI()));
                        SPIAccessor.getInstance().setAllFilesJob((Context)ctx.second(), true);
                        notIndexables = new FilteringIterable<Indexable>(new ProxyIterable<T>(indexerIndexablesList), RepositoryUpdater.notIndexableFilter(factory, ((Context)ctx.second()).getRootURI()));
                        factory.filesDeleted(notIndexables, (Context)ctx.second());
                        indexer = factory.createIndexer();
                        if (RepositoryUpdater.LOGGER.isLoggable(Level.FINE)) {
                            sb = Debug.printMimeTypes(var17_17.getMimeTypes(), new StringBuilder());
                            RepositoryUpdater.LOGGER.log(Level.FINE, "Reindexing {0} using {1}; mimeTypes={2}", new Object[]{root, indexer, sb});
                        }
                        SPIAccessor.getInstance().putProperty((Context)ctx.second(), "ci-index-set", ci);
                        st = System.currentTimeMillis();
                        this.logStartIndexer(factory.getIndexerName());
                        try {
                            SPIAccessor.getInstance().index(indexer, indexables, (Context)ctx.second());
                        }
                        catch (ThreadDeath td) {
                            throw td;
                        }
                        catch (Throwable t) {
                            RepositoryUpdater.LOGGER.log(Level.WARNING, null, t);
                        }
                        et = System.currentTimeMillis();
                        this.logIndexerTime(factory.getIndexerName(), (int)(et - st));
                    } else {
                        RepositoryUpdater.LOGGER.log(Level.WARNING, "RefreshCifIndices ignored recently added factory: {0}", indexerKey);
                    }
                    InjectedTasksSupport.execute();
                    ** GOTO lbl20
                }
            }
            usedIterables.offerAll(allIndexblesSentToIndexers);
            commit = this.getCancelRequest().isRaised() == false;
            this.scanFinished(transactionContexts.values(), usedIterables, commit);
            if (commit == false) return true;
            crawler.storeTimestamps();
            return true;
        }
    }

    public static final class FSRefreshInterceptor
    implements IndexingActivityInterceptor {
        private FileSystem.AtomicAction activeAA = null;
        private boolean ignoreFsEvents = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IndexingActivityInterceptor.Authorization authorizeFileSystemEvent(FileEvent event) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                if (this.activeAA != null) {
                    boolean firedFrom = event.firedFrom(this.activeAA);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "{0} fired from {1}: {2}", new Object[]{event, this.activeAA, firedFrom});
                    }
                    return firedFrom ? IndexingActivityInterceptor.Authorization.IGNORE : IndexingActivityInterceptor.Authorization.PROCESS;
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Set to ignore {0}: {1}", new Object[]{event, this.ignoreFsEvents});
                }
                return this.ignoreFsEvents ? IndexingActivityInterceptor.Authorization.IGNORE : IndexingActivityInterceptor.Authorization.PROCESS;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setActiveAtomicAction(FileSystem.AtomicAction aa) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                LOGGER.log(Level.FINE, "setActiveAtomicAction({0})", aa);
                if (aa != null) {
                    assert (this.activeAA == null) : "Expecting no activeAA: " + this.activeAA;
                    this.activeAA = aa;
                } else {
                    assert (this.activeAA != null) : "Expecting some activeAA";
                    this.activeAA = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setIgnoreFsEvents(boolean ignore) {
            FSRefreshInterceptor fSRefreshInterceptor = this;
            synchronized (fSRefreshInterceptor) {
                LOGGER.log(Level.FINE, "setIgnoreFsEvents({0})", ignore);
                assert (this.activeAA == null) : "Expecting no activeAA: " + this.activeAA;
                this.ignoreFsEvents = ignore;
            }
        }
    }

    static final class RefreshWork
    extends AbstractRootsWork {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Map<URL, List<URL>> scannedBinaries2InvDependencies;
        private final Map<URL, List<URL>> scannedRoots2Peers;
        private final Set<URL> incompleteSeenRoots;
        private final Set<URL> sourcesForBinaryRoots;
        private final Set<Pair<Object, Boolean>> suspectFilesOrFileObjects;
        private final FSRefreshInterceptor interceptor;
        private DependenciesContext depCtx;
        private Map<URL, Set<FileObject>> fullRescanFiles;
        private Map<URL, Set<FileObject>> checkTimestampFiles;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public RefreshWork(Map<URL, List<URL>> scannedRoots2Depencencies, Map<URL, List<URL>> scannedBinaries2InvDependencies, Map<URL, List<URL>> scannedRoots2Peers, Set<URL> incompleteSeenRoots, Set<URL> sourcesForBinaryRoots, boolean fullRescan, boolean logStatistics, Collection<? extends Object> suspectFilesOrFileObjects, FSRefreshInterceptor interceptor, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(logStatistics, suspendStatus, logCtx);
            Parameters.notNull((CharSequence)"scannedRoots2Depencencies", scannedRoots2Depencencies);
            Parameters.notNull((CharSequence)"scannedBinaries2InvDependencies", scannedBinaries2InvDependencies);
            Parameters.notNull((CharSequence)"scannedRoots2Peers", scannedRoots2Peers);
            Parameters.notNull((CharSequence)"sourcesForBinaryRoots", sourcesForBinaryRoots);
            Parameters.notNull((CharSequence)"interceptor", (Object)interceptor);
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.scannedBinaries2InvDependencies = scannedBinaries2InvDependencies;
            this.scannedRoots2Peers = scannedRoots2Peers;
            this.incompleteSeenRoots = incompleteSeenRoots;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
            this.suspectFilesOrFileObjects = new HashSet<Pair<Object, Boolean>>();
            if (suspectFilesOrFileObjects != null) {
                this.addSuspects(suspectFilesOrFileObjects, fullRescan);
            }
            this.interceptor = interceptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        protected boolean getDone() {
            Level logLevel;
            if (this.depCtx == null) {
                this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.sourcesForBinaryRoots, false, false, () -> this.getSourceIndexers(false));
                this.depCtx.newIncompleteSeenRoots.addAll(this.incompleteSeenRoots);
                if (this.suspectFilesOrFileObjects.isEmpty()) {
                    this.depCtx.newBinariesToScan.addAll(this.scannedBinaries2InvDependencies.keySet());
                    try {
                        this.depCtx.newRootsToScan.addAll(BaseUtilities.topologicalSort(this.scannedRoots2Dependencies.keySet(), this.scannedRoots2Dependencies));
                    }
                    catch (TopologicalSortException tse) {
                        LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", tse);
                        List partialSort = tse.partialSort();
                        this.depCtx.newRootsToScan.addAll(partialSort);
                    }
                    Collections.reverse(this.depCtx.newRootsToScan);
                } else {
                    FileObject rootFo;
                    HashSet<Pair> suspects = new HashSet<Pair>();
                    for (Pair<Object, Boolean> fileOrFileObject : this.suspectFilesOrFileObjects) {
                        Pair fileObject = null;
                        if (fileOrFileObject.first() instanceof File) {
                            FileObject fileObject2;
                            try {
                                fileObject2 = FileUtil.toFileObject((File)((File)fileOrFileObject.first()));
                            }
                            catch (IllegalArgumentException e) {
                                throw new IllegalArgumentException("Non-normalized file among files to rescan.", e){
                                    {
                                        super(message, cause);
                                        LogContext logCtx = this.getLogContext();
                                        if (logCtx != null) {
                                            this.setStackTrace(logCtx.getCaller());
                                        }
                                    }
                                };
                            }
                            if (fileObject2 != null) {
                                fileObject = Pair.of((Object)fileObject2, (Object)((Boolean)fileOrFileObject.second()));
                            }
                        } else if (fileOrFileObject.first() instanceof FileObject) {
                            fileObject = Pair.of((Object)((FileObject)fileOrFileObject.first()), (Object)((Boolean)fileOrFileObject.second()));
                        } else {
                            LOGGER.log(Level.FINE, "Not File or FileObject, ignoring: {0}", fileOrFileObject);
                        }
                        if (fileObject == null) continue;
                        suspects.add(fileObject);
                    }
                    block10: for (Pair f : suspects) {
                        for (URL uRL : this.scannedBinaries2InvDependencies.keySet()) {
                            FileObject rootFo2;
                            File rootFile = FileUtil.archiveOrDirForURL((URL)uRL);
                            if (rootFile != null && (rootFo2 = FileUtil.toFileObject((File)rootFile)) != null && (f.first() == rootFo2 || FileUtil.isParentOf((FileObject)((FileObject)f.first()), (FileObject)rootFo2))) {
                                this.depCtx.newBinariesToScan.add(uRL);
                                continue block10;
                            }
                            FileObject rootFo3 = URLCache.getInstance().findFileObject(uRL, true);
                            if (rootFo3 == null || f.first() != rootFo3 && !FileUtil.isParentOf((FileObject)rootFo3, (FileObject)((FileObject)f.first()))) continue;
                            this.depCtx.newBinariesToScan.add(uRL);
                            continue block10;
                        }
                    }
                    HashSet containers = new HashSet();
                    HashMap<URL, Pair> sourceRootsToScan = new HashMap<URL, Pair>();
                    for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                        rootFo = URLCache.getInstance().findFileObject(uRL, true);
                        if (rootFo == null) continue;
                        for (Pair f : suspects) {
                            if (f.first() != rootFo && !FileUtil.isParentOf((FileObject)((FileObject)f.first()), (FileObject)rootFo)) continue;
                            Pair pair = (Pair)sourceRootsToScan.get(uRL);
                            pair = pair == null ? Pair.of((Object)rootFo, (Object)((Boolean)f.second())) : Pair.of((Object)rootFo, (Object)((Boolean)pair.second() != false || (Boolean)f.second() != false ? 1 : 0));
                            sourceRootsToScan.put(uRL, pair);
                            containers.add(f);
                        }
                    }
                    suspects.removeAll(containers);
                    for (Map.Entry entry : sourceRootsToScan.entrySet()) {
                        Iterator it = suspects.iterator();
                        while (it.hasNext()) {
                            Pair f = (Pair)it.next();
                            Pair root = (Pair)entry.getValue();
                            if (!FileUtil.isParentOf((FileObject)((FileObject)root.first()), (FileObject)((FileObject)f.first())) || !((Boolean)root.second()).booleanValue() && ((Boolean)f.second()).booleanValue()) continue;
                            it.remove();
                        }
                    }
                    for (Map.Entry entry : sourceRootsToScan.entrySet()) {
                        this.depCtx.newRootsToScan.add((URL)entry.getKey());
                        if (!((Boolean)((Pair)entry.getValue()).second()).booleanValue()) continue;
                        this.depCtx.fullRescanSourceRoots.add((URL)entry.getKey());
                    }
                    this.fullRescanFiles = new HashMap<URL, Set<FileObject>>();
                    this.checkTimestampFiles = new HashMap<URL, Set<FileObject>>();
                    block17: for (Pair f : suspects) {
                        for (URL uRL : this.scannedRoots2Dependencies.keySet()) {
                            rootFo = URLCache.getInstance().findFileObject(uRL, true);
                            if (rootFo == null || f.first() != rootFo && !FileUtil.isParentOf((FileObject)rootFo, (FileObject)((FileObject)f.first()))) continue;
                            Map<URL, Set<FileObject>> map = (Boolean)f.second() != false ? this.fullRescanFiles : this.checkTimestampFiles;
                            Set<FileObject> files = map.get(uRL);
                            if (files == null) {
                                files = new HashSet<FileObject>();
                                map.put(uRL, files);
                            }
                            files.add((FileObject)f.first());
                            continue block17;
                        }
                    }
                }
                FileSystem.AtomicAction aa = () -> FileUtil.refreshFor((File[])File.listRoots());
                this.interceptor.setIgnoreFsEvents(true);
                try {
                    FileUtil.runAtomicAction((FileSystem.AtomicAction)aa);
                }
                catch (IOException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                finally {
                    this.interceptor.setIgnoreFsEvents(false);
                }
            } else {
                this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                this.depCtx.scannedRoots.clear();
                this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                this.depCtx.scannedBinaries.clear();
            }
            boolean finished = this.scanBinaries(this.depCtx);
            if (finished && (finished = this.scanSources(this.depCtx, null)) && (finished = this.scanRootFiles(this.fullRescanFiles, this.depCtx.newIncompleteSeenRoots))) {
                finished = this.scanRootFiles(this.checkTimestampFiles, this.depCtx.newIncompleteSeenRoots);
            }
            if (LOGGER.isLoggable(logLevel = Level.FINE)) {
                LOGGER.log(logLevel, "{0} {1}: '{'", new Object[]{this, this.getCancelRequest().isRaised() ? "cancelled" : "finished"});
                LOGGER.log(logLevel, "  scannedRoots2Dependencies({0})=", this.scannedRoots2Dependencies.size());
                LOGGER.log(logLevel, Debug.printMap(this.scannedRoots2Dependencies, new StringBuilder()).toString());
                LOGGER.log(logLevel, "  scannedBinaries({0})=", this.scannedBinaries2InvDependencies.size());
                LOGGER.log(logLevel, Debug.printCollection(this.scannedBinaries2InvDependencies.keySet(), new StringBuilder()).toString());
                LOGGER.log(logLevel, "} ====");
            }
            HashSet<URL> affectedRoots = new HashSet<URL>();
            affectedRoots.addAll(this.depCtx.newRootsToScan);
            affectedRoots.addAll(this.depCtx.newBinariesToScan);
            affectedRoots.addAll(this.depCtx.scannedRoots);
            affectedRoots.addAll(this.depCtx.scannedBinaries);
            affectedRoots.addAll(this.depCtx.oldBinaries);
            affectedRoots.addAll(this.depCtx.oldRoots);
            this.refreshAffectedDocuments(affectedRoots);
            return finished;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork instanceof RefreshWork) {
                this.suspectFilesOrFileObjects.addAll(((RefreshWork)newWork).suspectFilesOrFileObjects);
                return true;
            }
            if (newWork instanceof FileListWork) {
                FileListWork flw = (FileListWork)newWork;
                if (flw.files.isEmpty()) {
                    this.suspectFilesOrFileObjects.add((Pair<Object, Boolean>)Pair.of((Object)URLCache.getInstance().findFileObject(flw.root, false), (Object)flw.forceRefresh));
                } else {
                    this.addSuspects(flw.files, flw.forceRefresh);
                }
                return true;
            }
            if (newWork instanceof DeleteWork) {
                this.suspectFilesOrFileObjects.add((Pair<Object, Boolean>)Pair.of((Object)URLCache.getInstance().findFileObject(((DeleteWork)newWork).root, false), (Object)false));
                return true;
            }
            return false;
        }

        public void addSuspects(Collection<? extends Object> filesOrFolders, boolean fullRescan) {
            for (Object object : filesOrFolders) {
                this.suspectFilesOrFileObjects.add((Pair<Object, Boolean>)Pair.of((Object)object, (Object)fullRescan));
            }
        }

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        private boolean scanRootFiles(@NullAllowed Map<URL, Set<FileObject>> files, @NonNull Set<URL> incompleteSeenRoots) {
            if (files != null && !files.isEmpty()) {
                Iterator<Map.Entry<URL, Set<FileObject>>> it = files.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<URL, Set<FileObject>> entry = it.next();
                    URL root = entry.getKey();
                    if (incompleteSeenRoots.contains(root) || this.scanFiles(root, (Collection<FileObject>)entry.getValue(), true, this.sourcesForBinaryRoots.contains(root))) {
                        it.remove();
                        continue;
                    }
                    return false;
                }
            }
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + ", suspectFilesOrFileObjects=" + this.suspectFilesOrFileObjects;
        }
    }

    private final class Controller
    extends IndexingController {
        Map<URL, List<URL>> roots2Dependencies = Collections.emptyMap();
        Map<URL, List<URL>> binRoots2Dependencies = Collections.emptyMap();
        Map<URL, List<URL>> roots2Peers = Collections.emptyMap();

        public Controller() {
            RepositoryUpdater.this.start(false);
        }

        @Override
        public void enterProtectedMode() {
            RepositoryUpdater.this.worker.enterProtectedMode(Thread.currentThread().getId());
        }

        @Override
        public void exitProtectedMode(Runnable followUpTask) {
            RepositoryUpdater.this.worker.exitProtectedMode(Thread.currentThread().getId(), followUpTask);
        }

        @Override
        public boolean isInProtectedMode() {
            return RepositoryUpdater.this.worker.isInProtectedMode();
        }

        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public synchronized Map<URL, List<URL>> getRootDependencies() {
            return this.roots2Dependencies;
        }

        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public synchronized Map<URL, List<URL>> getBinaryRootDependencies() {
            return this.binRoots2Dependencies;
        }

        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public synchronized Map<URL, List<URL>> getRootPeers() {
            return this.roots2Peers;
        }

        @Override
        public int getFileLocksDelay() {
            return FILE_LOCKS_DELAY;
        }
    }

    private static class RootsWork
    extends AbstractRootsWork {
        private final Map<URL, List<URL>> scannedRoots2Dependencies;
        private final Map<URL, List<URL>> scannedBinaries2InvDependencies;
        private final Map<URL, List<URL>> scannedRoots2Peers;
        private final Set<URL> incompleteSeenRoots;
        private final Set<URL> sourcesForBinaryRoots;
        private final AtomicLong scannedRoots2DependenciesLamport;
        private boolean useInitialState;
        private boolean refreshNonExistentDeps;
        private DependenciesContext depCtx;
        private boolean shouldDoNothing;
        private Level previousLevel;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public RootsWork(Map<URL, List<URL>> scannedRoots2Depencencies, Map<URL, List<URL>> scannedBinaries2InvDependencies, Map<URL, List<URL>> scannedRoots2Peers, Set<URL> incompleteSeenRoots, Set<URL> sourcesForBinaryRoots, boolean useInitialState, boolean refreshNonExistentDeps, @NonNull AtomicLong scannedRoots2DependenciesLamport, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext logCtx) {
            super(false, suspendStatus, logCtx);
            this.scannedRoots2Dependencies = scannedRoots2Depencencies;
            this.scannedBinaries2InvDependencies = scannedBinaries2InvDependencies;
            this.scannedRoots2Peers = scannedRoots2Peers;
            this.incompleteSeenRoots = incompleteSeenRoots;
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
            this.useInitialState = useInitialState;
            this.refreshNonExistentDeps = refreshNonExistentDeps;
            this.scannedRoots2DependenciesLamport = scannedRoots2DependenciesLamport;
        }

        @Override
        public String toString() {
            return super.toString() + ", useInitialState=" + this.useInitialState;
        }

        private void dumpGlobalRegistry(String n, Collection<String> pathIds) {
            boolean printed = false;
            for (String pathId : pathIds) {
                GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
                Set paths = gpr.getPaths(pathId);
                if (!paths.isEmpty() && !printed) {
                    LOGGER.log(Level.FINE, "Dumping: {0}", n);
                    printed = true;
                }
                LOGGER.log(Level.FINE, "Paths ID {0}: {1}", new Object[]{pathId, paths});
            }
        }

        private void checkRootCollection(Collection<? extends URL> roots) {
            FileObject parent;
            File archiveFile;
            FileObject archive;
            FileObject f;
            URL u;
            String path;
            if (!this.shouldDoNothing || roots.isEmpty() || this.getCancelRequest().isRaised()) {
                return;
            }
            int stubCount = 0;
            Iterator<? extends URL> iterator = roots.iterator();
            while (iterator.hasNext() && (path = (u = iterator.next()).getPath()) != null && path.endsWith("stubs.zip!/") && (f = URLMapper.findFileObject((URL)u)) != null && (archive = FileUtil.getArchiveFile((FileObject)f)) != null && (archiveFile = FileUtil.toFile((FileObject)archive)) != null && (parent = archive.getParent()) != null && (parent = parent.getParent()) != null) {
                String clusterPath = FileUtil.getRelativePath((FileObject)parent, (FileObject)archive);
                File file = InstalledFileLocator.getDefault().locate(clusterPath, null, false);
                if (file == null || !file.equals(archiveFile)) break;
                ++stubCount;
            }
            if (stubCount == roots.size()) {
                return;
            }
            if (this.previousLevel == null) {
                Level toSet;
                this.previousLevel = LOGGER.getLevel() == null ? Level.ALL : LOGGER.getLevel();
                try {
                    toSet = Level.parse(System.getProperty("RepositoryUpdate.increasedLogLevel", "FINE"));
                }
                catch (IllegalArgumentException ex) {
                    toSet = Level.FINE;
                }
                LOGGER.setLevel(toSet);
                LOGGER.warning("Non-empty roots encountered while no projects are opened; loglevel increased");
                Collection recogs = Lookup.getDefault().lookupAll(PathRecognizer.class);
                PathRecognizerRegistry reg = PathRecognizerRegistry.getDefault();
                this.dumpGlobalRegistry("Binary Libraries", reg.getBinaryLibraryIds());
                this.dumpGlobalRegistry("Libraries", reg.getLibraryIds());
                this.dumpGlobalRegistry("Sources", reg.getSourceIds());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public boolean getDone() {
            boolean bl;
            block39: {
                TEST_LOGGER.log(Level.FINEST, "RootsWork-started");
                if (this.getCancelRequest().isRaised()) {
                    return false;
                }
                Project[] openProjects = OpenProjects.getDefault().getOpenProjects();
                this.shouldDoNothing = openProjects.length == 0;
                try {
                    Controller controller;
                    boolean restarted;
                    this.updateProgress(NbBundle.getMessage(RepositoryUpdater.class, (String)"MSG_ProjectDependencies"));
                    long tm1 = System.currentTimeMillis();
                    if (this.depCtx != null) {
                        restarted = true;
                        this.depCtx.newRootsToScan.removeAll(this.depCtx.scannedRoots);
                        this.depCtx.scannedRoots.clear();
                        this.depCtx.newBinariesToScan.removeAll(this.depCtx.scannedBinaries);
                        this.depCtx.scannedBinaries.clear();
                        this.depCtx.oldBinaries.clear();
                        this.depCtx.oldRoots.clear();
                        if (this.shouldDoNothing) {
                            LOGGER.log(Level.WARNING, "restarted while no projects are opened. Roots = {0} binaries = {1}", new Object[]{this.depCtx.newRootsToScan, this.depCtx.newBinariesToScan});
                        }
                    } else {
                        Iterator<URL> controller2;
                        restarted = false;
                        this.depCtx = new DependenciesContext(this.scannedRoots2Dependencies, this.scannedBinaries2InvDependencies, this.scannedRoots2Peers, this.sourcesForBinaryRoots, this.useInitialState, this.refreshNonExistentDeps, () -> this.getSourceIndexers(false));
                        HashSet<? extends URL> newRoots = new HashSet<URL>();
                        Collection<? extends URL> c = PathRegistry.getDefault().getSources();
                        this.checkRootCollection(c);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "PathRegistry.sources={0}", Debug.printCollection(c, new StringBuilder()));
                        }
                        newRoots.addAll(c);
                        c = PathRegistry.getDefault().getLibraries();
                        this.checkRootCollection(c);
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "PathRegistry.libraries={0}", Debug.printCollection(c, new StringBuilder()));
                        }
                        newRoots.addAll(c);
                        this.checkRootCollection(PathRegistry.getDefault().getBinaryLibraries());
                        this.depCtx.newBinariesToScan.addAll(PathRegistry.getDefault().getBinaryLibraries());
                        if (this.useInitialState) {
                            c = PathRegistry.getDefault().getUnknownRoots();
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "PathRegistry.unknown={0}", Debug.printCollection(c, new StringBuilder()));
                            }
                            this.depCtx.unknownRoots.addAll(c);
                            this.depCtx.preInversedDeps = Util.findTransitiveReverseDependencies(this.depCtx.initialRoots2Deps, this.depCtx.initialRoots2Peers);
                            newRoots.addAll(c);
                        }
                        for (URL uRL : newRoots) {
                            if (RepositoryUpdater.findDependencies(uRL, this.depCtx, null, null, null, this.getCancelRequest(), this.getSuspendStatus())) continue;
                            this.depCtx = null;
                            boolean bl2 = false;
                            if (this.previousLevel != null) {
                                LOGGER.setLevel(this.previousLevel == Level.ALL ? null : this.previousLevel);
                                this.previousLevel = null;
                            }
                            return bl2;
                        }
                        Iterator<URL> it = this.depCtx.newBinariesToScan.iterator();
                        while (it.hasNext()) {
                            if (!this.depCtx.oldBinaries.remove(it.next())) continue;
                            it.remove();
                        }
                        Iterator<URL> iterator = controller2 = (Controller)IndexingController.getDefault();
                        synchronized (iterator) {
                            HashMap<URL, List<URL>> hashMap = new HashMap<URL, List<URL>>();
                            hashMap.putAll(this.depCtx.initialRoots2Deps);
                            hashMap.keySet().removeAll(this.depCtx.oldRoots);
                            hashMap.putAll(this.depCtx.newRoots2Deps);
                            ((Controller)((Object)controller2)).roots2Dependencies = Collections.unmodifiableMap(hashMap);
                            HashMap<URL, List<URL>> nextBinRoots2Deps = new HashMap<URL, List<URL>>();
                            nextBinRoots2Deps.putAll(this.depCtx.initialBinaries2InvDeps);
                            nextBinRoots2Deps.keySet().removeAll(this.depCtx.oldBinaries);
                            nextBinRoots2Deps.putAll(this.depCtx.newBinaries2InvDeps);
                            ((Controller)((Object)controller2)).binRoots2Dependencies = Collections.unmodifiableMap(nextBinRoots2Deps);
                            HashMap<URL, List<URL>> nextRoots2Peers = new HashMap<URL, List<URL>>();
                            nextRoots2Peers.putAll(this.depCtx.initialRoots2Peers);
                            nextRoots2Peers.keySet().removeAll(this.depCtx.oldRoots);
                            nextRoots2Peers.putAll(this.depCtx.newRoots2Peers);
                            ((Controller)((Object)controller2)).roots2Peers = Collections.unmodifiableMap(nextRoots2Peers);
                        }
                        try {
                            this.depCtx.newRootsToScan.addAll(BaseUtilities.topologicalSort(this.depCtx.newRoots2Deps.keySet(), this.depCtx.newRoots2Deps));
                        }
                        catch (TopologicalSortException topologicalSortException) {
                            LOGGER.log(Level.INFO, "Cycles detected in classpath roots dependencies, using partial ordering", topologicalSortException);
                            List list = topologicalSortException.partialSort();
                            this.depCtx.newRootsToScan.addAll(list);
                        }
                        Collections.reverse(this.depCtx.newRootsToScan);
                        if (!this.useInitialState) {
                            HashMap<URL, List<URL>> hashMap = new HashMap<URL, List<URL>>();
                            HashMap<URL, List<URL>> hashMap2 = new HashMap<URL, List<URL>>();
                            HashMap removedPeers = new HashMap();
                            HashMap addedOrChangedPeers = new HashMap();
                            RootsWork.diff(this.depCtx.initialRoots2Deps, this.depCtx.newRoots2Deps, hashMap2, hashMap);
                            RootsWork.diff(this.depCtx.initialRoots2Peers, this.depCtx.newRoots2Peers, addedOrChangedPeers, removedPeers);
                            Level logLevel = Level.FINE;
                            if (!(!LOGGER.isLoggable(logLevel) || hashMap2.isEmpty() && hashMap.isEmpty())) {
                                LOGGER.log(logLevel, "Changes in dependencies detected:");
                                LOGGER.log(logLevel, "initialRoots2Deps({0})=", this.depCtx.initialRoots2Deps.size());
                                LOGGER.log(logLevel, Debug.printMap(this.depCtx.initialRoots2Deps, new StringBuilder()).toString());
                                LOGGER.log(logLevel, "newRoots2Deps({0})=", this.depCtx.newRoots2Deps.size());
                                LOGGER.log(logLevel, Debug.printMap(this.depCtx.newRoots2Deps, new StringBuilder()).toString());
                                LOGGER.log(logLevel, "addedOrChanged({0})=", hashMap2.size());
                                LOGGER.log(logLevel, Debug.printMap(hashMap2, new StringBuilder()).toString());
                                LOGGER.log(logLevel, "removed({0})=", hashMap.size());
                                LOGGER.log(logLevel, Debug.printMap(hashMap, new StringBuilder()).toString());
                            }
                            this.depCtx.oldRoots.clear();
                            this.depCtx.oldRoots.addAll(hashMap.keySet());
                            HashSet toScan = new HashSet(hashMap2.keySet());
                            toScan.addAll(addedOrChangedPeers.keySet());
                            this.depCtx.newRootsToScan.retainAll(toScan);
                        }
                    }
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "Resolving dependencies took: {0} ms", System.currentTimeMillis() - tm1);
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Running {0} on \n{1}", new Object[]{this, this.depCtx});
                        if (this.previousLevel != null && this.getCancelRequest().isRaised()) {
                            LOGGER.fine("Note: the Work was canceled during dependency-resolve, disregard preceding logs on non-empty paths");
                            LOGGER.setLevel(this.previousLevel == Level.ALL ? null : this.previousLevel);
                        }
                    }
                    this.switchProgressToDeterminate(this.depCtx.newBinariesToScan.size() + this.depCtx.newRootsToScan.size());
                    boolean finished = this.scanBinaries(this.depCtx);
                    if (finished) {
                        finished = this.scanSources(this.depCtx, this.scannedRoots2Dependencies);
                    }
                    if (!finished) {
                        ArrayDeque<URL> toUnregister = new ArrayDeque<URL>();
                        for (URL uRL : this.depCtx.newlySFBTranslated) {
                            if (!this.depCtx.newRootsToScan.contains(uRL) || this.depCtx.scannedRoots.contains(uRL)) continue;
                            toUnregister.offer(uRL);
                        }
                        PathRegistry.getDefault().unregisterUnknownSourceRoots(toUnregister);
                    }
                    LinkedList<URL> missingRoots = new LinkedList<URL>();
                    this.scannedRoots2Dependencies.keySet().removeAll(this.depCtx.oldRoots);
                    this.scannedRoots2Peers.keySet().removeAll(this.depCtx.oldRoots);
                    this.incompleteSeenRoots.removeAll(this.depCtx.oldRoots);
                    for (URL uRL : this.depCtx.scannedRoots) {
                        void var9_33;
                        List<URL> list = this.depCtx.newRoots2Deps.get(uRL);
                        if (list == null) {
                            List<URL> list2 = UNKNOWN_ROOT;
                            missingRoots.add(uRL);
                        }
                        this.scannedRoots2Dependencies.put(uRL, (List<URL>)var9_33);
                        List<URL> list3 = this.depCtx.newRoots2Peers.get(uRL);
                        this.scannedRoots2Peers.put(uRL, list3);
                        if (!this.depCtx.newIncompleteSeenRoots.contains(uRL)) continue;
                        this.incompleteSeenRoots.add(uRL);
                    }
                    HashSet<URL> unknownToRemove = new HashSet<URL>();
                    if (!this.depCtx.unknownRoots.isEmpty()) {
                        Map<URL, Collection<URL>> map = Util.findTransitiveReverseDependencies(this.scannedRoots2Dependencies, this.scannedRoots2Peers);
                        for (URL ur : this.depCtx.unknownRoots) {
                            Collection<URL> preUrInversedDeps;
                            boolean remove;
                            Collection<URL> postUrInversedDeps = map.get(ur);
                            if (postUrInversedDeps == null) {
                                remove = true;
                            } else {
                                postUrInversedDeps.removeAll(this.depCtx.unknownRoots);
                                remove = postUrInversedDeps.isEmpty();
                            }
                            if (!remove || (preUrInversedDeps = this.depCtx.preInversedDeps.get(ur)) == null) continue;
                            preUrInversedDeps.removeAll(this.depCtx.unknownRoots);
                            if (preUrInversedDeps.isEmpty()) continue;
                            unknownToRemove.add(ur);
                        }
                    }
                    PathRegistry.getDefault().unregisterUnknownSourceRoots(unknownToRemove);
                    this.scannedRoots2DependenciesLamport.incrementAndGet();
                    if (!missingRoots.isEmpty()) {
                        StringBuilder stringBuilder = new StringBuilder("Missing dependencies for roots: ");
                        Debug.printCollection(missingRoots, stringBuilder);
                        stringBuilder.append("Context:");
                        stringBuilder.append(this.depCtx);
                        stringBuilder.append("Restarted: ");
                        stringBuilder.append(restarted);
                        LOGGER.info(stringBuilder.toString());
                    }
                    for (URL uRL : this.depCtx.scannedBinaries) {
                        List<URL> deps = this.depCtx.newBinaries2InvDeps.get(uRL);
                        if (deps == null) {
                            deps = UNKNOWN_ROOT;
                        }
                        this.scannedBinaries2InvDependencies.put(uRL, deps);
                    }
                    this.scannedBinaries2InvDependencies.keySet().removeAll(this.depCtx.oldBinaries);
                    Controller controller3 = controller = (Controller)IndexingController.getDefault();
                    synchronized (controller3) {
                        controller.roots2Dependencies = Collections.unmodifiableMap(new HashMap<URL, List<URL>>(this.scannedRoots2Dependencies));
                        controller.binRoots2Dependencies = Collections.unmodifiableMap(new HashMap<URL, List<URL>>(this.scannedBinaries2InvDependencies));
                        controller.roots2Peers = Collections.unmodifiableMap(new HashMap<URL, List<URL>>(this.scannedRoots2Peers));
                    }
                    this.notifyRootsRemoved(this.depCtx.oldBinaries, this.depCtx.oldRoots, unknownToRemove);
                    Level level = Level.FINE;
                    if (LOGGER.isLoggable(level)) {
                        LOGGER.log(level, "{0} {1}: '{'", new Object[]{this, this.getCancelRequest().isRaised() ? "cancelled" : "finished"});
                        LOGGER.log(level, "  scannedRoots2Dependencies({0})=", this.scannedRoots2Dependencies.size());
                        LOGGER.log(level, Debug.printMap(this.scannedRoots2Dependencies, new StringBuilder()).toString());
                        LOGGER.log(level, "  scannedBinaries({0})=", this.scannedBinaries2InvDependencies.size());
                        LOGGER.log(level, Debug.printCollection(this.scannedBinaries2InvDependencies.keySet(), new StringBuilder()).toString());
                        LOGGER.log(level, "  scannedRoots2Peers({0})=", this.scannedRoots2Peers.size());
                        LOGGER.log(level, Debug.printMap(this.scannedRoots2Peers, new StringBuilder()).toString());
                        LOGGER.log(level, "} ====");
                    }
                    TEST_LOGGER.log(Level.FINEST, "RootsWork-finished");
                    HashSet<URL> affectedRoots = new HashSet<URL>();
                    affectedRoots.addAll(this.depCtx.newRootsToScan);
                    affectedRoots.addAll(this.depCtx.newBinariesToScan);
                    affectedRoots.addAll(this.depCtx.scannedRoots);
                    affectedRoots.addAll(this.depCtx.scannedBinaries);
                    affectedRoots.addAll(this.depCtx.oldBinaries);
                    affectedRoots.addAll(this.depCtx.oldRoots);
                    this.refreshAffectedDocuments(affectedRoots);
                    bl = finished;
                    if (this.previousLevel == null) break block39;
                    LOGGER.setLevel(this.previousLevel == Level.ALL ? null : this.previousLevel);
                }
                catch (Throwable throwable) {
                    if (this.previousLevel != null) {
                        LOGGER.setLevel(this.previousLevel == Level.ALL ? null : this.previousLevel);
                        this.previousLevel = null;
                    }
                    throw throwable;
                }
                this.previousLevel = null;
            }
            return bl;
        }

        @Override
        protected boolean isCancelledBy(Work newWork, Collection<? super Work> follow) {
            boolean b;
            boolean bl = b = newWork instanceof RootsWork && this.useInitialState;
            if (b) {
                newWork.inheritChangedIndexers(this);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Cancelling {0}, because of {1}", new Object[]{this, newWork});
                }
            }
            return b;
        }

        @Override
        public boolean absorb(Work newWork) {
            if (newWork.getClass().equals(RootsWork.class)) {
                RootsWork rw = (RootsWork)newWork;
                if (!rw.useInitialState) {
                    this.useInitialState = rw.useInitialState;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Absorbing {0}, updating useInitialState to {1}", new Object[]{rw, this.useInitialState});
                    }
                }
                this.inheritChangedIndexers(newWork);
                if (rw.refreshNonExistentDeps) {
                    this.refreshNonExistentDeps = rw.refreshNonExistentDeps;
                }
                return true;
            }
            return false;
        }

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        private void notifyRootsRemoved(@NonNull Collection<? extends URL> binaries, @NonNull Collection<? extends URL> sources, @NonNull Collection<? extends URL> unknown) {
            if (!binaries.isEmpty()) {
                Collection binFactories = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);
                Collection<? extends URL> roots = Collections.unmodifiableCollection(binaries);
                for (BinaryIndexerFactory binaryIndexerFactory : binFactories) {
                    binaryIndexerFactory.rootsRemoved(roots);
                }
                RepositoryUpdater.getDefault().rootsListeners.removeBinaries(binaries);
            }
            if (!sources.isEmpty() || !unknown.isEmpty()) {
                ProxyIterable roots = new ProxyIterable(Arrays.asList(sources, unknown));
                Collection<IndexerCache.IndexerInfo<CustomIndexerFactory>> customIndexers = IndexerCache.getCifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo indexerInfo : customIndexers) {
                    ((CustomIndexerFactory)indexerInfo.getIndexerFactory()).rootsRemoved(roots);
                }
                Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> embeddingIndexers = IndexerCache.getEifCache().getIndexers(null);
                for (IndexerCache.IndexerInfo<EmbeddingIndexerFactory> embeddingIndexer : embeddingIndexers) {
                    embeddingIndexer.getIndexerFactory().rootsRemoved(roots);
                }
                RepositoryUpdater.getDefault().rootsListeners.removeSources(sources);
            }
        }

        private static <A, B> void diff(Map<A, B> oldMap, Map<A, B> newMap, Map<A, B> addedOrChangedEntries, Map<A, B> removedEntries) {
            for (A key : oldMap.keySet()) {
                if (!newMap.containsKey(key)) {
                    removedEntries.put(key, oldMap.get(key));
                    continue;
                }
                if (BaseUtilities.compareObjects(oldMap.get(key), newMap.get(key))) continue;
                addedOrChangedEntries.put(key, newMap.get(key));
            }
            for (A key : newMap.keySet()) {
                if (oldMap.containsKey(key)) continue;
                addedOrChangedEntries.put(key, newMap.get(key));
            }
        }
    }

    static final class LexicographicComparator
    implements Comparator<URL> {
        private final boolean reverse;

        public LexicographicComparator(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        public int compare(URL o1, URL o2) {
            int order = o1.toString().compareTo(o2.toString());
            return this.reverse ? -1 * order : order;
        }
    }

    private final class FCL
    extends FileChangeAdapter {
        private final Boolean listeningOnSources;

        public FCL(Boolean listeningOnSources) {
            this.listeningOnSources = listeningOnSources;
        }

        public void fileFolderCreated(FileEvent fe) {
            RepositoryUpdater.this.fileFolderCreatedImpl(fe, this.listeningOnSources);
        }

        public void fileDataCreated(FileEvent fe) {
            RepositoryUpdater.this.fileChangedImpl(fe, this.listeningOnSources);
        }

        public void fileChanged(FileEvent fe) {
            RepositoryUpdater.this.fileChangedImpl(fe, this.listeningOnSources);
        }

        public void fileDeleted(FileEvent fe) {
            RepositoryUpdater.this.fileDeletedImpl(fe, this.listeningOnSources);
        }

        public void fileRenamed(FileRenameEvent fe) {
            RepositoryUpdater.this.fileRenamedImpl(fe, this.listeningOnSources);
        }
    }

    private static final class DependenciesContext {
        final Map<URL, List<URL>> initialRoots2Deps;
        final Map<URL, List<URL>> initialBinaries2InvDeps;
        final Map<URL, List<URL>> initialRoots2Peers;
        final Set<URL> oldRoots;
        final Set<URL> oldBinaries;
        final Map<URL, List<URL>> newRoots2Deps;
        final Map<URL, List<URL>> newBinaries2InvDeps;
        final Map<URL, List<URL>> newRoots2Peers;
        final List<URL> newRootsToScan;
        final Set<URL> newBinariesToScan;
        final Set<URL> newIncompleteSeenRoots;
        final Set<URL> scannedRoots;
        final Set<URL> scannedBinaries;
        final Set<URL> sourcesForBinaryRoots;
        final Set<URL> unknownRoots;
        final Set<URL> newlySFBTranslated;
        Map<URL, Collection<URL>> preInversedDeps;
        Set<URL> fullRescanSourceRoots;
        final Stack<URL> cycleDetector;
        final boolean useInitialState;
        final boolean refreshNonExistentDeps;
        private final Callable<SourceIndexers> indexersProvider;
        private Set<String> indexerNames;

        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        public DependenciesContext(@NonNull Map<URL, List<URL>> scannedRoots2Deps, @NonNull Map<URL, List<URL>> scannedBinaries2InvDependencies, @NonNull Map<URL, List<URL>> scannedRoots2Peers, @NonNull Set<URL> sourcesForBinaryRoots, boolean useInitialState, boolean refreshNonExistentDeps, @NonNull Callable<SourceIndexers> indexersProvider) {
            assert (scannedRoots2Deps != null);
            assert (scannedBinaries2InvDependencies != null);
            this.initialRoots2Deps = Collections.unmodifiableMap(scannedRoots2Deps);
            this.initialBinaries2InvDeps = Collections.unmodifiableMap(scannedBinaries2InvDependencies);
            this.initialRoots2Peers = Collections.unmodifiableMap(scannedRoots2Peers);
            this.oldRoots = new HashSet<URL>(scannedRoots2Deps.keySet());
            this.oldBinaries = new HashSet<URL>(scannedBinaries2InvDependencies.keySet());
            this.newRoots2Deps = new HashMap<URL, List<URL>>();
            this.newBinaries2InvDeps = new HashMap<URL, List<URL>>();
            this.newRoots2Peers = new HashMap<URL, List<URL>>();
            this.newRootsToScan = new ArrayList<URL>();
            this.newBinariesToScan = new HashSet<URL>();
            this.scannedRoots = new HashSet<URL>();
            this.scannedBinaries = new HashSet<URL>();
            this.sourcesForBinaryRoots = sourcesForBinaryRoots;
            this.fullRescanSourceRoots = new HashSet<URL>();
            this.useInitialState = useInitialState;
            this.refreshNonExistentDeps = refreshNonExistentDeps;
            this.cycleDetector = new Stack();
            this.unknownRoots = new HashSet<URL>();
            this.newlySFBTranslated = new HashSet<URL>();
            this.newIncompleteSeenRoots = new HashSet<URL>();
            this.indexersProvider = indexersProvider;
        }

        @NonNull
        Set<String> getIndexerNames() {
            if (this.indexerNames == null) {
                this.indexerNames = new HashSet<String>();
                try {
                    SourceIndexers indexers = this.indexersProvider.call();
                    for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                        this.indexerNames.add(indexerInfo.getIndexerName());
                    }
                    for (Collection collection : indexers.eifInfosMap.values()) {
                        for (IndexerCache.IndexerInfo indexer : collection) {
                            this.indexerNames.add(indexer.getIndexerName());
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return Collections.unmodifiableSet(this.indexerNames);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString());
            sb.append(": {\n");
            sb.append("  useInitialState=").append(this.useInitialState).append("\n");
            sb.append("  initialRoots2Deps(").append(this.initialRoots2Deps.size()).append(")=\n");
            Debug.printMap(this.initialRoots2Deps, sb);
            sb.append("  initialBinaries(").append(this.initialBinaries2InvDeps.size()).append(")=\n");
            Debug.printMap(this.initialBinaries2InvDeps, sb);
            sb.append("  initialRoots2Peers(").append(this.initialRoots2Peers.size()).append(")=\n");
            Debug.printMap(this.initialRoots2Peers, sb);
            sb.append("  oldRoots(").append(this.oldRoots.size()).append(")=\n");
            Debug.printCollection(this.oldRoots, sb);
            sb.append("  oldBinaries(").append(this.oldBinaries.size()).append(")=\n");
            Debug.printCollection(this.oldBinaries, sb);
            sb.append("  newRootsToScan(").append(this.newRootsToScan.size()).append(")=\n");
            Debug.printCollection(this.newRootsToScan, sb);
            sb.append("  newBinariesToScan(").append(this.newBinariesToScan.size()).append(")=\n");
            Debug.printCollection(this.newBinariesToScan, sb);
            sb.append("  scannedRoots(").append(this.scannedRoots.size()).append(")=\n");
            Debug.printCollection(this.scannedRoots, sb);
            sb.append("  scannedBinaries(").append(this.scannedBinaries.size()).append(")=\n");
            Debug.printCollection(this.scannedBinaries, sb);
            sb.append("  newRoots2Deps(").append(this.newRoots2Deps.size()).append(")=\n");
            Debug.printMap(this.newRoots2Deps, sb);
            sb.append("  newBinaries2InvDeps(").append(this.newBinaries2InvDeps.size()).append(")=\n");
            Debug.printMap(this.newBinaries2InvDeps, sb);
            sb.append("  newRoots2Peers(").append(this.newRoots2Peers.size()).append(")=\n");
            Debug.printMap(this.newRoots2Peers, sb);
            sb.append("} ----\n");
            return sb.toString();
        }
    }

    private static enum IncompleteStatus {
        COMPLETE(true, true),
        INCOMPLETE_SEEN(true, false),
        INCOMPLETE_UNSEEN(false, false);

        private final boolean active;
        private final boolean shouldScan;

        private IncompleteStatus(boolean active, boolean shouldScan) {
            this.active = active;
            this.shouldScan = shouldScan;
        }

        boolean active() {
            return this.active;
        }

        boolean shouldScan() {
            return this.shouldScan;
        }

        @NonNull
        static IncompleteStatus get(boolean incomplete, @NonNull URL rootURL, @NonNull DependenciesContext depCtx) {
            if (incomplete) {
                if (depCtx.initialRoots2Deps.containsKey(rootURL) || IncompleteStatus.hasIndex(rootURL, depCtx)) {
                    return INCOMPLETE_SEEN;
                }
                return INCOMPLETE_UNSEEN;
            }
            return COMPLETE;
        }

        private static boolean hasIndex(@NonNull URL root, @NonNull DependenciesContext depCtx) {
            try {
                FileObject dataFolder = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.EXISTENT);
                if (dataFolder != null) {
                    Set<String> names = depCtx.getIndexerNames();
                    for (FileObject child : dataFolder.getChildren()) {
                        if (!names.contains(child.getName())) continue;
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }

    private static class SamplerInvoker
    implements Runnable,
    Callable<byte[]> {
        private ProfilerSupport sampler;
        private final String indexerName;
        private RequestProcessor.Task scheduled;
        private final URL root;
        private final int estimate;

        public SamplerInvoker(String indexerName, int delay, URL root) {
            this.estimate = delay;
            this.indexerName = indexerName;
            this.root = root;
        }

        public static void start(LogContext ctx, String indexerName, int delay, URL root) {
            if (delay <= 0) {
                return;
            }
            if (currentSampler != null) {
                return;
            }
            String prop = System.getProperty(PROP_SAMPLING);
            if (prop == null) {
                return;
            }
            SamplerInvoker inv = new SamplerInvoker(indexerName, delay, root);
            if (Boolean.TRUE.equals(Boolean.valueOf(prop)) || "oneshot".equals(prop)) {
                delay = 0;
            }
            ctx.setProfileSource(inv);
            inv.scheduled = SAMPLER_RP.post((Runnable)inv, delay);
            currentSampler = inv;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Sampler scheduled after {0} + {3} for indexer {1} on {2}", new Object[]{new Date(), indexerName, root, delay});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProfilerSupport.Factory factory = (ProfilerSupport.Factory)Lookup.getDefault().lookup(ProfilerSupport.Factory.class);
            if (factory != null) {
                SamplerInvoker samplerInvoker = this;
                synchronized (samplerInvoker) {
                    ProfilerSupport newSampler = factory.create("repoupdater");
                    if (newSampler != null && currentSampler == this) {
                        newSampler.start();
                        this.sampler = newSampler;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Updater profiling started at {0} because of {1} runnint on {2} more than {3})", new Object[]{new Date(), this.indexerName, this.root, this.estimate});
                        }
                    }
                }
            }
        }

        @Override
        public synchronized byte[] call() throws Exception {
            if (this.sampler == null) {
                return null;
            }
            LOGGER.log(Level.FINE, "Dumping snapshot for {0}", this.indexerName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try (DataOutputStream dos = new DataOutputStream(out);){
                this.sampler.stopAndSnapshot(dos);
            }
            this.sampler = null;
            return out.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean _stop(boolean release) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Sampler cancelled at {0} for indexer {1} on {2}", new Object[]{new Date(), this.indexerName, this.root});
            }
            if (this.scheduled != null && !this.scheduled.cancel()) {
                LOGGER.log(Level.FINE, "Sampling has already started, release = {0}", release);
                if (release) {
                    SamplerInvoker samplerInvoker = this;
                    synchronized (samplerInvoker) {
                        if (this.sampler != null) {
                            this.sampler.cancel();
                            this.sampler = null;
                        }
                    }
                    return true;
                }
                return false;
            }
            return true;
        }

        public static void release() {
            if (currentSampler != null) {
                currentSampler._stop(true);
                currentSampler = null;
            }
        }

        public static boolean stop() {
            if (currentSampler == null) {
                return true;
            }
            boolean s = currentSampler._stop(false);
            if (s) {
                currentSampler = null;
            }
            return s;
        }
    }

    private static class WorkCancel
    implements Cancellable {
        private final AtomicReference<Work> work = new AtomicReference();

        private WorkCancel() {
        }

        public void setWork(@NullAllowed Work theWork) {
            this.work.set(theWork);
        }

        public boolean cancel() {
            LogContext logCtx;
            Work theWork = this.work.get();
            if (theWork != null && (logCtx = theWork.getLogContext()) != null) {
                logCtx.log();
            }
            return false;
        }
    }

    private static final class BinaryIndexers {
        public final Collection<? extends BinaryIndexerFactory> bifs = MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookupAll(BinaryIndexerFactory.class);

        public static BinaryIndexers load() {
            return new BinaryIndexers();
        }

        private BinaryIndexers() {
        }
    }

    private static final class SourceIndexers {
        public final Set<IndexerCache.IndexerInfo<CustomIndexerFactory>> changedCifs;
        public final Collection<? extends IndexerCache.IndexerInfo<CustomIndexerFactory>> cifInfos;
        public final Set<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>> changedEifs;
        public final Map<String, Collection<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>> eifInfosMap;

        public static SourceIndexers load(boolean detectChanges) {
            return new SourceIndexers(detectChanges);
        }

        private SourceIndexers(boolean detectChanges) {
            long start = System.currentTimeMillis();
            if (detectChanges) {
                this.changedCifs = new HashSet<IndexerCache.IndexerInfo<CustomIndexerFactory>>();
                this.changedEifs = new HashSet<IndexerCache.IndexerInfo<EmbeddingIndexerFactory>>();
            } else {
                this.changedCifs = null;
                this.changedEifs = null;
            }
            this.cifInfos = IndexerCache.getCifCache().getIndexers(this.changedCifs);
            this.eifInfosMap = IndexerCache.getEifCache().getIndexersMap(this.changedEifs);
            long delta = System.currentTimeMillis() - start;
            LOGGER.log(Level.FINE, "Loading indexers took {0} ms.", delta);
        }
    }

    private static abstract class AbstractRootsWork
    extends Work {
        private boolean logStatistics;

        protected AbstractRootsWork(boolean logStatistics, @NonNull SuspendStatus suspendStatus, @NullAllowed LogContext ctx) {
            super(false, false, true, true, suspendStatus, ctx);
            this.logStatistics = logStatistics;
        }

        protected final boolean scanBinaries(DependenciesContext ctx) {
            assert (ctx != null);
            AtomicInteger scannedRootsCnt = new AtomicInteger(0);
            BinaryIndexers binaryIndexers = ctx.newBinariesToScan.isEmpty() ? null : BinaryIndexers.load();
            IndexBinaryWorkPool pool = new IndexBinaryWorkPool(root -> this.scanBinary((URL)root, binaryIndexers, scannedRootsCnt), () -> this.getCancelRequest().isRaised(), ctx.newBinariesToScan);
            long binaryScanStart = System.currentTimeMillis();
            Pair<Boolean, Collection<? extends URL>> res = pool.execute();
            long binaryScanEnd = System.currentTimeMillis();
            ctx.scannedBinaries.addAll((Collection)res.second());
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Complete indexing of {0} binary roots took: {1} ms", new Object[]{scannedRootsCnt.get(), binaryScanEnd - binaryScanStart});
            }
            TEST_LOGGER.log(Level.FINEST, "scanBinary", ctx.newBinariesToScan);
            return (Boolean)res.first();
        }

        protected final boolean scanBinary(@NonNull URL root, @NonNull BinaryIndexers binaryIndexers, AtomicInteger scannedRootsCnt) {
            try {
                Callable<Boolean> action = () -> {
                    long tmStart;
                    boolean success;
                    block15: {
                        success = false;
                        tmStart = System.currentTimeMillis();
                        LinkedHashMap<BinaryIndexerFactory, Context> contexts = new LinkedHashMap<BinaryIndexerFactory, Context>(binaryIndexers.bifs.size());
                        BitSet startedIndexers = new BitSet(binaryIndexers.bifs.size());
                        LogContext lctx = this.getLogContext();
                        if (lctx != null) {
                            lctx.noteRootScanning(root, false);
                        }
                        try {
                            boolean upToDate;
                            long currentLastModified;
                            FileObject file;
                            this.createBinaryContexts(root, binaryIndexers, contexts);
                            FileObject rootFo = URLCache.getInstance().findFileObject(root, true);
                            FileObject fileObject = file = rootFo == null ? null : FileUtil.getArchiveFile((FileObject)rootFo);
                            if (file != null) {
                                Pair<Long, Map<Pair<String, Integer>, Integer>> lastState = ArchiveTimeStamps.getLastModified(root);
                                boolean indexersUpToDate = this.checkBinaryIndexers(lastState, contexts);
                                currentLastModified = file.lastModified().getTime();
                                upToDate = indexersUpToDate && (Long)lastState.first() == currentLastModified;
                            } else {
                                currentLastModified = -1L;
                                upToDate = false;
                            }
                            try {
                                this.binaryScanStarted(root, upToDate, contexts, startedIndexers);
                                this.updateProgress(root, true);
                                success = this.indexBinary(root, binaryIndexers, contexts);
                            }
                            finally {
                                this.binaryScanFinished(binaryIndexers, contexts, startedIndexers, success);
                                if (success && !upToDate && FileUtil.getArchiveFile((URL)root) != null) {
                                    ArchiveTimeStamps.setLastModified(root, this.createBinaryIndexersTimeStamp(currentLastModified, contexts));
                                }
                            }
                            if (lctx == null) break block15;
                            lctx.finishScannedRoot(root);
                        }
                        catch (Throwable throwable) {
                            if (lctx != null) {
                                lctx.finishScannedRoot(root);
                            }
                            long time = System.currentTimeMillis() - tmStart;
                            if (scannedRootsCnt != null) {
                                scannedRootsCnt.incrementAndGet();
                            }
                            AbstractRootsWork.reportRootScan(root, time);
                            if (LOGGER.isLoggable(Level.FINE)) {
                                LOGGER.log(Level.FINE, "Indexing of: {0} took: {1} ms", new Object[]{root, time});
                            }
                            throw throwable;
                        }
                    }
                    long time = System.currentTimeMillis() - tmStart;
                    if (scannedRootsCnt != null) {
                        scannedRootsCnt.incrementAndGet();
                    }
                    AbstractRootsWork.reportRootScan(root, time);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Indexing of: {0} took: {1} ms", new Object[]{root, time});
                    }
                    return success;
                };
                return RepositoryUpdater.runInContext(root, action);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
                return false;
            }
        }

        /*
         * Exception decompiling
         */
        @SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="URLs have never host part")
        protected final boolean scanSources(DependenciesContext ctx, Map<URL, List<URL>> preregisterIn) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static boolean isNoRootsScan() {
            return Boolean.getBoolean("netbeans.indexing.noRootsScan");
        }

        @CheckForNull
        private static URL getRemoteIndexURL(@NonNull URL sourceRoot) {
            for (IndexDownloader ld : Lookup.getDefault().lookupAll(IndexDownloader.class)) {
                URL indexURL = ld.getIndexURL(sourceRoot);
                if (indexURL == null) continue;
                return indexURL;
            }
            return null;
        }

        private static boolean patchDownloadedIndex(@NonNull URL sourceRoot, @NonNull URL cacheFolder) {
            boolean vote = true;
            for (DownloadedIndexPatcher patcher : Lookup.getDefault().lookupAll(DownloadedIndexPatcher.class)) {
                vote &= patcher.updateIndex(sourceRoot, cacheFolder);
            }
            return vote;
        }

        @NonNull
        private static String getSimpleName(@NonNull URL indexURL) throws IllegalArgumentException {
            String path = indexURL.getPath();
            if (path.length() == 0 || path.charAt(path.length() - 1) == '/') {
                throw new IllegalArgumentException(indexURL.toString());
            }
            int index = path.lastIndexOf(47);
            return index < 0 ? path : path.substring(index + 1);
        }

        @CheckForNull
        private File download(@NonNull URL indexURL, @NonNull File into) {
            try {
                File packedIndex = new File(into, AbstractRootsWork.getSimpleName(indexURL));
                try (BufferedInputStream in = new BufferedInputStream(indexURL.openStream());
                     BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(packedIndex));){
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                }
                return packedIndex;
            }
            catch (IOException ioe) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean unpack(@NonNull File packedFile, @NonNull File targetFolder) throws IOException {
            ZipFile zf = new ZipFile(packedFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            try {
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File target = new File(targetFolder, entry.getName().replace('/', File.separatorChar));
                    if (entry.isDirectory()) {
                        target.mkdirs();
                        continue;
                    }
                    target.getParentFile().mkdirs();
                    InputStream in = zf.getInputStream(entry);
                    try (FileOutputStream out = new FileOutputStream(target);){
                        FileUtil.copy((InputStream)in, (OutputStream)out);
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                return true;
            }
            finally {
                zf.close();
            }
        }

        private static void delete(File ... toDelete) {
            if (toDelete != null) {
                for (File td : toDelete) {
                    if (td.isDirectory()) {
                        AbstractRootsWork.delete(td.listFiles());
                    }
                    td.delete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean nopCustomIndexers(@NonNull URL root, @NonNull SourceIndexers indexers, boolean sourceForBinaryRoot) throws IOException {
            FileObject cacheRoot = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.CREATE);
            HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> transactionContexts = new HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>>();
            Work.UsedIndexables usedIndexables = new Work.UsedIndexables();
            HashMap<SourceIndexerFactory, Boolean> votes = new HashMap<SourceIndexerFactory, Boolean>();
            boolean indexResult = false;
            try {
                this.customIndexersScanStarted(root, cacheRoot, sourceForBinaryRoot, indexers.cifInfos, votes, transactionContexts);
                for (IndexerCache.IndexerInfo<CustomIndexerFactory> indexerInfo : indexers.cifInfos) {
                    if (this.getCancelRequest().isRaised()) break;
                    CustomIndexerFactory factory = indexerInfo.getIndexerFactory();
                    CustomIndexer indexer = factory.createIndexer();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Fake indexing: indexer={0}", indexer);
                    }
                    long start = System.currentTimeMillis();
                    this.logStartIndexer(indexerInfo.getIndexerName());
                    try {
                        Pair indexerKey = Pair.of((Object)factory.getIndexerName(), (Object)factory.getIndexVersion());
                        Pair ctx = (Pair)transactionContexts.get(indexerKey);
                        if (ctx != null) {
                            SPIAccessor.getInstance().index(indexer, Collections.emptySet(), (Context)ctx.second());
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "RefreshCifIndices ignored recently added factory: {0}", indexerKey);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                    finally {
                        this.logIndexerTime(indexerInfo.getIndexerName(), (int)(System.currentTimeMillis() - start));
                    }
                }
                indexResult = !this.getCancelRequest().isRaised();
            }
            finally {
                this.scanFinished(transactionContexts.values(), usedIndexables, indexResult);
            }
            return indexResult;
        }

        private boolean scanSource(@NonNull URL root, boolean fullRescan, boolean sourceForBinaryRoot, @NullAllowed int[] outOfDateFiles, @NullAllowed int[] deletedFiles, @NullAllowed long[] recursiveListenersTime) throws IOException {
            LOGGER.log(Level.FINE, "Scanning sources root: {0}", root);
            FileObject rootFo = URLCache.getInstance().findFileObject(root, true);
            if (rootFo != null) {
                Callable<Boolean> action = () -> {
                    URL indexURL;
                    boolean rootSeen = TimeStamps.existForRoot(root);
                    SourceIndexers indexers = this.getSourceIndexers(false);
                    if (AbstractRootsWork.isNoRootsScan() && !fullRescan && rootSeen) {
                        return this.nopCustomIndexers(root, indexers, sourceForBinaryRoot);
                    }
                    LogContext lctx = this.getLogContext();
                    long t = System.currentTimeMillis();
                    if (!rootSeen && (indexURL = AbstractRootsWork.getRemoteIndexURL(root)) != null) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Downloading index for root: {0} from: {1}", new Object[]{root, indexURL});
                        }
                        FileObject cf = CacheFolder.getCacheFolder();
                        assert (cf != null);
                        File cacheFolder = FileUtil.toFile((FileObject)cf);
                        assert (cacheFolder != null);
                        File downloadFolder = new File(cacheFolder, RepositoryUpdater.INDEX_DOWNLOAD_FOLDER);
                        if (downloadFolder.exists()) {
                            AbstractRootsWork.delete(downloadFolder.listFiles());
                        } else {
                            downloadFolder.mkdir();
                        }
                        File packedIndex = this.download(indexURL, downloadFolder);
                        if (packedIndex != null) {
                            this.unpack(packedIndex, downloadFolder);
                            packedIndex.delete();
                            if (AbstractRootsWork.patchDownloadedIndex(root, BaseUtilities.toURI((File)downloadFolder).toURL())) {
                                FileObject df = CacheFolder.getDataFolder(root, EnumSet.of(CacheFolderProvider.Kind.SOURCES, CacheFolderProvider.Kind.LIBRARIES), CacheFolderProvider.Mode.CREATE);
                                assert (df != null);
                                File dataFolder = FileUtil.toFile((FileObject)df);
                                assert (dataFolder != null);
                                if (dataFolder.exists()) {
                                    AbstractRootsWork.delete(dataFolder);
                                }
                                downloadFolder.renameTo(dataFolder);
                                TimeStamps timeStamps = TimeStamps.forRoot(root, false);
                                timeStamps.resetToNow();
                                timeStamps.store();
                                this.nopCustomIndexers(root, indexers, sourceForBinaryRoot);
                                for (Map.Entry e : IndexManager.getOpenIndexes().entrySet()) {
                                    if (!Util.isParentOf(dataFolder, (File)e.getKey())) continue;
                                    ((Index)e.getValue()).getStatus(true);
                                }
                                return true;
                            }
                        }
                    }
                    ClassPath.Entry entry = sourceForBinaryRoot ? null : RepositoryUpdater.getClassPathEntry(rootFo);
                    EnumSet<Crawler.TimeStampAction> checkTimeStamps = EnumSet.of(Crawler.TimeStampAction.UPDATE);
                    if (!fullRescan) {
                        checkTimeStamps.add(Crawler.TimeStampAction.CHECK);
                    }
                    FileObjectCrawler crawler = new FileObjectCrawler(rootFo, checkTimeStamps, entry, this.getCancelRequest(), this.getSuspendStatus());
                    List<Indexable> resources = crawler.getResources();
                    List<Indexable> allResources = crawler.getAllResources();
                    List<Indexable> deleted = crawler.getDeletedResources();
                    this.modifiedResourceCount = resources.size();
                    this.allResourceCount = allResources == null ? 0 : allResources.size();
                    this.logCrawlerTime(crawler, t);
                    if (crawler.isFinished()) {
                        IdentityHashMap<SourceIndexerFactory, Boolean> invalidatedMap = new IdentityHashMap<SourceIndexerFactory, Boolean>();
                        HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>> ctxToFinish = new HashMap<Pair<String, Integer>, Pair<SourceIndexerFactory, Context>>();
                        Work.UsedIndexables usedIterables = new Work.UsedIndexables();
                        boolean indexResult = false;
                        try {
                            this.scanStarted(root, sourceForBinaryRoot, indexers, invalidatedMap, ctxToFinish);
                            this.delete(deleted, ctxToFinish, usedIterables);
                            long tm = System.currentTimeMillis();
                            boolean rlAdded = RepositoryUpdater.getDefault().rootsListeners.addSource(root, entry);
                            if (recursiveListenersTime != null) {
                                recursiveListenersTime[0] = System.currentTimeMillis() - tm;
                            }
                            if (rlAdded) {
                                indexResult = this.index(resources, allResources, root, sourceForBinaryRoot, indexers, invalidatedMap, ctxToFinish, usedIterables);
                                this.invalidateSources(resources);
                                if (indexResult) {
                                    crawler.storeTimestamps();
                                    outOfDateFiles[0] = resources.size();
                                    deletedFiles[0] = deleted.size();
                                    if (this.logStatistics) {
                                        this.logStatistics = false;
                                        if (SFEC_LOGGER.isLoggable(Level.INFO)) {
                                            LogRecord r = new LogRecord(Level.INFO, "STATS_SCAN_SOURCES");
                                            r.setParameters(new Object[]{outOfDateFiles[0] > 0 || deletedFiles[0] > 0});
                                            r.setResourceBundle(NbBundle.getBundle(RepositoryUpdater.class));
                                            r.setResourceBundleName(RepositoryUpdater.class.getPackage().getName() + ".Bundle");
                                            r.setLoggerName(SFEC_LOGGER.getName());
                                            SFEC_LOGGER.log(r);
                                        }
                                    }
                                    Boolean bl = true;
                                    return bl;
                                }
                            }
                        }
                        finally {
                            this.scanFinished(ctxToFinish.values(), usedIterables, indexResult);
                        }
                    }
                    return false;
                };
                return RepositoryUpdater.runInContext(rootFo, action);
            }
            RepositoryUpdater.getDefault().rootsListeners.addSource(root, null);
            return true;
        }

        private static void reportRootScan(URL root, long duration) {
            if (PERF_LOGGER.isLoggable(Level.FINE)) {
                PERF_LOGGER.log(Level.FINE, "reportScanOfFile: {0} {1}", new Object[]{root, duration});
            }
        }
    }
}

