/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.extexecution.base;

import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.extexecution.base.EnvironmentAccessor;
import org.netbeans.spi.extexecution.base.EnvironmentImplementation;
import org.openide.util.Parameters;

public final class Environment {
    private final EnvironmentImplementation implementation;

    private Environment(EnvironmentImplementation implementation) {
        this.implementation = implementation;
    }

    @CheckForNull
    public String getVariable(@NonNull String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        return this.implementation.getVariable(name);
    }

    public void appendPath(@NonNull String name, @NonNull String value) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"value", (Object)value);
        this.implementation.appendPath(name, value);
    }

    public void prependPath(@NonNull String name, @NonNull String value) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"value", (Object)value);
        this.implementation.prependPath(name, value);
    }

    public void setVariable(@NonNull String name, @NonNull String value) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"value", (Object)value);
        this.implementation.setVariable(name, value);
    }

    public void removeVariable(@NonNull String name) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.implementation.removeVariable(name);
    }

    @NonNull
    public Map<String, String> values() {
        return this.implementation.values();
    }

    static {
        EnvironmentAccessor.setDefault(new EnvironmentAccessor(){

            @Override
            public Environment createEnvironment(EnvironmentImplementation impl) {
                return new Environment(impl);
            }
        });
    }
}

