/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;

public class ArchiveTypeBindingTypeFilter<T extends Element>
extends Filter<T> {
    private WebBeansModelImplementation myImpl;

    static <T extends Element> ArchiveTypeBindingTypeFilter<T> get(Class<T> clazz) {
        ArchiveTypeBindingTypeFilter.assertElement(clazz);
        if (clazz.equals(Element.class) || clazz.equals(TypeElement.class)) {
            return new ArchiveTypeBindingTypeFilter<T>();
        }
        return null;
    }

    void init(WebBeansModelImplementation impl) {
        this.myImpl = impl;
    }

    @Override
    void filter(Set<T> set) {
        super.filter(set);
        if (this.myImpl.getBeansModel() != null) {
            switch (this.myImpl.getBeansModel().getBeanArchiveType()) {
                case NONE: {
                    set.clear();
                    break;
                }
                case IMPLICIT: {
                    CompilationController compInfo = this.myImpl.getModel().getCompilationController();
                    Iterator<T> iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Element element = (Element)iterator.next();
                        boolean isNormalScopeOrScopeOrSingleton = AnnotationUtil.getAnnotationMirror(element, (CompilationInfo)compInfo, "javax.enterprise.context.NormalScope", "jakarta.enterprise.context.NormalScope", "javax.inject.Scope", "jakarta.inject.Scope", "javax.enterprise.context.RequestScoped", "jakarta.enterprise.context.RequestScoped", "javax.enterprise.context.SessionScoped", "jakarta.enterprise.context.SessionScoped", "javax.enterprise.context.ApplicationScoped", "jakarta.enterprise.context.ApplicationScoped", "javax.enterprise.context.ConversationScoped", "jakarta.enterprise.context.ConversationScoped", "javax.enterprise.context.Dependent", "jakarta.enterprise.context.Dependent", "javax.inject.Singleton", "jakarta.inject.Singleton") != null;
                        if (isNormalScopeOrScopeOrSingleton || AnnotationUtil.isSessionBean(element, (CompilationInfo)compInfo)) continue;
                        iterator.remove();
                    }
                    break;
                }
            }
        }
    }
}

