/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.refactoring;

import com.google.gson.Gson;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.netbeans.api.htmlui.HTMLDialog;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.input.QuickPickItem;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.refactoring.Bundle;
import org.netbeans.modules.java.lsp.server.refactoring.ChangeMethodParameterUI;
import org.netbeans.modules.java.lsp.server.refactoring.CodeRefactoring;
import org.netbeans.modules.java.lsp.server.refactoring.Pages;
import org.netbeans.modules.java.lsp.server.refactoring.ParameterUI;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class ChangeMethodParametersRefactoring
extends CodeRefactoring {
    private static final String CHANGE_METHOD_PARAMS_REFACTORING_KIND = "refactor.change.method.params";
    private static final String CHANGE_METHOD_PARAMS_REFACTORING_COMMAND = "nbls.java.refactor.change.method.params";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        TreePath path;
        CompilationController info;
        List only = params.getContext().getOnly();
        if (only == null || !only.contains("refactor")) {
            return Collections.emptyList();
        }
        CompilationController compilationController = info = resultIterator.getParserResult() != null ? CompilationController.get((Parser.Result)resultIterator.getParserResult()) : null;
        if (info == null || !JavaRefactoringUtils.isRefactorable((FileObject)info.getFileObject())) {
            return Collections.emptyList();
        }
        info.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        int offset = ChangeMethodParametersRefactoring.getOffset((CompilationInfo)info, params.getRange().getStart());
        TokenSequence ts = info.getTokenHierarchy().tokenSequence(JavaTokenId.language());
        ts.move(offset);
        if (ts.moveNext() && ts.token().id() != JavaTokenId.WHITESPACE && ts.offset() == offset) {
            ++offset;
        }
        Trees trees = info.getTrees();
        Tree.Kind kind = null;
        for (path = info.getTreeUtilities().pathFor(offset); path != null && (kind = path.getLeaf().getKind()) != Tree.Kind.METHOD && kind != Tree.Kind.METHOD_INVOCATION && kind != Tree.Kind.NEW_CLASS && kind != Tree.Kind.MEMBER_REFERENCE; path = path.getParentPath()) {
        }
        Element element = null;
        FileObject elementSource = null;
        if (kind == Tree.Kind.METHOD || kind == Tree.Kind.METHOD_INVOCATION || kind == Tree.Kind.NEW_CLASS || kind == Tree.Kind.MEMBER_REFERENCE) {
            element = trees.getElement(path);
            if (element == null || element.asType().getKind() == TypeKind.ERROR) {
                return Collections.emptyList();
            }
            ElementHandle handle = ElementHandle.create((Element)element);
            if (JavaRefactoringUtils.isFromLibrary((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo())) {
                return Collections.emptyList();
            }
            elementSource = SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo());
        }
        if (elementSource == null) {
            return Collections.emptyList();
        }
        QuickPickItem elementItem = new QuickPickItem(ChangeMethodParametersRefactoring.createLabel((CompilationInfo)info, element, true));
        elementItem.setUserData(new CodeActionsProvider.ElementData(element));
        return Collections.singletonList(this.createCodeAction(client, Bundle.DN_ChangeMethodParams(), CHANGE_METHOD_PARAMS_REFACTORING_KIND, null, CHANGE_METHOD_PARAMS_REFACTORING_COMMAND, Utils.toUri(elementSource), elementItem));
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(CHANGE_METHOD_PARAMS_REFACTORING_COMMAND);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        block4: {
            try {
                if (arguments.size() > 1) {
                    String uri = (String)this.gson.fromJson(this.gson.toJson(arguments.get(0)), String.class);
                    QuickPickItem sourceItem = (QuickPickItem)this.gson.fromJson(this.gson.toJson(arguments.get(1)), QuickPickItem.class);
                    ElementHandle handle = ((CodeActionsProvider.ElementData)this.gson.fromJson(this.gson.toJson(sourceItem.getUserData()), CodeActionsProvider.ElementData.class)).toHandle();
                    FileObject file = Utils.fromUri(uri);
                    JavaSource js = JavaSource.forFileObject((FileObject)file);
                    if (js != null) {
                        return CompletableFuture.supplyAsync(() -> {
                            try {
                                js.runUserActionTask(ci -> {
                                    ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                                    ExecutableElement method = (ExecutableElement)handle.resolve((CompilationInfo)ci);
                                    if (method != null) {
                                        Pages.showChangeMethodParametersUI(ci, client, file, handle, method);
                                    }
                                }, true);
                                return null;
                            }
                            catch (IOException ex) {
                                throw new IllegalStateException(ex);
                            }
                        }, (Executor)RequestProcessor.getDefault());
                    }
                    break block4;
                }
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            catch (Exception ex) {
                client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }
        return CompletableFuture.completedFuture(true);
    }

    private static String defaultValue(String type) {
        switch (type) {
            case "boolean": {
                return "false";
            }
            case "byte": 
            case "char": 
            case "double": 
            case "float": 
            case "int": 
            case "long": 
            case "short": {
                return "0";
            }
        }
        return "null";
    }

    static HTMLDialog.OnSubmit showChangeMethodParametersUI(CompilationController ci, NbCodeLanguageClient client, FileObject file, ElementHandle handle, ExecutableElement method) {
        ParameterUI[] params = new ParameterUI[method.getParameters().size()];
        for (int i = 0; i < method.getParameters().size(); ++i) {
            VariableElement param = method.getParameters().get(i);
            ChangeParametersRefactoring.ParameterInfo info = new ChangeParametersRefactoring.ParameterInfo(i, param.getSimpleName().toString(), Utilities.getTypeName((CompilationInfo)ci, (TypeMirror)param.asType(), (boolean)true).toString(), null);
            params[i] = new ParameterUI(info.getType(), info.getName());
            params[i].assignInfo(info);
        }
        Modifier mod = method.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC) ? Modifier.PUBLIC : (method.getModifiers().contains((Object)javax.lang.model.element.Modifier.PROTECTED) ? Modifier.PROTECTED : (method.getModifiers().contains((Object)javax.lang.model.element.Modifier.PRIVATE) ? Modifier.PRIVATE : Modifier.PACKAGE_PRIVATE));
        ChangeMethodParameterUI model = new ChangeMethodParameterUI();
        model.withName(method.getSimpleName().toString()).withReturnType(Utilities.getTypeName((CompilationInfo)ci, (TypeMirror)method.getReturnType(), (boolean)true).toString()).withSelectedModifier(mod).withIsStatic(method.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC)).withParameters(params).assignData(client, file, TreePathHandle.from((ElementHandle)handle, (ClasspathInfo)ClasspathInfo.create((FileObject)file)));
        model.applyBindings();
        return id -> {
            if ("accept".equals(id)) {
                model.doRefactoring();
            }
            return true;
        };
    }

    public static enum Modifier {
        PUBLIC("public"),
        PROTECTED("protected"),
        PACKAGE_PRIVATE("", "package private"),
        PRIVATE("private");

        final String javaName;
        final String humanName;

        private Modifier(String javaName) {
            this(javaName, null);
        }

        private Modifier(String javaName, String humanName) {
            this.javaName = javaName;
            this.humanName = humanName;
        }

        public String toString() {
            return this.humanName == null ? this.javaName : this.humanName;
        }
    }

    static final class ParamControl {
        private ChangeParametersRefactoring.ParameterInfo info;

        ParamControl() {
        }

        void assignInfo(ParameterUI model, ChangeParametersRefactoring.ParameterInfo info) {
            this.info = info;
        }

        void getInfo(ParameterUI model, int idx, BiConsumer<Integer, ChangeParametersRefactoring.ParameterInfo> consumer) {
            consumer.accept(idx, this.info);
        }
    }

    static final class MethodControl {
        private NbCodeLanguageClient client;
        private FileObject file;
        private TreePathHandle handle;

        MethodControl() {
        }

        void assignData(ChangeMethodParameterUI ui, NbCodeLanguageClient client, FileObject file, TreePathHandle handle) {
            this.client = client;
            this.file = file;
            this.handle = handle;
        }

        void doRefactoring(ChangeMethodParameterUI ui) {
            try {
                String returnType;
                ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring(this.handle);
                Modifier selectedModifier = ui.getSelectedModifier();
                if (selectedModifier != null) {
                    EnumSet<javax.lang.model.element.Modifier> modifiers = EnumSet.noneOf(javax.lang.model.element.Modifier.class);
                    switch (selectedModifier) {
                        case PRIVATE: {
                            modifiers.add(javax.lang.model.element.Modifier.PRIVATE);
                            break;
                        }
                        case PACKAGE_PRIVATE: {
                            break;
                        }
                        case PROTECTED: {
                            modifiers.add(javax.lang.model.element.Modifier.PROTECTED);
                            break;
                        }
                        case PUBLIC: {
                            modifiers.add(javax.lang.model.element.Modifier.PUBLIC);
                        }
                    }
                    refactoring.setModifiers(modifiers);
                }
                refactoring.setReturnType((returnType = ui.getReturnType()).length() > 0 ? returnType : null);
                String name = ui.getName();
                refactoring.setMethodName(name.length() > 0 ? name : null);
                List<ParameterUI> parameters = ui.getParameters();
                ChangeParametersRefactoring.ParameterInfo[] params = new ChangeParametersRefactoring.ParameterInfo[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    ParameterUI parameter = parameters.get(i);
                    parameter.getInfo(i, (idx, info) -> {
                        params[idx.intValue()] = info != null ? new ChangeParametersRefactoring.ParameterInfo(info.getOriginalIndex(), parameter.getName(), parameter.getType(), null) : new ChangeParametersRefactoring.ParameterInfo(-1, parameter.getName(), parameter.getType(), ChangeMethodParametersRefactoring.defaultValue(parameter.getType()));
                    });
                }
                refactoring.setParameterInfo(params);
                refactoring.getContext().add((Object)JavaRefactoringUtils.getClasspathInfoFor((FileObject[])new FileObject[]{this.file}));
                this.client.applyEdit(new ApplyWorkspaceEditParams(CodeRefactoring.perform((AbstractRefactoring)refactoring, "ChangeMethodParameters")));
            }
            catch (Exception ex) {
                if (this.client == null) {
                    Exceptions.printStackTrace((Throwable)Exceptions.attachSeverity((Throwable)ex, (Level)Level.SEVERE));
                }
                this.client.showMessage(new MessageParams(MessageType.Error, ex.getLocalizedMessage()));
            }
        }

        void moveUpParameter(ChangeMethodParameterUI ui, ParameterUI data) {
            List<ParameterUI> arr = ui.getParameters();
            int index = arr.indexOf(data);
            if (index > 0) {
                ParameterUI other = arr.get(index - 1);
                arr.set(index, other);
                arr.set(index - 1, data);
            }
        }

        void moveDownParameter(ChangeMethodParameterUI ui, ParameterUI data) {
            List<ParameterUI> arr = ui.getParameters();
            int index = arr.indexOf(data);
            if (index != -1 && index + 1 < arr.size()) {
                ParameterUI other = arr.get(index + 1);
                arr.set(index, other);
                arr.set(index + 1, data);
            }
        }

        void addParameter(ChangeMethodParameterUI ui) {
            ui.getParameters().add(new ParameterUI());
        }

        void removeParameter(ChangeMethodParameterUI ui, ParameterUI data) {
            ui.getParameters().remove(data);
        }

        static List<Modifier> availableModifiers() {
            return Arrays.asList(Modifier.values());
        }

        static String preview(Modifier selectedModifier, boolean isStatic, String returnType, String name, List<ParameterUI> parameters) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectedModifier != null ? selectedModifier.javaName : "").append(" ");
            if (isStatic) {
                sb.append("static ");
            }
            sb.append(returnType);
            sb.append(" ").append(name).append("(");
            String sep = "";
            for (ParameterUI p : parameters) {
                sb.append(sep);
                sb.append(p.getType() != null ? p.getType() : "").append(" ").append(p.getName() != null ? p.getName() : "");
                sep = ", ";
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

