/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.phpdoc.ui.BrowseFolderPanel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class PhpDocPreferences {
    private static final String PHPDOC_ENABLED = "enabled";
    private static final String PHPDOC_TARGET = "target";
    private static final String PHPDOC_TITLE = "title";
    private static final String PHPDOC_CONFIGURATION_ENABLED = "configuration.enabled";
    private static final String PHPDOC_CONFIGURATION_PATH = "configuration.path";

    private PhpDocPreferences() {
    }

    public static boolean isEnabled(PhpModule phpModule) {
        return PhpDocPreferences.getPreferences(phpModule).getBoolean(PHPDOC_ENABLED, false);
    }

    public static void setEnabled(PhpModule phpModule, boolean enabled) {
        PhpDocPreferences.getPreferences(phpModule).putBoolean(PHPDOC_ENABLED, enabled);
    }

    public static String getPhpDocTarget(PhpModule phpModule, boolean showPanel) {
        Preferences preferences = PhpDocPreferences.getPreferences(phpModule);
        String phpDocTarget = preferences.get(PHPDOC_TARGET, null);
        if ((phpDocTarget == null || phpDocTarget.isEmpty()) && showPanel) {
            phpDocTarget = BrowseFolderPanel.open(phpModule);
            if (phpDocTarget == null) {
                return null;
            }
            PhpDocPreferences.setPhpDocTarget(phpModule, phpDocTarget);
        }
        return phpDocTarget;
    }

    public static void setPhpDocTarget(PhpModule phpModule, String phpDocTarget) {
        PhpDocPreferences.getPreferences(phpModule).put(PHPDOC_TARGET, phpDocTarget);
    }

    public static String getPhpDocTitle(PhpModule phpModule) {
        return PhpDocPreferences.getPreferences(phpModule).get(PHPDOC_TITLE, PhpDocPreferences.getDefaultPhpDocTitle(phpModule));
    }

    public static void setPhpDocTitle(PhpModule phpModule, String phpDocTitle) {
        if (phpDocTitle.equals(PhpDocPreferences.getDefaultPhpDocTitle(phpModule))) {
            return;
        }
        PhpDocPreferences.getPreferences(phpModule).put(PHPDOC_TITLE, phpDocTitle);
    }

    public static boolean isConfigurationEnabled(PhpModule phpModule) {
        return PhpDocPreferences.getPreferences(phpModule).getBoolean(PHPDOC_CONFIGURATION_ENABLED, false);
    }

    public static void setConfigurationEnabled(PhpModule phpModule, boolean configurationEnabled) {
        PhpDocPreferences.getPreferences(phpModule).putBoolean(PHPDOC_CONFIGURATION_ENABLED, configurationEnabled);
    }

    @CheckForNull
    public static String getPhpDocConfigurationPath(PhpModule phpModule) {
        return PhpDocPreferences.resolvePath(phpModule, PhpDocPreferences.getPreferences(phpModule).get(PHPDOC_CONFIGURATION_PATH, null));
    }

    public static void setPhpDocConfigurationPath(PhpModule phpModule, String phpDocConfiguration) {
        PhpDocPreferences.getPreferences(phpModule).put(PHPDOC_CONFIGURATION_PATH, phpDocConfiguration);
    }

    private static Preferences getPreferences(PhpModule phpModule) {
        return phpModule.getPreferences(PhpDocPreferences.class, false);
    }

    private static String getDefaultPhpDocTitle(PhpModule phpModule) {
        return phpModule.getDisplayName();
    }

    @CheckForNull
    private static String resolvePath(PhpModule phpModule, String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)phpModule.getProjectDirectory()), (String)filePath).getAbsolutePath();
    }
}

