/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.customizer;

import java.awt.EventQueue;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.editor.indent.project.api.Customizers;
import org.netbeans.modules.php.api.documentation.PhpDocumentations;
import org.netbeans.modules.php.api.framework.PhpFrameworks;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.testing.PhpTesting;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.customizer.Bundle;
import org.netbeans.modules.php.project.ui.customizer.CustomizerAnnotations;
import org.netbeans.modules.php.project.ui.customizer.CustomizerBrowser;
import org.netbeans.modules.php.project.ui.customizer.CustomizerFramework;
import org.netbeans.modules.php.project.ui.customizer.CustomizerIgnorePath;
import org.netbeans.modules.php.project.ui.customizer.CustomizerIncludePath;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.project.ui.customizer.CustomizerRun;
import org.netbeans.modules.php.project.ui.customizer.CustomizerSeleniumTesting;
import org.netbeans.modules.php.project.ui.customizer.CustomizerSources;
import org.netbeans.modules.php.project.ui.customizer.CustomizerTesting;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.project.ui.customizer.TestingProviderPanel;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.web.clientproject.api.jstesting.JsTestingProviders;
import org.netbeans.modules.web.common.ui.api.CssPreprocessorsUI;
import org.netbeans.spi.project.support.ant.ui.CustomizerUtilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CompositePanelProviderImpl
implements ProjectCustomizer.CompositeCategoryProvider {
    public static final String SOURCES = "Sources";
    public static final String RUN = "Run";
    public static final String BROWSER = "Browser";
    public static final String PHP_INCLUDE_PATH = "PhpIncludePath";
    public static final String IGNORE_PATH = "IgnorePath";
    public static final String FRAMEWORKS = "Frameworks";
    public static final String TESTING = "Testing";
    public static final String TESTING_SELENIUM = "SeleniumTesting";
    public static final String ANNOTATIONS = "Annotations";
    public static final String LICENSE = "License";
    private final String name;
    private final Map<ProjectCustomizer.Category, PhpModuleCustomizerExtender> frameworkCategories;
    private final Map<ProjectCustomizer.Category, TestingProviderPanelProvider> testingProviderPanels;

    public CompositePanelProviderImpl(String name) {
        this.name = name;
        this.frameworkCategories = FRAMEWORKS.equals(name) ? new LinkedHashMap<ProjectCustomizer.Category, PhpModuleCustomizerExtender>() : null;
        this.testingProviderPanels = TESTING.equals(name) ? Collections.synchronizedMap(new LinkedHashMap()) : null;
    }

    public ProjectCustomizer.Category createCategory(Lookup context) {
        ProjectCustomizer.Category toReturn = null;
        ProjectCustomizer.Category[] categories = null;
        PhpProject project = (PhpProject)context.lookup(PhpProject.class);
        assert (project != null);
        PhpProjectProperties uiProps = (PhpProjectProperties)context.lookup(PhpProjectProperties.class);
        assert (uiProps != null);
        assert (project == uiProps.getProject()) : project + " <> " + uiProps.getProject();
        if (SOURCES.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)SOURCES, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_Sources"), null, categories);
        } else if (RUN.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)RUN, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_RunConfig"), null, categories);
        } else if (BROWSER.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)BROWSER, (String)Bundle.CompositePanelProviderImpl_category_browser_title(), null, categories);
        } else if (ANNOTATIONS.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)ANNOTATIONS, (String)Bundle.CompositePanelProviderImpl_category_annotations_title(), null, categories);
        } else if (PHP_INCLUDE_PATH.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)PHP_INCLUDE_PATH, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_PhpIncludePath"), null, categories);
        } else if (IGNORE_PATH.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)IGNORE_PATH, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_IgnorePath"), null, categories);
        } else if (FRAMEWORKS.equals(this.name)) {
            this.fillFrameworkCategories(project);
            if (this.frameworkCategories.isEmpty()) {
                return null;
            }
            List<ProjectCustomizer.Category> subcategories = CompositePanelProviderImpl.sortCategories(this.frameworkCategories.keySet());
            toReturn = ProjectCustomizer.Category.create((String)FRAMEWORKS, (String)NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Config_Frameworks"), null, (ProjectCustomizer.Category[])subcategories.toArray(new ProjectCustomizer.Category[0]));
        } else if (TESTING.equals(this.name)) {
            this.fillTestingProviderPanels(uiProps, context);
            List<ProjectCustomizer.Category> subcategories = CompositePanelProviderImpl.sortCategories(this.testingProviderPanels.keySet());
            toReturn = ProjectCustomizer.Category.create((String)TESTING, (String)Bundle.CompositePanelProviderImpl_category_testing_title(), null, (ProjectCustomizer.Category[])subcategories.toArray(new ProjectCustomizer.Category[0]));
        } else if (TESTING_SELENIUM.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)TESTING_SELENIUM, (String)Bundle.CompositePanelProviderImpl_category_selenium_testing_title(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        } else if (LICENSE.equals(this.name)) {
            toReturn = ProjectCustomizer.Category.create((String)LICENSE, (String)Bundle.CompositePanelProviderImpl_category_licenceHeaders_title(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
        }
        assert (toReturn != null) : "No category for name: " + this.name;
        return toReturn;
    }

    public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
        TestingProviderPanelProvider panelProvider;
        PhpModuleCustomizerExtender extender;
        String nm = category.getName();
        final PhpProjectProperties uiProps = (PhpProjectProperties)context.lookup(PhpProjectProperties.class);
        if (SOURCES.equals(nm)) {
            return new CustomizerSources(category, uiProps);
        }
        if (RUN.equals(nm)) {
            return new CustomizerRun(uiProps, category);
        }
        if (BROWSER.equals(nm)) {
            return new CustomizerBrowser(category, uiProps);
        }
        if (ANNOTATIONS.equals(nm)) {
            return new CustomizerAnnotations(category, (PhpProject)context.lookup(PhpProject.class));
        }
        if (PHP_INCLUDE_PATH.equals(nm)) {
            return new CustomizerIncludePath(category, uiProps);
        }
        if (IGNORE_PATH.equals(nm)) {
            return new CustomizerIgnorePath(category, uiProps);
        }
        if (FRAMEWORKS.equals(nm)) {
            return new JPanel();
        }
        if (TESTING.equals(nm)) {
            return new CustomizerTesting(category, uiProps, this.creatingTestingPanels());
        }
        if (TESTING_SELENIUM.equals(nm)) {
            return new CustomizerSeleniumTesting(category, uiProps);
        }
        if (LICENSE.equals(nm)) {
            CustomizerUtilities.LicensePanelContentHandler handler = new CustomizerUtilities.LicensePanelContentHandler(){

                public String getProjectLicenseLocation() {
                    return uiProps.getLicensePathValue();
                }

                public String getGlobalLicenseName() {
                    return uiProps.getLicenseNameValue();
                }

                public FileObject resolveProjectLocation(@NonNull String path) {
                    PhpProject project = uiProps.getProject();
                    String evaluated = ProjectPropertiesSupport.getPropertyEvaluator(project).evaluate(path);
                    assert (evaluated != null) : path;
                    return project.getHelper().resolveFileObject(evaluated);
                }

                public void setProjectLicenseLocation(@NullAllowed String newLocation) {
                    uiProps.setLicensePathValue(newLocation);
                }

                public void setGlobalLicenseName(@NullAllowed String newName) {
                    uiProps.setLicenseNameValue(newName);
                }

                public String getDefaultProjectLicenseLocation() {
                    return "./nbproject/licenseheader.txt";
                }

                public void setProjectLicenseContent(@NullAllowed String text) {
                    uiProps.setChangedLicensePathContent(text);
                }
            };
            return CustomizerUtilities.createLicenseHeaderCustomizerPanel((ProjectCustomizer.Category)category, (CustomizerUtilities.LicensePanelContentHandler)handler);
        }
        if (this.frameworkCategories != null && (extender = this.frameworkCategories.get(category)) != null) {
            return new CustomizerFramework(category, extender, uiProps);
        }
        if (this.testingProviderPanels != null && (panelProvider = this.testingProviderPanels.get(category)) != null) {
            return panelProvider.getPanel();
        }
        assert (false) : "No component found for " + category.getDisplayName();
        return new JPanel();
    }

    public static CompositePanelProviderImpl createSources() {
        return new CompositePanelProviderImpl(SOURCES);
    }

    public static CompositePanelProviderImpl createRunConfig() {
        return new CompositePanelProviderImpl(RUN);
    }

    public static CompositePanelProviderImpl createBrowser() {
        return new CompositePanelProviderImpl(BROWSER);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createCssPreprocessors() {
        return CssPreprocessorsUI.getDefault().createCustomizer();
    }

    public static CompositePanelProviderImpl createPhpIncludePath() {
        return new CompositePanelProviderImpl(PHP_INCLUDE_PATH);
    }

    public static CompositePanelProviderImpl createIgnorePath() {
        return new CompositePanelProviderImpl(IGNORE_PATH);
    }

    public static CompositePanelProviderImpl createFrameworks() {
        return new CompositePanelProviderImpl(FRAMEWORKS);
    }

    public static CompositePanelProviderImpl createTesting() {
        return new CompositePanelProviderImpl(TESTING);
    }

    public static CompositePanelProviderImpl createSeleniumTesting() {
        return new CompositePanelProviderImpl(TESTING_SELENIUM);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createJsTesting() {
        return JsTestingProviders.getDefault().createCustomizer();
    }

    public static ProjectCustomizer.CompositeCategoryProvider createPhpDocumentation() {
        return PhpDocumentations.createCustomizer();
    }

    public static ProjectCustomizer.CompositeCategoryProvider createAnnotations() {
        return new CompositePanelProviderImpl(ANNOTATIONS);
    }

    public static CompositePanelProviderImpl createLicense() {
        return new CompositePanelProviderImpl(LICENSE);
    }

    public static ProjectCustomizer.CompositeCategoryProvider createFormatting() {
        return Customizers.createFormattingCategoryProvider(Collections.singletonMap("allowedMimeTypes", "text/x-php5,text/html,text/css,text/javascript,text/x-json"));
    }

    private void fillFrameworkCategories(PhpProject project) {
        this.frameworkCategories.clear();
        PhpModule phpModule = project.getPhpModule();
        int i = 0;
        for (PhpFrameworkProvider frameworkProvider : PhpFrameworks.getFrameworks()) {
            PhpModuleCustomizerExtender extender = frameworkProvider.createPhpModuleCustomizerExtender(phpModule);
            if (extender == null) continue;
            String categoryName = extender.getDisplayName(phpModule);
            if (categoryName == null) {
                categoryName = frameworkProvider.getName();
            }
            ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)(FRAMEWORKS + i++), (String)categoryName, null, (ProjectCustomizer.Category[])null);
            this.frameworkCategories.put(category, extender);
        }
    }

    private void fillTestingProviderPanels(PhpProjectProperties uiProps, Lookup context) {
        this.testingProviderPanels.clear();
        PhpModule phpModule = uiProps.getProject().getPhpModule();
        for (PhpTestingProvider testingProvider : PhpTesting.getTestingProviders()) {
            ProjectCustomizer.Category category;
            ProjectCustomizer.CompositeCategoryProvider categoryProvider = testingProvider.createCustomizer(phpModule);
            if (categoryProvider == null || (category = categoryProvider.createCategory(context)) == null) continue;
            this.testingProviderPanels.put(category, new TestingProviderPanelProvider(category, uiProps, testingProvider, categoryProvider, context));
        }
    }

    private Map<String, TestingProviderPanel> creatingTestingPanels() {
        ConcurrentHashMap<String, TestingProviderPanel> providers = new ConcurrentHashMap<String, TestingProviderPanel>();
        for (TestingProviderPanelProvider panelProvider : this.testingProviderPanels.values()) {
            TestingProviderPanel panel = panelProvider.getPanel();
            providers.put(panel.getProviderIdentifier(), panel);
        }
        return providers;
    }

    private static List<ProjectCustomizer.Category> sortCategories(Collection<ProjectCustomizer.Category> categories) {
        final Collator collator = Collator.getInstance();
        ArrayList<ProjectCustomizer.Category> sortedCategories = new ArrayList<ProjectCustomizer.Category>(categories);
        sortedCategories.sort(new Comparator<ProjectCustomizer.Category>(){

            @Override
            public int compare(ProjectCustomizer.Category category1, ProjectCustomizer.Category category2) {
                return collator.compare(category1.getDisplayName(), category2.getDisplayName());
            }
        });
        return sortedCategories;
    }

    private static final class TestingProviderPanelProvider {
        private final ProjectCustomizer.Category category;
        private final PhpProjectProperties uiProps;
        private final PhpTestingProvider testingProvider;
        private final ProjectCustomizer.CompositeCategoryProvider categoryProvider;
        private final Lookup context;
        private TestingProviderPanel panel;

        public TestingProviderPanelProvider(ProjectCustomizer.Category category, PhpProjectProperties uiProps, PhpTestingProvider testingProvider, ProjectCustomizer.CompositeCategoryProvider categoryProvider, Lookup context) {
            this.category = category;
            this.uiProps = uiProps;
            this.testingProvider = testingProvider;
            this.categoryProvider = categoryProvider;
            this.context = context;
        }

        public TestingProviderPanel getPanel() {
            assert (EventQueue.isDispatchThread());
            if (this.panel == null) {
                JComponent component = this.categoryProvider.createComponent(this.category, this.context);
                assert (component != null) : "Component should be created by " + this.categoryProvider.getClass().getName();
                this.panel = new TestingProviderPanel(this.category, this.uiProps, this.testingProvider.getIdentifier(), component);
            }
            return this.panel;
        }
    }
}

